/*
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export default angular.module('thingsboard.locale', [])
    .constant('locales',
        {
            'en_US': {
                "access": {
                    "unauthorized": "Unauthorized",
                    "unauthorized-access": "Unauthorized Access",
                    "unauthorized-access-text": "You should sign in to have access to this resource!",
                    "access-forbidden": "Access Forbidden",
                    "access-forbidden-text": "You haven't access rights to this location!<br/>Try to sign in with different user if you still wish to gain access to this location.",
                    "refresh-token-expired": "Session has expired",
                    "refresh-token-failed": "Unable to refresh session"
                },
                "action": {
                    "activate": "Activate",
                    "suspend": "Suspend",
                    "save": "Save",
                    "saveAs": "Save as",
                    "cancel": "Cancel",
                    "ok": "OK",
                    "delete": "Delete",
                    "add": "Add",
                    "yes": "Yes",
                    "no": "No",
                    "update": "Update",
                    "remove": "Remove",
                    "search": "Search",
                    "assign": "Assign",
                    "unassign": "Unassign",
                    "share": "Share",
                    "make-private": "Make private",
                    "apply": "Apply",
                    "apply-changes": "Apply changes",
                    "edit-mode": "Edit mode",
                    "enter-edit-mode": "Enter edit mode",
                    "decline-changes": "Decline changes",
                    "close": "Close",
                    "back": "Back",
                    "run": "Run",
                    "sign-in": "Sign in!",
                    "edit": "Edit",
                    "view": "View",
                    "create": "Create",
                    "drag": "Drag",
                    "refresh": "Refresh",
                    "undo": "Undo",
                    "copy": "Copy",
                    "paste": "Paste",
                    "import": "Import",
                    "export": "Export",
                    "share-via": "Share via {{provider}}"
                },
                "aggregation": {
                    "aggregation": "Aggregation",
                    "function": "Data aggregation function",
                    "limit": "Max values",
                    "group-interval": "Grouping interval",
                    "min": "Min",
                    "max": "Max",
                    "avg": "Average",
                    "sum": "Sum",
                    "count": "Count",
                    "none": "None"
                },
                "admin": {
                    "general": "General",
                    "general-settings": "General Settings",
                    "outgoing-mail": "Outgoing Mail",
                    "outgoing-mail-settings": "Outgoing Mail Settings",
                    "system-settings": "System Settings",
                    "test-mail-sent": "Test mail was successfully sent!",
                    "base-url": "Base URL",
                    "base-url-required": "Base URL is required.",
                    "mail-from": "Mail From",
                    "mail-from-required": "Mail From is required.",
                    "smtp-protocol": "SMTP protocol",
                    "smtp-host": "SMTP host",
                    "smtp-host-required": "SMTP host is required.",
                    "smtp-port": "SMTP port",
                    "smtp-port-required": "You must supply a smtp port.",
                    "smtp-port-invalid": "That doesn't look like a valid smtp port.",
                    "timeout-msec": "Timeout (msec)",
                    "timeout-required": "Timeout is required.",
                    "timeout-invalid": "That doesn't look like a valid timeout.",
                    "enable-tls": "Enable TLS",
                    "send-test-mail": "Send test mail"
                },
                "attribute": {
                    "attributes": "Attributes",
                    "latest-telemetry": "Latest telemetry",
                    "attributes-scope": "Device attributes scope",
                    "scope-latest-telemetry": "Latest telemetry",
                    "scope-client": "Client attributes",
                    "scope-server": "Server attributes",
                    "scope-shared": "Shared attributes",
                    "add": "Add attribute",
                    "key": "Key",
                    "key-required": "Attribute key is required.",
                    "value": "Value",
                    "value-required": "Attribute value is required.",
                    "delete-attributes-title": "Are you sure you want to delete { count, select, 1 {1 attribute} other {# attributes} }?",
                    "delete-attributes-text": "Be careful, after the confirmation all selected attributes will be removed.",
                    "delete-attributes": "Delete attributes",
                    "enter-attribute-value": "Enter attribute value",
                    "show-on-widget": "Show on widget",
                    "widget-mode": "Widget mode",
                    "next-widget": "Next widget",
                    "prev-widget": "Previous widget",
                    "add-to-dashboard": "Add to dashboard",
                    "add-widget-to-dashboard": "Add widget to dashboard",
                    "selected-attributes": "{ count, select, 1 {1 attribute} other {# attributes} } selected",
                    "selected-telemetry": "{ count, select, 1 {1 telemetry unit} other {# telemetry units} } selected"
                },
                "confirm-on-exit": {
                    "message": "You have unsaved changes. Are you sure you want to leave this page?",
                    "html-message": "You have unsaved changes.<br/>Are you sure you want to leave this page?",
                    "title": "Unsaved changes"
                },
                "contact": {
                    "country": "Country",
                    "city": "City",
                    "state": "State",
                    "postal-code": "Postal code",
                    "postal-code-invalid": "Only digits are allowed.",
                    "address": "Address",
                    "address2": "Address 2",
                    "phone": "Phone",
                    "email": "Email",
                    "no-address": "No address"
                },
                "common": {
                    "username": "Username",
                    "password": "Password",
                    "enter-username": "Enter username",
                    "enter-password": "Enter password",
                    "enter-search": "Enter search"
                },
                "customer": {
                    "customers": "Customers",
                    "management": "Customer management",
                    "dashboard": "Customer Dashboard",
                    "dashboards": "Customer Dashboards",
                    "devices": "Customer Devices",
                    "public-dashboards": "Public Dashboards",
                    "public-devices": "Public Devices",
                    "add": "Add Customer",
                    "delete": "Delete customer",
                    "manage-customer-users": "Manage customer users",
                    "manage-customer-devices": "Manage customer devices",
                    "manage-customer-dashboards": "Manage customer dashboards",
                    "manage-public-devices": "Manage public devices",
                    "manage-public-dashboards": "Manage public dashboards",
                    "add-customer-text": "Add new customer",
                    "no-customers-text": "No customers found",
                    "customer-details": "Customer details",
                    "delete-customer-title": "Are you sure you want to delete the customer '{{customerTitle}}'?",
                    "delete-customer-text": "Be careful, after the confirmation the customer and all related data will become unrecoverable.",
                    "delete-customers-title": "Are you sure you want to delete { count, select, 1 {1 customer} other {# customers} }?",
                    "delete-customers-action-title": "Delete { count, select, 1 {1 customer} other {# customers} }",
                    "delete-customers-text": "Be careful, after the confirmation all selected customers will be removed and all related data will become unrecoverable.",
                    "manage-users": "Manage users",
                    "manage-devices": "Manage devices",
                    "manage-dashboards": "Manage dashboards",
                    "title": "Title",
                    "title-required": "Title is required.",
                    "description": "Description"
                },
                "datetime": {
                    "date-from": "Date from",
                    "time-from": "Time from",
                    "date-to": "Date to",
                    "time-to": "Time to"
                },
                "dashboard": {
                    "dashboard": "Dashboard",
                    "dashboards": "Dashboards",
                    "management": "Dashboard management",
                    "view-dashboards": "View Dashboards",
                    "add": "Add Dashboard",
                    "assign-dashboard-to-customer": "Assign Dashboard(s) To Customer",
                    "assign-dashboard-to-customer-text": "Please select the dashboards to assign to the customer",
                    "assign-to-customer-text": "Please select the customer to assign the dashboard(s)",
                    "assign-to-customer": "Assign to customer",
                    "unassign-from-customer": "Unassign from customer",
                    "make-public": "Make dashboard public",
                    "make-private": "Make dashboard private",
                    "no-dashboards-text": "No dashboards found",
                    "no-widgets": "No widgets configured",
                    "add-widget": "Add new widget",
                    "title": "Title",
                    "select-widget-title": "Select widget",
                    "select-widget-subtitle": "List of available widget types",
                    "delete": "Delete dashboard",
                    "title-required": "Title is required.",
                    "description": "Description",
                    "details": "Details",
                    "dashboard-details": "Dashboard details",
                    "add-dashboard-text": "Add new dashboard",
                    "assign-dashboards": "Assign dashboards",
                    "assign-new-dashboard": "Assign new dashboard",
                    "assign-dashboards-text": "Assign { count, select, 1 {1 dashboard} other {# dashboards} } to customer",
                    "delete-dashboards": "Delete dashboards",
                    "unassign-dashboards": "Unassign dashboards",
                    "unassign-dashboards-action-title": "Unassign { count, select, 1 {1 dashboard} other {# dashboards} } from customer",
                    "delete-dashboard-title": "Are you sure you want to delete the dashboard '{{dashboardTitle}}'?",
                    "delete-dashboard-text": "Be careful, after the confirmation the dashboard and all related data will become unrecoverable.",
                    "delete-dashboards-title": "Are you sure you want to delete { count, select, 1 {1 dashboard} other {# dashboards} }?",
                    "delete-dashboards-action-title": "Delete { count, select, 1 {1 dashboard} other {# dashboards} }",
                    "delete-dashboards-text": "Be careful, after the confirmation all selected dashboards will be removed and all related data will become unrecoverable.",
                    "unassign-dashboard-title": "Are you sure you want to unassign the dashboard '{{dashboardTitle}}'?",
                    "unassign-dashboard-text": "After the confirmation the dashboard will be unassigned and won't be accessible by the customer.",
                    "unassign-dashboard": "Unassign dashboard",
                    "unassign-dashboards-title": "Are you sure you want to unassign { count, select, 1 {1 dashboard} other {# dashboards} }?",
                    "unassign-dashboards-text": "After the confirmation all selected dashboards will be unassigned and won't be accessible by the customer.",
                    "public-dashboard-title": "Dashboard is now public",
                    "public-dashboard-text": "Your dashboard <b>{{dashboardTitle}}</b> is now public and accessible via next public <a href='{{publicLink}}' target='_blank'>link</a>:",
                    "public-dashboard-notice": "<b>Note:</b> Do not forget to make related devices public in order to access their data.",
                    "make-private-dashboard-title": "Are you sure you want to make the dashboard '{{dashboardTitle}}' private?",
                    "make-private-dashboard-text": "After the confirmation the dashboard will be made private and won't be accessible by others.",
                    "make-private-dashboard": "Make dashboard private",
                    "socialshare-text": "'{{dashboardTitle}}' powered by ThingsBoard",
                    "socialshare-title": "'{{dashboardTitle}}' powered by ThingsBoard",
                    "select-dashboard": "Select dashboard",
                    "no-dashboards-matching": "No dashboards matching '{{dashboard}}' were found.",
                    "dashboard-required": "Dashboard is required.",
                    "select-existing": "Select existing dashboard",
                    "create-new": "Create new dashboard",
                    "new-dashboard-title": "New dashboard title",
                    "open-dashboard": "Open dashboard",
                    "set-background": "Set background",
                    "background-color": "Background color",
                    "background-image": "Background image",
                    "background-size-mode": "Background size mode",
                    "no-image": "No image selected",
                    "drop-image": "Drop an image or click to select a file to upload.",
                    "settings": "Settings",
                    "columns-count": "Columns count",
                    "columns-count-required": "Columns count is required.",
                    "min-columns-count-message": "Only 10 minimum column count is allowed.",
                    "max-columns-count-message": "Only 1000 maximum column count is allowed.",
                    "widgets-margins": "Margin between widgets",
                    "horizontal-margin": "Horizontal margin",
                    "horizontal-margin-required": "Horizontal margin value is required.",
                    "min-horizontal-margin-message": "Only 0 is allowed as minimum horizontal margin value.",
                    "max-horizontal-margin-message": "Only 50 is allowed as maximum horizontal margin value.",
                    "vertical-margin": "Vertical margin",
                    "vertical-margin-required": "Vertical margin value is required.",
                    "min-vertical-margin-message": "Only 0 is allowed as minimum vertical margin value.",
                    "max-vertical-margin-message": "Only 50 is allowed as maximum vertical margin value.",
                    "display-title": "Display dashboard title",
                    "title-color": "Title color",
                    "display-device-selection": "Display device selection",
                    "display-dashboard-timewindow": "Display timewindow",
                    "display-dashboard-export": "Display export",
                    "import": "Import dashboard",
                    "export": "Export dashboard",
                    "export-failed-error": "Unable to export dashboard: {{error}}",
                    "create-new-dashboard": "Create new dashboard",
                    "dashboard-file": "Dashboard file",
                    "invalid-dashboard-file-error": "Unable to import dashboard: Invalid dashboard data structure.",
                    "dashboard-import-missing-aliases-title": "Configure aliases used by imported dashboard",
                    "create-new-widget": "Create new widget",
                    "import-widget": "Import widget",
                    "widget-file": "Widget file",
                    "invalid-widget-file-error": "Unable to import widget: Invalid widget data structure.",
                    "widget-import-missing-aliases-title": "Configure aliases used by imported widget",
                    "open-toolbar": "Open dashboard toolbar",
                    "close-toolbar": "Close toolbar",
                    "configuration-error": "Configuration error",
                    "alias-resolution-error-title": "Dashboard aliases configuration error",
                    "invalid-aliases-config": "Unable to find any devices matching to some of the aliases filter.<br/>" +
                                              "Please contact your administrator in order to resolve this issue.",
                    "select-devices": "Select devices",
                    "assignedToCustomer": "Assigned to customer",
                    "public": "Public",
                    "public-link": "Public link",
                    "copy-public-link": "Copy public link",
                    "public-link-copied-message": "Dashboard public link has been copied to clipboard"
                },
                "datakey": {
                    "settings": "Settings",
                    "advanced": "Advanced",
                    "label": "Label",
                    "color": "Color",
                    "data-generation-func": "Data generation function",
                    "use-data-post-processing-func": "Use data post-processing function",
                    "configuration": "Data key configuration",
                    "timeseries": "Timeseries",
                    "attributes": "Attributes",
                    "timeseries-required": "Device timeseries is required.",
                    "timeseries-or-attributes-required": "Device timeseries/attributes is required.",
                    "function-types": "Function types",
                    "function-types-required": "Function types is required."
                },
                "datasource": {
                    "type": "Datasource type",
                    "add-datasource-prompt": "Please add datasource"
                },
                "details": {
                    "edit-mode": "Edit mode",
                    "toggle-edit-mode": "Toggle edit mode"
                },
                "device": {
                    "device": "Device",
                    "device-required": "Device is required.",
                    "devices": "Devices",
                    "management": "Device management",
                    "view-devices": "View Devices",
                    "device-alias": "Device alias",
                    "aliases": "Device aliases",
                    "no-alias-matching": "'{{alias}}' not found.",
                    "no-aliases-found": "No aliases found.",
                    "no-key-matching": "'{{key}}' not found.",
                    "no-keys-found": "No keys found.",
                    "create-new-alias": "Create a new one!",
                    "create-new-key": "Create a new one!",
                    "duplicate-alias-error": "Duplicate alias found '{{alias}}'.<br>Device aliases must be unique whithin the dashboard.",
                    "configure-alias": "Configure '{{alias}}' alias",
                    "no-devices-matching": "No devices matching '{{device}}' were found.",
                    "alias": "Alias",
                    "alias-required": "Device alias is required.",
                    "remove-alias": "Remove device alias",
                    "add-alias": "Add device alias",
                    "name-starts-with": "Name starts with",
                    "device-list": "Device list",
                    "use-device-name-filter": "Use filter",
                    "device-list-empty": "No devices selected.",
                    "device-name-filter-required": "Device name filter is required.",
                    "device-name-filter-no-device-matched": "No devices starting with '{{device}}' were found.",
                    "add": "Add Device",
                    "assign-to-customer": "Assign to customer",
                    "assign-device-to-customer": "Assign Device(s) To Customer",
                    "assign-device-to-customer-text": "Please select the devices to assign to the customer",
                    "make-public": "Make device public",
                    "make-private": "Make device private",
                    "no-devices-text": "No devices found",
                    "assign-to-customer-text": "Please select the customer to assign the device(s)",
                    "device-details": "Device details",
                    "add-device-text": "Add new device",
                    "credentials": "Credentials",
                    "manage-credentials": "Manage credentials",
                    "delete": "Delete device",
                    "assign-devices": "Assign devices",
                    "assign-devices-text": "Assign { count, select, 1 {1 device} other {# devices} } to customer",
                    "delete-devices": "Delete devices",
                    "unassign-from-customer": "Unassign from customer",
                    "unassign-devices": "Unassign devices",
                    "unassign-devices-action-title": "Unassign { count, select, 1 {1 device} other {# devices} } from customer",
                    "assign-new-device": "Assign new device",
                    "make-public-device-title": "Are you sure you want to make the device '{{deviceName}}' public?",
                    "make-public-device-text": "After the confirmation the device and all its data will be made public and accessible by others.",
                    "make-private-device-title": "Are you sure you want to make the device '{{deviceName}}' private?",
                    "make-private-device-text": "After the confirmation the device and all its data will be made private and won't be accessible by others.",
                    "view-credentials": "View credentials",
                    "delete-device-title": "Are you sure you want to delete the device '{{deviceName}}'?",
                    "delete-device-text": "Be careful, after the confirmation the device and all related data will become unrecoverable.",
                    "delete-devices-title": "Are you sure you want to delete { count, select, 1 {1 device} other {# devices} }?",
                    "delete-devices-action-title": "Delete { count, select, 1 {1 device} other {# devices} }",
                    "delete-devices-text": "Be careful, after the confirmation all selected devices will be removed and all related data will become unrecoverable.",
                    "unassign-device-title": "Are you sure you want to unassign the device '{{deviceName}}'?",
                    "unassign-device-text": "After the confirmation the device will be unassigned and won't be accessible by the customer.",
                    "unassign-device": "Unassign device",
                    "unassign-devices-title": "Are you sure you want to unassign { count, select, 1 {1 device} other {# devices} }?",
                    "unassign-devices-text": "After the confirmation all selected devices will be unassigned and won't be accessible by the customer.",
                    "device-credentials": "Device Credentials",
                    "credentials-type": "Credentials type",
                    "access-token": "Access token",
                    "access-token-required": "Access token is required.",
                    "access-token-invalid": "Access token length must be from 1 to 20 characters.",
                    "rsa-key": "RSA public key",
                    "rsa-key-required": "RSA public key is required.",
                    "secret": "Secret",
                    "secret-required": "Secret is required.",
                    "name": "Name",
                    "name-required": "Name is required.",
                    "description": "Description",
                    "events": "Events",
                    "details": "Details",
                    "copyId": "Copy device Id",
                    "copyAccessToken": "Copy access token",
                    "idCopiedMessage": "Device Id has been copied to clipboard",
                    "accessTokenCopiedMessage": "Device access token has been copied to clipboard",
                    "assignedToCustomer": "Assigned to customer",
                    "unable-delete-device-alias-title": "Unable to delete device alias",
                    "unable-delete-device-alias-text": "Device alias '{{deviceAlias}}' can't be deleted as it used by the following widget(s):<br/>{{widgetsList}}",
                    "is-gateway": "Is gateway",
                    "public": "Public",
                    "device-public": "Device is public"
                },
                "dialog": {
                    "close": "Close dialog"
                },
                "error": {
                    "unable-to-connect": "Unable to connect to the server! Please check your internet connection.",
                    "unhandled-error-code": "Unhandled error code: {{errorCode}}",
                    "unknown-error": "Unknown error"
                },
                "event": {
                    "event-type": "Event type",
                    "type-alarm": "Alarm",
                    "type-error": "Error",
                    "type-lc-event": "Lifecycle event",
                    "type-stats": "Statistics",
                    "no-events-prompt": "No events found",
                    "error": "Error",
                    "alarm": "Alarm",
                    "event-time": "Event time",
                    "server": "Server",
                    "body": "Body",
                    "method": "Method",
                    "event": "Event",
                    "status": "Status",
                    "success": "Success",
                    "failed": "Failed",
                    "messages-processed": "Messages processed",
                    "errors-occurred": "Errors occurred"
                },
                "fullscreen": {
                    "expand": "Expand to fullscreen",
                    "exit": "Exit fullscreen",
                    "toggle": "Toggle fullscreen mode",
                    "fullscreen": "Fullscreen"
                },
                "function": {
                    "function": "Function"
                },
                "grid": {
                    "delete-item-title": "Are you sure you want to delete this item?",
                    "delete-item-text": "Be careful, after the confirmation this item and all related data will become unrecoverable.",
                    "delete-items-title": "Are you sure you want to delete { count, select, 1 {1 item} other {# items} }?",
                    "delete-items-action-title": "Delete { count, select, 1 {1 item} other {# items} }",
                    "delete-items-text": "Be careful, after the confirmation all selected items will be removed and all related data will become unrecoverable.",
                    "add-item-text": "Add new item",
                    "no-items-text": "No items found",
                    "item-details": "Item details",
                    "delete-item": "Delete Item",
                    "delete-items": "Delete Items",
                    "scroll-to-top": "Scroll to top"
                },
                "help": {
                    "goto-help-page": "Go to help page"
                },
                "home": {
                    "home": "Home",
                    "profile": "Profile",
                    "logout": "Logout",
                    "menu": "Menu",
                    "avatar": "Avatar",
                    "open-user-menu": "Open user menu"
                },
                "import": {
                    "no-file": "No file selected",
                    "drop-file": "Drop a JSON file or click to select a file to upload."
                },
                "item": {
                    "selected": "Selected"
                },
                "js-func": {
                    "no-return-error": "Function must return value!",
                    "return-type-mismatch": "Function must return value of '{{type}}' type!"
                },
                "legend": {
                    "position": "Legend position",
                    "show-max": "Show max value",
                    "show-min": "Show min value",
                    "show-avg": "Show average value",
                    "show-total": "Show total value",
                    "settings": "Legend settings",
                    "min": "min",
                    "max": "max",
                    "avg": "avg",
                    "total": "total"
                },
                "login": {
                    "login": "Login",
                    "request-password-reset": "Request Password Reset",
                    "reset-password": "Reset Password",
                    "create-password": "Create Password",
                    "passwords-mismatch-error": "Entered passwords must be same!",
                    "password-again": "Password again",
                    "sign-in": "Please sign in",
                    "username": "Username (email)",
                    "remember-me": "Remember me",
                    "forgot-password": "Forgot Password?",
                    "password-reset": "Password reset",
                    "new-password": "New password",
                    "new-password-again": "New password again",
                    "password-link-sent-message": "Password reset link was successfully sent!",
                    "email": "Email"
                },
                "plugin": {
                    "plugins": "Plugins",
                    "delete": "Delete plugin",
                    "activate": "Activate plugin",
                    "suspend": "Suspend plugin",
                    "active": "Active",
                    "suspended": "Suspended",
                    "name": "Name",
                    "name-required": "Name is required.",
                    "description": "Description",
                    "add": "Add Plugin",
                    "delete-plugin-title": "Are you sure you want to delete the plugin '{{pluginName}}'?",
                    "delete-plugin-text": "Be careful, after the confirmation the plugin and all related data will become unrecoverable.",
                    "delete-plugins-title": "Are you sure you want to delete { count, select, 1 {1 plugin} other {# plugins} }?",
                    "delete-plugins-action-title": "Delete { count, select, 1 {1 plugin} other {# plugins} }",
                    "delete-plugins-text": "Be careful, after the confirmation all selected plugins will be removed and all related data will become unrecoverable.",
                    "add-plugin-text": "Add new plugin",
                    "no-plugins-text": "No plugins found",
                    "plugin-details": "Plugin details",
                    "api-token": "API token",
                    "api-token-required": "API token is required.",
                    "type": "Plugin type",
                    "type-required": "Plugin type is required.",
                    "configuration": "Plugin configuration",
                    "system": "System",
                    "select-plugin": "Select plugin",
                    "plugin": "Plugin",
                    "no-plugins-matching": "No plugins matching '{{plugin}}' were found.",
                    "plugin-required": "Plugin is required.",
                    "plugin-require-match": "Please select an existing plugin.",
                    "events": "Events",
                    "details": "Details",
                    "import": "Import plugin",
                    "export": "Export plugin",
                    "export-failed-error": "Unable to export plugin: {{error}}",
                    "create-new-plugin": "Create new plugin",
                    "plugin-file": "Plugin file",
                    "invalid-plugin-file-error": "Unable to import plugin: Invalid plugin data structure."
                },
                "position": {
                    "top": "Top",
                    "bottom": "Bottom",
                    "left": "Left",
                    "right": "Right"
                },
                "profile": {
                    "profile": "Profile",
                    "change-password": "Change Password",
                    "current-password": "Current password"
                },
                "rule": {
                    "rules": "Rules",
                    "delete": "Delete rule",
                    "activate": "Activate rule",
                    "suspend": "Suspend rule",
                    "active": "Active",
                    "suspended": "Suspended",
                    "name": "Name",
                    "name-required": "Name is required.",
                    "description": "Description",
                    "add": "Add Rule",
                    "delete-rule-title": "Are you sure you want to delete the rule '{{ruleName}}'?",
                    "delete-rule-text": "Be careful, after the confirmation the rule and all related data will become unrecoverable.",
                    "delete-rules-title": "Are you sure you want to delete { count, select, 1 {1 rule} other {# rules} }?",
                    "delete-rules-action-title": "Delete { count, select, 1 {1 rule} other {# rules} }",
                    "delete-rules-text": "Be careful, after the confirmation all selected rules will be removed and all related data will become unrecoverable.",
                    "add-rule-text": "Add new rule",
                    "no-rules-text": "No rules found",
                    "rule-details": "Rule details",
                    "filters": "Filters",
                    "filter": "Filter",
                    "add-filter-prompt": "Please add filter",
                    "remove-filter": "Remove filter",
                    "add-filter": "Add filter",
                    "filter-name": "Filter name",
                    "filter-type": "Filter type",
                    "edit-filter": "Edit filter",
                    "view-filter": "View filter",
                    "component-name": "Name",
                    "component-name-required": "Name is required.",
                    "component-type": "Type",
                    "component-type-required": "Type is required.",
                    "processor": "Processor",
                    "no-processor-configured": "No processor configured",
                    "create-processor": "Create processor",
                    "processor-name": "Processor name",
                    "processor-type": "Processor type",
                    "plugin-action": "Plugin action",
                    "action-name": "Action name",
                    "action-type": "Action type",
                    "create-action-prompt": "Please create action",
                    "create-action": "Create action",
                    "details": "Details",
                    "events": "Events",
                    "system": "System",
                    "import": "Import rule",
                    "export": "Export rule",
                    "export-failed-error": "Unable to export rule: {{error}}",
                    "create-new-rule": "Create new rule",
                    "rule-file": "Rule file",
                    "invalid-rule-file-error": "Unable to import rule: Invalid rule data structure."
                },
                "rule-plugin": {
                    "management": "Rules and plugins management"
                },
                "tenant": {
                    "tenants": "Tenants",
                    "management": "Tenant management",
                    "add": "Add Tenant",
                    "admins": "Admins",
                    "manage-tenant-admins": "Manage tenant admins",
                    "delete": "Delete tenant",
                    "add-tenant-text": "Add new tenant",
                    "no-tenants-text": "No tenants found",
                    "tenant-details": "Tenant details",
                    "delete-tenant-title": "Are you sure you want to delete the tenant '{{tenantTitle}}'?",
                    "delete-tenant-text": "Be careful, after the confirmation the tenant and all related data will become unrecoverable.",
                    "delete-tenants-title": "Are you sure you want to delete { count, select, 1 {1 tenant} other {# tenants} }?",
                    "delete-tenants-action-title": "Delete { count, select, 1 {1 tenant} other {# tenants} }",
                    "delete-tenants-text": "Be careful, after the confirmation all selected tenants will be removed and all related data will become unrecoverable.",
                    "title": "Title",
                    "title-required": "Title is required.",
                    "description": "Description"
                },
                "timeinterval": {
                    "seconds-interval": "{ seconds, select, 1 {1 second} other {# seconds} }",
                    "minutes-interval": "{ minutes, select, 1 {1 minute} other {# minutes} }",
                    "hours-interval": "{ hours, select, 1 {1 hour} other {# hours} }",
                    "days-interval": "{ days, select, 1 {1 day} other {# days} }",
                    "days": "Days",
                    "hours": "Hours",
                    "minutes": "Minutes",
                    "seconds": "Seconds",
                    "advanced": "Advanced"
                },
                "timewindow": {
                    "days": "{ days, select, 1 { day } other {# days } }",
                    "hours": "{ hours, select, 0 { hour } 1 {1 hour } other {# hours } }",
                    "minutes": "{ minutes, select, 0 { minute } 1 {1 minute } other {# minutes } }",
                    "seconds": "{ seconds, select, 0 { second } 1 {1 second } other {# seconds } }",
                    "realtime": "Realtime",
                    "history": "History",
                    "last-prefix": "last",
                    "period": "from {{ startTime }} to {{ endTime }}",
                    "edit": "Edit timewindow",
                    "date-range": "Date range",
                    "last": "Last",
                    "time-period": "Time period"
                },
                "user": {
                    "users": "Users",
                    "customer-users": "Customer Users",
                    "tenant-admins": "Tenant Admins",
                    "sys-admin": "System administrator",
                    "tenant-admin": "Tenant administrator",
                    "customer": "Customer",
                    "anonymous": "Anonymous",
                    "add": "Add User",
                    "delete": "Delete user",
                    "add-user-text": "Add new user",
                    "no-users-text": "No users found",
                    "user-details": "User details",
                    "delete-user-title": "Are you sure you want to delete the user '{{userEmail}}'?",
                    "delete-user-text": "Be careful, after the confirmation the user and all related data will become unrecoverable.",
                    "delete-users-title": "Are you sure you want to delete { count, select, 1 {1 user} other {# users} }?",
                    "delete-users-action-title": "Delete { count, select, 1 {1 user} other {# users} }",
                    "delete-users-text": "Be careful, after the confirmation all selected users will be removed and all related data will become unrecoverable.",
                    "activation-email-sent-message": "Activation email was successfully sent!",
                    "resend-activation": "Resend activation",
                    "email": "Email",
                    "email-required": "Email is required.",
                    "first-name": "First Name",
                    "last-name": "Last Name",
                    "description": "Description",
                    "default-dashboard": "Default dashboard",
                    "always-fullscreen": "Always fullscreen"
                },
                "value": {
                    "type": "Value type",
                    "string": "String",
                    "string-value": "String value",
                    "integer": "Integer",
                    "integer-value": "Integer value",
                    "invalid-integer-value": "Invalid integer value",
                    "double": "Double",
                    "double-value": "Double value",
                    "boolean": "Boolean",
                    "boolean-value": "Boolean value",
                    "false": "False",
                    "true": "True"
                },
                "widget": {
                    "widget-library": "Widgets Library",
                    "widget-bundle": "Widgets Bundle",
                    "select-widgets-bundle": "Select widgets bundle",
                    "management": "Widget management",
                    "editor": "Widget Editor",
                    "widget-type-not-found": "Problem loading widget configuration.<br>Probably associated\n    widget type was removed.",
                    "widget-type-load-error": "Widget wasn't loaded due to the following errors:",
                    "remove": "Remove widget",
                    "edit": "Edit widget",
                    "remove-widget-title": "Are you sure you want to remove the widget '{{widgetTitle}}'?",
                    "remove-widget-text": "After the confirmation the widget and all related data will become unrecoverable.",
                    "timeseries": "Time series",
                    "latest-values": "Latest values",
                    "rpc": "Control widget",
                    "static": "Static widget",
                    "select-widget-type": "Select widget type",
                    "missing-widget-title-error": "Widget title must be specified!",
                    "widget-saved": "Widget saved",
                    "unable-to-save-widget-error": "Unable to save widget! Widget has errors!",
                    "save": "Save widget",
                    "saveAs": "Save widget as",
                    "save-widget-type-as": "Save widget type as",
                    "save-widget-type-as-text": "Please enter new widget title and/or select target widgets bundle",
                    "toggle-fullscreen": "Toggle fullscreen",
                    "run": "Run widget",
                    "title": "Widget title",
                    "title-required": "Widget title is required.",
                    "type": "Widget type",
                    "resources": "Resources",
                    "resource-url": "JavaScript/CSS URL",
                    "remove-resource": "Remove resource",
                    "add-resource": "Add resource",
                    "html": "HTML",
                    "tidy": "Tidy",
                    "css": "CSS",
                    "settings-schema": "Settings schema",
                    "datakey-settings-schema": "Data key settings schema",
                    "javascript": "Javascript",
                    "remove-widget-type-title": "Are you sure you want to remove the widget type '{{widgetName}}'?",
                    "remove-widget-type-text": "After the confirmation the widget type and all related data will become unrecoverable.",
                    "remove-widget-type": "Remove widget type",
                    "add-widget-type": "Add new widget type",
                    "widget-type-load-failed-error": "Failed to load widget type!",
                    "widget-template-load-failed-error": "Failed to load widget template!",
                    "add": "Add Widget",
                    "undo": "Undo widget changes",
                    "export": "Export widget"
                },
                "widgets-bundle": {
                    "current": "Current bundle",
                    "widgets-bundles": "Widgets Bundles",
                    "add": "Add Widgets Bundle",
                    "delete": "Delete widgets bundle",
                    "title": "Title",
                    "title-required": "Title is required.",
                    "add-widgets-bundle-text": "Add new widgets bundle",
                    "no-widgets-bundles-text": "No widgets bundles found",
                    "empty": "Widgets bundle is empty",
                    "details": "Details",
                    "widgets-bundle-details": "Widgets bundle details",
                    "delete-widgets-bundle-title": "Are you sure you want to delete the widgets bundle '{{widgetsBundleTitle}}'?",
                    "delete-widgets-bundle-text": "Be careful, after the confirmation the widgets bundle and all related data will become unrecoverable.",
                    "delete-widgets-bundles-title": "Are you sure you want to delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }?",
                    "delete-widgets-bundles-action-title": "Delete { count, select, 1 {1 widgets bundle} other {# widgets bundles} }",
                    "delete-widgets-bundles-text": "Be careful, after the confirmation all selected widgets bundles will be removed and all related data will become unrecoverable.",
                    "no-widgets-bundles-matching": "No widgets bundles matching '{{widgetsBundle}}' were found.",
                    "widgets-bundle-required": "Widgets bundle is required.",
                    "system": "System",
                    "import": "Import widgets bundle",
                    "export": "Export widgets bundle",
                    "export-failed-error": "Unable to export widgets bundle: {{error}}",
                    "create-new-widgets-bundle": "Create new widgets bundle",
                    "widgets-bundle-file": "Widgets bundle file",
                    "invalid-widgets-bundle-file-error": "Unable to import widgets bundle: Invalid widgets bundle data structure."
                },
                "widget-config": {
                    "data": "Data",
                    "settings": "Settings",
                    "advanced": "Advanced",
                    "title": "Title",
                    "general-settings": "General settings",
                    "display-title": "Display title",
                    "drop-shadow": "Drop shadow",
                    "enable-fullscreen": "Enable fullscreen",
                    "background-color": "Background color",
                    "text-color": "Text color",
                    "padding": "Padding",
                    "title-style": "Title style",
                    "mobile-mode-settings": "Mobile mode settings",
                    "order": "Order",
                    "height": "Height",
                    "units": "Special symbol to show next to value",
                    "decimals": "Number of digits after floating point",
                    "timewindow": "Timewindow",
                    "use-dashboard-timewindow": "Use dashboard timewindow",
                    "display-legend": "Display legend",
                    "datasources": "Datasources",
                    "datasource-type": "Type",
                    "datasource-parameters": "Parameters",
                    "remove-datasource": "Remove datasource",
                    "add-datasource": "Add datasource",
                    "target-device": "Target device"
                },
                "widget-type": {
                    "import": "Import widget type",
                    "export": "Export widget type",
                    "export-failed-error": "Unable to export widget type: {{error}}",
                    "create-new-widget-type": "Create new widget type",
                    "widget-type-file": "Widget type file",
                    "invalid-widget-type-file-error": "Unable to import widget type: Invalid widget type data structure."
                },
                "language": {
                    "language": "Language",
                    "en_US": "English",
                    "ko_KR": "Korean"
                }
            }
        }
    ).name;