--
-- Copyright © 2016-2017 The Thingsboard Authors
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--

/** SYSTEM **/

/** System admin **/
INSERT INTO tb_user ( id, tenant_id, customer_id, email, search_text, authority )
VALUES ( '5a797660-4612-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', '13814000-1dd2-11b2-8080-808080808080', 'sysadmin@thingsboard.org',
         'sysadmin@thingsboard.org', 'SYS_ADMIN' );

INSERT INTO user_credentials ( id, user_id, enabled, password )
VALUES ( '61441950-4612-11e7-a919-92ebcb67fe33', '5a797660-4612-11e7-a919-92ebcb67fe33', true,
         '$2a$10$5JTB8/hxWc9WAy62nCGSxeefl3KWmipA9nFpVdDa0/xfIseeBB4Bu' );

/** System settings **/
INSERT INTO admin_settings ( id, key, json_value )
VALUES ( '6a2266e4-4612-11e7-a919-92ebcb67fe33', 'general', '{
	"baseUrl": "http://localhost:8080"
}' );

INSERT INTO admin_settings ( id, key, json_value )
VALUES ( '6eaaefa6-4612-11e7-a919-92ebcb67fe33', 'mail', '{
	"mailFrom": "Thingsboard <sysadmin@localhost.localdomain>",
	"smtpProtocol": "smtp",
	"smtpHost": "localhost",
	"smtpPort": "25",
	"timeout": "10000",
	"enableTls": "false",
	"username": "",
	"password": ""
}' );

/** System widgets library **/
INSERT INTO widgets_bundle ( id, tenant_id, alias, search_text, title )
VALUES ( '720d2788-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'gpio_widgets', 'gpio widgets', 'GPIO widgets' );

INSERT INTO widgets_bundle ( id, tenant_id, alias, search_text, title )
VALUES ( '75d009da-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'maps', 'maps', 'Maps' );

INSERT INTO widgets_bundle ( id, tenant_id, alias, search_text, title )
VALUES ( '7b2bf538-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges', 'digital gauges', 'Digital gauges' );

INSERT INTO widgets_bundle ( id, tenant_id, alias, search_text, title )
VALUES ( '7ec2783e-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'charts', 'Charts' );

INSERT INTO widgets_bundle ( id, tenant_id, alias, search_text, title )
VALUES ( '82ded5f2-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'cards', 'cards', 'Cards' );

INSERT INTO widgets_bundle ( id, tenant_id, alias, search_text, title )
VALUES ( '85a1fa1c-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'analogue_gauges', 'analogue gauges', 'Analogue gauges' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '89ab3f2e-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'timeseries',
         '{"type":"timeseries","sizeX":8,"sizeY":5,"resources":[{"url":"https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"}],"templateHtml":"<canvas id=\"lineChart\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    \n    var lineData = {\n        labels: [],\n        datasets: []\n    };\n    \n    for (var i=0; i < self.ctx.data.length; i++) {\n        var dataKey = self.ctx.data[i].dataKey;\n        var keySettings = dataKey.settings;\n        var backgroundColor = tinycolor(dataKey.color);\n        backgroundColor.setAlpha(0.4);\n        var dataset = {\n            label: dataKey.label,\n            data: [],\n            borderColor: dataKey.color,\n            borderWidth: 2,\n            backgroundColor: backgroundColor.toRgbString(),\n            pointRadius: keySettings.showPoints ? 1 : 0,\n            fill: keySettings.fillLines || false,\n            showLine: keySettings.showLines || true,\n            spanGaps: false,\n            lineTension: angular.isDefined(keySettings.tension) ? keySettings.tension : 0.2\n        }\n        lineData.datasets.push(dataset);\n    }\n\n    var ctx = $(''#lineChart'', self.ctx.$container);\n    self.ctx.chart = new Chart(ctx, {\n        type: ''line'',\n        data: lineData,\n        options: {\n            responsive: false,\n            tooltips: {\n                mode: ''index'',\n                inersect: true\n            },\n            hover: {\n                mode: ''index'',\n                inersect: true\n            },\n            maintainAspectRatio: false,\n            /*animation: {\n              duration: 200,\n              easing: ''linear''\n            },*/\n            elements: {\n              line: {\n                  tension: 0.2\n              }  \n            },\n            scales: {\n                xAxes: [{\n                    type: ''time'',\n                    ticks: {\n                        maxRotation: 20,\n                        autoSkip: true\n                    },\n                    time: {\n                        displayFormats: {\n                            second: ''hh:mm:ss'',\n                            minute: ''hh:mm:ss''\n                        }\n                    }\n                }]\n            },\n            zoom: {\n                onSelect: function(startTimeMs, endTimeMs) {\n                    self.ctx.timewindowFunctions.onUpdateTimewindow(startTimeMs, endTimeMs);\n                },\n                onResetSelect: function() {\n                    self.ctx.timewindowFunctions.onResetTimewindow();\n                }\n            }\n        }\n    });\n    \n    self.onResize();\n    \n}\n\nself.onDataUpdated = function() {\n    \n    if (self.ctx.chart.zoom.isMouseInteraction) {\n        return;\n    }\n    if (!self.ctx.tickUpdate) {\n        for (var i = 0; i < self.ctx.data.length; i++) {\n            var dataSetData = [];\n            var dataKeyData = self.ctx.data[i].data;\n            for (var i2 = 0; i2 < dataKeyData.length; i2 ++) {\n                dataSetData.push({x: moment(dataKeyData[i2][0]), y: dataKeyData[i2][1]});\n                \n            }\n            self.ctx.chart.data.datasets[i].data = dataSetData; \n        }\n    }\n    \n    self.ctx.chart.options.scales.xAxes[0].time.min = moment(self.ctx.timeWindow.minTime);\n    self.ctx.chart.options.scales.xAxes[0].time.max = moment(self.ctx.timeWindow.maxTime);\n    \n    self.ctx.chart.update(0, true);\n\n}\n\nself.onResize = function() {\n    self.ctx.chart.resize();\n    self.ctx.chart.update(0, true);\n}\n\nself.onDestroy = function() {\n}\n\nfunction getYAxis(chartInstance) {\n    var scales = chartInstance.scales;\n    for (var scaleId in scales) {\n\t    var scale = scales[scaleId];\n\n\t    if (!scale.isHorizontal()) {\n\t\t    return scale;\n\t    }\n    }\n}\n\nfunction getXAxis(chartInstance) {\n    var scales = chartInstance.scales;\n    for (var scaleId in scales) {\n\t    var scale = scales[scaleId];\n\n\t    if (scale.isHorizontal()) {\n\t\t    return scale;\n\t    }\n    }\n}\n\nfunction eventPointer (e) {\n    if (angular.isDefined(e.touches) && e.touches.length > 0) {\n      return {\n        x : e.touches[0].pageX,\n        y : e.touches[0].pageY\n      };\n    } else if (angular.isDefined(e.changedTouches) && e.changedTouches.length > 0) {\n      return {\n        x : e.changedTouches[0].pageX,\n        y : e.changedTouches[0].pageY\n      };\n    } else if (e.pageX || e.pageY) {\n      return {\n        x : e.pageX,\n        y : e.pageY\n      };\n    } else if (e.clientX || e.clientY) {\n      var\n        d = document,\n        b = d.body,\n        de = d.documentElement;\n      return {\n        x: e.clientX + b.scrollLeft + de.scrollLeft,\n        y: e.clientY + b.scrollTop + de.scrollTop\n      };\n    }\n}\n\nvar zoomPlugin =     {\n        beforeInit: function(chartInstance) {\n            chartInstance.zoom = {};\n            var node = chartInstance.zoom.node = chartInstance.chart.ctx.canvas;\n            \n            chartInstance.zoom.mouseDownHandler = function(event) {\n                chartInstance.zoom.dragZoomStart = event;\n                chartInstance.zoom.dragZoomStartPointer = eventPointer(event);\n                chartInstance.zoom.isMouseInteraction = true;\n            };\n\n            node.addEventListener(''mousedown'', chartInstance.zoom.mouseDownHandler);\n            \n            chartInstance.zoom.mouseMoveHandler = function(event) {\n                if (chartInstance.zoom.dragZoomStart) {\n                    chartInstance.update(0);\n                    chartInstance.zoom.dragZoomEnd = event;\n                    chartInstance.zoom.dragZoomEndPointer = eventPointer(event);\n                }\n            };\n            \n            node.addEventListener(''mousemove'', chartInstance.zoom.mouseMoveHandler);\n            \n            chartInstance.zoom.mouseUpHandler = function(event) {\n                if (chartInstance.zoom.dragZoomStart) {\n                    \n                    var chartArea = chartInstance.chartArea;\n                    var yAxis = getYAxis(chartInstance);\n\t\t\t\t\tvar beginPoint = chartInstance.zoom.dragZoomStart;\n\t\t\t\t\tvar beginPointer = chartInstance.zoom.dragZoomStartPointer;\n\t\t\t\t\tvar upEventPointer = eventPointer(event);\n\t\t\t\t\tvar offsetX = beginPoint.target.getBoundingClientRect().left;\n\t\t\t\t\tvar startX = Math.min(beginPointer.x, upEventPointer.x) - offsetX;\n\t\t\t\t\tvar endX = Math.max(beginPointer.x, upEventPointer.x) - offsetX;\n\t\t\t\t\tvar dragDistance = endX - startX;\n\t\t\t\t\t\n\t\t\t\t\tif (dragDistance > 0) {\n    \t\t\t\t\tvar xAxis = getXAxis(chartInstance);\n    \t\t\t\t\tvar options = chartInstance.options;\n    \t\t\t\t\tif (options.scales.xAxes[0].time) {\n    \t\t\t\t\t    startX = Math.max(startX, xAxis.left);\n    \t\t\t\t\t    endX = Math.min(endX, xAxis.right);\n    \t\t\t\t\t    if (endX - startX > 0) {\n    \t\t\t\t\t        startX = startX - xAxis.left;\n    \t\t\t\t\t        endX = endX - xAxis.left;\n        \t\t\t\t\t    var time = options.scales.xAxes[0].time;\n        \t\t\t\t\t    var min = time.min.valueOf();\n        \t\t\t\t\t    var max = time.max.valueOf();\n    \t\t\t\t\t        var axisDistance = xAxis.right - xAxis.left;\n    \t\t\t\t\t        var timeDistance = max - min;\n    \t\t\t\t\t        \n    \t\t\t\t\t        var zoomStartTime = min + startX / axisDistance * timeDistance;\n    \t\t\t\t\t        var zoomEndTime = min + endX / axisDistance * timeDistance;\n\n    \t\t\t\t\t        if (options.zoom && options.zoom.onSelect) {\n    \t\t\t\t\t            options.zoom.onSelect(zoomStartTime, zoomEndTime);\n    \t\t\t\t\t        }\n    \t\t\t\t\t    }\n    \t\t\t\t\t}\n\t\t\t\t\t}\n        \t\t\tchartInstance.zoom.dragZoomStart = null;\n        \t\t\tchartInstance.zoom.dragZoomEnd = null;            \n                }\n                chartInstance.zoom.isMouseInteraction = false;\n            };\n            \n            node.addEventListener(''mouseup'', chartInstance.zoom.mouseUpHandler);\n            \n            chartInstance.zoom.mouseLeaveHandler = function(event) {\n                if (chartInstance.zoom.dragZoomStart) {\n        \t\t\tchartInstance.zoom.dragZoomStart = null;\n        \t\t\tchartInstance.zoom.dragZoomEnd = null;            \n                }\n                chartInstance.zoom.isMouseInteraction = false;\n            };\n            \n            node.addEventListener(''mouseleave'', chartInstance.zoom.mouseLeaveHandler);\n            \n            chartInstance.zoom.dblClickHandler = function(event) {\n                if (chartInstance.zoom.dragZoomStart) {\n        \t\t\tchartInstance.zoom.dragZoomStart = null;\n        \t\t\tchartInstance.zoom.dragZoomEnd = null;            \n                }\n                var options = chartInstance.options;\n                if (options.zoom && options.zoom.onResetSelect) {\n                    options.zoom.onResetSelect();\n                }\n            };\n            \n            node.addEventListener(''dblclick'', chartInstance.zoom.dblClickHandler);\n        },\n        beforeDatasetsDraw: function(chartInstance, easing) {\n    \t\tvar ctx = chartInstance.chart.ctx;\n    \t\tvar chartArea = chartInstance.chartArea;\n    \t\tctx.save();\n    \t\tctx.beginPath();\n    \t\tif (chartInstance.zoom && chartInstance.zoom.dragZoomEnd) {\n    \t\t\tvar yAxis = getYAxis(chartInstance);\n    \t\t\tvar beginPoint = chartInstance.zoom.dragZoomStart;\n    \t\t\tvar beginPointer = chartInstance.zoom.dragZoomStartPointer;\n    \t\t\tvar endPoint = chartInstance.zoom.dragZoomEnd;\n    \t\t\tvar endPointer = chartInstance.zoom.dragZoomEndPointer;\n    \t\t\t\n    \t\t\tvar offsetX = beginPoint.target.getBoundingClientRect().left;\n    \t\t\tvar startX = Math.min(beginPointer.x, endPointer.x) - offsetX;\n    \t\t\tvar endX = Math.max(beginPointer.x, endPointer.x) - offsetX;\n    \t\t\tvar rectWidth = endX - startX;\n    \t\t\tctx.fillStyle = ''rgba(157,203,255,0.1)'';\n    \t\t\tctx.lineWidth = 1;\n    \t\t\tctx.strokeRect(startX, yAxis.top, rectWidth, yAxis.bottom - yAxis.top);\n    \t\t\tctx.fillRect(startX, yAxis.top, rectWidth, yAxis.bottom - yAxis.top);\n    \t\t}\n    \t\tif (chartArea) {\n    \t\t    ctx.rect(chartArea.left, chartArea.top, chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);\n    \t\t}\n\t\t    ctx.clip();            \n        },\n        \n        afterDatasetsDraw: function(chartInstance) {\n\t        chartInstance.chart.ctx.restore();\n        },\n        \n        destroy: function(chartInstance) {\n            if (chartInstance.zoom) {\n                var node = chartInstance.zoom.node;\n\t\t\t\tnode.removeEventListener(''mousedown'', chartInstance.zoom.mouseDownHandler);\n\t\t\t\tnode.removeEventListener(''mousemove'', chartInstance.zoom.mouseMoveHandler);\n\t\t\t\tnode.removeEventListener(''mouseup'', chartInstance.zoom.mouseUpHandler);\n\t\t\t\tnode.removeEventListener(''mouseleave'', chartInstance.zoom.mouseLeaveHandler);\t \n\t\t\t\tnode.removeEventListener(''dblclick'', chartInstance.zoom.dblClickHandler);\n\t\t\t\tdelete chartInstance.zoom;\n            }\n        }\n    };\n\nChart.pluginService.register(zoomPlugin);\n","settingsSchema":"{}","dataKeySettingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"DataKeySettings\",\n        \"properties\": {\n            \"showLines\": {\n                \"title\": \"Show lines\",\n                \"type\": \"boolean\",\n                \"default\": true\n            },\n            \"fillLines\": {\n                \"title\": \"Fill lines\",\n                \"type\": \"boolean\",\n                \"default\": false\n            },\n            \"showPoints\": {\n                \"title\": \"Show points\",\n                \"type\": \"boolean\",\n                \"default\": false\n            },\n            \"tension\": {\n                \"title\": \"Line tension\",\n                \"type\": \"number\",\n                \"default\": 0.2\n            }\n        },\n        \"required\": [\"showLines\", \"fillLines\", \"showPoints\"]\n    },\n    \"form\": [\n        \"showLines\",\n        \"fillLines\",\n        \"showPoints\",\n        \"tension\"\n    ]\n}","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{\"showLines\":true,\"fillLines\":false,\"showPoints\":false},\"_hash\":0.5644745944820795,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -1000) {\\n\\tvalue = -1000;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#ffc107\",\"settings\":{\"showLines\":true,\"fillLines\":true,\"showPoints\":false},\"_hash\":0.18379294198604845,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -1000) {\\n\\tvalue = -1000;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{},\"title\":\"Timeseries - Chart.js (Deprecated)\"}"}',
         'Timeseries - Chart.js (Deprecated)' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '8d5ffd08-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'digital_vertical_bar',
         '{"type":"latest","sizeX":2.5,"sizeY":4.5,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < -60) {\\n\\tvalue = -60;\\n} else if (value > 60) {\\n\\tvalue = 60;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#000000\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":60,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[\"#3d5afe\",\"#f44336\"],\"refreshAnimationType\":\"<>\",\"refreshAnimationTime\":700,\"startAnimationType\":\"<>\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"style\":\"normal\",\"weight\":\"500\",\"size\":14},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":8,\"style\":\"normal\",\"weight\":\"normal\",\"color\":\"#cccccc\"},\"neonGlowBrightness\":20,\"decimals\":0,\"showUnitTitle\":true,\"gaugeColor\":\"#171a1c\",\"gaugeType\":\"verticalBar\",\"showTitle\":false,\"units\":\"°C\",\"minValue\":-60,\"dashThickness\":1.2},\"title\":\"Digital vertical bar\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Digital vertical bar' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '90e8e4ee-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'gpio_widgets', 'gpio_panel',
         '{"type":"latest","sizeX":5,"sizeY":2,"resources":[],"templateHtml":"<div class=\"gpio-panel\" style=\"height: 100%;\">\n    <section layout=\"row\" ng-repeat=\"row in rows\">\n        <section flex layout=\"row\" ng-repeat=\"cell in row\">\n            <section layout=\"row\" flex ng-if=\"cell\" layout-align=\"{{$index===0 ? ''end center'' : ''start center''}}\">\n                <span class=\"gpio-left-label\" ng-show=\"$index===0\">{{ cell.label }}</span>\n                <section layout=\"row\" class=\"led-panel\" ng-class=\"$index===0 ? ''col-0'' : ''col-1''\"\n                      ng-style=\"{backgroundColor: ledPanelBackgroundColor }\">\n                    <span class=\"pin\" ng-show=\"$index===0\">{{cell.pin}}</span>\n                    <span class=\"led-container\">\n                        <tb-led-light size=\"prefferedRowHeight\"\n                                      color-on=\"cell.colorOn\"\n                                      color-off=\"cell.colorOff\"\n                                      off-opacity=\"''0.9''\"\n                                      tb-enabled=\"cell.enabled\">\n                        </tb-led-light>\n                    </span>\n                    <span class=\"pin\" ng-show=\"$index===1\">{{cell.pin}}</span>\n                </section>\n                <span class=\"gpio-right-label\" ng-show=\"$index===1\">{{ cell.label }}</span>\n            </section>\n            <section layout=\"row\" flex ng-if=\"!cell\">\n                <span flex ng-show=\"$index===0\"></span>\n                <span class=\"led-panel\"\n                      ng-style=\"{backgroundColor: ledPanelBackgroundColor }\"></span>\n                <span flex ng-show=\"$index===1\"></span>\n            </section>\n        </section>\n    </section>                            \n</div>","templateCss":".error {\n    font-size: 14px !important;\n    color: maroon;/*rgb(250,250,250);*/\n    background-color: transparent;\n    padding: 6px;\n}\n\n.error span {\n    margin: auto;\n}\n\n.gpio-panel {\n    padding-top: 10px;\n    white-space: nowrap;\n}\n\n.gpio-panel tb-led-light > div {\n    margin: auto;\n}\n\n.led-panel {\n    margin: 0;\n    width: 66px;\n    min-width: 66px;\n}\n\n.led-container {\n    width: 48px;\n    min-width: 48px;\n}\n\n.pin {\n    margin-top: auto;\n    margin-bottom: auto;\n    color: white;\n    font-size: 12px;\n    width: 16px;\n    min-width: 16px;\n}\n\n.led-panel.col-0 .pin {\n    margin-left: auto;\n    padding-left: 2px;\n    text-align: right;\n}\n\n.led-panel.col-1 .pin {\n    margin-right: auto;\n    \n    text-align: left;\n}\n\n.gpio-left-label {\n    margin-right: 8px;\n}\n\n.gpio-right-label {\n    margin-left: 8px;\n}","controllerScript":"self.onInit = function() {\n    var i, gpio;\n    \n    var scope = self.ctx.$scope;\n    var settings = self.ctx.settings;\n    \n    scope.gpioList = [];\n    scope.gpioByPin = {};\n    for (var g = 0; g < settings.gpioList.length; g++) {\n        gpio = settings.gpioList[g];\n        scope.gpioList.push(\n            {\n                row: gpio.row,\n                col: gpio.col,\n                pin: gpio.pin,\n                label: gpio.label,\n                enabled: false,\n                colorOn: tinycolor(gpio.color).lighten(20).toHexString(),\n                colorOff: tinycolor(gpio.color).darken().toHexString()\n            }\n        );\n        scope.gpioByPin[gpio.pin] = scope.gpioList[scope.gpioList.length-1];\n    }\n\n    scope.ledPanelBackgroundColor = settings.ledPanelBackgroundColor || tinycolor(''green'').lighten(2).toRgbString();\n\n    scope.gpioCells = {};\n    var rowCount = 0;\n    for (i = 0; i < scope.gpioList.length; i++) {\n        gpio = scope.gpioList[i];\n        scope.gpioCells[gpio.row+''_''+gpio.col] = gpio;\n        rowCount = Math.max(rowCount, gpio.row+1);\n    }\n    \n    scope.prefferedRowHeight = 32;\n    scope.rows = [];\n    for (i = 0; i < rowCount; i++) {\n        var row = [];\n        for (var c =0; c<2;c++) {\n            if (scope.gpioCells[i+''_''+c]) {\n                row[c] = scope.gpioCells[i+''_''+c];\n            } else {\n                row[c] = null;\n            }\n        }\n        scope.rows.push(row);\n    }    \n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    var changed = false;\n    for (var d = 0; d < self.ctx.data.length; d++) {\n        var cellData = self.ctx.data[d];\n        var dataKey = cellData.dataKey;\n        var gpio = self.ctx.$scope.gpioByPin[dataKey.label];\n        if (gpio) {\n            var enabled = false;\n            if (cellData.data.length > 0) {\n                var tvPair = cellData.data[cellData.data.length - 1];\n                enabled = (tvPair[1] === true || tvPair[1] === ''true'');\n            }\n            if (gpio.enabled != enabled) {\n                changed = true;\n                gpio.enabled = enabled;\n            }\n        }\n    }\n    if (changed) {\n        self.ctx.$scope.$digest();\n    }    \n}\n\nself.onResize = function() {\n    var rowCount = self.ctx.$scope.rows.length;\n    var prefferedRowHeight = (self.ctx.height - 35)/rowCount;\n    prefferedRowHeight = Math.min(32, prefferedRowHeight);\n    prefferedRowHeight = Math.max(12, prefferedRowHeight);\n    self.ctx.$scope.prefferedRowHeight = prefferedRowHeight;\n    \n    var ratio = prefferedRowHeight/32;\n    \n    var leftLabels = $(''.gpio-left-label'', self.ctx.$container);\n    leftLabels.css(''font-size'', 16*ratio+''px'');\n    var rightLabels = $(''.gpio-right-label'', self.ctx.$container);\n    rightLabels.css(''font-size'', 16*ratio+''px'');\n    var pins = $(''.pin'', self.ctx.$container);\n    var pinsFontSize = Math.max(9, 12*ratio);\n    pins.css(''font-size'', pinsFontSize+''px'');    \n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"properties\": {\n            \"gpioList\": {\n                \"title\": \"Gpio leds\",\n                \"type\": \"array\",\n                \"minItems\" : 1,\n                \"items\": {\n                    \"title\": \"Gpio led\",\n                    \"type\": \"object\",\n                    \"properties\": {\n                        \"pin\": {\n                            \"title\": \"Pin\",\n                            \"type\": \"number\"\n                        },\n                        \"label\": {\n                            \"title\": \"Label\",\n                            \"type\": \"string\"\n                        },\n                        \"row\": {\n                            \"title\": \"Row\",\n                            \"type\": \"number\"\n                        },\n                        \"col\": {\n                            \"title\": \"Column\",\n                            \"type\": \"number\"\n                        },\n                        \"color\": {\n                            \"title\": \"Color\",\n                            \"type\": \"string\",\n                            \"default\": \"red\"\n                        }\n                    },\n                    \"required\": [\"pin\", \"label\", \"row\", \"col\", \"color\"]\n                }\n            },\n            \"ledPanelBackgroundColor\": {\n                \"title\": \"LED panel background color\",\n                \"type\": \"string\",\n                \"default\": \"#008a00\"\n            } \n        },\n        \"required\": [\"gpioList\", \n                     \"ledPanelBackgroundColor\"]\n    },\n    \"form\": [\n        {\n            \"key\": \"gpioList\",\n            \"items\": [\n                \"gpioList[].pin\",\n                \"gpioList[].label\",\n                \"gpioList[].row\",\n                \"gpioList[].col\",\n                {\n                    \"key\": \"gpioList[].color\",\n                    \"type\": \"color\"\n                }\n            ]\n        },\n        {\n            \"key\": \"ledPanelBackgroundColor\",\n            \"type\": \"color\"\n        }\n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"gpioList\":[{\"pin\":1,\"label\":\"GPIO 1\",\"row\":0,\"col\":0,\"color\":\"#008000\",\"_uniqueKey\":0},{\"pin\":2,\"label\":\"GPIO 2\",\"row\":0,\"col\":1,\"color\":\"#ffff00\",\"_uniqueKey\":1},{\"pin\":3,\"label\":\"GPIO 3\",\"row\":1,\"col\":0,\"color\":\"#cf006f\",\"_uniqueKey\":2}],\"ledPanelBackgroundColor\":\"#b71c1c\"},\"title\":\"Basic GPIO Panel\",\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"1\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.22518255793320163,\"funcBody\":\"var period = time % 1500;\\nreturn period < 500;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"2\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.7008206860666621,\"funcBody\":\"var period = time % 1500;\\nreturn period >= 500 && period < 1000;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"3\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.42600325102193426,\"funcBody\":\"var period = time % 1500;\\nreturn period >= 1000;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}}}"}',
         'Basic GPIO Panel' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '955ad5fa-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'cards', 'timeseries_table',
         '{"type":"timeseries","sizeX":8,"sizeY":6.5,"resources":[],"templateHtml":"<tb-timeseries-table-widget \n    config=\"config\"\n    table-id=\"tableId\"\n    datasources=\"datasources\"\n    data=\"data\">\n</tb-timeseries-table-widget>","templateCss":"","controllerScript":"self.onInit = function() {\n    \n    var scope = self.ctx.$scope;\n    var id = self.ctx.$scope.$injector.get(''utils'').guid();\n\n    scope.config = {\n        settings: self.ctx.settings,\n        widgetConfig: self.ctx.widgetConfig\n    }\n\n    scope.datasources = self.ctx.datasources;\n    scope.data = self.ctx.data;\n    scope.tableId = \"table-\"+id;\n    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.$scope.data = self.ctx.data;\n    self.ctx.$scope.$broadcast(''timeseries-table-data-updated'', self.ctx.$scope.tableId);\n}\n\nself.onDestroy = function() {\n}","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"TimeseriesTableSettings\",\n        \"properties\": {\n            \"showTimestamp\": {\n                \"title\": \"Display timestamp column\",\n                \"type\": \"boolean\",\n                \"default\": true\n            }\n        },\n        \"required\": []\n    },\n    \"form\": [\n        \"showTimestamp\"\n    ]\n}","dataKeySettingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"DataKeySettings\",\n        \"properties\": {\n            \"useCellStyleFunction\": {\n                \"title\": \"Use cell style function\",\n                \"type\": \"boolean\",\n                \"default\": false\n            },\n            \"cellStyleFunction\": {\n                \"title\": \"Cell style function: f(value)\",\n                \"type\": \"string\",\n                \"default\": \"\"\n            },\n            \"useCellContentFunction\": {\n                \"title\": \"Use cell content function\",\n                \"type\": \"boolean\",\n                \"default\": false\n            },\n            \"cellContentFunction\": {\n                \"title\": \"Cell content function: f(value, rowData, filter)\",\n                \"type\": \"string\",\n                \"default\": \"\"\n            }\n        },\n        \"required\": []\n    },\n    \"form\": [\n        \"useCellStyleFunction\",\n        {\n            \"key\": \"cellStyleFunction\",\n            \"type\": \"javascript\"\n        },\n        \"useCellContentFunction\",\n        {\n            \"key\": \"cellContentFunction\",\n            \"type\": \"javascript\"\n        }\n    ]\n}","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temperature  °C\",\"color\":\"#2196f3\",\"settings\":{\"useCellStyleFunction\":true,\"cellStyleFunction\":\"if (value) {\\n    var percent = (value + 60)/120 * 100;\\n    var color = tinycolor.mix(''blue'', ''red'', amount = percent);\\n    color.setAlpha(.5);\\n    return {\\n      paddingLeft: ''20px'',\\n      color: ''#ffffff'',\\n      background: color.toRgbString(),\\n      fontSize: ''18px''\\n    };\\n} else {\\n    return {};\\n}\"},\"_hash\":0.8587686344902596,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nvar multiplier = Math.pow(10, 1 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -60) {\\n\\tvalue = -60;\\n} else if (value > 60) {\\n\\tvalue = 60;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Humidity, %\",\"color\":\"#ffc107\",\"settings\":{\"useCellStyleFunction\":true,\"cellStyleFunction\":\"if (value) {\\n    var percent = value;\\n    var backgroundColor = tinycolor(''blue'');\\n    backgroundColor.setAlpha(value/100);\\n    var color = ''blue'';\\n    if (value > 50) {\\n        color = ''white'';\\n    }\\n    \\n    return {\\n      paddingLeft: ''20px'',\\n      color: color,\\n      background: backgroundColor.toRgbString(),\\n      fontSize: ''18px''\\n    };\\n} else {\\n    return {};\\n}\",\"useCellContentFunction\":false},\"_hash\":0.12775350966079668,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nvar multiplier = Math.pow(10, 1 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < 5) {\\n\\tvalue = 5;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"interval\":1000,\"timewindowMs\":60000},\"aggregation\":{\"type\":\"NONE\",\"limit\":200}},\"showTitle\":true,\"backgroundColor\":\"rgb(255, 255, 255)\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"showTimestamp\":true},\"title\":\"Timeseries table\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400},\"useDashboardTimewindow\":false,\"showLegend\":false}"}',
         'Timeseries table' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '9aa48574-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'polar_area_chart_js',
         '{"type":"latest","sizeX":7,"sizeY":5,"resources":[{"url":"https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.3.0/Chart.min.js"}],"templateHtml":"<canvas id=\"pieChart\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    var pieData = {\n        labels: [],\n        datasets: []\n    };\n\n    var dataset = {\n        data: [],\n        backgroundColor: [],\n        borderColor: [],\n        borderWidth: [],\n        hoverBackgroundColor: []\n    }\n    \n    pieData.datasets.push(dataset);\n    \n    for (var i = 0; i < self.ctx.data.length; i++) {\n        var dataKey = self.ctx.data[i].dataKey;\n        pieData.labels.push(dataKey.label);\n        dataset.data.push(0);\n        var hoverBackgroundColor = tinycolor(dataKey.color).lighten(15);\n        var borderColor = tinycolor(dataKey.color).darken();\n        dataset.backgroundColor.push(dataKey.color);\n        dataset.borderColor.push(''#fff'');\n        dataset.borderWidth.push(5);\n        dataset.hoverBackgroundColor.push(hoverBackgroundColor.toRgbString());\n    }\n\n    var ctx = $(''#pieChart'', self.ctx.$container);\n    self.ctx.chart = new Chart(ctx, {\n        type: ''polarArea'',\n        data: pieData,\n        options: {\n            responsive: false,\n            maintainAspectRatio: false\n        }\n    });\n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    for (var i = 0; i < self.ctx.data.length; i++) {\n        var cellData = self.ctx.data[i];\n        if (cellData.data.length > 0) {\n             var tvPair = cellData.data[cellData.data.length - 1];\n             var value = tvPair[1];\n             self.ctx.chart.data.datasets[0].data[i] = parseFloat(value);\n        }\n    }\n  \n    self.ctx.chart.update();\n}\n\nself.onResize = function() {\n    if (self.ctx.height >= 70) {\n        try {\n            self.ctx.chart.resize();\n        } catch (e) {}\n    }\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.545701115289893,\"funcBody\":\"var value = (prevValue-20) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+20;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Third\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.2592906835158064,\"funcBody\":\"var value = (prevValue-40) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+40;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Fourth\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.12880275585455747,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Fifth\",\"color\":\"#607d8b\",\"settings\":{},\"_hash\":0.2074391823443591,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{},\"title\":\"Polar Area - Chart.js\"}"}',
         'Polar Area - Chart.js' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '9d896bb0-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'cards', 'html_card',
         '{"type":"static","sizeX":7.5,"sizeY":3,"resources":[],"templateHtml":"","templateCss":"","controllerScript":"self.onInit = function() {\n\n    var cssParser = new cssjs();\n    cssParser.testMode = false;\n    var namespace = ''html-card-'' + hashCode(self.ctx.settings.cardCss);\n    cssParser.cssPreviewNamespace = namespace;\n    cssParser.createStyleElement(namespace, self.ctx.settings.cardCss);\n    self.ctx.$container.addClass(namespace);\n    cardHtml = self.ctx.settings.cardHtml;\n    self.ctx.$container.html(cardHtml);\n    \n    function hashCode(str) {\n        var hash = 0;\n        var i, char;\n        if (str.length === 0) return hash;\n        for (i = 0; i < str.length; i++) {\n            char = str.charCodeAt(i);\n            hash = ((hash << 5) - hash) + char;\n            hash = hash & hash;\n        }\n        return hash;\n    }\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"required\": [\"cardHtml\"],\n        \"properties\": {\n            \"cardCss\": {\n                \"title\": \"CSS\",\n                \"type\": \"string\",\n                \"default\": \".card {\\n font-weight: bold; \\n}\"\n            },\n            \"cardHtml\": {\n                \"title\": \"HTML\",\n                \"type\": \"string\",\n                \"default\": \"<div class=''card''>HTML code here</div>\"\n            }\n        }\n    },\n    \"form\": [\n        {\n            \"key\": \"cardCss\",\n            \"type\": \"css\"\n        },           \n        {\n            \"key\": \"cardHtml\",\n            \"type\": \"html\"\n        }    \n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"static\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Random\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -1000) {\\n\\tvalue = -1000;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"rgb(255, 255, 255)\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"cardHtml\":\"<div class=''card''>HTML code here</div>\",\"cardCss\":\".card {\\n    font-weight: bold;\\n    font-size: 32px;\\n    color: #999;\\n    width: 100%;\\n    height: 100%;\\n    display: flex;\\n    align-items: center;\\n    justify-content: center;\\n}\"},\"title\":\"HTML Card\",\"dropShadow\":true}"}',
         'HTML Card' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'a0cf40e2-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'simple_neon_gauge_justgage',
         '{"type":"latest","sizeX":3,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#388e3c\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#000000\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":1,\"levelColors\":[],\"refreshAnimationType\":\">\",\"refreshAnimationTime\":700,\"startAnimationType\":\">\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"style\":\"normal\",\"weight\":\"500\",\"size\":32},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"neonGlowBrightness\":40,\"dashThickness\":1.5,\"decimals\":0,\"gaugeType\":\"donut\"},\"title\":\"Simple neon gauge - justGage\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Simple neon gauge - justGage' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'a4e28428-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'analogue_gauges',
         'radial_gauge_canvas_gauges',
         '{"type":"latest","sizeX":6,"sizeY":5,"resources":[],"templateHtml":"<canvas id=\"radialGauge\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbAnalogueRadialGauge(self.ctx, ''radialGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.getSettingsSchema = function() {\n    return TbAnalogueRadialGauge.settingsSchema;\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 50 - 25;\\nif (value < -100) {\\n\\tvalue = -100;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"rgb(255, 255, 255)\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"maxValue\":100,\"startAngle\":45,\"ticksAngle\":270,\"showBorder\":true,\"defaultColor\":\"#e65100\",\"needleCircleSize\":10,\"highlights\":[],\"showUnitTitle\":true,\"colorPlate\":\"#fff\",\"colorMajorTicks\":\"#444\",\"colorMinorTicks\":\"#666\",\"minorTicks\":10,\"valueInt\":3,\"valueDec\":0,\"highlightsWidth\":15,\"valueBox\":true,\"animation\":true,\"animationDuration\":500,\"animationRule\":\"cycle\",\"colorNeedleShadowUp\":\"rgba(2, 255, 255, 0)\",\"numbersFont\":{\"family\":\"Roboto\",\"size\":18,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#616161\"},\"titleFont\":{\"family\":\"Roboto\",\"size\":24,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#888\"},\"unitsFont\":{\"family\":\"Roboto\",\"size\":22,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#616161\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"size\":36,\"style\":\"normal\",\"weight\":\"normal\",\"shadowColor\":\"rgba(0, 0, 0, 0.49)\",\"color\":\"#444\"},\"minValue\":-100,\"colorNeedleShadowDown\":\"rgba(188,143,143,0.45)\",\"colorValueBoxRect\":\"#888\",\"colorValueBoxRectEnd\":\"#666\",\"colorValueBoxBackground\":\"#babab2\",\"colorValueBoxShadow\":\"rgba(0,0,0,1)\"},\"title\":\"Radial gauge - Canvas Gauges\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Radial gauge - Canvas Gauges' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'a9005382-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'digital_speedometer',
         '{"type":"latest","sizeX":5,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Speed\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < 45) {\\n\\tvalue = 45;\\n} else if (value > 130) {\\n\\tvalue = 130;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#000000\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":180,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[\"#008000\",\"#fbc02d\",\"#f44336\"],\"refreshAnimationType\":\"linear\",\"refreshAnimationTime\":700,\"startAnimationType\":\"linear\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"style\":\"normal\",\"weight\":\"500\",\"size\":32},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#ffffff\"},\"neonGlowBrightness\":40,\"dashThickness\":1.5,\"decimals\":0,\"unitTitle\":\"MPH\",\"showUnitTitle\":true,\"gaugeColor\":\"#171a1c\",\"gaugeType\":\"arc\"},\"title\":\"Digital speedometer\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Digital speedometer' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'b0e395d2-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'doughnut_chart_js',
         '{"type":"latest","sizeX":7,"sizeY":5,"resources":[{"url":"https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.3.0/Chart.min.js"}],"templateHtml":"<canvas id=\"pieChart\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    var pieData = {\n        labels: [],\n        datasets: []\n    };\n\n    var dataset = {\n        data: [],\n        backgroundColor: [],\n        borderColor: [],\n        borderWidth: [],\n        hoverBackgroundColor: []\n    }\n    \n    var borderColor = self.ctx.settings.borderColor || ''#fff'';\n    var borderWidth = angular.isDefined(self.ctx.settings.borderWidth) ? self.ctx.settings.borderWidth : 5;\n    \n    pieData.datasets.push(dataset);\n    \n    for (var i=0; i < self.ctx.data.length; i++) {\n        var dataKey = self.ctx.data[i].dataKey;\n        pieData.labels.push(dataKey.label);\n        dataset.data.push(0);\n        var hoverBackgroundColor = tinycolor(dataKey.color).lighten(15);\n        dataset.backgroundColor.push(dataKey.color);\n        dataset.borderColor.push(borderColor);\n        dataset.borderWidth.push(borderWidth);\n        dataset.hoverBackgroundColor.push(hoverBackgroundColor.toRgbString());\n    }\n\n    var options = {\n        responsive: false,\n        maintainAspectRatio: false,\n        legend: {\n            display: true,\n            labels: {\n                fontColor: ''#666''\n            }\n        },\n        tooltips: {\n            callbacks: {\n                label: function(tooltipItem, data) {\n                    var label = data.labels[tooltipItem.index];\n                    var value = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];\n                    var content = label + '': '' + value;\n                    var units = self.ctx.settings.units ? self.ctx.settings.units : self.ctx.units;\n                    if (units) {\n                        content += '' '' + units;\n                    } \n                    return content;\n                }\n            }\n        }\n    };\n\n    if (self.ctx.settings.legend) {\n        options.legend.display = self.ctx.settings.legend.display !== false;\n        options.legend.labels.fontColor = self.ctx.settings.legend.labelsFontColor || ''#666'';\n    }\n\n    var ctx = $(''#pieChart'', self.ctx.$container);\n    self.ctx.chart = new Chart(ctx, {\n        type: ''doughnut'',\n        data: pieData,\n        options: options\n    });\n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    for (var i = 0; i < self.ctx.data.length; i++) {\n        var cellData = self.ctx.data[i];\n        if (cellData.data.length > 0) {\n             var tvPair = cellData.data[cellData.data.length - 1];\n             var value = tvPair[1];\n             self.ctx.chart.data.datasets[0].data[i] = parseFloat(value);\n        }\n    }\n    self.ctx.chart.update();\n}\n\nself.onResize = function() {\n    self.ctx.chart.resize();\n}\n\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"properties\": {\n            \"borderWidth\": {\n                \"title\": \"Border width\",\n                \"type\": \"number\",\n                \"default\": 5\n            },\n            \"borderColor\": {\n                \"title\": \"Border color\",\n                \"type\": \"string\",\n                \"default\": \"#fff\"\n            },\n            \"legend\": {\n                \"title\": \"Legend settings\",\n                \"type\": \"object\",\n                \"properties\": {\n                    \"display\": {\n                        \"title\": \"Display legend\",\n                        \"type\": \"boolean\",\n                        \"default\": true\n                    },\n                    \"labelsFontColor\": {\n                        \"title\": \"Labels font color\",\n                        \"type\": \"string\",\n                        \"default\": \"#666\"\n                    }\n                }\n            }\n        },\n        \"required\": []\n    },\n    \"form\": [\n        \"borderWidth\", \n        {\n            \"key\": \"borderColor\",\n            \"type\": \"color\"\n        }, \n        {\n            \"key\": \"legend\",\n            \"items\": [\n                \"legend.display\",\n                {\n                    \"key\": \"legend.labelsFontColor\",\n                    \"type\": \"color\"\n                }\n            ]\n        }\n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#26a69a\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#f57c00\",\"settings\":{},\"_hash\":0.545701115289893,\"funcBody\":\"var value = (prevValue-20) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+20;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Third\",\"color\":\"#afb42b\",\"settings\":{},\"_hash\":0.2592906835158064,\"funcBody\":\"var value = (prevValue-40) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+40;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Fourth\",\"color\":\"#673ab7\",\"settings\":{},\"_hash\":0.12880275585455747,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"borderWidth\":5,\"borderColor\":\"#fff\",\"legend\":{\"display\":true,\"labelsFontColor\":\"#666666\"}},\"title\":\"Doughnut - Chart.js\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Doughnut - Chart.js' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'b456a0f6-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'pie_chart_js',
         '{"type":"latest","sizeX":8,"sizeY":5,"resources":[{"url":"https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.3.0/Chart.min.js"}],"templateHtml":"<canvas id=\"pieChart\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    \n    var pieData = {\n        labels: [],\n        datasets: []\n    };\n\n    var dataset = {\n        data: [],\n        backgroundColor: [],\n        borderColor: [],\n        borderWidth: [],\n        hoverBackgroundColor: []\n    }\n    \n    pieData.datasets.push(dataset);\n    \n    for (var i=0; i < self.ctx.data.length; i++) {\n        var dataKey = self.ctx.data[i].dataKey;\n        pieData.labels.push(dataKey.label);\n        dataset.data.push(0);\n        var hoverBackgroundColor = tinycolor(dataKey.color).lighten(15);\n        var borderColor = tinycolor(dataKey.color).darken();\n        dataset.backgroundColor.push(dataKey.color);\n        dataset.borderColor.push(''#fff'');\n        dataset.borderWidth.push(5);\n        dataset.hoverBackgroundColor.push(hoverBackgroundColor.toRgbString());\n    }\n\n    var ctx = $(''#pieChart'', self.ctx.$container);\n    self.ctx.chart = new Chart(ctx, {\n        type: ''pie'',\n        data: pieData,\n        options: {\n            responsive: false,\n            maintainAspectRatio: false\n        }\n    });    \n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    for (var i = 0; i < self.ctx.data.length; i++) {\n        var cellData = self.ctx.data[i];\n        if (cellData.data.length > 0) {\n             var tvPair = cellData.data[cellData.data.length - 1];\n             var value = tvPair[1];\n             self.ctx.chart.data.datasets[0].data[i] = parseFloat(value);\n        }\n    }\n    self.ctx.chart.update();\n}\n\nself.onResize = function() {\n    self.ctx.chart.resize();\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.545701115289893,\"funcBody\":\"var value = (prevValue-20) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+20;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Third\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.2592906835158064,\"funcBody\":\"var value = (prevValue-40) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+40;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Fourth\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.12880275585455747,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{},\"title\":\"Pie - Chart.js\"}"}',
         'Pie - Chart.js' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'b72c406a-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'bars',
         '{"type":"latest","sizeX":7,"sizeY":5,"resources":[{"url":"https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.3.0/Chart.min.js"}],"templateHtml":"<canvas id=\"barChart\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    var barData = {\n        labels: [],\n        datasets: []\n    };\n    \n    for (var i = 0; i < self.ctx.datasources.length; i++) {\n        var datasource = self.ctx.datasources[i];\n        for (var d = 0; d < datasource.dataKeys.length; d++) {\n            var dataset = {\n                label: datasource.dataKeys[d].label,\n                data: [0],\n                backgroundColor: [datasource.dataKeys[d].color],\n                borderColor: [datasource.dataKeys[d].color],\n                borderWidth: 1\n            }\n            barData.datasets.push(dataset);\n        }\n    }\n\n    var ctx = $(''#barChart'', self.ctx.$container);\n    self.ctx.chart = new Chart(ctx, {\n        type: ''bar'',\n        data: barData,\n        options: {\n            responsive: false,\n            maintainAspectRatio: false,\n            scales: {\n                yAxes: [{\n                    ticks: {\n                        beginAtZero:true\n                    }\n                }]\n            }\n        }\n    });\n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    var c = 0;\n    for (var i = 0; i < self.ctx.chart.data.datasets.length; i++) {\n        var dataset = self.ctx.chart.data.datasets[i];\n        var cellData = self.ctx.data[i]; \n        if (cellData.data.length > 0) {\n             var tvPair = cellData.data[cellData.data.length - 1];\n             var value = tvPair[1];\n             dataset.data[0] = parseFloat(value);\n        }\n    }\n    self.ctx.chart.update();\n}\n\nself.onResize = function() {\n    self.ctx.chart.resize();\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.545701115289893,\"funcBody\":\"var value = (prevValue-20) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+20;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Third\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.2592906835158064,\"funcBody\":\"var value = (prevValue-40) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+40;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Fourth\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.12880275585455747,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{},\"title\":\"Bars - Chart.js\"}"}',
         'Bars - Chart.js' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'bb14af46-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges', 'digital_bar',
         '{"type":"latest","sizeX":6,"sizeY":2.5,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Speed\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < 80) {\\n\\tvalue = 80;\\n} else if (value > 160) {\\n\\tvalue = 160;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#000000\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":180,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[\"#008000\",\"#fbc02d\",\"#f44336\"],\"refreshAnimationType\":\"linear\",\"refreshAnimationTime\":700,\"startAnimationType\":\"linear\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"style\":\"normal\",\"weight\":\"500\",\"size\":18},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#ffffff\"},\"neonGlowBrightness\":40,\"dashThickness\":1.5,\"decimals\":0,\"unitTitle\":\"MPH\",\"showUnitTitle\":true,\"gaugeColor\":\"#171a1c\",\"gaugeType\":\"horizontalBar\",\"showTitle\":false},\"title\":\"Digital horizontal bar\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Digital horizontal bar' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'be62e9f6-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'mini_gauge_justgage',
         '{"type":"latest","sizeX":2,"sizeY":2,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#7cb342\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#ffffff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\">\",\"refreshAnimationTime\":700,\"startAnimationType\":\">\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Roboto\",\"style\":\"normal\",\"weight\":\"500\",\"size\":32},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"neonGlowBrightness\":0,\"dashThickness\":0,\"decimals\":0,\"roundedLineCap\":true,\"gaugeType\":\"donut\"},\"title\":\"Mini gauge - justGage\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Mini gauge - justGage' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'c7a95f5e-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'maps', 'route_map_openstreetmap',
         '{"type":"timeseries","sizeX":8.5,"sizeY":6,"resources":[],"templateHtml":"","templateCss":".leaflet-zoom-box {\n\tz-index: 9;\n}\n\n.leaflet-pane         { z-index: 4; }\n\n.leaflet-tile-pane    { z-index: 2; }\n.leaflet-overlay-pane { z-index: 4; }\n.leaflet-shadow-pane  { z-index: 5; }\n.leaflet-marker-pane  { z-index: 6; }\n.leaflet-tooltip-pane   { z-index: 7; }\n.leaflet-popup-pane   { z-index: 8; }\n\n.leaflet-map-pane canvas { z-index: 1; }\n.leaflet-map-pane svg    { z-index: 2; }\n\n.leaflet-control {\n\tz-index: 9;\n}\n.leaflet-top,\n.leaflet-bottom {\n\tz-index: 11;\n}\n\n.tb-marker-label {\n    border: none;\n    background: none;\n    box-shadow: none;\n}\n\n.tb-marker-label:before {\n    border: none;\n    background: none;\n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.map = new TbMapWidget(''openstreet-map'', true, self.ctx);\n}\n\nself.onDataUpdated = function() {\n    self.ctx.map.update();\n}\n\nself.onResize = function() {\n    self.ctx.map.resize();\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n  \"schema\": {\n    \"title\": \"Route Map Configuration\",\n    \"type\": \"object\",\n    \"properties\": {\n      \"defaultZoomLevel\": {\n         \"title\": \"Default map zoom level (1 - 20)\",\n         \"type\": \"number\"\n      },\n      \"fitMapBounds\": {\n          \"title\": \"Fit map bounds to cover all markers\",\n          \"type\": \"boolean\",\n          \"default\": true\n      },\n      \"routesSettings\": {\n            \"title\": \"Routes\",\n            \"type\": \"array\",\n            \"items\": {\n              \"title\": \"Route settings\",\n              \"type\": \"object\",\n              \"properties\": {\n                  \"latKeyName\": {\n                    \"title\": \"Latitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lat\"\n                  },\n                  \"lngKeyName\": {\n                    \"title\": \"Longitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lng\"\n                  },\n                  \"showLabel\": {\n                    \"title\": \"Show label\",\n                    \"type\": \"boolean\",\n                    \"default\": true\n                  },                  \n                  \"label\": {\n                    \"title\": \"Label\",\n                    \"type\": \"string\"\n                  },\n                  \"tooltipPattern\": {\n                    \"title\": \"Pattern ( for ex. ''Text ${keyName} units.'' or ''${#<key index>} units''  )\",\n                    \"type\": \"string\",\n                    \"default\": \"<b>Latitude:</b> ${lat:7}<br/><b>Longitude:</b> ${lng:7}\"\n                  },\n                  \"color\": {\n                    \"title\": \"Color\",\n                    \"type\": \"string\"\n                  },\n                  \"useColorFunction\": {\n                    \"title\": \"Use color function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"colorFunction\": {\n                    \"title\": \"Color function: f(data)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImage\": {\n                    \"title\": \"Custom marker image\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImageSize\": {\n                     \"title\": \"Custom marker image size (px)\",\n                     \"type\": \"number\",\n                     \"default\": 34\n                  },\n                  \"useMarkerImageFunction\": {\n                    \"title\": \"Use marker image function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"markerImageFunction\": {\n                    \"title\": \"Marker image function: f(data, images)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImages\": {\n                        \"title\": \"Marker images\",\n                        \"type\": \"array\",\n                        \"items\": {\n                          \"title\": \"Marker image\",\n                          \"type\": \"string\"\n                        }\n                  },\n                  \"strokeWeight\": {\n                    \"title\": \"Stroke weight\",\n                    \"type\": \"number\",\n                    \"default\": 2\n                  },\n                  \"strokeOpacity\": {\n                    \"title\": \"Stroke opacity\",\n                    \"type\": \"number\",\n                    \"default\": 1.0\n                  }\n              }\n            }\n      }\n    },\n    \"required\": [\n    ]\n  },\n  \"form\": [\n    \"defaultZoomLevel\",\n    \"fitMapBounds\",\n    {\n        \"key\": \"routesSettings\",\n        \"items\": [\n            \"routesSettings[].latKeyName\",\n            \"routesSettings[].lngKeyName\",\n            \"routesSettings[].showLabel\",\n            \"routesSettings[].label\",\n            \"routesSettings[].tooltipPattern\",\n            {\n                \"key\": \"routesSettings[].color\",\n                \"type\": \"color\"\n            },\n            \"routesSettings[].useColorFunction\",\n            {\n                \"key\": \"routesSettings[].colorFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"routesSettings[].markerImage\",\n                \"type\": \"image\"\n            },\n            \"routesSettings[].markerImageSize\",\n            \"routesSettings[].useMarkerImageFunction\",\n            {\n                \"key\": \"routesSettings[].markerImageFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"routesSettings[].markerImages\",\n                \"items\": [\n                    {\n                        \"key\": \"routesSettings[].markerImages[]\",\n                        \"type\": \"image\"\n                    }\n                ]\n            },\n            \"routesSettings[].strokeWeight\",\n            \"routesSettings[].strokeOpacity\"\n        ]\n    }\n  ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"latitude\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.8950926999078694,\"funcBody\":\"var lats = [37.7696499,\\n37.7699074,\\n37.7699536,\\n37.7697242,\\n37.7695189,\\n37.7696889,\\n37.7697153,\\n37.7701244,\\n37.7700604,\\n37.7705491,\\n37.7715705,\\n37.771752,\\n37.7707533,\\n37.769866];\\n\\nvar i = Math.floor((time/3 % 14000) / 1000);\\n\\nreturn lats[i];\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"longitude\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.2757675428823283,\"funcBody\":\"var lons = [-122.4261215,\\n-122.4219157,\\n-122.4199623,\\n-122.4179074,\\n-122.4155876,\\n-122.4155521,\\n-122.4163203,\\n-122.4193876,\\n-122.4210496,\\n-122.422284,\\n-122.4232717,\\n-122.4235138,\\n-122.4247605,\\n-122.4258812];\\n\\nvar i = Math.floor((time/3 % 14000) / 1000);\\n\\nreturn lons[i];\"}],\"intervalSec\":60},{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Speed\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.14481354591724638,\"funcBody\":\"var value = prevValue;\\nif (time % 500 < 100) {\\n    value = value + Math.random() * 40 - 20;\\n    if (value < 45) {\\n    \\tvalue = 45;\\n    } else if (value > 130) {\\n    \\tvalue = 130;\\n    }\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":30000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"fitMapBounds\":true,\"routesSettings\":[{\"latKeyName\":\"latitude\",\"lngKeyName\":\"longitude\",\"showLabel\":true,\"tooltipPattern\":\"<b>Latitude:</b> ${latitude:7}<br/><b>Longitude:</b> ${longitude:7}<br/><b>Speed:</b> ${Speed} MPH<br/><small>See advanced settings for details</small>\",\"strokeWeight\":4,\"label\":\"First route\",\"color\":\"#3d5afe\",\"strokeOpacity\":1,\"useColorFunction\":true,\"useMarkerImageFunction\":true,\"markerImages\":[\"data:image/png;base64,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\",\"data:image/png;base64,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\",\"data:image/png;base64,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\"],\"colorFunction\":\"var speed = data[''Speed''];\\nif (typeof speed !== undefined) {\\n    var percent = (speed - 45)/85;\\n    if (percent < 0.5) {\\n        percent *=2*100; \\n        return tinycolor.mix(''green'', ''yellow'', amount = percent).toHexString();\\n    } else {\\n        percent = (percent - 0.5)*2*100;\\n        return tinycolor.mix(''yellow'', ''red'', amount = percent).toHexString();\\n    }\\n}\\nreturn ''green'';\",\"markerImageFunction\":\"var speed = data[''Speed''];\\nvar res = {\\n    url: images[0],\\n    size: 55\\n};\\nif (typeof speed !== undefined) {\\n    var percent = (speed - 45)/85;\\n    var index = Math.floor(3 * percent);\\n    res.url = images[index];\\n}\\nreturn res;\"}]},\"title\":\"Route Map - OpenStreetMap\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400},\"useDashboardTimewindow\":true,\"showLegend\":false}"}',
         'Route Map - OpenStreetMap' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'cb0e48b2-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'cards', 'label_widget',
         '{"type":"latest","sizeX":4.5,"sizeY":5,"resources":[],"templateHtml":"","templateCss":"#container {\n    overflow: auto;\n}\n\n.tbDatasource-container {\n    margin: 5px;\n    padding: 8px;\n}\n\n.tbDatasource-title {\n    font-size: 1.200rem;\n    font-weight: 500;\n    padding-bottom: 10px;\n}\n\n.tbDatasource-table {\n    width: 100%;\n    box-shadow: 0 0 10px #ccc;\n    border-collapse: collapse;\n    white-space: nowrap;\n    font-size: 1.000rem;\n    color: #757575;\n}\n\n.tbDatasource-table td {\n    position: relative;\n    border-top: 1px solid rgba(0, 0, 0, 0.12);\n    border-bottom: 1px solid rgba(0, 0, 0, 0.12);\n    padding: 0px 18px;\n    box-sizing: border-box;\n}","controllerScript":"self.onInit = function() {\n    self.ctx.varsRegex = /\\$\\{([^\\}]*)\\}/g;\n    \n    var imageUrl = self.ctx.settings.backgroundImageUrl ? self.ctx.settings.backgroundImageUrl :\n    ''data:image/svg+xml;base64,PHN2ZyBpZD0ic3ZnMiIgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMTAwIiB3aWR0aD0iMTAwIiB2ZXJzaW9uPSIxLjEiIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIgdmlld0JveD0iMCAwIDEwMCAxMDAiPgogPGcgaWQ9ImxheWVyMSIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMCAtOTUyLjM2KSI+CiAgPHJlY3QgaWQ9InJlY3Q0Njg0IiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBoZWlnaHQ9Ijk5LjAxIiB3aWR0aD0iOTkuMDEiIHN0cm9rZT0iIzAwMCIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiB5PSI5NTIuODYiIHg9Ii40OTUwNSIgc3Ryb2tlLXdpZHRoPSIuOTkwMTAiIGZpbGw9IiNlZWUiLz4KICA8dGV4dCBpZD0idGV4dDQ2ODYiIHN0eWxlPSJ3b3JkLXNwYWNpbmc6MHB4O2xldHRlci1zcGFjaW5nOjBweDt0ZXh0LWFuY2hvcjptaWRkbGU7dGV4dC1hbGlnbjpjZW50ZXIiIGZvbnQtd2VpZ2h0PSJib2xkIiB4bWw6c3BhY2U9InByZXNlcnZlIiBmb250LXNpemU9IjEwcHgiIGxpbmUtaGVpZ2h0PSIxMjUlIiB5PSI5NzAuNzI4MDkiIHg9IjQ5LjM5NjQ3NyIgZm9udC1mYW1pbHk9IlJvYm90byIgZmlsbD0iIzY2NjY2NiI+PHRzcGFuIGlkPSJ0c3BhbjQ2OTAiIHg9IjUwLjY0NjQ3NyIgeT0iOTcwLjcyODA5Ij5JbWFnZSBiYWNrZ3JvdW5kIDwvdHNwYW4+PHRzcGFuIGlkPSJ0c3BhbjQ2OTIiIHg9IjQ5LjM5NjQ3NyIgeT0iOTgzLjIyODA5Ij5pcyBub3QgY29uZmlndXJlZDwvdHNwYW4+PC90ZXh0PgogIDxyZWN0IGlkPSJyZWN0NDY5NCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgaGVpZ2h0PSIxOS4zNiIgd2lkdGg9IjY5LjM2IiBzdHJva2U9IiMwMDAiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgeT0iOTkyLjY4IiB4PSIxNS4zMiIgc3Ryb2tlLXdpZHRoPSIuNjM5ODYiIGZpbGw9Im5vbmUiLz4KIDwvZz4KPC9zdmc+Cg=='';\n\n    self.ctx.$container.css(''background'', ''url(\"''+imageUrl+''\") no-repeat'');\n    self.ctx.$container.css(''backgroundSize'', ''contain'');\n    self.ctx.$container.css(''backgroundPosition'', ''50% 50%'');\n    \n    function processLabelPattern(pattern, data) {\n        var match = self.ctx.varsRegex.exec(pattern);\n        var replaceInfo = {};\n        replaceInfo.variables = [];\n        while (match !== null) {\n            var variableInfo = {};\n            variableInfo.dataKeyIndex = -1;\n            var variable = match[0];\n            var label = match[1];\n            var valDec = 2;\n            var splitVals = label.split('':'');\n            if (splitVals.length > 1) {\n                label = splitVals[0];\n                valDec = parseFloat(splitVals[1]);\n            }\n            variableInfo.variable = variable;\n            variableInfo.valDec = valDec;\n            \n            if (label.startsWith(''#'')) {\n                var keyIndexStr = label.substring(1);\n                var n = Math.floor(Number(keyIndexStr));\n                if (String(n) === keyIndexStr && n >= 0) {\n                    variableInfo.dataKeyIndex = n;\n                }\n            }\n            if (variableInfo.dataKeyIndex === -1) {\n                for (var i = 0; i < data.length; i++) {\n                     var datasourceData = data[i];\n                     var dataKey = datasourceData.dataKey;\n                     if (dataKey.label === label) {\n                         variableInfo.dataKeyIndex = i;\n                         break;\n                     }\n                }\n            }\n            replaceInfo.variables.push(variableInfo);\n            match = self.ctx.varsRegex.exec(pattern);\n        }\n        return replaceInfo;\n    }\n\n    var configuredLabels = self.ctx.settings.labels;\n    if (!configuredLabels) {\n        configuredLabels = [];\n    }\n    \n    self.ctx.labels = [];\n\n    for (var l = 0; l < configuredLabels.length; l++) {\n        var labelConfig = configuredLabels[l];\n        var localConfig = {};\n        localConfig.font = {};\n        \n        localConfig.pattern = labelConfig.pattern ? labelConfig.pattern : ''${#0}'';\n        localConfig.x = labelConfig.x ? labelConfig.x : 0;\n        localConfig.y = labelConfig.y ? labelConfig.y : 0;\n        localConfig.backgroundColor = labelConfig.backgroundColor ? labelConfig.backgroundColor : ''rgba(0,0,0,0)'';\n        \n        var settingsFont = labelConfig.font;\n        if (!settingsFont) {\n            settingsFont = {};\n        }\n        \n        localConfig.font.family = settingsFont.family || ''RobotoDraft'';\n        localConfig.font.size = settingsFont.size ? settingsFont.size : 6;\n        localConfig.font.style = settingsFont.style ? settingsFont.style : ''normal'';\n        localConfig.font.weight = settingsFont.weight ? settingsFont.weight : ''500'';\n        localConfig.font.color = settingsFont.color ? settingsFont.color : ''#fff'';\n        \n        localConfig.replaceInfo = processLabelPattern(localConfig.pattern, self.ctx.data);\n        \n        var label = {};\n        var labelElement = $(''<div/>'');\n        labelElement.css(''position'', ''absolute'');\n        labelElement.css(''display'', ''none'');\n        labelElement.css(''top'', ''0'');\n        labelElement.css(''left'', ''0'');\n        labelElement.css(''backgroundColor'', localConfig.backgroundColor);\n        labelElement.css(''color'', localConfig.font.color);\n        labelElement.css(''fontFamily'', localConfig.font.family);\n        labelElement.css(''fontStyle'', localConfig.font.style);\n        labelElement.css(''fontWeight'', localConfig.font.weight);\n        \n        labelElement.html(localConfig.pattern);\n        self.ctx.$container.append(labelElement);\n        label.element = labelElement;\n        label.config = localConfig;\n        label.htmlSet = false;\n        label.visible = false;\n        self.ctx.labels.push(label);\n    }\n\n    var bgImg = $(''<img />'');\n    bgImg.hide();\n    bgImg.bind(''load'', function()\n    {\n        self.ctx.bImageHeight = $(this).height();\n        self.ctx.bImageWidth = $(this).width();\n        self.onResize();\n    });\n    self.ctx.$container.append(bgImg);\n    bgImg.attr(''src'', imageUrl);\n    \n    self.onDataUpdated();\n}\n\nself.onDataUpdated = function() {\n    updateLabels();\n}\n\nself.onResize = function() {\n    if (self.ctx.bImageHeight && self.ctx.bImageWidth) {\n        var backgroundRect = {};\n        var imageRatio = self.ctx.bImageWidth / self.ctx.bImageHeight;\n        var componentRatio = self.ctx.width / self.ctx.height;\n        if (componentRatio >= imageRatio) {\n            backgroundRect.top = 0;\n            backgroundRect.bottom = 1.0;\n            backgroundRect.xRatio = imageRatio / componentRatio;\n            backgroundRect.yRatio = 1;\n            var offset = (1 - backgroundRect.xRatio) / 2;\n            backgroundRect.left = offset;\n            backgroundRect.right = 1 - offset;\n        } else {\n            backgroundRect.left = 0;\n            backgroundRect.right = 1.0;\n            backgroundRect.xRatio = 1;\n            backgroundRect.yRatio = componentRatio / imageRatio;\n            var offset = (1 - backgroundRect.yRatio) / 2;\n            backgroundRect.top = offset;\n            backgroundRect.bottom = 1 - offset;\n        }\n        for (var l = 0; l < self.ctx.labels.length; l++) {\n            var label = self.ctx.labels[l];\n            var labelLeft = backgroundRect.left*100 + (label.config.x*backgroundRect.xRatio);\n            var labelTop = backgroundRect.top*100 + (label.config.y*backgroundRect.yRatio);\n            var fontSize = self.ctx.height * backgroundRect.yRatio * label.config.font.size / 100;\n            label.element.css(''top'', labelTop + ''%'');\n            label.element.css(''left'', labelLeft + ''%'');\n            label.element.css(''fontSize'', fontSize + ''px'');\n            if (!label.visible) {\n                label.element.css(''display'', ''block'');\n                label.visible = true;\n            }\n        }\n    }    \n}\n\n\nfunction isNumber(n) {\n    return !isNaN(parseFloat(n)) && isFinite(n);\n}\n\nfunction padValue(val, dec, int) {\n    var i = 0;\n    var s, strVal, n;\n\n    val = parseFloat(val);\n    n = (val < 0);\n    val = Math.abs(val);\n\n    if (dec > 0) {\n        strVal = val.toFixed(dec).toString().split(''.'');\n        s = int - strVal[0].length;\n\n        for (; i < s; ++i) {\n            strVal[0] = ''0'' + strVal[0];\n        }\n\n        strVal = (n ? ''-'' : '''') + strVal[0] + ''.'' + strVal[1];\n    }\n\n    else {\n        strVal = Math.round(val).toString();\n        s = int - strVal.length;\n\n        for (; i < s; ++i) {\n            strVal = ''0'' + strVal;\n        }\n\n        strVal = (n ? ''-'' : '''') + strVal;\n    }\n\n    return strVal;\n}\n\nfunction updateLabels() {\n    for (var l = 0; l < self.ctx.labels.length; l++) {\n        var label = self.ctx.labels[l];\n        var text = label.config.pattern;\n        var replaceInfo = label.config.replaceInfo;\n        var updated = false;\n        for (var v = 0; v < replaceInfo.variables.length; v++) {\n            var variableInfo = replaceInfo.variables[v];\n            var txtVal = '''';\n            if (variableInfo.dataKeyIndex > -1) {\n                var varData = self.ctx.data[variableInfo.dataKeyIndex].data;\n                if (varData.length > 0) {\n                    var val = varData[varData.length-1][1];\n                    if (isNumber(val)) {\n                        txtVal = padValue(val, variableInfo.valDec, 0);\n                        updated = true;\n                    } else {\n                        txtVal = val;\n                        updated = true;\n                    }\n                }\n            }\n            text = text.split(variableInfo.variable).join(txtVal);\n        }\n        if (updated || !label.htmlSet) {\n            label.element.html(text);\n            if (!label.htmlSet) {\n                label.htmlSet = true;\n            }\n        }\n    }\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"required\": [\"backgroundImageUrl\"],\n        \"properties\": {\n            \"backgroundImageUrl\": {\n                \"title\": \"Background image\",\n                \"type\": \"string\",\n                \"default\": \"data:image/svg+xml;base64,PHN2ZyBpZD0ic3ZnMiIgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMTAwIiB3aWR0aD0iMTAwIiB2ZXJzaW9uPSIxLjEiIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIgdmlld0JveD0iMCAwIDEwMCAxMDAiPgogPGcgaWQ9ImxheWVyMSIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMCAtOTUyLjM2KSI+CiAgPHJlY3QgaWQ9InJlY3Q0Njg0IiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBoZWlnaHQ9Ijk5LjAxIiB3aWR0aD0iOTkuMDEiIHN0cm9rZT0iIzAwMCIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiB5PSI5NTIuODYiIHg9Ii40OTUwNSIgc3Ryb2tlLXdpZHRoPSIuOTkwMTAiIGZpbGw9IiNlZWUiLz4KICA8dGV4dCBpZD0idGV4dDQ2ODYiIHN0eWxlPSJ3b3JkLXNwYWNpbmc6MHB4O2xldHRlci1zcGFjaW5nOjBweDt0ZXh0LWFuY2hvcjptaWRkbGU7dGV4dC1hbGlnbjpjZW50ZXIiIGZvbnQtd2VpZ2h0PSJib2xkIiB4bWw6c3BhY2U9InByZXNlcnZlIiBmb250LXNpemU9IjEwcHgiIGxpbmUtaGVpZ2h0PSIxMjUlIiB5PSI5NzAuNzI4MDkiIHg9IjQ5LjM5NjQ3NyIgZm9udC1mYW1pbHk9IlJvYm90byIgZmlsbD0iIzY2NjY2NiI+PHRzcGFuIGlkPSJ0c3BhbjQ2OTAiIHg9IjUwLjY0NjQ3NyIgeT0iOTcwLjcyODA5Ij5JbWFnZSBiYWNrZ3JvdW5kIDwvdHNwYW4+PHRzcGFuIGlkPSJ0c3BhbjQ2OTIiIHg9IjQ5LjM5NjQ3NyIgeT0iOTgzLjIyODA5Ij5pcyBub3QgY29uZmlndXJlZDwvdHNwYW4+PC90ZXh0PgogIDxyZWN0IGlkPSJyZWN0NDY5NCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgaGVpZ2h0PSIxOS4zNiIgd2lkdGg9IjY5LjM2IiBzdHJva2U9IiMwMDAiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgeT0iOTkyLjY4IiB4PSIxNS4zMiIgc3Ryb2tlLXdpZHRoPSIuNjM5ODYiIGZpbGw9Im5vbmUiLz4KIDwvZz4KPC9zdmc+Cg==\"\n            },\n            \"labels\": {\n                \"title\": \"Labels\",\n                \"type\": \"array\",\n                \"items\": {\n                   \"title\": \"Label\",\n                   \"type\": \"object\",\n                   \"required\": [\"pattern\"],\n                   \"properties\": {\n                       \"pattern\": {\n                           \"title\": \"Pattern ( for ex. ''Text ${keyName} units.'' or ''${#<key index>} units''  )\",\n                           \"type\": \"string\",\n                           \"default\": \"${#0}\"\n                       },\n                       \"x\": {\n                           \"title\": \"X (Percentage relative to background)\",\n                           \"type\": \"number\",\n                           \"default\": 50\n                       },\n                       \"y\": {\n                           \"title\": \"Y (Percentage relative to background)\",\n                           \"type\": \"number\",\n                           \"default\": 50\n                       },\n                       \"backgroundColor\": {\n                           \"title\": \"Backround color\",\n                           \"type\": \"string\",\n                           \"default\": \"rgba(0,0,0,0)\"\n                       },\n                       \"font\": {\n                           \"type\": \"object\",\n                           \"properties\": {\n                               \"family\": {\n                                    \"title\": \"Font family\",\n                                    \"type\": \"string\",\n                                    \"default\": \"RobotoDraft\"\n                                },\n                                \"size\": {\n                                    \"title\": \"Relative font size (percents)\",\n                                    \"type\": \"number\",\n                                    \"default\": 6\n                                },\n                                \"style\": {\n                                    \"title\": \"Style\",\n                                    \"type\": \"string\",\n                                    \"default\": \"normal\"\n                                },\n                                \"weight\": {\n                                    \"title\": \"Weight\",\n                                    \"type\": \"string\",\n                                    \"default\": \"500\"\n                                },\n                                \"color\": {\n                                    \"title\": \"color\",\n                                    \"type\": \"string\",\n                                    \"default\": \"#fff\"\n                                }\n                           }\n                       }\n                   }\n                }\n            }\n        }\n    },\n    \"form\": [\n        {\n            \"key\": \"backgroundImageUrl\",\n            \"type\": \"image\"\n        },\n        {\n            \"key\": \"labels\",\n            \"items\": [\n                \"labels[].pattern\",\n                \"labels[].x\",\n                \"labels[].y\",\n                {\n                    \"key\": \"labels[].backgroundColor\",\n                    \"type\": \"color\"\n                },\n                \"labels[].font.family\",\n                \"labels[].font.size\",\n                {\n                   \"key\": \"labels[].font.style\",\n                   \"type\": \"rc-select\",\n                   \"multiple\": false,\n                   \"items\": [\n                       {\n                           \"value\": \"normal\",\n                           \"label\": \"Normal\"\n                       },\n                       {\n                           \"value\": \"italic\",\n                           \"label\": \"Italic\"\n                       },\n                       {\n                           \"value\": \"oblique\",\n                           \"label\": \"Oblique\"\n                       }\n                    ]\n\n                },\n                {\n                   \"key\": \"labels[].font.weight\",\n                   \"type\": \"rc-select\",\n                   \"multiple\": false,\n                   \"items\": [\n                       {\n                           \"value\": \"normal\",\n                           \"label\": \"Normal\"\n                       },\n                       {\n                           \"value\": \"bold\",\n                           \"label\": \"Bold\"\n                       },\n                       {\n                           \"value\": \"bolder\",\n                           \"label\": \"Bolder\"\n                       },\n                       {\n                           \"value\": \"lighter\",\n                           \"label\": \"Lighter\"\n                       },\n                       {\n                           \"value\": \"100\",\n                           \"label\": \"100\"\n                       },\n                       {\n                           \"value\": \"200\",\n                           \"label\": \"200\"\n                       },\n                       {\n                           \"value\": \"300\",\n                           \"label\": \"300\"\n                       },\n                       {\n                           \"value\": \"400\",\n                           \"label\": \"400\"\n                       },\n                       {\n                           \"value\": \"500\",\n                           \"label\": \"500\"\n                       },\n                       {\n                           \"value\": \"600\",\n                           \"label\": \"600\"\n                       },\n                       {\n                           \"value\": \"700\",\n                           \"label\": \"800\"\n                       },\n                       {\n                           \"value\": \"800\",\n                           \"label\": \"800\"\n                       },\n                       {\n                           \"value\": \"900\",\n                           \"label\": \"900\"\n                       }\n                    ]\n                },\n                {\n                    \"key\": \"labels[].font.color\",\n                    \"type\": \"color\"\n                }\n            ]\n        }\n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"var\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -1000) {\\n\\tvalue = -1000;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"backgroundImageUrl\":\"data:image/svg+xml;base64,PHN2ZyBpZD0ic3ZnMiIgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMTAwIiB3aWR0aD0iMTAwIiB2ZXJzaW9uPSIxLjEiIHhtbG5zOmNjPSJodHRwOi8vY3JlYXRpdmVjb21tb25zLm9yZy9ucyMiIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIgdmlld0JveD0iMCAwIDEwMCAxMDAiPgogPGcgaWQ9ImxheWVyMSIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMCAtOTUyLjM2KSI+CiAgPHJlY3QgaWQ9InJlY3Q0Njg0IiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBoZWlnaHQ9Ijk5LjAxIiB3aWR0aD0iOTkuMDEiIHN0cm9rZT0iIzAwMCIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiB5PSI5NTIuODYiIHg9Ii40OTUwNSIgc3Ryb2tlLXdpZHRoPSIuOTkwMTAiIGZpbGw9IiNlZWUiLz4KICA8dGV4dCBpZD0idGV4dDQ2ODYiIHN0eWxlPSJ3b3JkLXNwYWNpbmc6MHB4O2xldHRlci1zcGFjaW5nOjBweDt0ZXh0LWFuY2hvcjptaWRkbGU7dGV4dC1hbGlnbjpjZW50ZXIiIGZvbnQtd2VpZ2h0PSJib2xkIiB4bWw6c3BhY2U9InByZXNlcnZlIiBmb250LXNpemU9IjEwcHgiIGxpbmUtaGVpZ2h0PSIxMjUlIiB5PSI5NzAuNzI4MDkiIHg9IjQ5LjM5NjQ3NyIgZm9udC1mYW1pbHk9IlJvYm90byIgZmlsbD0iIzY2NjY2NiI+PHRzcGFuIGlkPSJ0c3BhbjQ2OTAiIHg9IjUwLjY0NjQ3NyIgeT0iOTcwLjcyODA5Ij5JbWFnZSBiYWNrZ3JvdW5kIDwvdHNwYW4+PHRzcGFuIGlkPSJ0c3BhbjQ2OTIiIHg9IjQ5LjM5NjQ3NyIgeT0iOTgzLjIyODA5Ij5pcyBub3QgY29uZmlndXJlZDwvdHNwYW4+PC90ZXh0PgogIDxyZWN0IGlkPSJyZWN0NDY5NCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIgaGVpZ2h0PSIxOS4zNiIgd2lkdGg9IjY5LjM2IiBzdHJva2U9IiMwMDAiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgeT0iOTkyLjY4IiB4PSIxNS4zMiIgc3Ryb2tlLXdpZHRoPSIuNjM5ODYiIGZpbGw9Im5vbmUiLz4KIDwvZz4KPC9zdmc+Cg==\",\"labels\":[{\"pattern\":\"Value: ${#0:2} units.\",\"x\":20,\"y\":47,\"font\":{\"color\":\"#515151\",\"family\":\"Roboto\",\"size\":6,\"style\":\"normal\",\"weight\":\"500\"}}]},\"title\":\"Label widget\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Label widget' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'cdf0fc46-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'cards', 'simple_card',
         '{"type":"latest","sizeX":5,"sizeY":3,"resources":[],"templateHtml":"","templateCss":"#container {\n    overflow: auto;\n}\n\n.tbDatasource-container {\n    width: 100%;\n    height: 100%;\n    overflow: hidden;\n}\n\n.tbDatasource-table {\n    width: 100%;\n    height: 100%;\n    border-collapse: collapse;\n    white-space: nowrap;\n    font-weight: 100;\n    text-align: right;\n}\n\n.tbDatasource-table td {\n    padding: 12px;\n    position: relative;\n    box-sizing: border-box;\n}\n\n.tbDatasource-data-key {\n    opacity: 0.7;\n    font-weight: 400;\n    font-size: 3.500rem;\n}\n\n.tbDatasource-value {\n    font-size: 5.000rem;\n}","controllerScript":"self.onInit = function() {\n    self.ctx.units = self.ctx.settings.units || self.ctx.units;\n    self.ctx.valueDec = (typeof self.ctx.settings.valueDec !== ''undefined'' && self.ctx.settings.valueDec !== null)\n                ? self.ctx.settings.valueDec : self.ctx.decimals;\n                \n    self.ctx.labelPosition = self.ctx.settings.labelPosition || ''left'';\n    \n    if (self.ctx.datasources.length > 0) {\n        var tbDatasource = self.ctx.datasources[0];\n        var datasourceId = ''tbDatasource'' + 0;\n        self.ctx.$container.append(\n            \"<div id=''\" + datasourceId +\n            \"'' class=''tbDatasource-container''></div>\"\n        );\n        \n        self.ctx.datasourceContainer = $(''#'' + datasourceId,\n            self.ctx.$container);\n        \n        var tableId = ''table'' + 0;\n        self.ctx.datasourceContainer.append(\n            \"<table id=''\" + tableId +\n            \"'' class=''tbDatasource-table''><col width=''30%''><col width=''70%''></table>\"\n        );\n        var table = $(''#'' + tableId, self.ctx.$container);\n        if (self.ctx.labelPosition === ''top'') {\n            table.css(''text-align'', ''left'');\n        }\n        \n        if (tbDatasource.dataKeys.length > 0) {\n            var dataKey = tbDatasource.dataKeys[0];\n            var labelCellId = ''labelCell'' + 0;\n            var cellId = ''cell'' + 0;\n            if (self.ctx.labelPosition === ''left'') {\n                table.append(\n                    \"<tr><td class=''tbDatasource-data-key'' id=''\" + labelCellId +\"''>\" +\n                    dataKey.label +\n                    \"</td><td class=''tbDatasource-value'' id=''\" +\n                    cellId +\n                    \"''></td></tr>\");\n            } else {\n                table.append(\n                    \"<tr style=''vertical-align: bottom;''><td class=''tbDatasource-data-key'' id=''\" + labelCellId +\"''>\" +\n                    dataKey.label +\n                    \"</td></tr><tr><td class=''tbDatasource-value'' id=''\" +\n                    cellId +\n                    \"''></td></tr>\");\n            }\n            self.ctx.labelCell = $(''#'' + labelCellId, table);\n            self.ctx.valueCell = $(''#'' + cellId, table);\n            self.ctx.valueCell.html(0 + '' '' + self.ctx.units);\n        }\n    }\n    \n    $.fn.textWidth = function(){\n        var html_org = $(this).html();\n        var html_calc = ''<span>'' + html_org + ''</span>'';\n        $(this).html(html_calc);\n        var width = $(this).find(''span:first'').width();\n        $(this).html(html_org);\n        return width;\n    };    \n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    \n    function isNumber(n) {\n        return !isNaN(parseFloat(n)) && isFinite(n);\n    }\n    \n    function padValue(val, dec, int) {\n        var i = 0;\n        var s, strVal, n;\n    \n        val = parseFloat(val);\n        n = (val < 0);\n        val = Math.abs(val);\n    \n        if (dec > 0) {\n            strVal = val.toFixed(dec).toString().split(''.'');\n            s = int - strVal[0].length;\n    \n            for (; i < s; ++i) {\n                strVal[0] = ''0'' + strVal[0];\n            }\n    \n            strVal = (n ? ''-'' : '''') + strVal[0] + ''.'' + strVal[1];\n        }\n    \n        else {\n            strVal = Math.round(val).toString();\n            s = int - strVal.length;\n    \n            for (; i < s; ++i) {\n                strVal = ''0'' + strVal;\n            }\n    \n            strVal = (n ? ''-'' : '''') + strVal;\n        }\n    \n        return strVal;\n    }\n    \n    if (self.ctx.valueCell && self.ctx.data.length > 0) {\n        var cellData = self.ctx.data[0];\n        if (cellData.data.length > 0) {\n            var tvPair = cellData.data[cellData.data.length -\n                1];\n            var value = tvPair[1];\n            var txtValue;\n            if (isNumber(value)) {\n                txtValue = padValue(value, self.ctx.alueDec, 0) + '' '' + self.ctx.units;\n            } else {\n                txtValue = value;\n            }\n            self.ctx.valueCell.html(txtValue);\n            var targetWidth;\n            var minDelta;\n            if (self.ctx.labelPosition === ''left'') {\n                targetWidth = self.ctx.datasourceContainer.width() - self.ctx.labelCell.width();\n                minDelta = self.ctx.width/16 + self.ctx.padding;\n            } else {\n                targetWidth = self.ctx.datasourceContainer.width();\n                minDelta = self.ctx.padding;\n            }\n            var delta = targetWidth - self.ctx.valueCell.textWidth();\n            var fontSize = self.ctx.valueFontSize;\n            if (targetWidth > minDelta) {\n                while (delta < minDelta && fontSize > 6) {\n                    fontSize--;\n                    self.ctx.valueCell.css(''font-size'', fontSize+''px'');\n                    delta = targetWidth - self.ctx.valueCell.textWidth();\n                }\n            }\n        }\n    }    \n    \n}\n\nself.onResize = function() {\n    var labelFontSize;\n    if (self.ctx.labelPosition === ''top'') {\n        self.ctx.padding = self.ctx.height/20;\n        labelFontSize = self.ctx.height/4;\n        self.ctx.valueFontSize = self.ctx.height/2;\n    } else {\n        self.ctx.padding = self.ctx.width/50;\n        labelFontSize = self.ctx.height/2.5;\n        self.ctx.valueFontSize = height/2;\n        if (self.ctx.width/self.ctx.height <= 2.7) {\n            labelFontSize = self.ctx.width/7;\n            self.ctx.valueFontSize = self.ctx.width/6;\n        }\n    }\n    self.ctx.padding = Math.min(12, self.ctx.padding);\n    \n    if (self.ctx.labelCell) {\n        self.ctx.labelCell.css(''font-size'', labelFontSize+''px'');\n        self.ctx.labelCell.css(''padding'', self.ctx.padding+''px'');\n    }\n    if (self.ctx.valueCell) {\n        self.ctx.valueCell.css(''font-size'', self.ctx.valueFontSize+''px'');\n        self.ctx.valueCell.css(''padding'', self.ctx.padding+''px'');\n    }    \n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"properties\": {\n            \"labelPosition\": {\n                \"title\": \"Label position\",\n                \"type\": \"string\",\n                \"default\": \"left\"\n            }\n        },\n        \"required\": []\n    },\n    \"form\": [\n        {\n           \"key\": \"labelPosition\",\n           \"type\": \"rc-select\",\n           \"multiple\": false,\n           \"items\": [\n               {\n                   \"value\": \"left\",\n                   \"label\": \"Left\"\n               },\n               {\n                   \"value\": \"top\",\n                   \"label\": \"Top\"\n               }\n            ]\n        }\n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.2392660816082064,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < -60) {\\n\\tvalue = -60;\\n} else if (value > 60) {\\n\\tvalue = 60;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#ff5722\",\"color\":\"rgba(255, 255, 255, 0.87)\",\"padding\":\"16px\",\"settings\":{\"labelPosition\":\"top\"},\"title\":\"Simple card\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400},\"units\":\"°C\",\"decimals\":0,\"useDashboardTimewindow\":true,\"showLegend\":false}"}',
         'Simple card' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'd12897a2-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges', 'lcd_bar_gauge',
         '{"type":"latest","sizeX":2,"sizeY":3.5,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Humidity\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#babab2\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\"linear\",\"refreshAnimationTime\":700,\"startAnimationType\":\"linear\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Roboto\",\"style\":\"normal\",\"weight\":\"400\",\"size\":16},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"neonGlowBrightness\":0,\"dashThickness\":1.5,\"decimals\":0,\"showUnitTitle\":true,\"defaultColor\":\"#444444\",\"gaugeType\":\"verticalBar\",\"units\":\"%\"},\"title\":\"LCD bar gauge\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'LCD bar gauge' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'd4041e6a-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'vertical_bar_justgage',
         '{"type":"latest","sizeX":2,"sizeY":3.5,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#f57c00\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#ffffff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\">\",\"refreshAnimationTime\":700,\"startAnimationType\":\">\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#999999\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Roboto\",\"style\":\"normal\",\"weight\":\"500\",\"size\":12,\"color\":\"#666666\"},\"minMaxFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#666666\"},\"neonGlowBrightness\":0,\"decimals\":0,\"dashThickness\":1.5,\"gaugeColor\":\"#eeeeee\",\"showTitle\":false,\"gaugeType\":\"verticalBar\"},\"title\":\"Vertical bar - justGage\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Vertical bar - justGage' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'd6d4e8ea-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'cards', 'html_value_card',
         '{"type":"latest","sizeX":7.5,"sizeY":3,"resources":[],"templateHtml":"","templateCss":"","controllerScript":"self.onInit = function() {\n    self.ctx.varsRegex = /\\$\\{([^\\}]*)\\}/g;\n    self.ctx.htmlSet = false;\n    \n    var cssParser = new cssjs();\n    cssParser.testMode = false;\n    var namespace = ''html-value-card-'' + hashCode(self.ctx.settings.cardCss);\n    cssParser.cssPreviewNamespace = namespace;\n    cssParser.createStyleElement(namespace, self.ctx.settings.cardCss);\n    self.ctx.$container.addClass(namespace);\n    self.ctx.html = self.ctx.settings.cardHtml;\n    self.ctx.replaceInfo = processHtmlPattern(self.ctx.html, self.ctx.data);\n    \n    updateHtml();\n    \n    function hashCode(str) {\n        var hash = 0;\n        var i, char;\n        if (str.length === 0) return hash;\n        for (i = 0; i < str.length; i++) {\n            char = str.charCodeAt(i);\n            hash = ((hash << 5) - hash) + char;\n            hash = hash & hash;\n        }\n        return hash;\n    }\n    \n    function processHtmlPattern(pattern, data) {\n        var match = self.ctx.varsRegex.exec(pattern);\n        var replaceInfo = {};\n        replaceInfo.variables = [];\n        while (match !== null) {\n            var variableInfo = {};\n            variableInfo.dataKeyIndex = -1;\n            var variable = match[0];\n            var label = match[1];\n            var valDec = 2;\n            var splitVals = label.split('':'');\n            if (splitVals.length > 1) {\n                label = splitVals[0];\n                valDec = parseFloat(splitVals[1]);\n            }\n            variableInfo.variable = variable;\n            variableInfo.valDec = valDec;\n            \n            if (label.startsWith(''#'')) {\n                var keyIndexStr = label.substring(1);\n                var n = Math.floor(Number(keyIndexStr));\n                if (String(n) === keyIndexStr && n >= 0) {\n                    variableInfo.dataKeyIndex = n;\n                }\n            }\n            if (variableInfo.dataKeyIndex === -1) {\n                for (var i = 0; i < data.length; i++) {\n                     var datasourceData = data[i];\n                     var dataKey = datasourceData.dataKey;\n                     if (dataKey.label === label) {\n                         variableInfo.dataKeyIndex = i;\n                         break;\n                     }\n                }\n            }\n            replaceInfo.variables.push(variableInfo);\n            match = self.ctx.varsRegex.exec(pattern);\n        }\n        return replaceInfo;\n    }    \n}\n\nself.onDataUpdated = function() {\n    updateHtml();\n}\n\nself.onDestroy = function() {\n}\n\nfunction isNumber(n) {\n    return !isNaN(parseFloat(n)) && isFinite(n);\n}\n\nfunction padValue(val, dec, int) {\n    var i = 0;\n    var s, strVal, n;\n\n    val = parseFloat(val);\n    n = (val < 0);\n    val = Math.abs(val);\n\n    if (dec > 0) {\n        strVal = val.toFixed(dec).toString().split(''.'');\n        s = int - strVal[0].length;\n\n        for (; i < s; ++i) {\n            strVal[0] = ''0'' + strVal[0];\n        }\n\n        strVal = (n ? ''-'' : '''') + strVal[0] + ''.'' + strVal[1];\n    }\n\n    else {\n        strVal = Math.round(val).toString();\n        s = int - strVal.length;\n\n        for (; i < s; ++i) {\n            strVal = ''0'' + strVal;\n        }\n\n        strVal = (n ? ''-'' : '''') + strVal;\n    }\n\n    return strVal;\n}\n\nfunction updateHtml() {\n    var text = self.ctx.html;\n    var updated = false;\n    for (var v in self.ctx.replaceInfo.variables) {\n        var variableInfo = self.ctx.replaceInfo.variables[v];\n        var txtVal = '''';\n        if (variableInfo.dataKeyIndex > -1) {\n            var varData = self.ctx.data[variableInfo.dataKeyIndex].data;\n            if (varData.length > 0) {\n                var val = varData[varData.length-1][1];\n                if (isNumber(val)) {\n                    txtVal = padValue(val, variableInfo.valDec, 0);\n                } else {\n                    txtVal = val;\n                }\n            }\n        }\n        if (typeof variableInfo.lastVal === undefined ||\n            variableInfo.lastVal !== txtVal) {\n            updated = true;\n            variableInfo.lastVal = txtVal;\n        }\n        text = text.split(variableInfo.variable).join(txtVal);\n    }\n    if (updated || !self.ctx.htmlSet) {\n        self.ctx.$container.html(text);\n        if (!self.ctx.htmlSet) {\n            self.ctx.htmlSet = true;\n        }\n    }\n}\n\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"required\": [\"cardHtml\"],\n        \"properties\": {\n            \"cardCss\": {\n                \"title\": \"CSS\",\n                \"type\": \"string\",\n                \"default\": \".card {\\n font-weight: bold; \\n}\"\n            },\n            \"cardHtml\": {\n                \"title\": \"HTML\",\n                \"type\": \"string\",\n                \"default\": \"<div class=''card''>HTML code here</div>\"\n            }\n        }\n    },\n    \"form\": [\n        {\n            \"key\": \"cardCss\",\n            \"type\": \"css\"\n        },           \n        {\n            \"key\": \"cardHtml\",\n            \"type\": \"html\"\n        }    \n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"My value\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"return Math.random() * 5.45;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"cardCss\":\".card {\\n   width: 100%;\\n   height: 100%;\\n   border: 2px solid #ccc;\\n   box-sizing: border-box;\\n}\\n\\n.card .content {\\n   padding: 20px;\\n   display: flex;\\n   flex-direction: row;\\n   align-items: center;\\n   justify-content: space-around;\\n   height: 100%;\\n   box-sizing: border-box;\\n}\\n\\n.card .content .column {\\n   display: flex;\\n   flex-direction: column;    \\n   justify-content: space-around;\\n   height: 100%;\\n}\\n\\n.card h1 {\\n    text-transform: uppercase;\\n    color: #999;\\n    font-size: 20px;\\n    font-weight: bold;\\n    margin: 0;\\n    padding-bottom: 10px;\\n    line-height: 32px;\\n}\\n\\n.card .value {\\n    font-size: 38px;\\n    font-weight: 200;\\n}\\n\\n.card .description {\\n    font-size: 20px;\\n    color: #999;\\n}\\n\",\"cardHtml\":\"<div class=''card''>\\n    <div class=''content''>\\n        <div class=''column''>\\n            <h1>Value title</h1>\\n            <div class=''value''>\\n                ${My value:2} units.\\n            </div>    \\n            <div class=''description''>\\n                Value description text\\n            </div>\\n        </div>\\n        <img height=\\\"80px\\\" src=\\\"https://thingsboard.io/images/logo_small.png\\\" />\\n    </div>\\n</div>\"},\"title\":\"HTML Value Card\",\"dropShadow\":false}"}',
         'HTML Value Card' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'e3ca1868-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'gpio_widgets',
         'raspberry_pi_gpio_panel',
         '{"type":"latest","sizeX":7,"sizeY":10.5,"resources":[],"templateHtml":"<div class=\"gpio-panel\" style=\"height: 100%;\">\n    <section layout=\"row\" ng-repeat=\"row in rows\">\n        <section flex layout=\"row\" ng-repeat=\"cell in row\">\n            <section layout=\"row\" flex ng-if=\"cell\" layout-align=\"{{$index===0 ? ''end center'' : ''start center''}}\">\n                <span class=\"gpio-left-label\" ng-show=\"$index===0\">{{ cell.label }}</span>\n                <section layout=\"row\" class=\"led-panel\" ng-class=\"$index===0 ? ''col-0'' : ''col-1''\"\n                      ng-style=\"{backgroundColor: ledPanelBackgroundColor}\">\n                    <span class=\"pin\" ng-show=\"$index===0\">{{cell.pin}}</span>\n                    <span class=\"led-container\">\n                        <tb-led-light size=\"prefferedRowHeight\"\n                                      color-on=\"cell.colorOn\"\n                                      color-off=\"cell.colorOff\"\n                                      off-opacity=\"''0.9''\"\n                                      tb-enabled=\"cell.enabled\">\n                        </tb-led-light>\n                    </span>\n                    <span class=\"pin\" ng-show=\"$index===1\">{{cell.pin}}</span>\n                </section>\n                <span class=\"gpio-right-label\" ng-show=\"$index===1\">{{ cell.label }}</span>\n            </section>\n            <section layout=\"row\" flex ng-if=\"!cell\">\n                <span flex ng-show=\"$index===0\"></span>\n                <span class=\"led-panel\"\n                      ng-style=\"{backgroundColor: ledPanelBackgroundColor}\"></span>\n                <span flex ng-show=\"$index===1\"></span>\n            </section>\n        </section>\n    </section>                            \n</div>","templateCss":".error {\n    font-size: 14px !important;\n    color: maroon;/*rgb(250,250,250);*/\n    background-color: transparent;\n    padding: 6px;\n}\n\n.error span {\n    margin: auto;\n}\n\n.gpio-panel {\n    padding-top: 10px;\n    white-space: nowrap;\n}\n\n.gpio-panel tb-led-light > div {\n    margin: auto;\n}\n\n.led-panel {\n    margin: 0;\n    width: 66px;\n    min-width: 66px;\n}\n\n.led-container {\n    width: 48px;\n    min-width: 48px;\n}\n\n.pin {\n    margin-top: auto;\n    margin-bottom: auto;\n    color: white;\n    font-size: 12px;\n    width: 16px;\n    min-width: 16px;\n}\n\n.led-panel.col-0 .pin {\n    margin-left: auto;\n    padding-left: 2px;\n    text-align: right;\n}\n\n.led-panel.col-1 .pin {\n    margin-right: auto;\n    \n    text-align: left;\n}\n\n.gpio-left-label {\n    margin-right: 8px;\n}\n\n.gpio-right-label {\n    margin-left: 8px;\n}","controllerScript":"self.onInit = function() {\n    var i, gpio;\n    \n    var scope = self.ctx.$scope;\n    var settings = self.ctx.settings;\n    \n    scope.gpioList = [];\n    scope.gpioByPin = {};\n    for (var g = 0; g < settings.gpioList.length; g++) {\n        gpio = settings.gpioList[g];\n        scope.gpioList.push(\n            {\n                row: gpio.row,\n                col: gpio.col,\n                pin: gpio.pin,\n                label: gpio.label,\n                enabled: false,\n                colorOn: tinycolor(gpio.color).lighten(20).toHexString(),\n                colorOff: tinycolor(gpio.color).darken().toHexString()\n            }\n        );\n        scope.gpioByPin[gpio.pin] = scope.gpioList[scope.gpioList.length-1];\n    }\n\n    scope.ledPanelBackgroundColor = settings.ledPanelBackgroundColor || tinycolor(''green'').lighten(2).toRgbString();\n\n    scope.gpioCells = {};\n    var rowCount = 0;\n    for (i = 0; i < scope.gpioList.length; i++) {\n        gpio = scope.gpioList[i];\n        scope.gpioCells[gpio.row+''_''+gpio.col] = gpio;\n        rowCount = Math.max(rowCount, gpio.row+1);\n    }\n    \n    scope.prefferedRowHeight = 32;\n    scope.rows = [];\n    for (i = 0; i < rowCount; i++) {\n        var row = [];\n        for (var c =0; c<2;c++) {\n            if (scope.gpioCells[i+''_''+c]) {\n                row[c] = scope.gpioCells[i+''_''+c];\n            } else {\n                row[c] = null;\n            }\n        }\n        scope.rows.push(row);\n    }    \n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    var changed = false;\n    for (var d = 0; d < self.ctx.data.length; d++) {\n        var cellData = self.ctx.data[d];\n        var dataKey = cellData.dataKey;\n        var gpio = self.ctx.$scope.gpioByPin[dataKey.label];\n        if (gpio) {\n            var enabled = false;\n            if (cellData.data.length > 0) {\n                var tvPair = cellData.data[cellData.data.length - 1];\n                enabled = (tvPair[1] === true || tvPair[1] === ''true'');\n            }\n            if (gpio.enabled != enabled) {\n                changed = true;\n                gpio.enabled = enabled;\n            }\n        }\n    }\n    if (changed) {\n        self.ctx.$scope.$digest();\n    }    \n}\n\nself.onResize = function() {\n    var rowCount = self.ctx.$scope.rows.length;\n    var prefferedRowHeight = (self.ctx.height - 35)/rowCount;\n    prefferedRowHeight = Math.min(32, prefferedRowHeight);\n    prefferedRowHeight = Math.max(12, prefferedRowHeight);\n    self.ctx.$scope.prefferedRowHeight = prefferedRowHeight;\n    \n    var ratio = prefferedRowHeight/32;\n    \n    var leftLabels = $(''.gpio-left-label'', self.ctx.$container);\n    leftLabels.css(''font-size'', 16*ratio+''px'');\n    var rightLabels = $(''.gpio-right-label'', self.ctx.$container);\n    rightLabels.css(''font-size'', 16*ratio+''px'');\n    var pins = $(''.pin'', self.ctx.$container);\n    var pinsFontSize = Math.max(9, 12*ratio);\n    pins.css(''font-size'', pinsFontSize+''px'');    \n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"properties\": {\n            \"gpioList\": {\n                \"title\": \"Gpio leds\",\n                \"type\": \"array\",\n                \"minItems\" : 1,\n                \"items\": {\n                    \"title\": \"Gpio led\",\n                    \"type\": \"object\",\n                    \"properties\": {\n                        \"pin\": {\n                            \"title\": \"Pin\",\n                            \"type\": \"number\"\n                        },\n                        \"label\": {\n                            \"title\": \"Label\",\n                            \"type\": \"string\"\n                        },\n                        \"row\": {\n                            \"title\": \"Row\",\n                            \"type\": \"number\"\n                        },\n                        \"col\": {\n                            \"title\": \"Column\",\n                            \"type\": \"number\"\n                        },\n                        \"color\": {\n                            \"title\": \"Color\",\n                            \"type\": \"string\",\n                            \"default\": \"red\"\n                        }\n                    },\n                    \"required\": [\"pin\", \"label\", \"row\", \"col\", \"color\"]\n                }\n            },\n            \"ledPanelBackgroundColor\": {\n                \"title\": \"LED panel background color\",\n                \"type\": \"string\",\n                \"default\": \"#008a00\"\n            } \n        },\n        \"required\": [\"gpioList\", \n                     \"ledPanelBackgroundColor\"]\n    },\n    \"form\": [\n        {\n            \"key\": \"gpioList\",\n            \"items\": [\n                \"gpioList[].pin\",\n                \"gpioList[].label\",\n                \"gpioList[].row\",\n                \"gpioList[].col\",\n                {\n                    \"key\": \"gpioList[].color\",\n                    \"type\": \"color\"\n                }\n            ]\n        },\n        {\n            \"key\": \"ledPanelBackgroundColor\",\n            \"type\": \"color\"\n        }\n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"gpioList\":[{\"pin\":1,\"label\":\"3.3V\",\"row\":0,\"col\":0,\"color\":\"#fc9700\",\"_uniqueKey\":0},{\"pin\":2,\"label\":\"5V\",\"row\":0,\"col\":1,\"color\":\"#fb0000\",\"_uniqueKey\":1},{\"pin\":3,\"label\":\"GPIO 2 (I2C1_SDA)\",\"row\":1,\"col\":0,\"color\":\"#02fefb\",\"_uniqueKey\":2},{\"color\":\"#fb0000\",\"pin\":4,\"label\":\"5V\",\"row\":1,\"col\":1},{\"color\":\"#02fefb\",\"pin\":5,\"label\":\"GPIO 3 (I2C1_SCL)\",\"row\":2,\"col\":0},{\"color\":\"#000000\",\"pin\":6,\"label\":\"GND\",\"row\":2,\"col\":1},{\"color\":\"#00fd00\",\"pin\":7,\"label\":\"GPIO 4 (GPCLK0)\",\"row\":3,\"col\":0},{\"color\":\"#fdfb00\",\"pin\":8,\"label\":\"GPIO 14 (UART_TXD)\",\"row\":3,\"col\":1},{\"color\":\"#000000\",\"pin\":9,\"label\":\"GND\",\"row\":4,\"col\":0},{\"color\":\"#fdfb00\",\"pin\":10,\"label\":\"GPIO 15 (UART_RXD)\",\"row\":4,\"col\":1},{\"color\":\"#00fd00\",\"pin\":11,\"label\":\"GPIO 17\",\"row\":5,\"col\":0},{\"color\":\"#00fd00\",\"pin\":12,\"label\":\"GPIO 18\",\"row\":5,\"col\":1},{\"color\":\"#00fd00\",\"pin\":13,\"label\":\"GPIO 27\",\"row\":6,\"col\":0},{\"color\":\"#000000\",\"pin\":14,\"label\":\"GND\",\"row\":6,\"col\":1},{\"color\":\"#00fd00\",\"pin\":15,\"label\":\"GPIO 22\",\"row\":7,\"col\":0},{\"color\":\"#00fd00\",\"pin\":16,\"label\":\"GPIO 23\",\"row\":7,\"col\":1},{\"color\":\"#fc9700\",\"pin\":17,\"label\":\"3.3V\",\"row\":8,\"col\":0},{\"color\":\"#00fd00\",\"pin\":18,\"label\":\"GPIO 24\",\"row\":8,\"col\":1},{\"color\":\"#fd01fd\",\"pin\":19,\"label\":\"GPIO 10 (SPI_MOSI)\",\"row\":9,\"col\":0},{\"color\":\"#000000\",\"pin\":20,\"label\":\"GND\",\"row\":9,\"col\":1},{\"color\":\"#fd01fd\",\"pin\":21,\"label\":\"GPIO 9 (SPI_MISO)\",\"row\":10,\"col\":0},{\"color\":\"#00fd00\",\"pin\":22,\"label\":\"GPIO 25\",\"row\":10,\"col\":1},{\"color\":\"#fd01fd\",\"pin\":23,\"label\":\"GPIO 11 (SPI_SCLK)\",\"row\":11,\"col\":0},{\"color\":\"#fd01fd\",\"pin\":24,\"label\":\"GPIO 8 (SPI_CE0)\",\"row\":11,\"col\":1},{\"color\":\"#000000\",\"pin\":25,\"label\":\"GND\",\"row\":12,\"col\":0},{\"color\":\"#fd01fd\",\"pin\":26,\"label\":\"GPIO 7 (SPI_CE1)\",\"row\":12,\"col\":1},{\"color\":\"#ffffff\",\"pin\":27,\"label\":\"ID_SD\",\"row\":13,\"col\":0},{\"color\":\"#ffffff\",\"pin\":28,\"label\":\"ID_SC\",\"row\":13,\"col\":1},{\"color\":\"#00fd00\",\"pin\":29,\"label\":\"GPIO 5\",\"row\":14,\"col\":0},{\"color\":\"#000000\",\"pin\":30,\"label\":\"GND\",\"row\":14,\"col\":1},{\"color\":\"#00fd00\",\"pin\":31,\"label\":\"GPIO 6\",\"row\":15,\"col\":0},{\"color\":\"#00fd00\",\"pin\":32,\"label\":\"GPIO 12\",\"row\":15,\"col\":1},{\"color\":\"#00fd00\",\"pin\":33,\"label\":\"GPIO 13\",\"row\":16,\"col\":0},{\"color\":\"#000000\",\"pin\":34,\"label\":\"GND\",\"row\":16,\"col\":1},{\"color\":\"#00fd00\",\"pin\":35,\"label\":\"GPIO 19\",\"row\":17,\"col\":0},{\"color\":\"#00fd00\",\"pin\":36,\"label\":\"GPIO 16\",\"row\":17,\"col\":1},{\"color\":\"#00fd00\",\"pin\":37,\"label\":\"GPIO 26\",\"row\":18,\"col\":0},{\"color\":\"#00fd00\",\"pin\":38,\"label\":\"GPIO 20\",\"row\":18,\"col\":1},{\"color\":\"#000000\",\"pin\":39,\"label\":\"GND\",\"row\":19,\"col\":0},{\"color\":\"#00fd00\",\"pin\":40,\"label\":\"GPIO 21\",\"row\":19,\"col\":1}],\"ledPanelBackgroundColor\":\"#008a00\"},\"title\":\"Raspberry Pi GPIO Panel\",\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"7\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.22518255793320163,\"funcBody\":\"var period = time % 1500;\\nreturn period < 500;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"11\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.7008206860666621,\"funcBody\":\"var period = time % 1500;\\nreturn period >= 500 && period < 1000;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"12\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.42600325102193426,\"funcBody\":\"var period = time % 1500;\\nreturn period >= 1000;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"13\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.48362241571415243,\"funcBody\":\"var period = time % 1500;\\nreturn period < 500;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"29\",\"color\":\"#607d8b\",\"settings\":{},\"_hash\":0.7217670147518815,\"funcBody\":\"var period = time % 1500;\\nreturn period >= 500 && period < 1000;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}}}"}',
         'Raspberry Pi GPIO Panel' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'e7acbd64-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'radar_chart_js',
         '{"type":"latest","sizeX":7,"sizeY":5,"resources":[{"url":"https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.3.0/Chart.min.js"}],"templateHtml":"<canvas id=\"radarChart\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    var barData = {\n        labels: [],\n        datasets: []\n    };\n\n    var backgroundColor = tinycolor(self.ctx.data[0].dataKey.color);\n    backgroundColor.setAlpha(0.2);\n    var borderColor = tinycolor(self.ctx.data[0].dataKey.color);\n    borderColor.setAlpha(1);\n    var dataset = {\n        label: self.ctx.datasources[0].name,\n        data: [],\n        backgroundColor: backgroundColor.toRgbString(),\n        borderColor: borderColor.toRgbString(),\n        pointBackgroundColor: borderColor.toRgbString(),\n        pointBorderColor: borderColor.darken().toRgbString(),\n        borderWidth: 1\n    }\n    \n    barData.datasets.push(dataset);\n    \n    for (var i = 0; i < self.ctx.data.length; i++) {\n        var dataKey = self.ctx.data[i].dataKey;\n        barData.labels.push(dataKey.label);\n        dataset.data.push(0);\n    }\n\n    var ctx = $(''#radarChart'', self.ctx.$container);\n    self.ctx.chart = new Chart(ctx, {\n        type: ''radar'',\n        data: barData,\n        options: {\n            responsive: false,\n            maintainAspectRatio: false\n        }\n    });\n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    for (var i = 0; i < self.ctx.data.length; i++) {\n        var cellData = self.ctx.data[i];\n        if (cellData.data.length > 0) {\n             var tvPair = cellData.data[cellData.data.length - 1];\n             var value = tvPair[1];\n             self.ctx.chart.data.datasets[0].data[i] = parseFloat(value);\n        }\n    }    \n    self.ctx.chart.update();\n}\n\nself.onResize = function() {\n    if (self.ctx.height >= 70) {\n        self.ctx.chart.resize();\n    }\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.545701115289893,\"funcBody\":\"var value = (prevValue-20) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+20;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Third\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.2592906835158064,\"funcBody\":\"var value = (prevValue-40) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+40;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Fourth\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.12880275585455747,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{},\"title\":\"Radar - Chart.js\"}"}',
         'Radar - Chart.js' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'ee579e40-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'neon_gauge_justgage',
         '{"type":"latest","sizeX":5,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#000000\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\">\",\"refreshAnimationTime\":700,\"startAnimationType\":\">\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"style\":\"normal\",\"weight\":\"500\",\"size\":32},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"neonGlowBrightness\":70,\"dashThickness\":1,\"decimals\":1,\"gaugeType\":\"arc\"},\"title\":\"Neon gauge - justGage\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Neon gauge - justGage' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'f26ff52c-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'simple_gauge_justgage',
         '{"type":"latest","sizeX":2,"sizeY":2,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>\n","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"\nself.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#ef6c00\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#ffffff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\">\",\"refreshAnimationTime\":700,\"startAnimationType\":\">\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Roboto\",\"style\":\"normal\",\"weight\":\"500\",\"size\":32,\"color\":\"#666666\"},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"neonGlowBrightness\":0,\"dashThickness\":0,\"decimals\":0,\"gaugeColor\":\"#eeeeee\",\"gaugeType\":\"donut\"},\"title\":\"Simple gauge - justGage\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Simple gauge - justGage' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'f56c6418-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'maps', 'route_map',
         '{"type":"timeseries","sizeX":8.5,"sizeY":6,"resources":[],"templateHtml":"","templateCss":".error {\n    color: red;\n}\n.tb-labels {\n  color: #222;\n  font: 12px/1.5 \"Helvetica Neue\", Arial, Helvetica, sans-serif;\n  text-align: center;\n  width: 100px;\n  white-space: nowrap;\n}","controllerScript":"self.onInit = function() {\n    self.ctx.map = new TbMapWidget(''google-map'', true, self.ctx);\n}\n\nself.onDataUpdated = function() {\n    self.ctx.map.update();\n}\n\nself.onResize = function() {\n    self.ctx.map.resize();\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n  \"schema\": {\n    \"title\": \"Route Map Configuration\",\n    \"type\": \"object\",\n    \"properties\": {\n      \"gmApiKey\": {\n        \"title\": \"Google Maps API Key\",\n        \"type\": \"string\"\n      },\n      \"gmDefaultMapType\": {\n          \"title\": \"Default map type\",\n          \"type\": \"string\",\n          \"default\": \"roadmap\"\n      },\n      \"defaultZoomLevel\": {\n         \"title\": \"Default map zoom level (1 - 20)\",\n         \"type\": \"number\"\n      },\n      \"fitMapBounds\": {\n          \"title\": \"Fit map bounds to cover all routes\",\n          \"type\": \"boolean\",\n          \"default\": true\n      },\n      \"routesSettings\": {\n            \"title\": \"Routes\",\n            \"type\": \"array\",\n            \"items\": {\n              \"title\": \"Route settings\",\n              \"type\": \"object\",\n              \"properties\": {\n                  \"latKeyName\": {\n                    \"title\": \"Latitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lat\"\n                  },\n                  \"lngKeyName\": {\n                    \"title\": \"Longitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lng\"\n                  },\n                  \"showLabel\": {\n                    \"title\": \"Show label\",\n                    \"type\": \"boolean\",\n                    \"default\": true\n                  },                  \n                  \"label\": {\n                    \"title\": \"Label\",\n                    \"type\": \"string\"\n                  },\n                  \"tooltipPattern\": {\n                    \"title\": \"Pattern ( for ex. ''Text ${keyName} units.'' or ''${#<key index>} units''  )\",\n                    \"type\": \"string\",\n                    \"default\": \"<b>Latitude:</b> ${lat:7}<br/><b>Longitude:</b> ${lng:7}\"\n                  },\n                  \"color\": {\n                    \"title\": \"Color\",\n                    \"type\": \"string\"\n                  },\n                  \"useColorFunction\": {\n                    \"title\": \"Use color function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"colorFunction\": {\n                    \"title\": \"Color function: f(data)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImage\": {\n                    \"title\": \"Custom marker image\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImageSize\": {\n                     \"title\": \"Custom marker image size (px)\",\n                     \"type\": \"number\",\n                     \"default\": 34\n                  },\n                  \"useMarkerImageFunction\": {\n                    \"title\": \"Use marker image function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"markerImageFunction\": {\n                    \"title\": \"Marker image function: f(data, images)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImages\": {\n                        \"title\": \"Marker images\",\n                        \"type\": \"array\",\n                        \"items\": {\n                          \"title\": \"Marker image\",\n                          \"type\": \"string\"\n                        }\n                  },\n                  \"strokeWeight\": {\n                    \"title\": \"Stroke weight\",\n                    \"type\": \"number\",\n                    \"default\": 2\n                  },\n                  \"strokeOpacity\": {\n                    \"title\": \"Stroke opacity\",\n                    \"type\": \"number\",\n                    \"default\": 1.0\n                  }\n              }\n            }\n      }\n    },\n    \"required\": [\n      \"gmApiKey\"\n    ]\n  },\n  \"form\": [\n    \"gmApiKey\",\n    {\n        \"key\": \"gmDefaultMapType\",\n        \"type\": \"rc-select\",\n        \"multiple\": false,\n        \"items\": [\n            {\n                \"value\": \"roadmap\",\n                \"label\": \"Roadmap\"\n            },\n            {\n                \"value\": \"satellite\",\n                \"label\": \"Satellite\"\n            },\n            {\n                \"value\": \"hybrid\",\n                \"label\": \"Hybrid\"\n            },\n            {\n                \"value\": \"terrain\",\n                \"label\": \"Terrain\"\n            }\n        ]\n    },    \n    \"defaultZoomLevel\",\n    \"fitMapBounds\",\n    {\n        \"key\": \"routesSettings\",\n        \"items\": [\n            \"routesSettings[].latKeyName\",\n            \"routesSettings[].lngKeyName\",\n            \"routesSettings[].showLabel\",\n            \"routesSettings[].label\",\n            \"routesSettings[].tooltipPattern\",\n            {\n                \"key\": \"routesSettings[].color\",\n                \"type\": \"color\"\n            },\n            \"routesSettings[].useColorFunction\",\n            {\n                \"key\": \"routesSettings[].colorFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"routesSettings[].markerImage\",\n                \"type\": \"image\"\n            },\n            \"routesSettings[].markerImageSize\",\n            \"routesSettings[].useMarkerImageFunction\",\n            {\n                \"key\": \"routesSettings[].markerImageFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"routesSettings[].markerImages\",\n                \"items\": [\n                    {\n                        \"key\": \"routesSettings[].markerImages[]\",\n                        \"type\": \"image\"\n                    }\n                ]\n            },\n            \"routesSettings[].strokeWeight\",\n            \"routesSettings[].strokeOpacity\"\n        ]\n    }\n  ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"latitude\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.3467277073670627,\"funcBody\":\"var lats = [37.7696499,\\n37.7699074,\\n37.7699536,\\n37.7697242,\\n37.7695189,\\n37.7696889,\\n37.7697153,\\n37.7701244,\\n37.7700604,\\n37.7705491,\\n37.7715705,\\n37.771752,\\n37.7707533,\\n37.769866];\\n\\nvar i = Math.floor((time/3 % 14000) / 1000);\\n\\nreturn lats[i];\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"longitude\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.058309787276281666,\"funcBody\":\"var lons = [-122.4261215,\\n-122.4219157,\\n-122.4199623,\\n-122.4179074,\\n-122.4155876,\\n-122.4155521,\\n-122.4163203,\\n-122.4193876,\\n-122.4210496,\\n-122.422284,\\n-122.4232717,\\n-122.4235138,\\n-122.4247605,\\n-122.4258812];\\n\\nvar i = Math.floor((time/3 % 14000) / 1000);\\n\\nreturn lons[i];\"}],\"intervalSec\":60},{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Speed\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.14288960550237473,\"funcBody\":\"var value = prevValue;\\nif (time % 500 < 100) {\\n    value = value + Math.random() * 40 - 20;\\n    if (value < 45) {\\n    \\tvalue = 45;\\n    } else if (value > 130) {\\n    \\tvalue = 130;\\n    }\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":30000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"gmApiKey\":\"AIzaSyDoEx2kaGz3PxwbI9T7ccTSg5xjdw8Nw8Q\",\"fitMapBounds\":true,\"routesSettings\":[{\"latKeyName\":\"latitude\",\"lngKeyName\":\"longitude\",\"showLabel\":true,\"color\":\"#1976d2\",\"strokeWeight\":4,\"strokeOpacity\":0.65,\"label\":\"First route\",\"tooltipPattern\":\"<b>Latitude:</b> ${latitude:7}<br/><b>Longitude:</b> ${longitude:7}<br/><b>Speed:</b> ${Speed} MPH<br/><small>See advanced settings for details</small>\",\"useColorFunction\":true,\"markerImageSize\":34,\"useMarkerImageFunction\":true,\"markerImageFunction\":\"var speed = data[''Speed''];\\nvar res = {\\n    url: images[0],\\n    size: 55\\n};\\nif (typeof speed !== undefined) {\\n    var percent = (speed - 45)/85;\\n    var index = Math.floor(3 * percent);\\n    res.url = images[index];\\n}\\nreturn res;\",\"markerImages\":[\"data:image/png;base64,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\",\"data:image/png;base64,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\",\"data:image/png;base64,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\"],\"colorFunction\":\"var speed = data[''Speed''];\\nif (typeof speed !== undefined) {\\n    var percent = (speed - 45)/85;\\n    if (percent < 0.5) {\\n        percent *=2*100; \\n        return tinycolor.mix(''green'', ''yellow'', amount = percent).toHexString();\\n    } else {\\n        percent = (percent - 0.5)*2*100;\\n        return tinycolor.mix(''yellow'', ''red'', amount = percent).toHexString();\\n    }\\n}\\nreturn ''green'';\"}]},\"title\":\"Route Map\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400},\"useDashboardTimewindow\":true,\"showLegend\":false}"}',
         'Route Map' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'fb474880-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'analogue_gauges',
         'temperature_gauge_canvas_gauges',
         '{"type":"latest","sizeX":7,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"linearGauge\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbAnalogueLinearGauge(self.ctx, ''linearGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.getSettingsSchema = function() {\n    return TbAnalogueLinearGauge.settingsSchema;\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 30 - 15;\\nif (value < -60) {\\n\\tvalue = -60;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"rgb(255, 255, 255)\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"maxValue\":100,\"defaultColor\":\"#e64a19\",\"barStrokeWidth\":2.5,\"colorBar\":\"rgba(255, 255, 255, 0.4)\",\"colorBarEnd\":\"rgba(221, 221, 221, 0.38)\",\"showUnitTitle\":true,\"minorTicks\":2,\"valueBox\":true,\"valueInt\":3,\"colorPlate\":\"#fff\",\"colorMajorTicks\":\"#444\",\"colorMinorTicks\":\"#666\",\"colorNeedleShadowUp\":\"rgba(2,255,255,0.2)\",\"colorNeedleShadowDown\":\"rgba(188,143,143,0.45)\",\"colorValueBoxRect\":\"#888\",\"colorValueBoxRectEnd\":\"#666\",\"colorValueBoxBackground\":\"#babab2\",\"colorValueBoxShadow\":\"rgba(0,0,0,1)\",\"highlightsWidth\":10,\"animation\":true,\"animationDuration\":1500,\"animationRule\":\"linear\",\"showBorder\":false,\"majorTicksCount\":8,\"numbersFont\":{\"family\":\"Arial\",\"size\":18,\"style\":\"normal\",\"weight\":\"normal\",\"color\":\"#263238\"},\"titleFont\":{\"family\":\"Roboto\",\"size\":24,\"style\":\"normal\",\"weight\":\"normal\",\"color\":\"#78909c\"},\"unitsFont\":{\"family\":\"Roboto\",\"size\":26,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#37474f\"},\"valueFont\":{\"family\":\"Roboto\",\"size\":40,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#444\",\"shadowColor\":\"rgba(0,0,0,0.3)\"},\"minValue\":-60,\"highlights\":[{\"from\":-60,\"to\":-40,\"color\":\"#90caf9\"},{\"from\":-40,\"to\":-20,\"color\":\"rgba(144, 202, 249, 0.66)\"},{\"from\":-20,\"to\":0,\"color\":\"rgba(144, 202, 249, 0.33)\"},{\"from\":0,\"to\":20,\"color\":\"rgba(244, 67, 54, 0.2)\"},{\"from\":20,\"to\":40,\"color\":\"rgba(244, 67, 54, 0.4)\"},{\"from\":40,\"to\":60,\"color\":\"rgba(244, 67, 54, 0.6)\"},{\"from\":60,\"to\":80,\"color\":\"rgba(244, 67, 54, 0.8)\"},{\"from\":80,\"to\":100,\"color\":\"#f44336\"}],\"unitTitle\":\"Temperature\",\"units\":\"°C\",\"colorBarProgress\":\"#90caf9\",\"colorBarProgressEnd\":\"#f44336\",\"colorBarStroke\":\"#b0bec5\",\"valueDec\":1},\"title\":\"Temperature gauge - Canvas Gauges\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Temperature gauge - Canvas Gauges' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'f8d616e4-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'maps', 'google_maps',
         '{"type":"latest","sizeX":8.5,"sizeY":6,"resources":[],"templateHtml":"","templateCss":".error {\n    color: red;\n}\n.tb-labels {\n  color: #222;\n  font: 12px/1.5 \"Helvetica Neue\", Arial, Helvetica, sans-serif;\n  text-align: center;\n  width: 100px;\n  white-space: nowrap;\n}","controllerScript":"self.onInit = function() {\n    self.ctx.map = new TbMapWidget(''google-map'', false, self.ctx);\n}\n\nself.onDataUpdated = function() {\n    self.ctx.map.update();\n}\n\nself.onResize = function() {\n    self.ctx.map.resize();\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n  \"schema\": {\n    \"title\": \"Google Map Configuration\",\n    \"type\": \"object\",\n    \"properties\": {\n      \"gmApiKey\": {\n        \"title\": \"Google Maps API Key\",\n        \"type\": \"string\"\n      },\n      \"gmDefaultMapType\": {\n          \"title\": \"Default map type\",\n          \"type\": \"string\",\n          \"default\": \"roadmap\"\n      },\n      \"defaultZoomLevel\": {\n         \"title\": \"Default map zoom level (1 - 20)\",\n         \"type\": \"number\"\n      },\n      \"fitMapBounds\": {\n          \"title\": \"Fit map bounds to cover all markers\",\n          \"type\": \"boolean\",\n          \"default\": true\n      },\n      \"markersSettings\": {\n            \"title\": \"Markers\",\n            \"type\": \"array\",\n            \"items\": {\n              \"title\": \"Marker settings\",\n              \"type\": \"object\",\n              \"properties\": {\n                  \"latKeyName\": {\n                    \"title\": \"Latitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lat\"\n                  },\n                  \"lngKeyName\": {\n                    \"title\": \"Longitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lng\"\n                  },                  \n                  \"showLabel\": {\n                    \"title\": \"Show label\",\n                    \"type\": \"boolean\",\n                    \"default\": true\n                  },                  \n                  \"label\": {\n                    \"title\": \"Label\",\n                    \"type\": \"string\"\n                  },\n                  \"tooltipPattern\": {\n                    \"title\": \"Pattern ( for ex. ''Text ${keyName} units.'' or ''${#<key index>} units''  )\",\n                    \"type\": \"string\",\n                    \"default\": \"<b>Latitude:</b> ${lat:7}<br/><b>Longitude:</b> ${lng:7}\"\n                  },\n                  \"color\": {\n                    \"title\": \"Color\",\n                    \"type\": \"string\"\n                  },\n                  \"useColorFunction\": {\n                    \"title\": \"Use color function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"colorFunction\": {\n                    \"title\": \"Color function: f(data)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImage\": {\n                    \"title\": \"Custom marker image\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImageSize\": {\n                     \"title\": \"Custom marker image size (px)\",\n                     \"type\": \"number\",\n                     \"default\": 34\n                  },\n                  \"useMarkerImageFunction\": {\n                    \"title\": \"Use marker image function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"markerImageFunction\": {\n                    \"title\": \"Marker image function: f(data, images)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImages\": {\n                        \"title\": \"Marker images\",\n                        \"type\": \"array\",\n                        \"items\": {\n                          \"title\": \"Marker image\",\n                          \"type\": \"string\"\n                        }\n                  }\n              }\n            }\n      }\n    },\n    \"required\": [\n      \"gmApiKey\"\n    ]\n  },\n  \"form\": [\n    \"gmApiKey\",\n    {\n        \"key\": \"gmDefaultMapType\",\n        \"type\": \"rc-select\",\n        \"multiple\": false,\n        \"items\": [\n            {\n                \"value\": \"roadmap\",\n                \"label\": \"Roadmap\"\n            },\n            {\n                \"value\": \"satellite\",\n                \"label\": \"Satellite\"\n            },\n            {\n                \"value\": \"hybrid\",\n                \"label\": \"Hybrid\"\n            },\n            {\n                \"value\": \"terrain\",\n                \"label\": \"Terrain\"\n            }\n        ]\n    },\n    \"defaultZoomLevel\",\n    \"fitMapBounds\",\n    {\n        \"key\": \"markersSettings\",\n        \"items\": [\n            \"markersSettings[].latKeyName\",\n            \"markersSettings[].lngKeyName\",\n            \"markersSettings[].showLabel\",\n            \"markersSettings[].label\",\n            \"markersSettings[].tooltipPattern\",\n            {\n                \"key\": \"markersSettings[].color\",\n                \"type\": \"color\"\n            },\n            \"markersSettings[].useColorFunction\",\n            {\n                \"key\": \"markersSettings[].colorFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"markersSettings[].markerImage\",\n                \"type\": \"image\"\n            },\n            \"markersSettings[].markerImageSize\",\n            \"markersSettings[].useMarkerImageFunction\",\n            {\n                \"key\": \"markersSettings[].markerImageFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"markersSettings[].markerImages\",\n                \"items\": [\n                    {\n                        \"key\": \"markersSettings[].markerImages[]\",\n                        \"type\": \"image\"\n                    }\n                ]\n            }\n        ]\n    }\n  ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"latitude\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.05427416942713381,\"funcBody\":\"var value = prevValue || 15.833293;\\nif (time % 5000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"longitude\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.680594833308841,\"funcBody\":\"var value = prevValue || -90.454350;\\nif (time % 5000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"}]},{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"lat\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.05012157428742059,\"funcBody\":\"var value = prevValue || 14.450463;\\nif (time % 4000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"lng\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.6742359401617628,\"funcBody\":\"var value = prevValue || -84.845334;\\nif (time % 4000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"}]},{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"temperature\",\"color\":\"#607d8b\",\"settings\":{},\"_hash\":0.799863043034289,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < -60) {\\n\\tvalue = -60;\\n} else if (value > 60) {\\n\\tvalue = 60;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"gmApiKey\":\"AIzaSyDoEx2kaGz3PxwbI9T7ccTSg5xjdw8Nw8Q\",\"markersSettings\":[{\"label\":\"First point\",\"color\":\"#1e88e5\",\"latKeyName\":\"latitude\",\"lngKeyName\":\"longitude\",\"showLabel\":true,\"tooltipPattern\":\"<b>Latitude:</b> ${latitude:7}<br/><b>Longitude:</b> ${longitude:7}<br/><b>Temperature:</b> ${temperature} °C<br/><small>See advanced settings for details</small>\",\"useColorFunction\":true,\"colorFunction\":\"var temperature = data[''temperature''];\\nif (typeof temperature !== undefined) {\\n    var percent = (temperature + 60)/120 * 100;\\n    return tinycolor.mix(''blue'', ''red'', amount = percent).toHexString();\\n}\\nreturn ''blue'';\",\"markerImages\":[],\"useMarkerImageFunction\":false},{\"label\":\"Second point\",\"color\":\"#fdd835\",\"latKeyName\":\"lat\",\"lngKeyName\":\"lng\",\"showLabel\":true,\"tooltipPattern\":\"<b>Latitude:</b> ${lat:7}<br/><b>Longitude:</b> ${lng:7}<br/><b>Temperature:</b> ${temperature} °C<br/><small>See advanced settings for details</small>\",\"markerImageSize\":34,\"markerImages\":[\"data:image/png;base64,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\",\"data:image/png;base64,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\",\"data:image/png;base64,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\",\"data:image/png;base64,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\"],\"useMarkerImageFunction\":true,\"markerImageFunction\":\"var res = {\\n    url: images[0],\\n    size: 40\\n}\\nvar temperature = data[''temperature''];\\nif (typeof temperature !== undefined) {\\n    var percent = (temperature + 60)/120;\\n    var index = Math.floor(4 * percent);\\n    res.url = images[index];\\n}\\nreturn res;\",\"useColorFunction\":false}],\"fitMapBounds\":true,\"gmDefaultMapType\":\"roadmap\"},\"title\":\"Google Maps\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400},\"useDashboardTimewindow\":true,\"showLegend\":false}"}',
         'Google Maps' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( 'ff0a8d4c-4610-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'analogue_gauges',
         'temperature_radial_gauge_canvas_gauges',
         '{"type":"latest","sizeX":6,"sizeY":5,"resources":[],"templateHtml":"<canvas id=\"radialGauge\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbAnalogueRadialGauge(self.ctx, ''radialGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.getSettingsSchema = function() {\n    return TbAnalogueRadialGauge.settingsSchema;\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temperature\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < -60) {\\n\\tvalue = -60;\\n} else if (value > 60) {\\n\\tvalue = 60;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"rgb(255, 255, 255)\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"maxValue\":60,\"startAngle\":67.5,\"ticksAngle\":225,\"showBorder\":true,\"defaultColor\":\"#e65100\",\"needleCircleSize\":7,\"highlights\":[{\"from\":-60,\"to\":-50,\"color\":\"#42a5f5\"},{\"from\":-50,\"to\":-40,\"color\":\"rgba(66, 165, 245, 0.83)\"},{\"from\":-40,\"to\":-30,\"color\":\"rgba(66, 165, 245, 0.66)\"},{\"from\":-30,\"to\":-20,\"color\":\"rgba(66, 165, 245, 0.5)\"},{\"from\":-20,\"to\":-10,\"color\":\"rgba(66, 165, 245, 0.33)\"},{\"from\":-10,\"to\":0,\"color\":\"rgba(66, 165, 245, 0.16)\"},{\"from\":0,\"to\":10,\"color\":\"rgba(229, 115, 115, 0.16)\"},{\"from\":10,\"to\":20,\"color\":\"rgba(229, 115, 115, 0.33)\"},{\"from\":20,\"to\":30,\"color\":\"rgba(229, 115, 115, 0.5)\"},{\"from\":30,\"to\":40,\"color\":\"rgba(229, 115, 115, 0.66)\"},{\"from\":40,\"to\":50,\"color\":\"rgba(229, 115, 115, 0.83)\"},{\"from\":50,\"to\":60,\"color\":\"#e57373\"}],\"showUnitTitle\":true,\"colorPlate\":\"#cfd8dc\",\"colorMajorTicks\":\"#444\",\"colorMinorTicks\":\"#666\",\"minorTicks\":2,\"valueInt\":3,\"valueDec\":1,\"highlightsWidth\":15,\"valueBox\":true,\"animation\":true,\"animationDuration\":1000,\"animationRule\":\"bounce\",\"colorNeedleShadowUp\":\"rgba(2, 255, 255, 0)\",\"colorNeedleShadowDown\":\"rgba(188, 143, 143, 0.78)\",\"units\":\"°C\",\"majorTicksCount\":12,\"numbersFont\":{\"family\":\"Roboto\",\"size\":20,\"style\":\"normal\",\"weight\":\"normal\",\"color\":\"#263238\"},\"titleFont\":{\"family\":\"Roboto\",\"size\":24,\"style\":\"normal\",\"weight\":\"normal\",\"color\":\"#263238\"},\"unitsFont\":{\"family\":\"Roboto\",\"size\":28,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#616161\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"size\":30,\"style\":\"normal\",\"weight\":\"normal\",\"shadowColor\":\"rgba(0, 0, 0, 0.49)\",\"color\":\"#444\"},\"colorValueBoxRect\":\"#888\",\"colorValueBoxRectEnd\":\"#666\",\"colorValueBoxBackground\":\"#babab2\",\"colorValueBoxShadow\":\"rgba(0,0,0,1)\",\"unitTitle\":\"Temperature\",\"minValue\":-60},\"title\":\"Temperature radial gauge - Canvas Gauges\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Temperature radial gauge - Canvas Gauges' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '01baee42-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'cards', 'attributes_card',
         '{"type":"latest","sizeX":7.5,"sizeY":3,"resources":[],"templateHtml":"","templateCss":"#container {\n    overflow: auto;\n}\n\n.tbDatasource-container {\n    margin: 5px;\n    padding: 8px;\n}\n\n.tbDatasource-title {\n    font-size: 1.200rem;\n    font-weight: 500;\n    padding-bottom: 10px;\n}\n\n.tbDatasource-table {\n    width: 100%;\n    box-shadow: 0 0 10px #ccc;\n    border-collapse: collapse;\n    white-space: nowrap;\n    font-size: 1.000rem;\n    color: #757575;\n}\n\n.tbDatasource-table td {\n    position: relative;\n    border-top: 1px solid rgba(0, 0, 0, 0.12);\n    border-bottom: 1px solid rgba(0, 0, 0, 0.12);\n    padding: 0px 18px;\n    box-sizing: border-box;\n}","controllerScript":"self.onInit = function() {\n    \n    self.ctx.datasourceTitleCells = [];\n    self.ctx.valueCells = [];\n    self.ctx.labelCells = [];\n    \n    for (var i=0; i < self.ctx.datasources.length; i++) {\n        var tbDatasource = self.ctx.datasources[i];\n\n        var datasourceId = ''tbDatasource'' + i;\n        self.ctx.$container.append(\n            \"<div id=''\" + datasourceId +\n            \"'' class=''tbDatasource-container''></div>\"\n        );\n\n        var datasourceContainer = $(''#'' + datasourceId,\n            self.ctx.$container);\n\n        datasourceContainer.append(\n            \"<div class=''tbDatasource-title''>\" +\n            tbDatasource.name + \"</div>\"\n        );\n        \n        var datasourceTitleCell = $(''.tbDatasource-title'', datasourceContainer);\n        self.ctx.datasourceTitleCells.push(datasourceTitleCell);\n        \n        var tableId = ''table'' + i;\n        datasourceContainer.append(\n            \"<table id=''\" + tableId +\n            \"'' class=''tbDatasource-table''><col width=''30%''><col width=''70%''></table>\"\n        );\n        var table = $(''#'' + tableId, self.ctx.$container);\n\n        for (var a = 0; a < tbDatasource.dataKeys.length; a++) {\n            var dataKey = tbDatasource.dataKeys[a];\n            var labelCellId = ''labelCell'' + a;\n            var cellId = ''cell'' + a;\n            table.append(\"<tr><td id=''\" + labelCellId + \"''>\" + dataKey.label +\n                \"</td><td id=''\" + cellId +\n                \"''></td></tr>\");\n            var labelCell = $(''#'' + labelCellId, table);\n            self.ctx.labelCells.push(labelCell);\n            var valueCell = $(''#'' + cellId, table);\n            self.ctx.valueCells.push(valueCell);\n        }\n    }    \n    \n    self.onResize();\n}\n\nself.onDataUpdated = function() {\n    for (var i = 0; i < self.ctx.valueCells.length; i++) {\n        var cellData = self.ctx.data[i];\n        if (cellData && cellData.data && cellData.data.length > 0) {\n            var tvPair = cellData.data[cellData.data.length -\n                1];\n            var value = tvPair[1];\n            self.ctx.valueCells[i].html(value);\n        }\n    }    \n}\n\nself.onResize = function() {\n    var datasoirceTitleFontSize = self.ctx.height/8;\n    if (self.ctx.width/self.ctx.height <= 1.5) {\n        datasoirceTitleFontSize = self.ctx.width/12;\n    }\n    datasoirceTitleFontSize = Math.min(datasoirceTitleFontSize, 20);\n    for (var i = 0; i < self.ctx.datasourceTitleCells.length; i++) {\n        self.ctx.datasourceTitleCells[i].css(''font-size'', datasoirceTitleFontSize+''px'');\n    }\n    var valueFontSize = self.ctx.height/9;\n    var labelFontSize = self.ctx.height/9;\n    if (self.ctx.width/self.ctx.height <= 1.5) {\n        valueFontSize = self.ctx.width/15;\n        labelFontSize = self.ctx.width/15;\n    }\n    valueFontSize = Math.min(valueFontSize, 18);\n    labelFontSize = Math.min(labelFontSize, 18);\n\n    for (i = 0; i < self.ctx.valueCells; i++) {\n        self.ctx.valueCells[i].css(''font-size'', valueFontSize+''px'');\n        self.ctx.valueCells[i].css(''height'', valueFontSize*2.5+''px'');\n        self.ctx.valueCells[i].css(''padding'', ''0px '' + valueFontSize + ''px'');\n        self.ctx.labelCells[i].css(''font-size'', labelFontSize+''px'');\n        self.ctx.labelCells[i].css(''height'', labelFontSize*2.5+''px'');\n        self.ctx.labelCells[i].css(''padding'', ''0px '' + labelFontSize + ''px'');\n    }    \n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Random\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -1000) {\\n\\tvalue = -1000;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{},\"title\":\"Attributes card\"}"}',
         'Attributes card' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '044283a0-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'digital_thermometer',
         '{"type":"latest","sizeX":3,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < -60) {\\n\\tvalue = 60;\\n} else if (value > 60) {\\n\\tvalue = 60;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#000000\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":60,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":1,\"levelColors\":[\"#304ffe\",\"#7e57c2\",\"#ff4081\",\"#d32f2f\"],\"refreshAnimationType\":\"<>\",\"refreshAnimationTime\":700,\"startAnimationType\":\"<>\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"style\":\"normal\",\"weight\":\"500\",\"size\":18},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"dashThickness\":1.5,\"decimals\":0,\"minValue\":-60,\"units\":\"°C\",\"gaugeColor\":\"#333333\",\"neonGlowBrightness\":35,\"gaugeType\":\"donut\"},\"title\":\"Digital thermometer\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Digital thermometer' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '0758880a-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'gpio_widgets',
         'raspberry_pi_gpio_control',
         '{"type":"rpc","sizeX":6,"sizeY":10.5,"resources":[],"templateHtml":"<fieldset class=\"gpio-panel\" ng-disabled=\"!rpcEnabled || executingRpcRequest\" style=\"height: 100%;\">\n    <section class=\"gpio-row\" layout=\"row\" ng-repeat=\"row in rows track by $index\" \n            ng-style=\"{''height'': prefferedRowHeight+''px''}\">\n        <section flex layout=\"row\" ng-repeat=\"cell in row track by $index\">\n            <section layout=\"row\" flex ng-if=\"cell\" layout-align=\"{{$index===0 ? ''end center'' : ''start center''}}\">\n                <span class=\"gpio-left-label\" ng-show=\"$index===0\">{{ cell.label }}</span>\n                <section layout=\"row\" class=\"switch-panel\" layout-align=\"start center\" ng-class=\"$index===0 ? ''col-0'' : ''col-1''\"\n                      ng-style=\"{''height'': prefferedRowHeight+''px'', ''backgroundColor'': ''{{ switchPanelBackgroundColor }}''}\">\n                    <span class=\"pin\" ng-show=\"$index===0\">{{cell.pin}}</span>\n                    <span flex ng-show=\"$index===1\"></span>\n                    <md-switch\n                        aria-label=\"{{ cell.label }}\"\n                        ng-disabled=\"!rpcEnabled || executingRpcRequest\"\n                        ng-model=\"cell.enabled\" \n                        ng-change=\"cell.enabled = !cell.enabled\" \n                        ng-click=\"gpioClick($event, cell)\">\n                    </md-switch>\n                    <span flex ng-show=\"$index===0\"></span>\n                    <span class=\"pin\" ng-show=\"$index===1\">{{cell.pin}}</span>\n                </section>\n                <span class=\"gpio-right-label\" ng-show=\"$index===1\">{{ cell.label }}</span>\n            </section>\n            <section layout=\"row\" flex ng-if=\"!cell\">\n                <span flex ng-show=\"$index===0\"></span>\n                <span class=\"switch-panel\"\n                      ng-style=\"{''height'': prefferedRowHeight+''px'', ''backgroundColor'': ''{{ switchPanelBackgroundColor }}''}\"></span>\n                <span flex ng-show=\"$index===1\"></span>\n            </section>\n        </section>\n    </section>                            \n    <span class=\"error\" style=\"position: absolute; bottom: 5px;\" ng-show=\"rpcErrorText\">{{rpcErrorText}}</span>\n    <md-progress-linear ng-show=\"executingRpcRequest\" style=\"position: absolute; bottom: 0;\" md-mode=\"indeterminate\"></md-progress-linear>    \n</fieldset>","templateCss":".error {\n    font-size: 14px !important;\n    color: maroon;/*rgb(250,250,250);*/\n    background-color: transparent;\n    padding: 6px;\n}\n\n.error span {\n    margin: auto;\n}\n\n.gpio-panel {\n    padding-top: 10px;\n    white-space: nowrap;\n}\n\n.switch-panel {\n    margin: 0;\n    height: 32px;\n    width: 66px;\n    min-width: 66px;\n}\n\n.switch-panel md-switch {\n    margin: 0;\n    width: 36px;\n    min-width: 36px;\n}\n\n.switch-panel md-switch > div.md-container {\n    margin: 0;\n}\n\n.switch-panel.col-0 md-switch {\n    margin-left: 8px;\n    margin-right: 4px;\n}\n\n.switch-panel.col-1 md-switch {\n    margin-left: 4px;\n    margin-right: 8px;\n}\n\n.gpio-row {\n    height: 32px;\n}\n\n.pin {\n    margin-top: auto;\n    margin-bottom: auto;\n    color: white;\n    font-size: 12px;\n    width: 16px;\n    min-width: 16px;\n}\n\n.switch-panel.col-0 .pin {\n    margin-left: auto;\n    padding-left: 2px;\n    text-align: right;\n}\n\n.switch-panel.col-1 .pin {\n    margin-right: auto;\n    \n    text-align: left;\n}\n\n.gpio-left-label {\n    margin-right: 8px;\n}\n\n.gpio-right-label {\n    margin-left: 8px;\n}","controllerScript":"self.onInit = function() {\n    \n    var i, gpio;\n    var scope = self.ctx.$scope;\n    var settings = self.ctx.settings;\n    scope.gpioList = [];\n    for (var g = 0; g < settings.gpioList.length; g++) {\n        gpio = settings.gpioList[g];\n        scope.gpioList.push(\n            {\n                row: gpio.row,\n                col: gpio.col,\n                pin: gpio.pin,\n                label: gpio.label,\n                enabled: false\n            }\n        );\n    }\n\n    scope.requestTimeout = settings.requestTimeout || 1000;\n\n    scope.switchPanelBackgroundColor = settings.switchPanelBackgroundColor || tinycolor(''green'').lighten(2).toRgbString();\n\n    scope.gpioStatusRequest = {\n        method: \"getGpioStatus\",\n        paramsBody: \"{}\"\n    };\n    \n    if (settings.gpioStatusRequest) {\n        scope.gpioStatusRequest.method = settings.gpioStatusRequest.method || scope.gpioStatusRequest.method;\n        scope.gpioStatusRequest.paramsBody = settings.gpioStatusRequest.paramsBody || scope.gpioStatusRequest.paramsBody;\n    }\n    \n    scope.gpioStatusChangeRequest = {\n        method: \"setGpioStatus\",\n        paramsBody: \"{\\n   \\\"pin\\\": \\\"{$pin}\\\",\\n   \\\"enabled\\\": \\\"{$enabled}\\\"\\n}\"\n    };\n    \n    if (settings.gpioStatusChangeRequest) {\n        scope.gpioStatusChangeRequest.method = settings.gpioStatusChangeRequest.method || scope.gpioStatusChangeRequest.method;\n        scope.gpioStatusChangeRequest.paramsBody = settings.gpioStatusChangeRequest.paramsBody || scope.gpioStatusChangeRequest.paramsBody;\n    }\n    \n    scope.parseGpioStatusFunction = \"return body[pin] === true;\";\n    \n    if (settings.parseGpioStatusFunction && settings.parseGpioStatusFunction.length > 0) {\n        scope.parseGpioStatusFunction = settings.parseGpioStatusFunction;\n    }\n    \n    scope.parseGpioStatusFunction = new Function(\"body, pin\", scope.parseGpioStatusFunction);\n    \n    function requestGpioStatus() {\n        self.ctx.controlApi.sendTwoWayCommand(scope.gpioStatusRequest.method, \n                            scope.gpioStatusRequest.paramsBody, \n                            scope.requestTimeout)\n            .then(\n                function success(responseBody) {\n                    for (var g = 0; g < scope.gpioList.length; g++) {\n                        var gpio = scope.gpioList[g];\n                        var enabled = scope.parseGpioStatusFunction.apply(this, [responseBody, gpio.pin]);\n                        gpio.enabled = enabled;                        \n                    }\n                }\n            );\n    }\n    \n    function changeGpioStatus(gpio) {\n        var pin = gpio.pin + '''';\n        var enabled = !gpio.enabled;\n        enabled = enabled === true ? ''true'' : ''false'';\n        var paramsBody = scope.gpioStatusChangeRequest.paramsBody;\n        var requestBody = JSON.parse(paramsBody.replace(\"\\\"{$pin}\\\"\", pin).replace(\"\\\"{$enabled}\\\"\", enabled));\n        self.ctx.controlApi.sendTwoWayCommand(scope.gpioStatusChangeRequest.method, \n                                    requestBody, scope.requestTimeout)\n                    .then(\n                        function success(responseBody) {\n                            var enabled = scope.parseGpioStatusFunction.apply(this, [responseBody, gpio.pin]);\n                            gpio.enabled = enabled;\n                        }\n                    );\n    }\n    \n    scope.gpioCells = {};\n    var rowCount = 0;\n    for (i = 0; i < scope.gpioList.length; i++) {\n        gpio = scope.gpioList[i];\n        scope.gpioCells[gpio.row+''_''+gpio.col] = gpio;\n        rowCount = Math.max(rowCount, gpio.row+1);\n    }\n    \n    scope.prefferedRowHeight = 32;\n    scope.rows = [];\n    for (i = 0; i < rowCount; i++) {\n        var row = [];\n        for (var c =0; c<2;c++) {\n            if (scope.gpioCells[i+''_''+c]) {\n                row[c] = scope.gpioCells[i+''_''+c];\n            } else {\n                row[c] = null;\n            }\n        }\n        scope.rows.push(row);\n    }\n\n    scope.gpioClick = function($event, gpio) {\n        changeGpioStatus(gpio);\n    };\n\n    requestGpioStatus();    \n    \n    self.onResize();\n}\n\nself.onResize = function() {\n    var scope = self.ctx.$scope;\n    var rowCount = scope.rows.length;\n    var prefferedRowHeight = (self.ctx.height - 35)/rowCount;\n    prefferedRowHeight = Math.min(32, prefferedRowHeight);\n    prefferedRowHeight = Math.max(12, prefferedRowHeight);\n    scope.prefferedRowHeight = prefferedRowHeight;\n    var ratio = prefferedRowHeight/32;\n    var switches = $(''md-switch'', self.ctx.$container);\n    switches.css(''height'', 30*ratio+''px'');\n    switches.css(''width'', 36*ratio+''px'');\n    switches.css(''min-width'', 36*ratio+''px'');\n    $(''.md-container'', switches).css(''height'', 24*ratio+''px'');\n    $(''.md-container'', switches).css(''width'', 36*ratio+''px'');\n    var bars = $(''.md-bar'', self.ctx.$container);\n    bars.css(''height'', 14*ratio+''px'');\n    bars.css(''width'', 34*ratio+''px'');\n    var thumbs = $(''.md-thumb'', self.ctx.$container);\n    thumbs.css(''height'', 20*ratio+''px'');\n    thumbs.css(''width'', 20*ratio+''px'');\n    \n    var leftLabels = $(''.gpio-left-label'', self.ctx.$container);\n    leftLabels.css(''font-size'', 16*ratio+''px'');\n    var rightLabels = $(''.gpio-right-label'', self.ctx.$container);\n    rightLabels.css(''font-size'', 16*ratio+''px'');\n    var pins = $(''.pin'', self.ctx.$container);\n    var pinsFontSize = Math.max(9, 12*ratio);\n    pins.css(''font-size'', pinsFontSize+''px'');    \n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"properties\": {\n            \"gpioList\": {\n                \"title\": \"Gpio switches\",\n                \"type\": \"array\",\n                \"minItems\" : 1,\n                \"items\": {\n                    \"title\": \"Gpio switch\",\n                    \"type\": \"object\",\n                    \"properties\": {\n                        \"pin\": {\n                            \"title\": \"Pin\",\n                            \"type\": \"number\"\n                        },\n                        \"label\": {\n                            \"title\": \"Label\",\n                            \"type\": \"string\"\n                        },\n                        \"row\": {\n                            \"title\": \"Row\",\n                            \"type\": \"number\"\n                        },\n                        \"col\": {\n                            \"title\": \"Column\",\n                            \"type\": \"number\"\n                        }\n                    },\n                    \"required\": [\"pin\", \"label\", \"row\", \"col\"]\n                }\n            },\n            \"requestTimeout\": {\n                \"title\": \"RPC request timeout\",\n                \"type\": \"number\",\n                \"default\": 500\n            },\n            \"switchPanelBackgroundColor\": {\n                \"title\": \"Switches panel background color\",\n                \"type\": \"string\",\n                \"default\": \"#008a00\"\n            },\n            \"gpioStatusRequest\": {\n                \"title\": \"GPIO status request\",\n                \"type\": \"object\",\n                 \"properties\": {\n                    \"method\": {\n                        \"title\": \"Method name\",\n                        \"type\": \"string\",\n                        \"default\": \"getGpioStatus\"\n                    },\n                    \"paramsBody\": {\n                      \"title\": \"Method body\",\n                      \"type\": \"string\",\n                      \"default\": \"{}\"\n                    }\n                },\n                \"required\": [\"method\", \"paramsBody\"]\n            },\n            \"gpioStatusChangeRequest\": {\n                \"title\": \"GPIO status change request\",\n                \"type\": \"object\",\n                 \"properties\": {\n                    \"method\": {\n                        \"title\": \"Method name\",\n                        \"type\": \"string\",\n                        \"default\": \"setGpioStatus\"\n                    },\n                    \"paramsBody\": {\n                      \"title\": \"Method body\",\n                      \"type\": \"string\",\n                      \"default\": \"{\\n   \\\"pin\\\": \\\"{$pin}\\\",\\n   \\\"enabled\\\": \\\"{$enabled}\\\"\\n}\"\n                    }\n                },\n                \"required\": [\"method\", \"paramsBody\"]\n            },\n            \"parseGpioStatusFunction\": {\n                \"title\": \"Parse gpio status function\",\n                \"type\": \"string\",\n                \"default\": \"return body[pin] === true;\"\n            } \n        },\n        \"required\": [\"gpioList\", \n                     \"requestTimeout\",\n                     \"switchPanelBackgroundColor\",\n                     \"gpioStatusRequest\",\n                     \"gpioStatusChangeRequest\",\n                     \"parseGpioStatusFunction\"]\n    },\n    \"form\": [\n        \"gpioList\",\n        \"requestTimeout\",\n        {\n            \"key\": \"switchPanelBackgroundColor\",\n            \"type\": \"color\"\n        },\n        {\n            \"key\": \"gpioStatusRequest\",\n            \"items\": [\n                \"gpioStatusRequest.method\",\n                {\n                    \"key\": \"gpioStatusRequest.paramsBody\",\n                    \"type\": \"json\"\n                }\n            ]\n        },\n        {\n            \"key\": \"gpioStatusChangeRequest\",\n            \"items\": [\n                \"gpioStatusChangeRequest.method\",\n                {\n                    \"key\": \"gpioStatusChangeRequest.paramsBody\",\n                    \"type\": \"json\"\n                }\n            ]\n        },\n        {\n            \"key\": \"parseGpioStatusFunction\",\n            \"type\": \"javascript\"\n        }\n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"targetDeviceAliases\":[],\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"parseGpioStatusFunction\":\"return body[pin] === true;\",\"gpioStatusChangeRequest\":{\"method\":\"setGpioStatus\",\"paramsBody\":\"{\\n   \\\"pin\\\": \\\"{$pin}\\\",\\n   \\\"enabled\\\": \\\"{$enabled}\\\"\\n}\"},\"requestTimeout\":500,\"switchPanelBackgroundColor\":\"#008a00\",\"gpioStatusRequest\":{\"method\":\"getGpioStatus\",\"paramsBody\":\"{}\"},\"gpioList\":[{\"pin\":7,\"label\":\"GPIO 4 (GPCLK0)\",\"row\":3,\"col\":0,\"_uniqueKey\":0},{\"pin\":11,\"label\":\"GPIO 17\",\"row\":5,\"col\":0,\"_uniqueKey\":1},{\"pin\":12,\"label\":\"GPIO 18\",\"row\":5,\"col\":1,\"_uniqueKey\":2},{\"_uniqueKey\":3,\"pin\":13,\"label\":\"GPIO 27\",\"row\":6,\"col\":0},{\"_uniqueKey\":4,\"pin\":15,\"label\":\"GPIO 22\",\"row\":7,\"col\":0},{\"_uniqueKey\":5,\"pin\":16,\"label\":\"GPIO 23\",\"row\":7,\"col\":1},{\"_uniqueKey\":6,\"pin\":18,\"label\":\"GPIO 24\",\"row\":8,\"col\":1},{\"_uniqueKey\":7,\"pin\":22,\"label\":\"GPIO 25\",\"row\":10,\"col\":1},{\"_uniqueKey\":8,\"pin\":29,\"label\":\"GPIO 5\",\"row\":14,\"col\":0},{\"_uniqueKey\":9,\"pin\":31,\"label\":\"GPIO 6\",\"row\":15,\"col\":0},{\"_uniqueKey\":10,\"pin\":32,\"label\":\"GPIO 12\",\"row\":15,\"col\":1},{\"_uniqueKey\":11,\"pin\":33,\"label\":\"GPIO 13\",\"row\":16,\"col\":0},{\"_uniqueKey\":12,\"pin\":35,\"label\":\"GPIO 19\",\"row\":17,\"col\":0},{\"_uniqueKey\":13,\"pin\":36,\"label\":\"GPIO 16\",\"row\":17,\"col\":1},{\"_uniqueKey\":14,\"pin\":37,\"label\":\"GPIO 26\",\"row\":18,\"col\":0},{\"_uniqueKey\":15,\"pin\":38,\"label\":\"GPIO 20\",\"row\":18,\"col\":1},{\"_uniqueKey\":16,\"pin\":40,\"label\":\"GPIO 21\",\"row\":19,\"col\":1}]},\"title\":\"Raspberry Pi GPIO Control\"}"}',
         'Raspberry Pi GPIO Control' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '09d408f2-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'gpio_widgets',
         'basic_gpio_control',
         '{"type":"rpc","sizeX":4,"sizeY":2,"resources":[],"templateHtml":"<fieldset class=\"gpio-panel\" ng-disabled=\"!rpcEnabled || executingRpcRequest\" style=\"height: 100%;\">\n    <section class=\"gpio-row\" layout=\"row\" ng-repeat=\"row in rows track by $index\" \n            ng-style=\"{''height'': prefferedRowHeight+''px''}\">\n        <section flex layout=\"row\" ng-repeat=\"cell in row track by $index\">\n            <section layout=\"row\" flex ng-if=\"cell\" layout-align=\"{{$index===0 ? ''end center'' : ''start center''}}\">\n                <span class=\"gpio-left-label\" ng-show=\"$index===0\">{{ cell.label }}</span>\n                <section layout=\"row\" class=\"switch-panel\" layout-align=\"start center\" ng-class=\"$index===0 ? ''col-0'' : ''col-1''\"\n                      ng-style=\"{''height'': prefferedRowHeight+''px'', ''backgroundColor'': ''{{ switchPanelBackgroundColor }}''}\">\n                    <span class=\"pin\" ng-show=\"$index===0\">{{cell.pin}}</span>\n                    <span flex ng-show=\"$index===1\"></span>\n                    <md-switch\n                        aria-label=\"{{ cell.label }}\"\n                        ng-disabled=\"!rpcEnabled || executingRpcRequest\"\n                        ng-model=\"cell.enabled\" \n                        ng-change=\"cell.enabled = !cell.enabled\" \n                        ng-click=\"gpioClick($event, cell)\">\n                    </md-switch>\n                    <span flex ng-show=\"$index===0\"></span>\n                    <span class=\"pin\" ng-show=\"$index===1\">{{cell.pin}}</span>\n                </section>\n                <span class=\"gpio-right-label\" ng-show=\"$index===1\">{{ cell.label }}</span>\n            </section>\n            <section layout=\"row\" flex ng-if=\"!cell\">\n                <span flex ng-show=\"$index===0\"></span>\n                <span class=\"switch-panel\"\n                      ng-style=\"{''height'': prefferedRowHeight+''px'', ''backgroundColor'': ''{{ switchPanelBackgroundColor }}''}\"></span>\n                <span flex ng-show=\"$index===1\"></span>\n            </section>\n        </section>\n    </section>                            \n    <span class=\"error\" style=\"position: absolute; bottom: 5px;\" ng-show=\"rpcErrorText\">{{rpcErrorText}}</span>\n    <md-progress-linear ng-show=\"executingRpcRequest\" style=\"position: absolute; bottom: 0;\" md-mode=\"indeterminate\"></md-progress-linear>    \n</fieldset>","templateCss":".error {\n    font-size: 14px !important;\n    color: maroon;/*rgb(250,250,250);*/\n    background-color: transparent;\n    padding: 6px;\n}\n\n.error span {\n    margin: auto;\n}\n\n.gpio-panel {\n    padding-top: 10px;\n    white-space: nowrap;\n}\n\n.switch-panel {\n    margin: 0;\n    height: 32px;\n    width: 66px;\n    min-width: 66px;\n}\n\n.switch-panel md-switch {\n    margin: 0;\n    width: 36px;\n    min-width: 36px;\n}\n\n.switch-panel md-switch > div.md-container {\n    margin: 0;\n}\n\n.switch-panel.col-0 md-switch {\n    padding-left: 8px;\n    padding-right: 4px;\n}\n\n.switch-panel.col-1 md-switch {\n    padding-left: 4px;\n    padding-right: 8px;\n}\n\n.gpio-row {\n    height: 32px;\n}\n\n.pin {\n    margin-top: auto;\n    margin-bottom: auto;\n    color: white;\n    font-size: 12px;\n    width: 16px;\n    min-width: 16px;\n}\n\n.switch-panel.col-0 .pin {\n    margin-left: auto;\n    padding-left: 2px;\n    text-align: right;\n}\n\n.switch-panel.col-1 .pin {\n    margin-right: auto;\n    \n    text-align: left;\n}\n\n.gpio-left-label {\n    margin-right: 8px;\n}\n\n.gpio-right-label {\n    margin-left: 8px;\n}","controllerScript":"self.onInit = function() {\n    \n    var i, gpio;\n    var scope = self.ctx.$scope;\n    var settings = self.ctx.settings;\n    scope.gpioList = [];\n    for (var g = 0; g < settings.gpioList.length; g++) {\n        gpio = settings.gpioList[g];\n        scope.gpioList.push(\n            {\n                row: gpio.row,\n                col: gpio.col,\n                pin: gpio.pin,\n                label: gpio.label,\n                enabled: false\n            }\n        );\n    }\n\n    scope.requestTimeout = settings.requestTimeout || 1000;\n\n    scope.switchPanelBackgroundColor = settings.switchPanelBackgroundColor || tinycolor(''green'').lighten(2).toRgbString();\n\n    scope.gpioStatusRequest = {\n        method: \"getGpioStatus\",\n        paramsBody: \"{}\"\n    };\n    \n    if (settings.gpioStatusRequest) {\n        scope.gpioStatusRequest.method = settings.gpioStatusRequest.method || scope.gpioStatusRequest.method;\n        scope.gpioStatusRequest.paramsBody = settings.gpioStatusRequest.paramsBody || scope.gpioStatusRequest.paramsBody;\n    }\n    \n    scope.gpioStatusChangeRequest = {\n        method: \"setGpioStatus\",\n        paramsBody: \"{\\n   \\\"pin\\\": \\\"{$pin}\\\",\\n   \\\"enabled\\\": \\\"{$enabled}\\\"\\n}\"\n    };\n    \n    if (settings.gpioStatusChangeRequest) {\n        scope.gpioStatusChangeRequest.method = settings.gpioStatusChangeRequest.method || scope.gpioStatusChangeRequest.method;\n        scope.gpioStatusChangeRequest.paramsBody = settings.gpioStatusChangeRequest.paramsBody || scope.gpioStatusChangeRequest.paramsBody;\n    }\n    \n    scope.parseGpioStatusFunction = \"return body[pin] === true;\";\n    \n    if (settings.parseGpioStatusFunction && settings.parseGpioStatusFunction.length > 0) {\n        scope.parseGpioStatusFunction = settings.parseGpioStatusFunction;\n    }\n    \n    scope.parseGpioStatusFunction = new Function(\"body, pin\", scope.parseGpioStatusFunction);\n    \n    function requestGpioStatus() {\n        self.ctx.controlApi.sendTwoWayCommand(scope.gpioStatusRequest.method, \n                            scope.gpioStatusRequest.paramsBody, \n                            scope.requestTimeout)\n            .then(\n                function success(responseBody) {\n                    for (var g = 0; g < scope.gpioList.length; g++) {\n                        var gpio = scope.gpioList[g];\n                        var enabled = scope.parseGpioStatusFunction.apply(this, [responseBody, gpio.pin]);\n                        gpio.enabled = enabled;                        \n                    }\n                }\n            );\n    }\n    \n    function changeGpioStatus(gpio) {\n        var pin = gpio.pin + '''';\n        var enabled = !gpio.enabled;\n        enabled = enabled === true ? ''true'' : ''false'';\n        var paramsBody = scope.gpioStatusChangeRequest.paramsBody;\n        var requestBody = JSON.parse(paramsBody.replace(\"\\\"{$pin}\\\"\", pin).replace(\"\\\"{$enabled}\\\"\", enabled));\n        self.ctx.controlApi.sendTwoWayCommand(scope.gpioStatusChangeRequest.method, \n                                    requestBody, scope.requestTimeout)\n                    .then(\n                        function success(responseBody) {\n                            var enabled = scope.parseGpioStatusFunction.apply(this, [responseBody, gpio.pin]);\n                            gpio.enabled = enabled;\n                        }\n                    );\n    }\n    \n    scope.gpioCells = {};\n    var rowCount = 0;\n    for (i = 0; i < scope.gpioList.length; i++) {\n        gpio = scope.gpioList[i];\n        scope.gpioCells[gpio.row+''_''+gpio.col] = gpio;\n        rowCount = Math.max(rowCount, gpio.row+1);\n    }\n    \n    scope.prefferedRowHeight = 32;\n    scope.rows = [];\n    for (i = 0; i < rowCount; i++) {\n        var row = [];\n        for (var c =0; c<2;c++) {\n            if (scope.gpioCells[i+''_''+c]) {\n                row[c] = scope.gpioCells[i+''_''+c];\n            } else {\n                row[c] = null;\n            }\n        }\n        scope.rows.push(row);\n    }\n\n    scope.gpioClick = function($event, gpio) {\n        changeGpioStatus(gpio);\n    };\n\n    requestGpioStatus();    \n    \n    self.onResize();\n}\n\nself.onResize = function() {\n    var scope = self.ctx.$scope;\n    var rowCount = scope.rows.length;\n    var prefferedRowHeight = (self.ctx.height - 35)/rowCount;\n    prefferedRowHeight = Math.min(32, prefferedRowHeight);\n    prefferedRowHeight = Math.max(12, prefferedRowHeight);\n    scope.prefferedRowHeight = prefferedRowHeight;\n    var ratio = prefferedRowHeight/32;\n    var switches = $(''md-switch'', self.ctx.$container);\n    switches.css(''height'', 30*ratio+''px'');\n    switches.css(''width'', 36*ratio+''px'');\n    switches.css(''min-width'', 36*ratio+''px'');\n    $(''.md-container'', switches).css(''height'', 24*ratio+''px'');\n    $(''.md-container'', switches).css(''width'', 36*ratio+''px'');\n    var bars = $(''.md-bar'', self.ctx.$container);\n    bars.css(''height'', 14*ratio+''px'');\n    bars.css(''width'', 34*ratio+''px'');\n    var thumbs = $(''.md-thumb'', self.ctx.$container);\n    thumbs.css(''height'', 20*ratio+''px'');\n    thumbs.css(''width'', 20*ratio+''px'');\n    \n    var leftLabels = $(''.gpio-left-label'', self.ctx.$container);\n    leftLabels.css(''font-size'', 16*ratio+''px'');\n    var rightLabels = $(''.gpio-right-label'', self.ctx.$container);\n    rightLabels.css(''font-size'', 16*ratio+''px'');\n    var pins = $(''.pin'', self.ctx.$container);\n    var pinsFontSize = Math.max(9, 12*ratio);\n    pins.css(''font-size'', pinsFontSize+''px'');    \n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n    \"schema\": {\n        \"type\": \"object\",\n        \"title\": \"Settings\",\n        \"properties\": {\n            \"gpioList\": {\n                \"title\": \"Gpio switches\",\n                \"type\": \"array\",\n                \"minItems\" : 1,\n                \"items\": {\n                    \"title\": \"Gpio switch\",\n                    \"type\": \"object\",\n                    \"properties\": {\n                        \"pin\": {\n                            \"title\": \"Pin\",\n                            \"type\": \"number\"\n                        },\n                        \"label\": {\n                            \"title\": \"Label\",\n                            \"type\": \"string\"\n                        },\n                        \"row\": {\n                            \"title\": \"Row\",\n                            \"type\": \"number\"\n                        },\n                        \"col\": {\n                            \"title\": \"Column\",\n                            \"type\": \"number\"\n                        }\n                    },\n                    \"required\": [\"pin\", \"label\", \"row\", \"col\"]\n                }\n            },\n            \"requestTimeout\": {\n                \"title\": \"RPC request timeout\",\n                \"type\": \"number\",\n                \"default\": 500\n            },\n            \"switchPanelBackgroundColor\": {\n                \"title\": \"Switches panel background color\",\n                \"type\": \"string\",\n                \"default\": \"#008a00\"\n            },\n            \"gpioStatusRequest\": {\n                \"title\": \"GPIO status request\",\n                \"type\": \"object\",\n                 \"properties\": {\n                    \"method\": {\n                        \"title\": \"Method name\",\n                        \"type\": \"string\",\n                        \"default\": \"getGpioStatus\"\n                    },\n                    \"paramsBody\": {\n                      \"title\": \"Method body\",\n                      \"type\": \"string\",\n                      \"default\": \"{}\"\n                    }\n                },\n                \"required\": [\"method\", \"paramsBody\"]\n            },\n            \"gpioStatusChangeRequest\": {\n                \"title\": \"GPIO status change request\",\n                \"type\": \"object\",\n                 \"properties\": {\n                    \"method\": {\n                        \"title\": \"Method name\",\n                        \"type\": \"string\",\n                        \"default\": \"setGpioStatus\"\n                    },\n                    \"paramsBody\": {\n                      \"title\": \"Method body\",\n                      \"type\": \"string\",\n                      \"default\": \"{\\n   \\\"pin\\\": \\\"{$pin}\\\",\\n   \\\"enabled\\\": \\\"{$enabled}\\\"\\n}\"\n                    }\n                },\n                \"required\": [\"method\", \"paramsBody\"]\n            },\n            \"parseGpioStatusFunction\": {\n                \"title\": \"Parse gpio status function\",\n                \"type\": \"string\",\n                \"default\": \"return body[pin] === true;\"\n            } \n        },\n        \"required\": [\"gpioList\", \n                     \"requestTimeout\",\n                     \"switchPanelBackgroundColor\",\n                     \"gpioStatusRequest\",\n                     \"gpioStatusChangeRequest\",\n                     \"parseGpioStatusFunction\"]\n    },\n    \"form\": [\n        \"gpioList\",\n        \"requestTimeout\",\n        {\n            \"key\": \"switchPanelBackgroundColor\",\n            \"type\": \"color\"\n        },\n        {\n            \"key\": \"gpioStatusRequest\",\n            \"items\": [\n                \"gpioStatusRequest.method\",\n                {\n                    \"key\": \"gpioStatusRequest.paramsBody\",\n                    \"type\": \"json\"\n                }\n            ]\n        },\n        {\n            \"key\": \"gpioStatusChangeRequest\",\n            \"items\": [\n                \"gpioStatusChangeRequest.method\",\n                {\n                    \"key\": \"gpioStatusChangeRequest.paramsBody\",\n                    \"type\": \"json\"\n                }\n            ]\n        },\n        {\n            \"key\": \"parseGpioStatusFunction\",\n            \"type\": \"javascript\"\n        }\n    ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"targetDeviceAliases\":[],\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"parseGpioStatusFunction\":\"return body[pin] === true;\",\"gpioStatusChangeRequest\":{\"method\":\"setGpioStatus\",\"paramsBody\":\"{\\n   \\\"pin\\\": \\\"{$pin}\\\",\\n   \\\"enabled\\\": \\\"{$enabled}\\\"\\n}\"},\"requestTimeout\":500,\"switchPanelBackgroundColor\":\"#b71c1c\",\"gpioStatusRequest\":{\"method\":\"getGpioStatus\",\"paramsBody\":\"{}\"},\"gpioList\":[{\"pin\":1,\"label\":\"GPIO 1\",\"row\":0,\"col\":0,\"_uniqueKey\":0},{\"pin\":2,\"label\":\"GPIO 2\",\"row\":0,\"col\":1,\"_uniqueKey\":1},{\"pin\":3,\"label\":\"GPIO 3\",\"row\":1,\"col\":0,\"_uniqueKey\":2}]},\"title\":\"Basic GPIO Control\"}"}',
         'Basic GPIO Control' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '0d10aca0-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'horizontal_bar_justgage',
         '{"type":"latest","sizeX":7,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>\n","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#ffffff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\">\",\"refreshAnimationTime\":700,\"startAnimationType\":\">\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#999999\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Roboto\",\"style\":\"normal\",\"weight\":\"500\",\"size\":18,\"color\":\"#666666\"},\"minMaxFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#666666\"},\"neonGlowBrightness\":0,\"decimals\":0,\"dashThickness\":0,\"gaugeColor\":\"#eeeeee\",\"showTitle\":true,\"gaugeType\":\"horizontalBar\"},\"title\":\"Horizontal bar - justGage\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Horizontal bar - justGage' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '10500a0a-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges',
         'gauge_justgage',
         '{"type":"latest","sizeX":4,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Temp\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 20 - 10;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#ffffff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":100,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\">\",\"refreshAnimationTime\":700,\"startAnimationType\":\">\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#999999\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Roboto\",\"style\":\"normal\",\"weight\":\"500\",\"size\":36,\"color\":\"#666666\"},\"minMaxFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#666666\"},\"neonGlowBrightness\":0,\"decimals\":0,\"dashThickness\":0,\"gaugeColor\":\"#eeeeee\",\"showTitle\":true,\"gaugeType\":\"arc\"},\"title\":\"Gauge - justGage\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Gauge - justGage' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '13820124-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'digital_gauges', 'lcd_gauge',
         '{"type":"latest","sizeX":5,"sizeY":3,"resources":[],"templateHtml":"<canvas id=\"digitalGauge\"></canvas>","templateCss":"#gauge {\n    text-align: center;\n   /* margin-left: -100px;\n    margin-right: -100px;*/\n    /*margin-top: -50px;*/\n    \n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbCanvasDigitalGauge(self.ctx, ''digitalGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.getSettingsSchema = function() {\n    return TbCanvasDigitalGauge.settingsSchema;\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Speed\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 180) {\\n\\tvalue = 180;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"#babab2\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"0px\",\"settings\":{\"maxValue\":180,\"minValue\":0,\"donutStartAngle\":90,\"showValue\":true,\"showMinMax\":true,\"gaugeWidthScale\":0.75,\"levelColors\":[],\"refreshAnimationType\":\"linear\",\"refreshAnimationTime\":700,\"startAnimationType\":\"linear\",\"startAnimationTime\":700,\"titleFont\":{\"family\":\"Roboto\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"labelFont\":{\"family\":\"Roboto\",\"size\":8,\"style\":\"normal\",\"weight\":\"500\"},\"valueFont\":{\"family\":\"Segment7Standard\",\"style\":\"normal\",\"weight\":\"500\",\"size\":32},\"minMaxFont\":{\"family\":\"Segment7Standard\",\"size\":12,\"style\":\"normal\",\"weight\":\"500\"},\"neonGlowBrightness\":0,\"dashThickness\":1.5,\"decimals\":0,\"unitTitle\":\"MPH\",\"showUnitTitle\":true,\"defaultColor\":\"#444444\",\"gaugeType\":\"arc\"},\"title\":\"LCD gauge\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'LCD gauge' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '166c022c-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'maps', 'openstreetmap',
         '{"type":"latest","sizeX":8.5,"sizeY":6,"resources":[],"templateHtml":"","templateCss":".leaflet-zoom-box {\n\tz-index: 9;\n}\n\n.leaflet-pane         { z-index: 4; }\n\n.leaflet-tile-pane    { z-index: 2; }\n.leaflet-overlay-pane { z-index: 4; }\n.leaflet-shadow-pane  { z-index: 5; }\n.leaflet-marker-pane  { z-index: 6; }\n.leaflet-tooltip-pane   { z-index: 7; }\n.leaflet-popup-pane   { z-index: 8; }\n\n.leaflet-map-pane canvas { z-index: 1; }\n.leaflet-map-pane svg    { z-index: 2; }\n\n.leaflet-control {\n\tz-index: 9;\n}\n.leaflet-top,\n.leaflet-bottom {\n\tz-index: 11;\n}\n\n.tb-marker-label {\n    border: none;\n    background: none;\n    box-shadow: none;\n}\n\n.tb-marker-label:before {\n    border: none;\n    background: none;\n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.map = new TbMapWidget(''openstreet-map'', false, self.ctx);\n}\n\nself.onDataUpdated = function() {\n    self.ctx.map.update();\n}\n\nself.onResize = function() {\n    self.ctx.map.resize();\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{\n  \"schema\": {\n    \"title\": \"Google Map Configuration\",\n    \"type\": \"object\",\n    \"properties\": {\n      \"defaultZoomLevel\": {\n         \"title\": \"Default map zoom level (1 - 20)\",\n         \"type\": \"number\"\n      },\n      \"fitMapBounds\": {\n          \"title\": \"Fit map bounds to cover all markers\",\n          \"type\": \"boolean\",\n          \"default\": true\n      },\n      \"markersSettings\": {\n            \"title\": \"Markers\",\n            \"type\": \"array\",\n            \"items\": {\n              \"title\": \"Marker settings\",\n              \"type\": \"object\",\n              \"properties\": {\n                  \"latKeyName\": {\n                    \"title\": \"Latitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lat\"\n                  },\n                  \"lngKeyName\": {\n                    \"title\": \"Longitude key name\",\n                    \"type\": \"string\",\n                    \"default\": \"lng\"\n                  },                  \n                  \"showLabel\": {\n                    \"title\": \"Show label\",\n                    \"type\": \"boolean\",\n                    \"default\": true\n                  },                  \n                  \"label\": {\n                    \"title\": \"Label\",\n                    \"type\": \"string\"\n                  },\n                  \"tooltipPattern\": {\n                    \"title\": \"Pattern ( for ex. ''Text ${keyName} units.'' or ''${#<key index>} units''  )\",\n                    \"type\": \"string\",\n                    \"default\": \"<b>Latitude:</b> ${lat:7}<br/><b>Longitude:</b> ${lng:7}\"\n                  },\n                  \"color\": {\n                    \"title\": \"Color\",\n                    \"type\": \"string\"\n                  },\n                  \"useColorFunction\": {\n                    \"title\": \"Use color function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"colorFunction\": {\n                    \"title\": \"Color function: f(data)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImage\": {\n                    \"title\": \"Custom marker image\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImageSize\": {\n                    \"title\": \"Custom marker image size (px)\",\n                    \"type\": \"number\",\n                    \"default\": 34\n                  },\n                  \"useMarkerImageFunction\": {\n                    \"title\": \"Use marker image function\",\n                    \"type\": \"boolean\",\n                    \"default\": false\n                  },\n                  \"markerImageFunction\": {\n                    \"title\": \"Marker image function: f(data, images)\",\n                    \"type\": \"string\"\n                  },\n                  \"markerImages\": {\n                        \"title\": \"Marker images\",\n                        \"type\": \"array\",\n                        \"items\": {\n                          \"title\": \"Marker image\",\n                          \"type\": \"string\"\n                        }\n                  }\n              }\n           }\n       }\n    },\n    \"required\": [\n    ]\n  },\n  \"form\": [\n    \"defaultZoomLevel\",\n    \"fitMapBounds\",\n    {\n        \"key\": \"markersSettings\",\n        \"items\": [\n            \"markersSettings[].latKeyName\",\n            \"markersSettings[].lngKeyName\",\n            \"markersSettings[].showLabel\",\n            \"markersSettings[].label\",\n            \"markersSettings[].tooltipPattern\",\n            {\n                \"key\": \"markersSettings[].color\",\n                \"type\": \"color\"\n            },\n            \"markersSettings[].useColorFunction\",\n            {\n                \"key\": \"markersSettings[].colorFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"markersSettings[].markerImage\",\n                \"type\": \"image\"\n            },\n            \"markersSettings[].markerImageSize\",\n            \"markersSettings[].useMarkerImageFunction\",\n            {\n                \"key\": \"markersSettings[].markerImageFunction\",\n                \"type\": \"javascript\"\n            },\n            {\n                \"key\": \"markersSettings[].markerImages\",\n                \"items\": [\n                    {\n                        \"key\": \"markersSettings[].markerImages[]\",\n                        \"type\": \"image\"\n                    }\n                ]\n            }\n        ]\n    }\n  ]\n}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"latitude\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.05427416942713381,\"funcBody\":\"var value = prevValue || 15.833293;\\nif (time % 5000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"longitude\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.680594833308841,\"funcBody\":\"var value = prevValue || -90.454350;\\nif (time % 5000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"}]},{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"lat\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.05012157428742059,\"funcBody\":\"var value = prevValue || 14.450463;\\nif (time % 4000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"lng\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.6742359401617628,\"funcBody\":\"var value = prevValue || -84.845334;\\nif (time % 4000 < 500) {\\n    value += Math.random() * 0.05 - 0.025;\\n}\\nreturn value;\"}]},{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"temperature\",\"color\":\"#607d8b\",\"settings\":{},\"_hash\":0.21553274887887564,\"funcBody\":\"var value = prevValue + Math.random() * 40 - 20;\\nif (value < -60) {\\n\\tvalue = -60;\\n} else if (value > 60) {\\n\\tvalue = 60;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"markersSettings\":[{\"label\":\"First point\",\"color\":\"#1e88e5\",\"latKeyName\":\"latitude\",\"lngKeyName\":\"longitude\",\"showLabel\":true,\"tooltipPattern\":\"<b>Latitude:</b> ${latitude:7}<br/><b>Longitude:</b> ${longitude:7}<br/><b>Temperature:</b> ${temperature} °C<br/><small>See advanced settings for details</small>\",\"useColorFunction\":true,\"colorFunction\":\"var temperature = data[''temperature''];\\nif (typeof temperature !== undefined) {\\n    var percent = (temperature + 60)/120 * 100;\\n    return tinycolor.mix(''blue'', ''red'', amount = percent).toHexString();\\n}\\nreturn ''blue'';\"},{\"label\":\"Second point\",\"color\":\"#fdd835\",\"latKeyName\":\"lat\",\"lngKeyName\":\"lng\",\"showLabel\":true,\"tooltipPattern\":\"<b>Latitude:</b> ${lat:7}<br/><b>Longitude:</b> ${lng:7}<br/><b>Temperature:</b> ${temperature} °C<br/><small>See advanced settings for details</small>\",\"markerImageSize\":34,\"useMarkerImageFunction\":true,\"markerImages\":[\"data:image/svg+xml;base64,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\",\"data:image/svg+xml;base64,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\",\"data:image/svg+xml;base64,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\",\"data:image/svg+xml;base64,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\"],\"markerImageFunction\":\"var res = {\\n    url: images[0],\\n    size: 40\\n}\\nvar temperature = data[''temperature''];\\nif (typeof temperature !== undefined) {\\n    var percent = (temperature + 60)/120;\\n    var index = Math.floor(4 * percent);\\n    res.url = images[index];\\n}\\nreturn res;\"}],\"fitMapBounds\":true},\"title\":\"OpenStreetMap\"}"}',
         'OpenStreetMap' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '191d156a-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'analogue_gauges',
         'speed_gauge_canvas_gauges',
         '{"type":"latest","sizeX":7,"sizeY":5,"resources":[],"templateHtml":"<canvas id=\"radialGauge\"></canvas>\n","templateCss":"","controllerScript":"self.onInit = function() {\n    self.ctx.gauge = new TbAnalogueRadialGauge(self.ctx, ''radialGauge'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.gauge.update();\n}\n\nself.onResize = function() {\n    self.ctx.gauge.resize();\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.gauge.mobileModeChanged();\n}\n\nself.getSettingsSchema = function() {\n    return TbAnalogueRadialGauge.settingsSchema;\n}\n\nself.onDestroy = function() {\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Speed\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.7282710489093589,\"funcBody\":\"var value = prevValue + Math.random() * 50 - 25;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 220) {\\n\\tvalue = 220;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":false,\"backgroundColor\":\"rgb(255, 255, 255)\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"maxValue\":180,\"startAngle\":45,\"ticksAngle\":270,\"showBorder\":false,\"defaultColor\":\"#e65100\",\"needleCircleSize\":7,\"highlights\":[{\"from\":80,\"to\":120,\"color\":\"#fdd835\"},{\"color\":\"#e57373\",\"from\":120,\"to\":180}],\"showUnitTitle\":false,\"colorPlate\":\"#fff\",\"colorMajorTicks\":\"#444\",\"colorMinorTicks\":\"#666\",\"minorTicks\":2,\"valueInt\":3,\"minValue\":0,\"valueDec\":0,\"highlightsWidth\":15,\"valueBox\":true,\"animation\":true,\"animationDuration\":1500,\"animationRule\":\"linear\",\"colorNeedleShadowUp\":\"rgba(2, 255, 255, 0)\",\"colorNeedleShadowDown\":\"rgba(188, 143, 143, 0.78)\",\"units\":\"MPH\",\"majorTicksCount\":9,\"numbersFont\":{\"family\":\"Roboto\",\"size\":22,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#616161\"},\"titleFont\":{\"family\":\"Roboto\",\"size\":24,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#888\"},\"unitsFont\":{\"family\":\"Roboto\",\"size\":28,\"style\":\"normal\",\"weight\":\"500\",\"color\":\"#616161\"},\"valueFont\":{\"size\":32,\"style\":\"normal\",\"weight\":\"normal\",\"shadowColor\":\"rgba(0, 0, 0, 0.49)\",\"color\":\"#444\",\"family\":\"Segment7Standard\"},\"colorValueBoxRect\":\"#888\",\"colorValueBoxRectEnd\":\"#666\",\"colorValueBoxBackground\":\"#babab2\",\"colorValueBoxShadow\":\"rgba(0,0,0,1)\"},\"title\":\"Speed gauge - Canvas Gauges\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Speed gauge - Canvas Gauges' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '1c58d1ec-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'pie',
         '{"type":"latest","sizeX":8,"sizeY":5,"resources":[],"templateHtml":"","templateCss":".legend {\n    font-size: 13px;\n    line-height: 10px;\n}\n\n.legend table { \n    border-spacing: 0px;\n    border-collapse: separate;\n}\n\n.pie-label {\n    font-size: 12px;\n    font-family: ''Roboto'';\n    font-weight: bold;\n    text-align: center;\n    padding: 2px;\n    color: white;\n}\n","controllerScript":"self.onInit = function() {\n    self.ctx.flot = new TbFlot(self.ctx, ''pie'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.flot.update();\n}\n\nself.onResize = function() {\n    self.ctx.flot.resize();\n}\n\nself.onEditModeChanged = function() {\n    self.ctx.flot.checkMouseEvents();\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.flot.checkMouseEvents();\n}\n\nself.getSettingsSchema = function() {\n    return TbFlot.pieSettingsSchema;\n}\n\nself.getDataKeySettingsSchema = function() {\n    return TbFlot.pieDatakeySettingsSchema;\n}\n\nself.onDestroy = function() {\n    self.ctx.flot.destroy();\n}\n","settingsSchema":"{}\n","dataKeySettingsSchema":"{}\n","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{},\"_hash\":0.15479322438769105,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#4caf50\",\"settings\":{},\"_hash\":0.6114638304362894,\"funcBody\":\"var value = (prevValue-20) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+20;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Third\",\"color\":\"#f44336\",\"settings\":{},\"_hash\":0.9955906536344441,\"funcBody\":\"var value = (prevValue-40) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+40;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Fourth\",\"color\":\"#ffc107\",\"settings\":{},\"_hash\":0.9430835931647599,\"funcBody\":\"var value = (prevValue-50) + Math.random() * 2 - 1;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 100) {\\n\\tvalue = 100;\\n}\\nreturn value+50;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"radius\":1,\"fontColor\":\"#545454\",\"fontSize\":10,\"decimals\":1,\"legend\":{\"show\":true,\"position\":\"nw\",\"labelBoxBorderColor\":\"#CCCCCC\",\"backgroundColor\":\"#F0F0F0\",\"backgroundOpacity\":0.85},\"innerRadius\":0,\"showLabels\":true,\"stroke\":{\"width\":5},\"tilt\":1,\"animatedPie\":false},\"title\":\"Pie - Flot\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400}}"}',
         'Pie - Flot' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '1f712b86-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'timeseries_bars_flot',
         '{"type":"timeseries","sizeX":8,"sizeY":5,"resources":[],"templateHtml":"","templateCss":".legend {\n    font-size: 13px;\n    line-height: 10px;\n}\n\n.legend table { \n    border-spacing: 0px;\n    border-collapse: separate;\n}\n\n.mouse-events .flot-overlay {\n    cursor: crosshair; \n}\n\n","controllerScript":"self.onInit = function() {\n    self.ctx.flot = new TbFlot(self.ctx, ''bar'');    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.flot.update();\n}\n\nself.onResize = function() {\n    self.ctx.flot.resize();\n}\n\nself.onEditModeChanged = function() {\n    self.ctx.flot.checkMouseEvents();\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.flot.checkMouseEvents();\n}\n\nself.getSettingsSchema = function() {\n    return TbFlot.settingsSchema;\n}\n\nself.getDataKeySettingsSchema = function() {\n    return TbFlot.datakeySettingsSchema(false);\n}\n\nself.onDestroy = function() {\n    self.ctx.flot.destroy();\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{\"showLines\":false,\"fillLines\":false,\"showPoints\":false},\"_hash\":0.8587686344902596,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#ffc107\",\"settings\":{\"showLines\":false,\"fillLines\":false,\"showPoints\":false},\"_hash\":0.12775350966079668,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < 0) {\\n\\tvalue = 0;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000},\"aggregation\":{\"limit\":200,\"type\":\"AVG\"}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"shadowSize\":4,\"fontColor\":\"#545454\",\"fontSize\":10,\"xaxis\":{\"showLabels\":true,\"color\":\"#545454\"},\"yaxis\":{\"showLabels\":true,\"color\":\"#545454\"},\"grid\":{\"color\":\"#545454\",\"tickColor\":\"#DDDDDD\",\"verticalLines\":true,\"horizontalLines\":true,\"outlineWidth\":1},\"legend\":{\"show\":true,\"position\":\"nw\",\"backgroundColor\":\"#f0f0f0\",\"backgroundOpacity\":0.85,\"labelBoxBorderColor\":\"rgba(1, 1, 1, 0.45)\"},\"decimals\":1,\"stack\":true,\"tooltipIndividual\":false},\"title\":\"Timeseries Bars - Flot\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400},\"mobileHeight\":null}"}',
         'Timeseries Bars - Flot' );

INSERT INTO widget_type ( id, tenant_id, bundle_alias, alias, descriptor, name )
VALUES ( '229fb296-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'charts', 'basic_timeseries',
         '{"type":"timeseries","sizeX":8,"sizeY":5,"resources":[],"templateHtml":"","templateCss":".legend {\n    font-size: 13px;\n    line-height: 10px;\n}\n\n.legend table { \n    border-spacing: 0px;\n    border-collapse: separate;\n}\n\n.mouse-events .flot-overlay {\n    cursor: crosshair; \n}\n\n","controllerScript":"self.onInit = function() {\n    self.ctx.flot = new TbFlot(self.ctx);    \n}\n\nself.onDataUpdated = function() {\n    self.ctx.flot.update();\n}\n\nself.onResize = function() {\n    self.ctx.flot.resize();\n}\n\nself.onEditModeChanged = function() {\n    self.ctx.flot.checkMouseEvents();\n}\n\nself.onMobileModeChanged = function() {\n    self.ctx.flot.checkMouseEvents();\n}\n\nself.getSettingsSchema = function() {\n    return TbFlot.settingsSchema;\n}\n\nself.getDataKeySettingsSchema = function() {\n    return TbFlot.datakeySettingsSchema(true);\n}\n\nself.onDestroy = function() {\n    self.ctx.flot.destroy();\n}\n","settingsSchema":"{}","dataKeySettingsSchema":"{}","defaultConfig":"{\"datasources\":[{\"type\":\"function\",\"name\":\"function\",\"dataKeys\":[{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"First\",\"color\":\"#2196f3\",\"settings\":{\"showLines\":true,\"fillLines\":true,\"showPoints\":false},\"_hash\":0.8587686344902596,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -1000) {\\n\\tvalue = -1000;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"},{\"name\":\"f(x)\",\"type\":\"function\",\"label\":\"Second\",\"color\":\"#ffc107\",\"settings\":{\"showLines\":true,\"fillLines\":false,\"showPoints\":false},\"_hash\":0.12775350966079668,\"funcBody\":\"var value = prevValue + Math.random() * 100 - 50;\\nvar multiplier = Math.pow(10, 2 || 0);\\nvar value = Math.round(value * multiplier) / multiplier;\\nif (value < -1000) {\\n\\tvalue = -1000;\\n} else if (value > 1000) {\\n\\tvalue = 1000;\\n}\\nreturn value;\"}]}],\"timewindow\":{\"realtime\":{\"timewindowMs\":60000}},\"showTitle\":true,\"backgroundColor\":\"#fff\",\"color\":\"rgba(0, 0, 0, 0.87)\",\"padding\":\"8px\",\"settings\":{\"shadowSize\":4,\"fontColor\":\"#545454\",\"fontSize\":10,\"xaxis\":{\"showLabels\":true,\"color\":\"#545454\"},\"yaxis\":{\"showLabels\":true,\"color\":\"#545454\"},\"grid\":{\"color\":\"#545454\",\"tickColor\":\"#DDDDDD\",\"verticalLines\":true,\"horizontalLines\":true,\"outlineWidth\":1},\"legend\":{\"show\":true,\"position\":\"nw\",\"backgroundColor\":\"#f0f0f0\",\"backgroundOpacity\":0.85,\"labelBoxBorderColor\":\"rgba(1, 1, 1, 0.45)\"},\"decimals\":1,\"stack\":false,\"tooltipIndividual\":false},\"title\":\"Timeseries - Flot\",\"dropShadow\":true,\"enableFullscreen\":true,\"titleStyle\":{\"fontSize\":\"16px\",\"fontWeight\":400},\"mobileHeight\":null}"}',
         'Timeseries - Flot' );

/** System plugins and rules **/
INSERT INTO plugin ( id, tenant_id, name, state, search_text, api_token, plugin_class, public_access, configuration )
VALUES ( '60cb2da2-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'System Telemetry Plugin', 'ACTIVE',
         'system telemetry plugin', 'telemetry',
         'org.thingsboard.server.extensions.core.plugin.telemetry.TelemetryStoragePlugin', true, '{}' );

INSERT INTO rule ( id, tenant_id, name, plugin_token, state, search_text, weight, filters, processor, action )
VALUES ( '65abad4c-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'System Telemetry Rule', 'telemetry', 'ACTIVE',
         'system telemetry rule', 0,
         '[{"clazz":"org.thingsboard.server.extensions.core.filter.MsgTypeFilter", "name":"TelemetryFilter", "configuration": {"messageTypes":["POST_TELEMETRY","POST_ATTRIBUTES","GET_ATTRIBUTES"]}}]',
         null,
         '{"clazz":"org.thingsboard.server.extensions.core.action.telemetry.TelemetryPluginAction", "name":"TelemetryMsgConverterAction", "configuration":{}}'
);

INSERT INTO plugin ( id, tenant_id, name, state, search_text, api_token, plugin_class, public_access, configuration )
VALUES ( '6b3b8994-4611-11e7-a919-92ebcb67fe33', '13814000-1dd2-11b2-8080-808080808080', 'System RPC Plugin', 'ACTIVE',
         'system rpc plugin', 'rpc', 'org.thingsboard.server.extensions.core.plugin.rpc.RpcPlugin', true, '{
       "defaultTimeout": 20000
     }' );

/** SYSTEM **/