/*
 * Copyright © 2016-2018 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export default function addLocaleSpanish(locales) {
    var es_ES = {
        "access": {
            "unauthorized": "No autorizado",
            "unauthorized-access": "Acceso no autorizado",
            "unauthorized-access-text": "Debes iniciar sesión para tener acceso a este recurso!",
            "access-forbidden": "Acceso Prohibido",
            "access-forbidden-text": "No tienes derechos para acceder a esta ubicación!<br/>Intenta iniciar sesión con otro usuario si todavía quieres acceder a esta ubicación.",
            "refresh-token-expired": "La sesión ha expirado",
            "refresh-token-failed": "No se puede actualizar la sesión"
        },
        "action": {
            "activate": "Activar",
            "suspend": "Suspender",
            "save": "Guardar",
            "saveAs": "Guardar como",
            "cancel": "Cancelar",
            "ok": "OK",
            "delete": "Borrar",
            "add": "Agregar",
            "yes": "Si",
            "no": "No",
            "update": "Actualizar",
            "remove": "Eliminar",
            "search": "Buscar",
            "assign": "Asignar",
            "unassign": "Cancelar asignación",
            "share": "Compartir",
            "make-private": "Hacer privado",
            "apply": "Aplicar",
            "apply-changes": "Aplicar cambios",
            "edit-mode": "Modo Edición",
            "enter-edit-mode": "Modo Edición",
            "decline-changes": "Descartar cambios",
            "close": "Cerrar",
            "back": "Atrás",
            "run": "Correr",
            "sign-in": "Regístrate!",
            "edit": "Editar",
            "view": "Ver",
            "create": "Crear",
            "drag": "Arrastrar",
            "refresh": "Refrescar",
            "undo": "Deshacer",
            "copy": "Copiar",
            "paste": "Pegar",
            "import": "Importar",
            "export": "Exportar",
            "share-via": "Compartir vía {{provider}}"
        },
        "aggregation": {
            "aggregation": "Agregación",
            "function": "Función de Agregación",
            "limit": "Valores Max",
            "group-interval": "Intervalo de agrupación",
            "min": "Min",
            "max": "Max",
            "avg": "Promedio",
            "sum": "Suma",
            "count": "Cuenta",
            "none": "Ninguno"
        },
        "admin": {
            "general": "General",
            "general-settings": "Ajustes General",
            "outgoing-mail": "Mail de Salida",
            "outgoing-mail-settings": "Ajustes del Mail de Salida",
            "system-settings": "Sistema",
            "test-mail-sent": "Mail de prueba enviado correctamente!",
            "base-url": "URL Base",
            "base-url-required": "URL Base requerida.",
            "mail-from": "Mail Desde",
            "mail-from-required": "Mail Desde requerido.",
            "smtp-protocol": "Protocolo SMTP",
            "smtp-host": "Host SMTP",
            "smtp-host-required": "Host SMTP requerido.",
            "smtp-port": "Puerto SMTP",
            "smtp-port-required": "Debe ingresar un Puerto SMTP.",
            "smtp-port-invalid": "No parece un Puerto SMTP valido.",
            "timeout-msec": "Timeout (ms)",
            "timeout-required": "Timeout requerido.",
            "timeout-invalid": "No parece un Timeout valido.",
            "enable-tls": "Habilitar TLS",
            "send-test-mail": "Enviar mail de prueba"
        },
        "alarm": { // TODO
            "alarm": "Alarm",
            "alarms": "Alarms",
            "select-alarm": "Select alarm",
            "no-alarms-matching": "No alarms matching '{{entity}}' were found.",
            "alarm-required": "Alarm is required",
            "alarm-status": "Alarm status",
            "search-status": {
                "ANY": "Any",
                "ACTIVE": "Active",
                "CLEARED": "Cleared",
                "ACK": "Acknowledged",
                "UNACK": "Unacknowledged"
            },
            "display-status": {
                "ACTIVE_UNACK": "Active Unacknowledged",
                "ACTIVE_ACK": "Active Acknowledged",
                "CLEARED_UNACK": "Cleared Unacknowledged",
                "CLEARED_ACK": "Cleared Acknowledged"
            },
            "no-alarms-prompt": "No alarms found",
            "created-time": "Created time",
            "type": "Type",
            "severity": "Severity",
            "originator": "Originator",
            "originator-type": "Originator type",
            "details": "Details",
            "status": "Status",
            "alarm-details": "Alarm details",
            "start-time": "Start time",
            "end-time": "End time",
            "ack-time": "Acknowledged time",
            "clear-time": "Cleared time",
            "severity-critical": "Critical",
            "severity-major": "Major",
            "severity-minor": "Minor",
            "severity-warning": "Warning",
            "severity-indeterminate": "Indeterminate",
            "acknowledge": "Acknowledge",
            "clear": "Clear",
            "search": "Search alarms",
            "selected-alarms": "{ count, select, 1 {1 alarm} other {# alarms} } selected",
            "no-data": "No data to display",
            "polling-interval": "Alarms polling interval (sec)",
            "polling-interval-required": "Alarms polling interval is required.",
            "min-polling-interval-message": "At least 1 sec polling interval is allowed.",
            "aknowledge-alarms-title": "Acknowledge { count, select, 1 {1 alarm} other {# alarms} }",
            "aknowledge-alarms-text": "Are you sure you want to acknowledge { count, select, 1 {1 alarm} other {# alarms} }?",
            "clear-alarms-title": "Clear { count, select, 1 {1 alarm} other {# alarms} }",
            "clear-alarms-text": "Are you sure you want to clear { count, select, 1 {1 alarm} other {# alarms} }?"
        },
        "alias": { // TODO
            "add": "Add alias",
            "edit": "Edit alias",
            "name": "Alias name",
            "name-required": "Alias name is required",
            "duplicate-alias": "Alias with same name is already exists.",
            "filter-type-single-entity": "Single entity",
            "filter-type-entity-list": "Entity list",
            "filter-type-entity-name": "Entity name",
            "filter-type-state-entity": "Entity from dashboard state",
            "filter-type-state-entity-description": "Entity taken from dashboard state parameters",
            "filter-type-asset-type": "Asset type",
            "filter-type-asset-type-description": "Assets of type '{{assetType}}'",
            "filter-type-asset-type-and-name-description": "Assets of type '{{assetType}}' and with name starting with '{{prefix}}'",
            "filter-type-device-type": "Device type",
            "filter-type-device-type-description": "Devices of type '{{deviceType}}'",
            "filter-type-device-type-and-name-description": "Devices of type '{{deviceType}}' and with name starting with '{{prefix}}'",
            "filter-type-relations-query": "Relations query",
            "filter-type-relations-query-description": "{{entities}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "filter-type-asset-search-query": "Asset search query",
            "filter-type-asset-search-query-description": "Assets with types {{assetTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "filter-type-device-search-query": "Device search query",
            "filter-type-device-search-query-description": "Devices with types {{deviceTypes}} that have {{relationType}} relation {{direction}} {{rootEntity}}",
            "entity-filter": "Entity filter",
            "resolve-multiple": "Resolve as multiple entities",
            "filter-type": "Filter type",
            "filter-type-required": "Filter type is required.",
            "entity-filter-no-entity-matched": "No entities matching specified filter were found.",
            "no-entity-filter-specified": "No entity filter specified",
            "root-state-entity": "Use dashboard state entity as root",
            "root-entity": "Root entity",
            "state-entity-parameter-name": "State entity parameter name",
            "default-state-entity": "Default state entity",
            "default-entity-parameter-name": "By default",
            "max-relation-level": "Max relation level",
            "unlimited-level": "Unlimited level",
            "state-entity": "Dashboard state entity",
            "all-entities": "All entities",
            "any-relation": "any"
        },
        "asset": { // TODO
            "asset": "Asset",
            "assets": "Assets",
            "management": "Asset management",
            "view-assets": "View Assets",
            "add": "Add Asset",
            "assign-to-customer": "Assign to customer",
            "assign-asset-to-customer": "Assign Asset(s) To Customer",
            "assign-asset-to-customer-text": "Please select the assets to assign to the customer",
            "no-assets-text": "No assets found",
            "assign-to-customer-text": "Please select the customer to assign the asset(s)",
            "public": "Public",
            "assignedToCustomer": "Assigned to customer",
            "make-public": "Make asset public",
            "make-private": "Make asset private",
            "unassign-from-customer": "Unassign from customer",
            "delete": "Delete asset",
            "asset-public": "Asset is public",
            "asset-type": "Asset type",
            "asset-type-required": "Asset type is required.",
            "select-asset-type": "Select asset type",
            "enter-asset-type": "Enter asset type",
            "any-asset": "Any asset",
            "no-asset-types-matching": "No asset types matching '{{entitySubtype}}' were found.",
            "asset-type-list-empty": "No asset types selected.",
            "asset-types": "Asset types",
            "name": "Name",
            "name-required": "Name is required.",
            "description": "Description",
            "type": "Type",
            "type-required": "Type is required.",
            "details": "Details",
            "events": "Events",
            "add-asset-text": "Add new asset",
            "asset-details": "Asset details",
            "assign-assets": "Assign assets",
            "assign-assets-text": "Assign { count, select, 1 {1 asset} other {# assets} } to customer",
            "delete-assets": "Delete assets",
            "unassign-assets": "Unassign assets",
            "unassign-assets-action-title": "Unassign { count, select, 1 {1 asset} other {# assets} } from customer",
            "assign-new-asset": "Assign new asset",
            "delete-asset-title": "Are you sure you want to delete the asset '{{assetName}}'?",
            "delete-asset-text": "Be careful, after the confirmation the asset and all related data will become unrecoverable.",
            "delete-assets-title": "Are you sure you want to delete { count, select, 1 {1 asset} other {# assets} }?",
            "delete-assets-action-title": "Delete { count, select, 1 {1 asset} other {# assets} }",
            "delete-assets-text": "Be careful, after the confirmation all selected assets will be removed and all related data will become unrecoverable.",
            "make-public-asset-title": "Are you sure you want to make the asset '{{assetName}}' public?",
            "make-public-asset-text": "After the confirmation the asset and all its data will be made public and accessible by others.",
            "make-private-asset-title": "Are you sure you want to make the asset '{{assetName}}' private?",
            "make-private-asset-text": "After the confirmation the asset and all its data will be made private and won't be accessible by others.",
            "unassign-asset-title": "Are you sure you want to unassign the asset '{{assetName}}'?",
            "unassign-asset-text": "After the confirmation the asset will be unassigned and won't be accessible by the customer.",
            "unassign-asset": "Unassign asset",
            "unassign-assets-title": "Are you sure you want to unassign { count, select, 1 {1 asset} other {# assets} }?",
            "unassign-assets-text": "After the confirmation all selected assets will be unassigned and won't be accessible by the customer.",
            "copyId": "Copy asset Id",
            "idCopiedMessage": "Asset Id has been copied to clipboard",
            "select-asset": "Select asset",
            "no-assets-matching": "No assets matching '{{entity}}' were found.",
            "asset-required": "Asset is required",
            "name-starts-with": "Asset name starts with"
        },
        "attribute": {
            "attributes": "Atributos",
            "latest-telemetry": "Última telemetría",
            "attributes-scope": "Alcance de los atributos del dispositivo",
            "scope-latest-telemetry": "Última telemetría",
            "scope-client": "Atributos del Cliente",
            "scope-server": "Atributos del Servidor",
            "scope-shared": "Atributos Compartidos",
            "add": "Agregar atributo",
            "key": "Clave",
            "key-required": "Clave del atributo requerida.",
            "value": "Valor",
            "value-required": "Valor del atributo requerido.",
            "delete-attributes-title": "¿Estás seguro que quieres eliminar { count, select, 1 {1 atributo} other {# atributos} }?",
            "delete-attributes-text": "Ten cuidado, luego de confirmar el atributo será eliminado, y la información relacionada será irrecuperable.",
            "delete-attributes": "Borrar atributo",
            "enter-attribute-value": "Ingresar valor del atributo",
            "show-on-widget": "Mostrar en Widget",
            "widget-mode": "Widget",
            "next-widget": "Widget siguiente",
            "prev-widget": "Widget anterior",
            "add-to-dashboard": "Agregar al Panel",
            "add-widget-to-dashboard": "Agregar widget al Panel",
            "selected-attributes": "{ count, select, 1 {1 atributo} other {# atributos} } seleccionados",
            "selected-telemetry": "{ count, select, 1 {1 unidad de telemetría } other {# unidades de telemetría} } seleccionadas."
        },
        "audit-log": { // TODO
            "audit": "Audit",
            "audit-logs": "Audit Logs",
            "timestamp": "Timestamp",
            "entity-type": "Entity Type",
            "entity-name": "Entity Name",
            "user": "User",
            "type": "Type",
            "status": "Status",
            "details": "Details",
            "type-added": "Added",
            "type-deleted": "Deleted",
            "type-updated": "Updated",
            "type-attributes-updated": "Attributes updated",
            "type-attributes-deleted": "Attributes deleted",
            "type-rpc-call": "RPC call",
            "type-credentials-updated": "Credentials updated",
            "type-assigned-to-customer": "Assigned to Customer",
            "type-unassigned-from-customer": "Unassigned from Customer",
            "type-activated": "Activated",
            "type-suspended": "Suspended",
            "type-credentials-read": "Credentials read",
            "type-attributes-read": "Attributes read",
            "status-success": "Success",
            "status-failure": "Failure",
            "audit-log-details": "Audit log details",
            "no-audit-logs-prompt": "No logs found",
            "action-data": "Action data",
            "failure-details": "Failure details",
            "search": "Search audit logs",
            "clear-search": "Clear search"
        },
        "confirm-on-exit": {
            "message": "Tienes cambios sin guardar. ¿Estás seguro que quieres abandonar la página?",
            "html-message": "Tienes cambios sin guardar.<br/>¿Estás seguro que quieres abandonar la página?",
            "title": "Cambios sin guardar"
        },
        "contact": {
            "country": "País",
            "city": "Ciudad",
            "state": "Estado/Provincia",
            "postal-code": "Código Postal",
            "postal-code-invalid": "Solo se permiten dígitos.",
            "address": "Dirección",
            "address2": "Dirección 2",
            "phone": "Teléfono",
            "email": "Email",
            "no-address": "Sin Dirección"
        },
        "common": {
            "username": "Usuario",
            "password": "Contraseña",
            "enter-username": "Ingresa el nombre de usuario.",
            "enter-password": "Ingresa la contraseña",
            "enter-search": "Ingresa búsqueda"
        },
        "content-type": { // TODO
            "json": "Json",
            "text": "Text",
            "binary": "Binary (Base64)"
        },
        "customer": {
            "customers": "Clientes",
            "management": "Gestión de Clientes",
            "dashboard": "Panel del Cliente",
            "dashboards": "Paneles del Cliente",
            "devices": "Panel del Cliente",
            "public-dashboards": "Paneles Públicos",
            "public-devices": "Dispositivos Públicos",
            "add": "Agregar cliente",
            "delete": "Borrar cliente",
            "manage-customer-users": "Gestionar usuarios del cliente",
            "manage-customer-devices": "Gestionar dispositivos del cliente",
            "manage-customer-dashboards": "Gestionar paneles del cliente",
            "manage-public-devices": "Gestionar dispositivos públicos",
            "manage-public-dashboards": "Gestionar paneles públicos",
            "add-customer-text": "Agregar nuevo cliente",
            "no-customers-text": "No se encontrar clientes",
            "customer-details": "Detalles del cliente",
            "delete-customer-title": "¿Estás seguro que quieres eliminar el cliente '{{customerTitle}}'?",
            "delete-customer-text": "Ten cuidado, luego de confirmar el cliente será eliminado y toda la información relacionada será irrecuperable.",
            "delete-customers-title": "¿Estás seguro que quieres eliminar { count, select, 1 {1 cliente} other {# clientes} }?",
            "delete-customers-action-title": "Borrar { count, select, 1 {1 cliente} other {# clientes} }",
            "delete-customers-text": "Ten cuidado, luego de confirmar todos los clientes seleccionados serán eliminados y su información relacionada será irrecuperable.",
            "manage-users": "Gestionar usuarios",
            "manage-devices": "Gestionar dispositivos",
            "manage-dashboards": "Gestionar paneles",
            "title": "Título",
            "title-required": "Título requerido.",
            "description": "Descripción"
        },
        "datetime": {
            "date-from": "Fecha desde",
            "time-from": "Tiempo desde",
            "date-to": "Fecha hasta",
            "time-to": "Tiempo hasta"
        },
        "dashboard": {
            "dashboard": "Panel",
            "dashboards": "Paneles",
            "management": "Gestión de Paneles",
            "view-dashboards": "Ver paneles",
            "add": "Agregar Panel",
            "assign-dashboard-to-customer": "Asignar panel(es) a cliente",
            "assign-dashboard-to-customer-text": "Por favor, seleccione algún panel para asignar al Cliente.",
            "assign-to-customer-text": "Por favor, seleccione algún cliente para asignar al(los) panel(es).",
            "assign-to-customer": "Asignar a cliente",
            "unassign-from-customer": "Desasignar del cliente",
            "make-public": "Hacer panel público",
            "make-private": "Hacer panel privado",
            "no-dashboards-text": "Ningún panel encontrado",
            "no-widgets": "Ningún widget configurado",
            "add-widget": "Agregar nuevo widget",
            "title": "Titulo",
            "select-widget-title": "Seleccionar widget",
            "select-widget-subtitle": "Lista de tipos de widgets",
            "delete": "Eliminar panel",
            "title-required": "Título requerido.",
            "description": "Descripción",
            "details": "Detalles",
            "dashboard-details": "Detalles del panel",
            "add-dashboard-text": "Agregar nuevo panel",
            "assign-dashboards": "Asignar paneles",
            "assign-new-dashboard": "Asignar nuevo panel",
            "assign-dashboards-text": "Asignar { count, select, 1 {1 panel} other {# paneles} } al cliente",
            "delete-dashboards": "Eliminar paneles",
            "unassign-dashboards": "Desasignar paneles",
            "unassign-dashboards-action-title": "Desasignar { count, select, 1 {1 paneles} other {# paneles} } del cliente",
            "delete-dashboard-title": "¿Estás seguro que quieres eliminar el panel '{{dashboardTitle}}'?",
            "delete-dashboard-text": "Ten cuidado, el panel seleccionado será eliminado y la información relacionada sera irrecuperable.",
            "delete-dashboards-title": "¿Estás seguro que quieres eliminar { count, select, 1 {1 panel} other {# paneles} }?",
            "delete-dashboards-action-title": "Eliminar { count, select, 1 {1 panel} other {# paneles} }",
            "delete-dashboards-text": "Ten cuidado, los paneles seleccionados serán eliminados y la información relacionada será irrecuperable.",
            "unassign-dashboard-title": "¿Estás seguro que quieres desasignar el panel '{{dashboardTitle}}'?",
            "unassign-dashboard-text": "Luego de confirmar, el panel será desasignado y no podrá ser accesible por el cliente.",
            "unassign-dashboard": "Desasignar panel",
            "unassign-dashboards-title": "¿Estás seguro que quieres desasignar { count, select, 1 {1 panel} other {# paneles} }?",
            "unassign-dashboards-text": "Luego de confirmar, los paneles seleccionados serán desasignados y no podrán ser accesibles por el cliente.",
            "public-dashboard-title": "El panel ahora es público",
            "public-dashboard-text": "Tu panel <b>{{dashboardTitle}}</b> es ahora público y podrá ser accedido desde: <a href='{{publicLink}}' target='_blank'>aquí</a>:",
            "public-dashboard-notice": "<b>Nota:</b>  No olvides hacer públicos los dispositivos relacionados para acceder a sus datos.",
            "make-private-dashboard-title": "¿Estás seguro que quieres hacer el panel '{{dashboardTitle}}' privado?",
            "make-private-dashboard-text": "Luego de confirmar, el panel será privado y no podrá ser accesible por otros.",
            "make-private-dashboard": "Hacer panel privado",
            "socialshare-text": "'{{dashboardTitle}}' powered by ThingsBoard",
            "socialshare-title": "'{{dashboardTitle}}' powered by ThingsBoard",
            "select-dashboard": "Seleccionar panel",
            "no-dashboards-matching": "Panel '{{entity}}' no encontrado.",
            "dashboard-required": "Panel requerido.",
            "select-existing": "Seleccionar paneles existentes",
            "create-new": "Crear nuevo panel",
            "new-dashboard-title": "Nuevo título",
            "open-dashboard": "Abrir panel",
            "set-background": "Definir fondo",
            "background-color": "Color de fondo",
            "background-image": "Imagen de fondo",
            "background-size-mode": "Modo tamaño de fondo",
            "no-image": "No se ha seleccionado ningúna imagen",
            "drop-image": "Suelte una imagen o haga clic para seleccionar un archivo para cargar.",
            "settings": "Ajustes",
            "columns-count": "Número de columnas",
            "columns-count-required": "Número de columnas requerido.",
            "min-columns-count-message": "Solo se permite un número mínimo de 10 columnas.",
            "max-columns-count-message": "Solo se permite un número máximo de 1000 columnas.",
            "widgets-margins": "Margen entre widgets",
            "horizontal-margin": "Margen horizontal",
            "horizontal-margin-required": "Margen horizontal requerido.",
            "min-horizontal-margin-message": "Solo se permite margen horizontal mínimo de 0.",
            "max-horizontal-margin-message": "Solo se permite margen horizontal máximo de 50.",
            "vertical-margin": "Margen vertical",
            "vertical-margin-required": "Margen vertical requerido.",
            "min-vertical-margin-message": "Solo se permite margen vertical mínimo de 0.",
            "max-vertical-margin-message": "Solo se permite margen vertical máximo de 50.",
            "display-title": "Mostrar título del panel",
            "title-color": "Color del título",
            "display-device-selection": "Mostrar selección de dispositivo",
            "display-dashboard-timewindow": "Mostrar ventana de tiempo",
            "display-dashboard-export": "Mostrar exportar",
            "import": "Importar panel",
            "export": "Exportar panel",
            "export-failed-error": "Imposible exportar panel: {{error}}",
            "create-new-dashboard": "Crear nuevo panel",
            "dashboard-file": "Archivo del panel",
            "invalid-dashboard-file-error": "Imposible importar panel: Estructura de datos inválida.",
            "dashboard-import-missing-aliases-title": "Configurar alias utilizados por el panel importado",
            "create-new-widget": "Crear nuevo widget",
            "import-widget": "Importar widget",
            "widget-file": "Archivo de widget",
            "invalid-widget-file-error": "Imposible importar widget: Estructura de datos inválida.",
            "widget-import-missing-aliases-title": "Configurar alias utilizados por el widget",
            "open-toolbar": "Abrir toolbar del panel",
            "close-toolbar": "Cerrar toolbar",
            "configuration-error": "Error de configuración",
            "alias-resolution-error-title": "Error de configuración de alias del panel",
            "invalid-aliases-config": "No se puede encontrar ningún dispositivo que coincida con algunos de los alias de filtro.<br/>" +
                "Póngase en contacto con su administrador para resolver este problema.",
            "select-devices": "Seleccionar dispositivos",
            "assignedToCustomer": "Asignado al cliente",
            "public": "Público",
            "public-link": "Link público",
            "copy-public-link": "Copiar link público",
            "public-link-copied-message": "El link público del panel se ha copiado al portapapeles"
        },
        "datakey": {
            "settings": "Ajustes",
            "advanced": "Avanzado",
            "label": "Etiqueta",
            "color": "Color",
            "data-generation-func": "Función de generación de datos",
            "use-data-post-processing-func": "Usar funcíon de post-procesamiendo de datos",
            "configuration": "Ajustes de clave de datos",
            "timeseries": "Serie de tiempos",
            "attributes": "Atributos",
            "timeseries-required": "Series de tiempo del dispositivo requerido.",
            "timeseries-or-attributes-required": "Series de tiempo/Atributos requeridos.",
            "function-types": "Tipos de funciones",
            "function-types-required": "Tipos de funciones requerido."
        },
        "datasource": {
            "type": "Típo de fuente de datos",
            "add-datasource-prompt": "Por favor, agrega una fuente de datos"
        },
        "details": {
            "edit-mode": "Modo Edición",
            "toggle-edit-mode": "Ir a Modo Edición"
        },
        "device": {
            "device": "Dispositivo",
            "device-required": "Dispositivo requerido.",
            "devices": "Dispositivos",
            "management": "Gestión de Dispositivos",
            "view-devices": "Ver dispositivos",
            "device-alias": "Alias de dispositivo",
            "aliases": "Alias de dispositivos",
            "no-alias-matching": "'{{alias}}' no encontrado.",
            "no-aliases-found": "Ningún alias encontrado.",
            "no-key-matching": "'{{key}}' no encontrado.",
            "no-keys-found": "Ninguna clave encontrada.",
            "create-new-alias": "Crear nuevo alias!",
            "create-new-key": "Crear nueva clave!",
            "duplicate-alias-error": "Alias duplicado '{{alias}}'.<br> El alias de los dispositivos deben ser únicos dentro del panel.",
            "configure-alias": "Configurar alias '{{alias}}'",
            "no-devices-matching": "No se encontró dispositivo '{{entity}}'",
            "alias": "Alias",
            "alias-required": "Alias de dispositivo requerido.",
            "remove-alias": "Eliminar alias",
            "add-alias": "Agregar alias",
            "name-starts-with": "Nombre empieza con",
            "device-list": "Lista de dispositivos",
            "use-device-name-filter": "Usar filtro",
            "device-list-empty": "Ningún dispositivo seleccionado.",
            "device-name-filter-required": "Nombre de filtro requerido.",
            "device-name-filter-no-device-matched": "Ningún dispositivo encontrado que comience con '{{device}}'.",
            "add": "Agregar dispositivo",
            "assign-to-customer": "Asignar a cliente",
            "assign-device-to-customer": "Asignar dispositivo(s) a Cliente",
            "assign-device-to-customer-text": "Por favor, seleccione los dispositivos que serán asignados al cliente",
            "make-public": "Hacer dispositivo público",
            "make-private": "Hacer dispositivo privado",
            "no-devices-text": "Ningún dispositivo encontrado",
            "assign-to-customer-text": "Por favor, seleccione el cliente para asignar el(los) dispositivo(s)",
            "device-details": "Detalles del dispositivo",
            "add-device-text": "Agregar nuevo dispositivo",
            "credentials": "Credenciales",
            "manage-credentials": "Gestionar credenciales",
            "delete": "Eliminar dispositivo",
            "assign-devices": "Asignar dispositivo",
            "assign-devices-text": "Asignar { count, select, 1 {1 dispositivo} other {# dispositivos} } al cliente",
            "delete-devices": "Eliminar dispositivo",
            "unassign-from-customer": "Desasignar del cliente",
            "unassign-devices": "Desasignar dispositivos",
            "unassign-devices-action-title": "Desasignar { count, select, 1 {1 dispositivo} other {# dispositivos} } del cliente",
            "assign-new-device": "Asignar nuevo dispositivo",
            "make-public-device-title": "¿Estás seguro que quieres hacer el dispositivo '{{deviceName}}' público?",
            "make-public-device-text": "Luego de confirmar, el dispositivo y la información relacionada serán públicos y podrá ser accesible por otros.",
            "make-private-device-title": "¿Estás seguro que quieres hacer el dispositivo '{{deviceName}}' privado?",
            "make-private-device-text": "Luego de confirmar, el dispositivo y la información relacionada serán privados y no podrá ser accesible por otros.",
            "view-credentials": "Ver credenciales",
            "delete-device-title": "¿Estás seguro que quieres eliminar el dispositivo '{{deviceName}}'?",
            "delete-device-text": "Ten cuidado, luego de confirmar los dispositivos serán eliminados y la información relacionada será irrecuperable.",
            "delete-devices-title": "¿Estás seguro que quieres eliminar { count, select, 1 {1 dispositivo} other {# dispositivos} }?",
            "delete-devices-action-title": "Eliminar { count, select, 1 {1 dispositivo} other {# dispositivos} }",
            "delete-devices-text": "Ten cuidado, luego de confirmar los dispositivos seleccionados serán eliminados y la información relacionada será irrecuperable.",
            "unassign-device-title": "¿Estás seguro que quieres desasignar el dispositivo '{{deviceName}}'?",
            "unassign-device-text": "Luego de confirmar el dispositivo será desasignado y no podrá ser accesible por el cliente.",
            "unassign-device": "Desasignar dispositivo",
            "unassign-devices-title": "¿Estás seguro que quieres desasignar { count, select, 1 {1 dispositivo} other {# dispositivos} }?",
            "unassign-devices-text": "Luego de confirmar los dispositivos seleccionados serán desasignados y no podrán ser accedidos por el cliente.",
            "device-credentials": "Credenciales del dispositivo",
            "credentials-type": "Tipo de credencial",
            "access-token": "Access token",
            "access-token-required": "Access token requerido.",
            "access-token-invalid": "Access token debe tener entre 1 a 20 caracteres.",
            "rsa-key": "Clave pública RSA",
            "rsa-key-required": "Clave pública RSA requerida.",
            "secret": "Secreta",
            "secret-required": "Secreta requerida.",
            "name": "Nombre",
            "name-required": "Nombre requerido.",
            "description": "Descripción",
            "events": "Eventos",
            "details": "Detalles",
            "copyId": "Copiar ID",
            "copyAccessToken": "Copiar access token",
            "idCopiedMessage": "Id del dispositivo copiado al portapapeles",
            "accessTokenCopiedMessage": "Access token del dispositivo copiado al portapapeles",
            "assignedToCustomer": "Asignado al cliente",
            "unable-delete-device-alias-title": "Imposible eliminar alias del dispositivo",
            "unable-delete-device-alias-text": "Alias '{{deviceAlias}}' no puede ser eliminado. Esta siendo usado por el(los) widget(s):<br/>{{widgetsList}}",
            "is-gateway": "Es gateway",
            "public": "Público",
            "device-public": "Dispositivo público"
        },
        "dialog": {
            "close": "Cerrar cuadro de diálogo"
        },
        "error": {
            "unable-to-connect": "Imposible conectar con el servidor! Por favor, revise su conexión a internet.",
            "unhandled-error-code": "Código de error no manejado: {{errorCode}}",
            "unknown-error": "Error desconocido"
        },
        "entity": { // TODO
            "entity": "Entity",
            "entities": "Entities",
            "aliases": "Entity aliases",
            "entity-alias": "Entity alias",
            "unable-delete-entity-alias-title": "Unable to delete entity alias",
            "unable-delete-entity-alias-text": "Entity alias '{{entityAlias}}' can't be deleted as it used by the following widget(s):<br/>{{widgetsList}}",
            "duplicate-alias-error": "Duplicate alias found '{{alias}}'.<br>Entity aliases must be unique whithin the dashboard.",
            "missing-entity-filter-error": "Filter is missing for alias '{{alias}}'.",
            "configure-alias": "Configure '{{alias}}' alias",
            "alias": "Alias",
            "alias-required": "Entity alias is required.",
            "remove-alias": "Remove entity alias",
            "add-alias": "Add entity alias",
            "entity-list": "Entity list",
            "entity-type": "Entity type",
            "entity-types": "Entity types",
            "entity-type-list": "Entity type list",
            "any-entity": "Any entity",
            "enter-entity-type": "Enter entity type",
            "no-entities-matching": "No entities matching '{{entity}}' were found.",
            "no-entity-types-matching": "No entity types matching '{{entityType}}' were found.",
            "name-starts-with": "Name starts with",
            "use-entity-name-filter": "Use filter",
            "entity-list-empty": "No entities selected.",
            "entity-type-list-empty": "No entity types selected.",
            "entity-name-filter-required": "Entity name filter is required.",
            "entity-name-filter-no-entity-matched": "No entities starting with '{{entity}}' were found.",
            "all-subtypes": "All",
            "select-entities": "Select entities",
            "no-aliases-found": "No aliases found.",
            "no-alias-matching": "'{{alias}}' not found.",
            "create-new-alias": "Create a new one!",
            "key": "Key",
            "key-name": "Key name",
            "no-keys-found": "No keys found.",
            "no-key-matching": "'{{key}}' not found.",
            "create-new-key": "Create a new one!",
            "type": "Type",
            "type-required": "Entity type is required.",
            "type-device": "Device",
            "type-devices": "Devices",
            "list-of-devices": "{ count, select, 1 {One device} other {List of # devices} }",
            "device-name-starts-with": "Devices whose names start with '{{prefix}}'",
            "type-asset": "Asset",
            "type-assets": "Assets",
            "list-of-assets": "{ count, select, 1 {One asset} other {List of # assets} }",
            "asset-name-starts-with": "Assets whose names start with '{{prefix}}'",
            "type-rule": "Rule",
            "type-rules": "Rules",
            "list-of-rules": "{ count, select, 1 {One rule} other {List of # rules} }",
            "rule-name-starts-with": "Rules whose names start with '{{prefix}}'",
            "type-plugin": "Plugin",
            "type-plugins": "Plugins",
            "list-of-plugins": "{ count, select, 1 {One plugin} other {List of # plugins} }",
            "plugin-name-starts-with": "Plugins whose names start with '{{prefix}}'",
            "type-tenant": "Tenant",
            "type-tenants": "Tenants",
            "list-of-tenants": "{ count, select, 1 {One tenant} other {List of # tenants} }",
            "tenant-name-starts-with": "Tenants whose names start with '{{prefix}}'",
            "type-customer": "Customer",
            "type-customers": "Customers",
            "list-of-customers": "{ count, select, 1 {One customer} other {List of # customers} }",
            "customer-name-starts-with": "Customers whose names start with '{{prefix}}'",
            "type-user": "User",
            "type-users": "Users",
            "list-of-users": "{ count, select, 1 {One user} other {List of # users} }",
            "user-name-starts-with": "Users whose names start with '{{prefix}}'",
            "type-dashboard": "Dashboard",
            "type-dashboards": "Dashboards",
            "list-of-dashboards": "{ count, select, 1 {One dashboard} other {List of # dashboards} }",
            "dashboard-name-starts-with": "Dashboards whose names start with '{{prefix}}'",
            "type-alarm": "Alarm",
            "type-alarms": "Alarms",
            "list-of-alarms": "{ count, select, 1 {One alarms} other {List of # alarms} }",
            "alarm-name-starts-with": "Alarms whose names start with '{{prefix}}'",
            "type-rulechain": "Rule chain",
            "type-rulechains": "Rule chains",
            "list-of-rulechains": "{ count, select, 1 {One rule chain} other {List of # rule chains} }",
            "rulechain-name-starts-with": "Rule chains whose names start with '{{prefix}}'",
            "type-current-customer": "Current Customer",
            "search": "Search entities",
            "selected-entities": "{ count, select, 1 {1 entity} other {# entities} } selected",
            "entity-name": "Entity name",
            "details": "Entity details",
            "no-entities-prompt": "No entities found",
            "no-data": "No data to display"
        },
        "event": {
            "event-type": "Tipo de evento",
            "type-error": "Error",
            "type-lc-event": "Ciclo de vida",
            "type-stats": "Estadísticas",
            "no-events-prompt": "Ningún evento encontrado.",
            "error": "Error",
            "alarm": "Alarma",
            "event-time": "Hora del evento",
            "server": "Servidor",
            "body": "Cuerpo",
            "method": "Método",
            "event": "Evento",
            "status": "Status",
            "success": "Éxito",
            "failed": "Fallo",
            "messages-processed": "Mensajes procesados",
            "errors-occurred": "Ocurrieron errores"
        },
        "extension": { // TODO
            "extensions": "Extensions",
            "selected-extensions": "{ count, select, 1 {1 extension} other {# extensions} } selected",
            "type": "Type",
            "key": "Key",
            "value": "Value",
            "id": "Id",
            "extension-id": "Extension id",
            "extension-type": "Extension type",
            "transformer-json": "JSON *",
            "unique-id-required": "Current extension id already exists.",
            "delete": "Delete extension",
            "add": "Add extension",
            "edit": "Edit extension",
            "delete-extension-title": "Are you sure you want to delete the extension '{{extensionId}}'?",
            "delete-extension-text": "Be careful, after the confirmation the extension and all related data will become unrecoverable.",
            "delete-extensions-title": "Are you sure you want to delete { count, select, 1 {1 extension} other {# extensions} }?",
            "delete-extensions-text": "Be careful, after the confirmation all selected extensions will be removed.",
            "converters": "Converters",
            "converter-id": "Converter id",
            "configuration": "Configuration",
            "converter-configurations": "Converter configurations",
            "token": "Security token",
            "add-converter": "Add converter",
            "add-config": "Add converter configuration",
            "device-name-expression": "Device name expression",
            "device-type-expression": "Device type expression",
            "custom": "Custom",
            "to-double": "To Double",
            "transformer": "Transformer",
            "json-required": "Transformer json is required.",
            "json-parse": "Unable to parse transformer json.",
            "attributes": "Attributes",
            "add-attribute": "Add attribute",
            "add-map": "Add mapping element",
            "timeseries": "Timeseries",
            "add-timeseries": "Add timeseries",
            "field-required": "Field is required",
            "brokers": "Brokers",
            "add-broker": "Add broker",
            "host": "Host",
            "port": "Port",
            "port-range": "Port should be in a range from 1 to 65535.",
            "ssl": "Ssl",
            "credentials": "Credentials",
            "username": "Username",
            "password": "Password",
            "retry-interval": "Retry interval in milliseconds",
            "anonymous": "Anonymous",
            "basic": "Basic",
            "pem": "PEM",
            "ca-cert": "CA certificate file *",
            "private-key": "Private key file *",
            "cert": "Certificate file *",
            "no-file": "No file selected.",
            "drop-file": "Drop a file or click to select a file to upload.",
            "mapping": "Mapping",
            "topic-filter": "Topic filter",
            "converter-type": "Converter type",
            "converter-json": "Json",
            "json-name-expression": "Device name json expression",
            "topic-name-expression": "Device name topic expression",
            "json-type-expression": "Device type json expression",
            "topic-type-expression": "Device type topic expression",
            "attribute-key-expression": "Attribute key expression",
            "attr-json-key-expression": "Attribute key json expression",
            "attr-topic-key-expression": "Attribute key topic expression",
            "request-id-expression": "Request id expression",
            "request-id-json-expression": "Request id json expression",
            "request-id-topic-expression": "Request id topic expression",
            "response-topic-expression": "Response topic expression",
            "value-expression": "Value expression",
            "topic": "Topic",
            "timeout": "Timeout in milliseconds",
            "converter-json-required": "Converter json is required.",
            "converter-json-parse": "Unable to parse converter json.",
            "filter-expression": "Filter expression",
            "connect-requests": "Connect requests",
            "add-connect-request": "Add connect request",
            "disconnect-requests": "Disconnect requests",
            "add-disconnect-request": "Add disconnect request",
            "attribute-requests": "Attribute requests",
            "add-attribute-request": "Add attribute request",
            "attribute-updates": "Attribute updates",
            "add-attribute-update": "Add attribute update",
            "server-side-rpc": "Server side RPC",
            "add-server-side-rpc-request": "Add server-side RPC request",
            "device-name-filter": "Device name filter",
            "attribute-filter": "Attribute filter",
            "method-filter": "Method filter",
            "request-topic-expression": "Request topic expression",
            "response-timeout": "Response timeout in milliseconds",
            "topic-expression": "Topic expression",
            "client-scope": "Client scope",
            "add-device": "Add device",
            "opc-server": "Servers",
            "opc-add-server": "Add server",
            "opc-add-server-prompt": "Please add server",
            "opc-application-name": "Application name",
            "opc-application-uri": "Application uri",
            "opc-scan-period-in-seconds": "Scan period in seconds",
            "opc-security": "Security",
            "opc-identity": "Identity",
            "opc-keystore": "Keystore",
            "opc-type": "Type",
            "opc-keystore-type": "Type",
            "opc-keystore-location": "Location *",
            "opc-keystore-password": "Password",
            "opc-keystore-alias": "Alias",
            "opc-keystore-key-password": "Key password",
            "opc-device-node-pattern": "Device node pattern",
            "opc-device-name-pattern": "Device name pattern",
            "modbus-server": "Servers/slaves",
            "modbus-add-server": "Add server/slave",
            "modbus-add-server-prompt": "Please add server/slave",
            "modbus-transport": "Transport",
            "modbus-port-name": "Serial port name",
            "modbus-encoding": "Encoding",
            "modbus-parity": "Parity",
            "modbus-baudrate": "Baud rate",
            "modbus-databits": "Data bits",
            "modbus-stopbits": "Stop bits",
            "modbus-databits-range": "Data bits should be in a range from 7 to 8.",
            "modbus-stopbits-range": "Stop bits should be in a range from 1 to 2.",
            "modbus-unit-id": "Unit ID",
            "modbus-unit-id-range": "Unit ID should be in a range from 1 to 247.",
            "modbus-device-name": "Device name",
            "modbus-poll-period": "Poll period (ms)",
            "modbus-attributes-poll-period": "Attributes poll period (ms)",
            "modbus-timeseries-poll-period": "Timeseries poll period (ms)",
            "modbus-poll-period-range": "Poll period should be positive value.",
            "modbus-tag": "Tag",
            "modbus-function": "Function",
            "modbus-register-address": "Register address",
            "modbus-register-address-range": "Register address should be in a range from 0 to 65535.",
            "modbus-register-bit-index": "Bit index",
            "modbus-register-bit-index-range": "Bit index should be in a range from 0 to 15.",
            "modbus-register-count": "Register count",
            "modbus-register-count-range": "Register count should be a positive value.",
            "modbus-byte-order": "Byte order",

            "sync": {
                "status": "Status",
                "sync": "Sync",
                "not-sync": "Not sync",
                "last-sync-time": "Last sync time",
                "not-available": "Not available"
            },

            "export-extensions-configuration": "Export extensions configuration",
            "import-extensions-configuration": "Import extensions configuration",
            "import-extensions": "Import extensions",
            "import-extension": "Import extension",
            "export-extension": "Export extension",
            "file": "Extensions file",
            "invalid-file-error": "Invalid extension file"
        },
        "fullscreen": {
            "expand": "Expandir a Pantalla Completa",
            "exit": "Salir de Pantalla Completa",
            "toggle": "Cambiar el modo de Pantalla Completa",
            "fullscreen": "Pantalla Completa"
        },
        "function": {
            "function": "Función"
        },
        "grid": {
            "delete-item-title": "¿Estás seguro que quieres eliminar este item?",
            "delete-item-text": "Ten cuidado, luego de confirmar el item será eliminado y la información relacionada será irrecuperable.",
            "delete-items-title": "¿Estás seguro que quieres eliminar { count, select, 1 {1 item} other {# items} }?",
            "delete-items-action-title": "Eliminar { count, select, 1 {1 item} other {# items} }",
            "delete-items-text": "Ten cuidado, luego de confirmar los items seleccionados serán eliminados y la información relacionada será irrecuperable.",
            "add-item-text": "Agregar nuevo item",
            "no-items-text": "Ningún item encontrado",
            "item-details": "Detalles del item",
            "delete-item": "Borrar Item",
            "delete-items": "Borrar Items",
            "scroll-to-top": "Ir hacia arriba"
        },
        "help": {
            "goto-help-page": "Ir a Página de Ayuda"
        },
        "home": {
            "home": "Principal",
            "profile": "Perfil",
            "logout": "Salir",
            "menu": "Menu",
            "avatar": "Avatar",
            "open-user-menu": "Abrir menú de usuario"
        },
        "import": {
            "no-file": "Ningún archivo seleccionado",
            "drop-file": "Arrastra un archivo JSON o clickea para seleccionar uno."
        },
        "item": {
            "selected": "Seleccionado"
        },
        "js-func": {
            "no-return-error": "La función debe retornar un valor!",
            "return-type-mismatch": "La función debe retornar un valor de tipo: '{{type}}'!"
        },
        "key-val": { // TODO
            "key": "Key",
            "value": "Value",
            "remove-entry": "Remove entry",
            "add-entry": "Add entry",
            "no-data": "No entries"
        },
        "layout": { // TODO
            "layout": "Layout",
            "manage": "Manage layouts",
            "settings": "Layout settings",
            "color": "Color",
            "main": "Main",
            "right": "Right",
            "select": "Select target layout"
        },
        "legend": {
            "position": "Posición de leyenda",
            "show-max": "Mostrar máximo",
            "show-min": "Mostrar mínimo",
            "show-avg": "Mostrar promedio",
            "show-total": "Mostrar total",
            "settings": "Ajustes de leyenda.",
            "min": "min",
            "max": "max",
            "avg": "prom",
            "total": "total"
        },
        "login": {
            "login": "Ingresar",
            "request-password-reset": "Pedir restablecer contraseña",
            "reset-password": "Restablecer contraseña",
            "create-password": "Crear contraseña",
            "passwords-mismatch-error": "Las contraseñas deben ser las mismas!",
            "password-again": "Reingresa la contraseña",
            "sign-in": "Iniciar sesión",
            "username": "Usuario (email)",
            "remember-me": "Recordar",
            "forgot-password": "¿Olvidaste tu contraseña?",
            "password-reset": "Restablecer Contraseña",
            "new-password": "Nueva contraseña",
            "new-password-again": "Repita la nueva contraseña",
            "password-link-sent-message": "Se ha enviado el enlace de restablecimiento de contraseña con éxito!",
            "email": "Email"
        },
        "position": {
            "top": "Arriba",
            "bottom": "Abajo",
            "left": "Izquierda",
            "right": "Derecha"
        },
        "profile": {
            "profile": "Perfil",
            "change-password": "Cambiar contraseña",
            "current-password": "Contraseña actual"
        },
        "relation": { // TODO
            "relations": "Relations",
            "direction": "Direction",
            "search-direction": {
                "FROM": "From",
                "TO": "To"
            },
            "direction-type": {
                "FROM": "from",
                "TO": "to"
            },
            "from-relations": "Outbound relations",
            "to-relations": "Inbound relations",
            "selected-relations": "{ count, select, 1 {1 relation} other {# relations} } selected",
            "type": "Type",
            "to-entity-type": "To entity type",
            "to-entity-name": "To entity name",
            "from-entity-type": "From entity type",
            "from-entity-name": "From entity name",
            "to-entity": "To entity",
            "from-entity": "From entity",
            "delete": "Delete relation",
            "relation-type": "Relation type",
            "relation-type-required": "Relation type is required.",
            "any-relation-type": "Any type",
            "add": "Add relation",
            "edit": "Edit relation",
            "delete-to-relation-title": "Are you sure you want to delete relation to the entity '{{entityName}}'?",
            "delete-to-relation-text": "Be careful, after the confirmation the entity '{{entityName}}' will be unrelated from the current entity.",
            "delete-to-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
            "delete-to-relations-text": "Be careful, after the confirmation all selected relations will be removed and corresponding entities will be unrelated from the current entity.",
            "delete-from-relation-title": "Are you sure you want to delete relation from the entity '{{entityName}}'?",
            "delete-from-relation-text": "Be careful, after the confirmation current entity will be unrelated from the entity '{{entityName}}'.",
            "delete-from-relations-title": "Are you sure you want to delete { count, select, 1 {1 relation} other {# relations} }?",
            "delete-from-relations-text": "Be careful, after the confirmation all selected relations will be removed and current entity will be unrelated from the corresponding entities.",
            "remove-relation-filter": "Remove relation filter",
            "add-relation-filter": "Add relation filter",
            "any-relation": "Any relation",
            "relation-filters": "Relation filters",
            "additional-info": "Additional info (JSON)",
            "invalid-additional-info": "Unable to parse additional info json."
        },
        "rulechain": { // TODO
            "rulechain": "Rule chain",
            "rulechains": "Rule chains",
            "root": "Root",
            "delete": "Delete rule chain",
            "name": "Name",
            "name-required": "Name is required.",
            "description": "Description",
            "add": "Add Rule Chain",
            "set-root": "Make rule chain root",
            "set-root-rulechain-title": "Are you sure you want to make the rule chain '{{ruleChainName}}' root?",
            "set-root-rulechain-text": "After the confirmation the rule chain will become root and will handle all incoming transport messages.",
            "delete-rulechain-title": "Are you sure you want to delete the rule chain '{{ruleChainName}}'?",
            "delete-rulechain-text": "Be careful, after the confirmation the rule chain and all related data will become unrecoverable.",
            "delete-rulechains-title": "Are you sure you want to delete { count, select, 1 {1 rule chain} other {# rule chains} }?",
            "delete-rulechains-action-title": "Delete { count, select, 1 {1 rule chain} other {# rule chains} }",
            "delete-rulechains-text": "Be careful, after the confirmation all selected rule chains will be removed and all related data will become unrecoverable.",
            "add-rulechain-text": "Add new rule chain",
            "no-rulechains-text": "No rule chains found",
            "rulechain-details": "Rule chain details",
            "details": "Details",
            "events": "Events",
            "system": "System",
            "import": "Import rule chain",
            "export": "Export rule chain",
            "export-failed-error": "Unable to export rule chain: {{error}}",
            "create-new-rulechain": "Create new rule chain",
            "rulechain-file": "Rule chain file",
            "invalid-rulechain-file-error": "Unable to import rule chain: Invalid rule chain data structure.",
            "copyId": "Copy rule chain Id",
            "idCopiedMessage": "Rule chain Id has been copied to clipboard",
            "select-rulechain": "Select rule chain",
            "no-rulechains-matching": "No rule chains matching '{{entity}}' were found.",
            "rulechain-required": "Rule chain is required",
            "management": "Rules management",
            "debug-mode": "Debug mode"
        },
        "rulenode": { // TODO
            "details": "Details",
            "events": "Events",
            "search": "Search nodes",
            "open-node-library": "Open node library",
            "add": "Add rule node",
            "name": "Name",
            "name-required": "Name is required.",
            "type": "Type",
            "description": "Description",
            "delete": "Delete rule node",
            "select-all-objects": "Select all nodes and connections",
            "deselect-all-objects": "Deselect all nodes and connections",
            "delete-selected-objects": "Delete selected nodes and connections",
            "delete-selected": "Delete selected",
            "select-all": "Select all",
            "copy-selected": "Copy selected",
            "deselect-all": "Deselect all",
            "rulenode-details": "Rule node details",
            "debug-mode": "Debug mode",
            "configuration": "Configuration",
            "link": "Link",
            "link-details": "Rule node link details",
            "add-link": "Add link",
            "link-label": "Link label",
            "link-label-required": "Link label is required.",
            "custom-link-label": "Custom link label",
            "custom-link-label-required": "Custom link label is required.",
            "type-filter": "Filter",
            "type-filter-details": "Filter incoming messages with configured conditions",
            "type-enrichment": "Enrichment",
            "type-enrichment-details": "Add additional information into Message Metadata",
            "type-transformation": "Transformation",
            "type-transformation-details": "Change Message payload and Metadata",
            "type-action": "Action",
            "type-action-details": "Perform special action",
            "type-external": "External",
            "type-external-details": "Interacts with external system",
            "type-rule-chain": "Rule Chain",
            "type-rule-chain-details": "Forwards incoming messages to specified Rule Chain",
            "type-input": "Input",
            "type-input-details": "Logical input of Rule Chain, forwards incoming messages to next related Rule Node",
            "directive-is-not-loaded": "Defined configuration directive '{{directiveName}}' is not available.",
            "ui-resources-load-error": "Failed to load configuration ui resources.",
            "invalid-target-rulechain": "Unable to resolve target rule chain!",
            "test-script-function": "Test script function",
            "message": "Message",
            "message-type": "Message type",
            "message-type-required": "Message type is required",
            "metadata": "Metadata",
            "metadata-required": "Metadata entries can't be empty.",
            "output": "Output",
            "test": "Test",
            "help": "Help"
        },
        "tenant": {
            "tenants": "Tenants",
            "management": "Gestión de Tenant",
            "add": "Agregar Tenant",
            "admins": "Admins",
            "manage-tenant-admins": "Gestionar administradores tenant",
            "delete": "Eliminar tenant",
            "add-tenant-text": "Agregar nuevo tenant",
            "no-tenants-text": "Ningún tenant encontrado",
            "tenant-details": "Detalles del Tenant",
            "delete-tenant-title": "¿Estás seguro que quieres eliminar el tenant '{{tenantTitle}}'?",
            "delete-tenant-text": "Ten cuidado, luego de confirmar el tenant será eliminado y la información relacionada será irrecuperable.",
            "delete-tenants-title": "¿Estás seguro que quieres eliminar { count, select, 1 {1 tenant} other {# tenants} }?",
            "delete-tenants-action-title": "Eliminar { count, select, 1 {1 tenant} other {# tenants} }",
            "delete-tenants-text": "Ten cuidado, luego de confirmar los tenants seleccionados serán eliminados y la información relacionada será irrecuperable.",
            "title": "Título",
            "title-required": "Título requerido.",
            "description": "Descripción"
        },
        "timeinterval": {
            "seconds-interval": "{ seconds, select, 1 {1 segundo} other {# segundos} }",
            "minutes-interval": "{ minutes, select, 1 {1 minuto} other {# minutos} }",
            "hours-interval": "{ hours, select, 1 {1 hora} other {# horas} }",
            "days-interval": "{ days, select, 1 {1 día} other {# días} }",
            "days": "Días",
            "hours": "Horas",
            "minutes": "Minutos",
            "seconds": "Segundos",
            "advanced": "Avanzado"
        },
        "timewindow": {
            "days": "{ days, select, 1 { día } other {# días } }",
            "hours": "{ hours, select, 0 { horas } 1 {1 hora } other {# horas } }",
            "minutes": "{ minutes, select, 0 { minutos } 1 {1 minuto } other {# minutos } }",
            "seconds": "{ seconds, select, 0 { segundos } 1 {1 segundo } other {# segundos } }",
            "realtime": "Tiempo-real",
            "history": "Histórico",
            "last-prefix": "último",
            "period": "desde {{ startTime }} hasta {{ endTime }}",
            "edit": "Editar ventana de tiempo",
            "date-range": "Rango de fechas",
            "last": "Últimos",
            "time-period": "Período de tiempo"
        },
        "user": {
            "users": "Usuarios",
            "customer-users": "Usuarios del Cliente",
            "tenant-admins": "Tenant Admins",
            "sys-admin": "Administrador del Sistema",
            "tenant-admin": "Administrador Tenant",
            "customer": "Cliente",
            "anonymous": "Anónimo",
            "add": "Agregar usuario",
            "delete": "Eliminar usuario",
            "add-user-text": "Agregar nuevo usuario",
            "no-users-text": "Ningún usuario encontrado",
            "user-details": "Detalles del usuario",
            "delete-user-title": "¿Estás seguro que quieres eliminar el usuario '{{userEmail}}'?",
            "delete-user-text": "Ten cuidado, luego de confirmar el usuario seleccionado será eliminado y la información relacionada será irrecuperable.",
            "delete-users-title": "¿Estás seguro que quieres eliminar { count, select, 1 {1 usuario} other {# usuarios} }?",
            "delete-users-action-title": "Borrar { count, select, 1 {1 usuario} other {# usuarios} }",
            "delete-users-text": "Ten cuidado, luego de confirmar los usuarios seleccionados serán eliminados y la información relacionada será irrecuperable.",
            "activation-email-sent-message": "Mail de activación enviado con éxito!",
            "resend-activation": "Reenviar activación",
            "email": "Email",
            "email-required": "Email requerido.",
            "first-name": "Nombre",
            "last-name": "Apellido",
            "description": "Descripción",
            "default-dashboard": "Panel por defecto",
            "always-fullscreen": "Siempre en pantalla completa"
        },
        "value": {
            "type": "Tipo de valor",
            "string": "Cadena de texto",
            "string-value": "Valor de cadena de texto",
            "integer": "Nro entero",
            "integer-value": "Valor de nro entero",
            "invalid-integer-value": "Valor inválido",
            "double": "Nro decimal",
            "double-value": "Valor nro decimal",
            "boolean": "Booleano",
            "boolean-value": "Valor booleano",
            "false": "Falso",
            "true": "Verdadero"
        },
        "widget": {
            "widget-library": "Bibloteca de Widgets",
            "widget-bundle": "Paquetes de Widgets",
            "select-widgets-bundle": "Seleccionar paquete de widgets",
            "management": "Gestión de Widgets",
            "editor": "Editor de widgets",
            "widget-type-not-found": "Problema al cargar la configuración del widget.<br>Probablemente asociado\n    El tipo de widget fue eliminado.",
            "widget-type-load-error": "Widget no pudo ser cargado debido a estos errores:",
            "remove": "Eliminar widget",
            "edit": "Editar widget",
            "remove-widget-title": "¿Estás seguro que quieres eliminar el widget '{{widgetTitle}}'?",
            "remove-widget-text": "Luego de confirmar el widget será eliminado y toda la información relacionada será irrecuperable..",
            "timeseries": "Series de tiempo",
            "latest-values": "Últimos valores",
            "rpc": "Widget de control",
            "static": "Widget estático",
            "select-widget-type": "Seleccionar tipo de widget",
            "missing-widget-title-error": "El titulo del widget debe ser especificado!",
            "widget-saved": "Widget guardado",
            "unable-to-save-widget-error": "Imposible guardar widget! Tiene errores!",
            "save": "Guardar widget",
            "saveAs": "Guardar widget como",
            "save-widget-type-as": "Guardar tipo de widget como",
            "save-widget-type-as-text": "Por favor, ingrese un nuevo titulo y/o seleccione un paquete de destino.",
            "toggle-fullscreen": "Cambiar a pantalla completa",
            "run": "Correr widget",
            "title": "Titulo",
            "title-required": "Titulo requerido.",
            "type": "Tipo",
            "resources": "Recursos",
            "resource-url": "JavaScript/CSS URL",
            "remove-resource": "Eliminar recurso",
            "add-resource": "Agregar recurso",
            "html": "HTML",
            "tidy": "Tidy",
            "css": "CSS",
            "settings-schema": "Esquema de configuración",
            "datakey-settings-schema": "Esquema de configuración de clave de datos",
            "javascript": "Javascript",
            "remove-widget-type-title": "¿Estás seguro que quieres eliminar el tipo del widget '{{widgetName}}'?",
            "remove-widget-type-text": "Luego de confirmar el tipo será eliminado y la información relacionada será irrecuperable.",
            "remove-widget-type": "Eliminar tipo de widget.",
            "add-widget-type": "Agregar nuevo tipo de widget",
            "widget-type-load-failed-error": "Error al cargar el tipo de widget!",
            "widget-template-load-failed-error": "Error al cargar el template del widget!",
            "add": "Agregar Widget",
            "undo": "Deshacer cambios",
            "export": "Exportar widget"
        },
        "widget-action": { // TODO
            "header-button": "Widget header button",
            "open-dashboard-state": "Navigate to new dashboard state",
            "update-dashboard-state": "Update current dashboard state",
            "open-dashboard": "Navigate to other dashboard",
            "custom": "Custom action",
            "target-dashboard-state": "Target dashboard state",
            "target-dashboard-state-required": "Target dashboard state is required",
            "set-entity-from-widget": "Set entity from widget",
            "target-dashboard": "Target dashboard",
            "open-right-layout": "Open right dashboard layout (mobile view)"
        },
        "widgets-bundle": {
            "current": "Paquete actual",
            "widgets-bundles": "Paquete de Widgets",
            "add": "Agregar paquete de widgets",
            "delete": "Eliminar paquete de widgets",
            "title": "Título",
            "title-required": "Título requerido.",
            "add-widgets-bundle-text": "Agregar nuevo paquete de widgets",
            "no-widgets-bundles-text": "Ningún paquete de widgets encontrado",
            "empty": "Paquete de widgets vacío.",
            "details": "Detalles",
            "widgets-bundle-details": "Detalles del paquete de Widgets",
            "delete-widgets-bundle-title": "¿Estás seguro que  desea eliminar el paquete de widgets '{{widgetsBundleTitle}}'?",
            "delete-widgets-bundle-text": "Ten cuidado, luego de confirmar todos los paquetes seleccionados serán eliminados y su información relacionada será irrecuperable.",
            "delete-widgets-bundles-title": "¿Estás seguro que deseas eliminar { count, select, 1 {1 paquete de widgets} other {# paquetes de widgets} }?",
            "delete-widgets-bundles-action-title": "Eliminar { count, select, 1 {1 paquete de widgets} other {# paquetes de widgets} }",
            "delete-widgets-bundles-text": "Ten cuidado, luego de confirmar todos los paquetes seleccionados serán eliminados y la información relacionada será irrecuperable.",
            "no-widgets-bundles-matching": "Ningún paquete '{{widgetsBundle}}' encontrado.",
            "widgets-bundle-required": "Paquete de widget requerido.",
            "system": "Sistema",
            "import": "Importar paquete de widgets",
            "export": "Exportar paquete de widgets",
            "export-failed-error": "Imposible exportar paquete de widgets: {{error}}",
            "create-new-widgets-bundle": "Crear nuevo paquete de widgets",
            "widgets-bundle-file": "Archivo de paquete de widgets",
            "invalid-widgets-bundle-file-error": "Imposible importar paquete de widgets: Estructura de datos inválida."
        },
        "widget-config": {
            "data": "Datos",
            "settings": "Ajustes",
            "advanced": "Avanzado",
            "title": "Titulo",
            "general-settings": "Ajustes generales",
            "display-title": "Mostrar titulo",
            "drop-shadow": "Sombra",
            "enable-fullscreen": "Habilitar pantalla completa",
            "background-color": "Color de fondo",
            "text-color": "Color del texto",
            "padding": "Relleno",
            "title-style": "Estilo de título",
            "mobile-mode-settings": "Ajustes mobile.",
            "order": "Orden",
            "height": "Altura",
            "units": "Caracter especial a mostrar en el siguiente valor",
            "decimals": "Números de dígitos después de la coma",
            "timewindow": "Ventana de tiempo",
            "use-dashboard-timewindow": "Usar ventana de tiempo del Panel",
            "display-legend": "Mostrar leyenda",
            "datasources": "Set de datos",
            "datasource-type": "Tipo",
            "datasource-parameters": "Parámetros",
            "remove-datasource": "Eliminar set de datos",
            "add-datasource": "Agregar set de datos",
            "target-device": "Dispositivo destino"
        },
        "widget-type": {
            "import": "Importar tipo de widget",
            "export": "Exportar tipo de widget",
            "export-failed-error": "Imposible exportar tipo de widget: {{error}}",
            "create-new-widget-type": "Crear nuevo tipo de widget",
            "widget-type-file": "Tipo de archivo del widget",
            "invalid-widget-type-file-error": "Imposible de importar tipo de widget: Estructura de datos inválida."
        },
        "icon": { // TODO
            "icon": "Icon",
            "select-icon": "Select icon",
            "material-icons": "Material icons",
            "show-all": "Show all icons"
        },
        "custom": { // TODO
            "widget-action": {
                "action-cell-button": "Action cell button",
                "row-click": "On row click",
                "marker-click": "On marker click",
                "tooltip-tag-action": "Tooltip tag action"
            }
        },
        "language": {
            "language": "Lenguaje",
            "en_US": "Inglés",
            "ko_KR": "Coreano",
            "zh_CN": "Chino",
            "ru_RU": "Ruso",
            "es_ES": "Español"
        }
    };
    angular.extend(locales, { 'es_ES': es_ES });
}