/**
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.thingsboard.server.common.transport.quota;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author Vitaliy Paromskiy
 * @version 1.0
 */
@Component
public class HostRequestLimitPolicy {

    private final long limit;

    public HostRequestLimitPolicy(@Value("${quota.host.limit}") long limit) {
        this.limit = limit;
    }

    public boolean isValid(long currentValue) {
        return currentValue <= limit;
    }

}
