/*
 * Copyright © 2016-2017 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import './aliases-entity-select.scss';

import $ from 'jquery';

/* eslint-disable import/no-unresolved, import/default */

import aliasesEntitySelectButtonTemplate from './aliases-entity-select-button.tpl.html';
import aliasesEntitySelectPanelTemplate from './aliases-entity-select-panel.tpl.html';

/* eslint-enable import/no-unresolved, import/default */

/* eslint-disable angular/angularelement */
/*@ngInject*/
export default function AliasesEntitySelectDirective($compile, $templateCache, $mdMedia, types, $mdPanel, $document, $translate) {

    var linker = function (scope, element, attrs, ngModelCtrl) {

        /* tbAliasesEntitySelect (ng-model)
         * {
         *    "aliasId": {
         *        alias: alias,
         *        entityType: entityType,
         *        entityId: entityId
         *    }
         * }
         */

        var template = $templateCache.get(aliasesEntitySelectButtonTemplate);

        scope.tooltipDirection = angular.isDefined(attrs.tooltipDirection) ? attrs.tooltipDirection : 'top';

        element.html(template);

        scope.openEditMode = function (event) {
            if (scope.disabled) {
                return;
            }
            var position;
            var panelHeight = $mdMedia('min-height: 350px') ? 250 : 150;
            var panelWidth = 300;
            var offset = element[0].getBoundingClientRect();
            var bottomY = offset.bottom - $(window).scrollTop(); //eslint-disable-line
            var leftX = offset.left - $(window).scrollLeft(); //eslint-disable-line
            var yPosition;
            var xPosition;
            if (bottomY + panelHeight > $( window ).height()) { //eslint-disable-line
                yPosition = $mdPanel.yPosition.ABOVE;
            } else {
                yPosition = $mdPanel.yPosition.BELOW;
            }
            if (leftX + panelWidth > $( window ).width()) { //eslint-disable-line
                xPosition = $mdPanel.xPosition.CENTER;
            } else {
                xPosition = $mdPanel.xPosition.ALIGN_START;
            }
            position = $mdPanel.newPanelPosition()
                .relativeTo(element)
                .addPanelPosition(xPosition, yPosition);
            var config = {
                attachTo: angular.element($document[0].body),
                controller: 'AliasesEntitySelectPanelController',
                controllerAs: 'vm',
                templateUrl: aliasesEntitySelectPanelTemplate,
                panelClass: 'tb-aliases-entity-select-panel',
                position: position,
                fullscreen: false,
                locals: {
                    'entityAliases': angular.copy(scope.model),
                    'entityAliasesInfo': scope.entityAliasesInfo,
                    'onEntityAliasesUpdate': function (entityAliases) {
                        scope.model = entityAliases;
                        scope.updateView();
                    }
                },
                openFrom: event,
                clickOutsideToClose: true,
                escapeToClose: true,
                focusOnOpen: false
            };
            $mdPanel.open(config);
        }

        scope.updateView = function () {
            var value = angular.copy(scope.model);
            ngModelCtrl.$setViewValue(value);
            updateDisplayValue();
        }

        ngModelCtrl.$render = function () {
            if (ngModelCtrl.$viewValue) {
                var value = ngModelCtrl.$viewValue;
                scope.model = angular.copy(value);
                updateDisplayValue();
            }
        }

        function updateDisplayValue() {
            var displayValue;
            var singleValue = true;
            var currentAliasId;
            for (var aliasId in scope.model) {
                if (!currentAliasId) {
                    currentAliasId = aliasId;
                } else {
                    singleValue = false;
                    break;
                }
            }
            if (singleValue && currentAliasId) {
                var entityId = scope.model[currentAliasId].entityId;
                var entitiesInfo = scope.entityAliasesInfo[currentAliasId];
                for (var i=0;i<entitiesInfo.length;i++) {
                    if (entitiesInfo[i].id === entityId) {
                        displayValue = entitiesInfo[i].name;
                        break;
                    }
                }
            } else {
                displayValue = $translate.instant('entity.entities');
            }
            scope.displayValue = displayValue;
        }

        $compile(element.contents())(scope);
    }

    return {
        restrict: "E",
        require: "^ngModel",
        scope: {
            entityAliasesInfo:'='
        },
        link: linker
    };

}

/* eslint-enable angular/angularelement */