package br.ufrgs.inf.prosoft.adaptivecaching.analysis;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model.MethodEntry;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats.CacheabilityPatternDecider;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCacheManager;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.TriggerType;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.TracerAspect;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheInfo;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.vendors.guava.GuavaMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.MongoRepository;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

public class Analyzer implements Runnable {

    public static Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private final AdaptiveCaching adaptiveConfig;
    private Repository dataSource;
    private Repository dataTarget;
    private CacheInfo cacheInfo;

    public Analyzer(Repository dataSource, Repository dataTarget, CacheInfo cacheInfo, AdaptiveCaching adaptiveConfig) {
        this.dataSource = dataSource;
        this.dataTarget = dataTarget;
        this.cacheInfo = cacheInfo;
        this.adaptiveConfig = adaptiveConfig;
    }

    public Analyzer(Repository dataSource, CacheInfo cacheInfo, AdaptiveCaching adaptiveConfig) {
        this.dataSource = dataSource;
        this.cacheInfo = cacheInfo;
        this.adaptiveConfig = adaptiveConfig;
    }

    public static void main(String[] args) {
        //TODO db according to properties file...
        MongoClient mongo = new MongoClient("localhost", 27017);
        MongoDatabase database = mongo.getDatabase("cachemonitoring");
        Repository repositoryTarget = new MongoRepository<MethodEntry>(database.getCollection("petclinicCacheable"), MethodEntry.class);
        Repository repositorySource = new MongoRepository<LogTrace>(database.getCollection("cloudstore"), LogTrace.class);
//        Repository repositorySource = new RedisRepository<LogTrace>();

        //TODO db according to properties file...
        GuavaCacheManager cacheManager = new GuavaCacheManager();
        Cache cache = cacheManager.getCache("test");
        CacheMonitor cacheMonitor = new GuavaMonitor((GuavaCache) cache);
        logger.debug("Cache provider is configured to Guava.");

        AdaptiveCaching adaptiveCaching = new AdaptiveCaching() {
            @Override
            public boolean equals(Object obj) {
                return false;
            }

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public String toString() {
                return null;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public boolean enabled() {
                return true;
            }

            @Override
            public RepositoryType logRepository() {
                return RepositoryType.MONGODB;
            }

            @Override
            public CacheProviderType cacheProvider() {
                return CacheProviderType.GUAVA;
            }

            @Override
            public Modelling modelling() {
                return Modelling.ACCUMULATION;
            }

            @Override
            public long expiry() {
                return 0;
            }

            @Override
            public TriggerType triggerType() {
                return TriggerType.TIME;
            }

            @Override
            public long triggerTime() {
                return 5;
            }

            @Override
            public boolean analyzerEnabled() {
                return true;
            }

            @Override
            public boolean disableMonitoringAfterAnalysis() {
                return false;
            }

            @Override
            public boolean traceAsync() {
                return true;
            }

            @Override
            public boolean clearMonitoringDataOnStart() {
                return false;
            }

            @Override
            public boolean tracerEnabled() {
                return true;
            }

            @Override
            public boolean analyzeOnce() {
                return false;
            }
        };
        Analyzer analyzer = new Analyzer(repositorySource, null, cacheMonitor.getCacheInfo(), adaptiveCaching);

        //TODO trigger by time?
        analyzer.run();
    }

    @Override
    public void run() {

        if(!TracerAspect.analyzerEnabled) {
            logger.info("Analyzer disabled, not running...");
            return;
        }

        List all = dataSource.findAll();

//        if(all.size() < 300)
//            return;

        Set<MethodEntry> process = analyzeAndReturn(all);

        if (dataTarget != null) {
            dataTarget.removeAll();
            process.forEach(dataTarget::save);
        }

        //todo maybe clean the cache here?
        TracerAspect.cacheableMethods = process;

        String methods = "";
        for (MethodEntry me : process) methods = methods.concat(me.getMethodInfo().getSignature() + ",");

        //TODO maybe after the analysis end, new data would be already registered, which should not be deleted
        if (adaptiveConfig.modelling().equals(Modelling.FULLEXPLORATION)) {
            dataSource.removeAll();
            logger.info("Old monitoring data deleted.");
        }

        if(adaptiveConfig.analyzeOnce())
            TracerAspect.analyzerEnabled = false;
    }


    public Set<MethodEntry> analyzeAndReturn(List<LogTrace> logList) {
        logger.info("Starting the analysis of cacheable methods from logs: " + logList.size() + " loaded.");
        //TODO trigger by number of logs
//        if(logList.size() < 500000)
//            return;

        CacheabilityPatternDecider decider = new CacheabilityPatternDecider(logList.size());
        FlowchartWorkFlow workflow = new FlowchartWorkFlow(decider, cacheInfo, logList);
        Set<MethodEntry> process = workflow.filterCacheableMethods(adaptiveConfig.expiry());
        logger.info(process.size() + " cacheable methods identified.");

//        //TODO find by annotations @Ignore and remove the methods marked
//
//        //        for (MethodInfo method : cacheableStats.getMethodsInfoMap().keySet()) {
////            if(cacheableStats.getMethodsInfoMap().get(method).hitRatio() > 10)
////                System.out.println(method.getSignature() + ": " + cacheableStats.getMethodsInfoMap().get(method).hitRatio());
////        }


//        //TODO if disable monitoring, should not schedule future analysis
        if (adaptiveConfig.disableMonitoringAfterAnalysis()) {
            TracerAspect.tracerEnabled = false;
            logger.info("Adaptive caching monitoring disabled since the model was built.");
        }
        return process;
    }
}
