package br.ufrgs.inf.prosoft.tigrisframework.metrics;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.TracerAspect;
import br.ufrgs.inf.prosoft.tigrisframework.statistics.StatisticalTest;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class LightweightAnalyzer implements Runnable {

    static Logger logger = LoggerFactory.getLogger(LightweightAnalyzer.class);

    public static Set<String> allowedFineGrained = new ConcurrentSkipListSet<>();

    public static void analyze() throws IOException {

        logger.info("Analyzing {} lightweight methods for relevance...", TracerAspect.metrics.size());

        StaticMetrics staticMetrics = new StaticMetrics(TracerAspect.staticFile);

        DescriptiveStatistics frequencies = new DescriptiveStatistics();
        DescriptiveStatistics changeabilities = new DescriptiveStatistics();
        DescriptiveStatistics errorprones = new DescriptiveStatistics();
        DescriptiveStatistics latencies = new DescriptiveStatistics();
        DescriptiveStatistics maintainabilities = new DescriptiveStatistics();
        DescriptiveStatistics userBehaviors = new DescriptiveStatistics();
        DescriptiveStatistics concurrencies = new DescriptiveStatistics();
        DescriptiveStatistics expensiveness = new DescriptiveStatistics();
        DescriptiveStatistics globalimpacts = new DescriptiveStatistics();
        System.out.println("---------------------------");
        Map<String, LightweightMetrics> mets = new HashMap<>(TracerAspect.metrics);
        for (String method : mets.keySet()) {
            System.out.println(method);
            LightweightMetrics sc = mets.get(method);
            StaticMetrics.StaticMetric staticMetric = staticMetrics.getMetrics(sc.getName());
            if(staticMetric == null)
                continue;
            frequencies.addValue(sc.getFrequency());
            changeabilities.addValue(sc.getChangeability());
            errorprones.addValue(staticMetric.maxNesting);
            latencies.addValue(sc.getLatency());
            maintainabilities.addValue(staticMetric.cyclomatic);
            userBehaviors.addValue(sc.getUserBehavior());
            concurrencies.addValue(sc.getConcurrency());
            expensiveness.addValue(sc.getExpensiveness());
            globalimpacts.addValue(staticMetric.countOutput);
        }

        System.out.println("---------------------------");
        System.out.println("Metric: frequency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(frequencies.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: maintainability; Distribution: " +
                ((StatisticalTest.isNormalDistribution(maintainabilities.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: changeability; Distribution: " +
                ((StatisticalTest.isNormalDistribution(changeabilities.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: userBehavior; Distribution: " +
                ((StatisticalTest.isNormalDistribution(userBehaviors.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: concurrency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(concurrencies.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: errorprone; Distribution: " +
                ((StatisticalTest.isNormalDistribution(errorprones.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: expensiveness; Distribution: " +
                ((StatisticalTest.isNormalDistribution(expensiveness.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: globalimpact; Distribution: " +
                ((StatisticalTest.isNormalDistribution(globalimpacts.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: latency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(latencies.getValues(), 0.05)) ? "normal" : "not_normal"));

        //cleaning selected methods
        allowedFineGrained = new ConcurrentSkipListSet<>();

        //TODO process SET operations dynamically
//        LightweightMetricAspect.criteriaDSL

        //less changeable C more frequent C (more user_behavior U (less user_behavior C more expensive))
        for(String method : mets.keySet()) {
            LightweightMetrics sc = mets.get(method);


            //extended filter
           if ((DataFiltering.isGroup("less", changeabilities, sc.getChangeability())
                    || DataFiltering.isGroup("normal", changeabilities, sc.getChangeability()))
                    && (DataFiltering.isGroup("more", frequencies, sc.getFrequency())
                    || DataFiltering.isGroup("normal", frequencies, sc.getFrequency()))
                    && ((DataFiltering.isGroup("more", userBehaviors, sc.getUserBehavior())
                    || DataFiltering.isGroup("normal", userBehaviors, sc.getUserBehavior()))
                    || ((DataFiltering.isGroup("less", userBehaviors, sc.getUserBehavior())
                       || DataFiltering.isGroup("normal", userBehaviors, sc.getUserBehavior()))
                    && (DataFiltering.isGroup("normal", expensiveness, sc.getExpensiveness())
                        || DataFiltering.isGroup("more", expensiveness, sc.getExpensiveness())))))

            //restricted filter
            //less changeable C more frequent C (more user_behavior U (less user_behavior C more expensive))
//            if (DataFiltering.isGroup("less", changeabilities, sc.getChangeability())
//                && DataFiltering.isGroup("more", frequencies, sc.getFrequency())
//                && (DataFiltering.isGroup("more", userBehaviors, sc.getUserBehavior())
//                    || (DataFiltering.isGroup("less", userBehaviors, sc.getUserBehavior())
//                        && DataFiltering.isGroup("more", expensiveness, sc.getExpensiveness()))))

//            if (DataFiltering.isGroup("least", changeabilities, sc.getChangeability())
//                && DataFiltering.isGroup("most", frequencies, sc.getFrequency())
//                && (DataFiltering.isGroup("most", userBehaviors, sc.getUserBehavior())
//                    || (DataFiltering.isGroup("least", userBehaviors, sc.getUserBehavior())
//                        && DataFiltering.isGroup("most", expensiveness, sc.getExpensiveness()))))

//            if (DataFiltering.isGroup("less", changeabilities, sc.getChangeability())
//                    && DataFiltering.isGroup("most", frequencies, sc.getFrequency())
//                    && DataFiltering.isGroup("most", expensiveness, sc.getExpensiveness()))

                allowedFineGrained.add(sc.getLongName());
        }
        logger.info("Selected methods for fine-grained ({}): {}", allowedFineGrained.size(), allowedFineGrained);

//        TracerAspect.enabled = true;
        TracerAspect.analyzerEnabled = true;
//        LightweightMetricAspect.enabled = true;

        //TODO remove: print all unique methods and metrics to csv file
        logger.info("Printing lightweigth metrics...");
        try {
            final PrintWriter pw = new PrintWriter(new File("lightweightanalysis.csv"));
            pw.write("method,frequency,maintainability,changeability,userBehavior,concurrency,errorprone,expensiveness,globalimpact,latency,vfrequency,vmaintainability,vchangeability,vuserBehavior,vconcurrency,verrorprone,vexpensiveness,vglobalimpact,vlatency\n");
            for(String name : mets.keySet()){
                LightweightMetrics lm = mets.get(name);
                StaticMetrics.StaticMetric staticMetric = staticMetrics.getMetrics(lm.getName());
                if(staticMetric == null)
                    continue;
                pw.write(mets.get(name).getName() + "," +
                    DataFiltering.getGroup(frequencies, mets.get(name).getFrequency()) +
                    "," + DataFiltering.getGroup(maintainabilities, staticMetric.cyclomatic) +
                    "," + DataFiltering.getGroup(changeabilities, lm.getChangeability()) +
                    "," + DataFiltering.getGroup(userBehaviors, lm.getUserBehavior()) +
                    "," + DataFiltering.getGroup(concurrencies, lm.getConcurrency()) +
                    "," + DataFiltering.getGroup(errorprones, staticMetric.maxNesting) +
                    "," + DataFiltering.getGroup(expensiveness, lm.getExpensiveness()) +
                    "," + DataFiltering.getGroup(globalimpacts, staticMetric.countOutput) +
                    "," + DataFiltering.getGroup(latencies, mets.get(name).getLatency()) +
                    "," +
                        DataFiltering.allMetricsToString(lm, staticMetrics) + '\n');
            }
            pw.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        //analyze once
        TracerAspect.lightweightAnayzerEnabled = false;
//        TracerAspect.lightweightTracerEnabled = false;
    }

    @Override
    public void run() {

//        logger.info("Tracing stats....... \n Stateful trace: {} \n Light trace: {} \n Checking allow: {}", TracerAspect.timeToStatefulTrace.getMean() / 1000,
//                TracerAspect.timeToLightweightTrace.getMean() / 1000, TracerAspect.timeToCheckAllowedTrace.getMean() / 1000);

        if (!TracerAspect.lightweightAnayzerEnabled) {
            logger.info("Lightweight analysis disabled...");
            return;
        }

        try {
            analyze();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
