package br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.TriggerType;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface AdaptiveCaching {

    //enabling configurations
    boolean enabled() default true;
    boolean tracerEnabled() default true;
    boolean analyzerEnabled() default true;

    RepositoryType logRepository() default RepositoryType.MONGODB;

    CacheProviderType cacheProvider() default CacheProviderType.GUAVA;

    Modelling modelling() default Modelling.ACCUMULATION;

    long expiryInterval() default 5; //in minutes
    long firstExpiry() default 6; //in minutes

    //todo when analysis based on trigger do not make sense to have this, its similar to trigger by time
    @Deprecated long analysisInterval() default 5; //in minutes
    @Deprecated long firstAnalysis() default 2; //in minutes

    TriggerType triggerType() default TriggerType.TIME; //if were not by time, load the class that implements the interface @Trigger

    long triggerTime() default 5; //in minutes

    //enables the analyzer to be executed just once
    boolean analyzeOnce() default false;

    //disable the monitoring after the first analyses
    boolean disableMonitoringAfterAnalysis() default false;

    @Deprecated boolean traceAsync() default true;
    boolean clearMonitoringDataOnStart() default false;

    //when a method cannot be traced, any future calls can be blacklisted
    boolean enableBlacklist() default false;
}
