package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata;

import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.Objects;

public class MethodInfo {

    private String signature;

    private Object[] arguments;

    private Object returnedValue;

//    private Integer hashedReturnedValue;
//    private Integer hashedArguments;

    public MethodInfo() {
    }

    public MethodInfo(String signature, Object[] arguments) {
        this.signature = signature;
        this.arguments = arguments;

//        try {
//            //TODO hash or not???
//            this.hashedArguments = HashCodeBuilder.reflectionHashCode(arguments);
//        } catch (Exception e) {
//        }
    }

    public MethodInfo(String signature, Object[] arguments, Object returnedValue) {
        this(signature, arguments);
        this.returnedValue = returnedValue;

//        try {
//            //TODO hash or not???
//            this.hashedArguments = HashCodeBuilder.reflectionHashCode(arguments);
//            this.hashedReturnedValue = HashCodeBuilder.reflectionHashCode(returnedValue);
//        } catch (Exception e) {
//        }
    }

    public String getSignature() {
        return this.signature;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object getReturnedValue() {
        return this.returnedValue;
    }

    public boolean equalsWithoutReturnedValue(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MethodInfo that = (MethodInfo) o;

        if (!signature.equals(that.signature)) return false;
        if (!Objects.deepEquals(arguments, that.arguments)) return false;
//        if (!arguments.equals(that.arguments)) return false;
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MethodInfo that = (MethodInfo) o;

        if (!signature.equals(that.signature)) return false;
//        if (!arguments.equals(that.arguments)) return false;
        if (!Objects.deepEquals(arguments, that.arguments)) return false;
        return returnedValue != null ? Objects.deepEquals(returnedValue, that.returnedValue) : that.returnedValue == null;
    }

//    public boolean equalsHashed(Object o) {
//        if (this == o) return true;
//        if (o == null || getClass() != o.getClass()) return false;
//
//        MethodInfo that = (MethodInfo) o;
//
//        if (!signature.equals(that.signature)) return false;
//        if (!Objects.deepEquals(hashedArguments, that.hashedArguments)) return false;
//        return hashedReturnedValue != null ? Objects.deepEquals(hashedReturnedValue, that.hashedReturnedValue) : that.hashedReturnedValue == null;
//    }
//
//    public boolean equalsHashedWithoutReturnedValue(Object o) {
//        if (this == o) return true;
//        if (o == null || getClass() != o.getClass()) return false;
//
//        MethodInfo that = (MethodInfo) o;
//
//        if (!signature.equals(that.signature)) return false;
//        if (!Objects.deepEquals(hashedArguments, that.hashedArguments)) return false;
//        return true;
//    }

//    public Integer getHashedReturnedValue() {
//        return hashedReturnedValue;
//    }
//
//    public Integer getHashedArguments() {
//        return hashedArguments;
//    }
//
//    public void setArguments(Object[] arguments) {
//        this.arguments = arguments;
//    }
//
//    public void setReturnedValue(Object returnedValue) {
//        this.returnedValue = returnedValue;
//    }

    @Override
    public int hashCode() {
        int result = signature.hashCode();
        result = 31 * result + Objects.hash(arguments);
        result = 31 * result + (returnedValue != null ? Objects.hash(returnedValue) : 0);
        return result;
    }

    public String toString() {
        return "br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.MethodInfo(signature=" + this.signature + ", arguments=" + this.arguments + ", returnedValue=" + this.returnedValue + ")";
    }
}
