package eu.cloudscale.showcase;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigrisframework.annotations.TigrisConfiguration;

@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE, logRepository = RepositoryType.MEMORY,
        modelling = Modelling.FULLEXPLORATION, analyzerEnabled = true, enabled = true, disableMonitoringAfterAnalysis = false,
        clearMonitoringDataOnStart = true, traceAsync = false, tracerEnabled = true, analyzeOnce = true, expiryInterval = 86400)
@ComponentScan(allowed = "eu.cloudscale.showcase", denied = {"eu.cloudscale.showcase.db.model", "eu.cloudscale.showcase.servlets", "eu.cloudscale.showcase.db.dao.hibernate"})
@TigrisConfiguration(
        samplingEnabled = true,
        samplingPercentage = 5,
        staticMetricFile = "/home/jhonnymertz/workspace/adaptive-caching-framework/understand/cloudstore.csv")
public class Configuration {
}
