package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.vendors.guava;

import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCache;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheInfo;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheMonitor;
import com.google.common.cache.CacheStats;

public class GuavaMonitor implements CacheMonitor{

    private GuavaCache cache;

    public GuavaMonitor(GuavaCache cache){
        this.cache = cache;
    }

    @Override
    public CacheInfo getCacheInfo() {
        CacheStats cacheStats = cache.stats();

        CacheInfo cacheInfo = new CacheInfo();

        //TODO size is unbound by default
        cacheInfo.setTotalSpace(null);
        cacheInfo.setUsedSpace(cache.size());

        cacheInfo.setEvictedKeys(cacheStats.evictionCount());
        cacheInfo.setKeyspaceHits(cacheStats.hitCount());
        cacheInfo.setKeyspaceMisses(cacheStats.missCount());
        cacheInfo.setNumberOfObjects(cache.size());

        return cacheInfo;

    }
}
