package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.providers;

import br.ufrgs.inf.prosoft.adaptivecaching.exceptions.StorageException;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MemoryRepository<T> implements Repository<T> {

    List<T> logs;

    public MemoryRepository() {
        logs = Collections.synchronizedList(new ArrayList<>());
    }

    @Override
    public void save(T t) throws StorageException {
        logs.add(t);
    }

    @Override
    public List<T> findAll() {
        return logs;
    }

    @Override
    public void removeAll() {
        logs.clear();
    }

    @Override
    public void saveAll(List<T> toSave) {

    }
}
