package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Set;

public class MethodStats {

    //exactly same method calls
    private Long sameOccurrences;

    //number of same method calls with different return
    private Long differentReturnOccurrences;
    private Long sameOccurrencesExecutionTime;
    private Long sameOccurrencesHigherExecutionTime;

    private Long amountOfIdentifiedSameOccurences;
    private Set<String> uniqueUsers;

    public MethodStats() {
        sameOccurrences = 0L;
        differentReturnOccurrences = 0L;
        sameOccurrencesExecutionTime = 0L;
        sameOccurrencesHigherExecutionTime = 0L;
        amountOfIdentifiedSameOccurences = 0L;
        uniqueUsers = new HashSet<>();
    }

    public MethodStats(LogTrace logTrace) {
        this();
        addSameOccurrence(logTrace);
    }

    public void addSameOccurrence(LogTrace logTrace) {
        sameOccurrences++;
        addSameOccurrencesTotalExecutionTime(logTrace.totalTime());

        //todo cannot be based on string
        if (!logTrace.getUserId().equals("Anonymous")) {
            uniqueUsers.add(logTrace.getUserId());
            addIdentifiedSameOccurence();
        }
    }

    public void addDifferentReturnOccurrence() {
        //todo if the request was identified, it should counts
        //addIdentifiedSameOccurence();
        differentReturnOccurrences += 1;
    }

    private void addSameOccurrencesTotalExecutionTime(Long executionTime) {
        sameOccurrencesExecutionTime += executionTime;
        if (executionTime > sameOccurrencesHigherExecutionTime)
            sameOccurrencesHigherExecutionTime = executionTime;
    }

    public Long getSameOccurrencesTotalExecutionTime() {
        return sameOccurrencesExecutionTime;
    }

    public double getSameOccurrencesAverageExecutionTime() {
        return new BigDecimal(getSameOccurrencesTotalExecutionTime())
                .divide(new BigDecimal(sameOccurrences), 5, RoundingMode.HALF_UP)
                .doubleValue();
    }

    public long getSameOccurrencesHigherExecutionTime() {
        return sameOccurrencesHigherExecutionTime;
    }

    /**
     * @return All occurrences of a method, i.e. with different params and return or not
     */
    public Long getNumberOfOccurrences() {
        return sameOccurrences + differentReturnOccurrences;
    }

    public Long getNumberOfSameOccurrences() {
        return sameOccurrences;
    }

    public Long getNumberOfDifferentReturnOccurrences() {
        return differentReturnOccurrences;
    }

    //from 0% to 100%
    public double hitRatio() {
        BigDecimal bd = new BigDecimal(getNumberOfSameOccurrences() * 100);
        return bd.divide(new BigDecimal(getNumberOfOccurrences()), 5, RoundingMode.HALF_UP).doubleValue();
    }

    //from 0% to 100%
    public double missRatio() {
        BigDecimal bd = new BigDecimal(getNumberOfDifferentReturnOccurrences() * 100);
        return bd.divide(new BigDecimal(getNumberOfOccurrences()), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public double shareability() {

        Long amountOfIdentifiedSameOccurences = getAmountOfIdentifiedSameOccurences();
        if (amountOfIdentifiedSameOccurences == 0)
            return 100;

        BigDecimal bd = new BigDecimal(getAmountOfUniqueIdentifiedSameOccurences() * 100);
        return bd.divide(new BigDecimal(amountOfIdentifiedSameOccurences), 5, RoundingMode.HALF_UP).doubleValue();
    }

    public String toCSV() {
        //numberOfSameOccurrences,numberOfDifferentReturnOccurrences,totalOccurrences,sameOccurrencesAverageExecutionTime,sameOccurrencesTotalExecutionTime,hitRatio,missRatio
        return getNumberOfSameOccurrences() +
                "," + getNumberOfDifferentReturnOccurrences() +
                "," + getNumberOfOccurrences() +
                "," + getSameOccurrencesAverageExecutionTime() +
                "," + getSameOccurrencesTotalExecutionTime() +
                "," + hitRatio() +
                "," + missRatio();
    }

    @Override
    public String toString() {
        return
                "MethodStats{" +
                        "numberOfSameOccurrences=" + getNumberOfSameOccurrences() +
                        ", numberOfDifferentReturnOccurrences=" + getNumberOfDifferentReturnOccurrences() +
                        ", totalOccurrences =" + getNumberOfOccurrences() +
                        ", sameOccurrencesAverageExecutionTime =" + getSameOccurrencesAverageExecutionTime() +
                        ", sameOccurrencesTotalExecutionTime =" + getSameOccurrencesTotalExecutionTime() +
                        ", hitRatio =" + hitRatio() +
                        ", missRatio =" + missRatio() +
                        '}';
    }

    public Long getAmountOfIdentifiedSameOccurences() {
        return amountOfIdentifiedSameOccurences;
    }

    public int getAmountOfUniqueIdentifiedSameOccurences() {
        return uniqueUsers.size();
    }

    public Long getAmountOfAnonymousSameOccurences() {
        return sameOccurrences - amountOfIdentifiedSameOccurences;
    }

    private void addIdentifiedSameOccurence() {
        amountOfIdentifiedSameOccurences++;
    }
}
