package br.ufrgs.inf.prosoft.adaptivecaching.analysis;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model.MethodEntry;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.TracerAspect;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheInfo;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Analyzer implements Runnable {

    public static Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private final AdaptiveCaching adaptiveConfig;
    private Repository dataSource;
    private Repository dataTarget;
    private CacheInfo cacheInfo;

    public Analyzer(Repository dataSource, Repository dataTarget, CacheInfo cacheInfo, AdaptiveCaching adaptiveConfig) {
        this.dataSource = dataSource;
        this.dataTarget = dataTarget;
        this.cacheInfo = cacheInfo;
        this.adaptiveConfig = adaptiveConfig;
    }

    public Analyzer(Repository dataSource, CacheInfo cacheInfo, AdaptiveCaching adaptiveConfig) {
        this.dataSource = dataSource;
        this.cacheInfo = cacheInfo;
        this.adaptiveConfig = adaptiveConfig;
    }

    @Override
    public void run() {

//        logger.info("Tracing stats....... \n Stateful trace: {} \n Light trace: {} \n Checking allow: {}", TracerAspect.timeToStatefulTrace.getMean() / 1000,
//                TracerAspect.timeToLightweightTrace.getMean() / 1000, TracerAspect.timeToCheckAllowedTrace.getMean() / 1000);


        if(!TracerAspect.analyzerEnabled) {
            logger.info("Analyzer disabled, waiting until next run to check again...");
            return;
        }

//        while(!TracerAspect.analyzerEnabled){
//            try {
//                logger.info("Analyzer disabled, waiting 30 seconds to check again...");
//                Thread.sleep(30000);
//            } catch (InterruptedException e) {
//                e.printStackTrace();
//            }
//        }

//        logger.info("Analyzer enable, waiting 120 seconds to start...");
//        try {
//            Thread.sleep(120000);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }

        List all = dataSource.findAll();

        //TODO trigger by number of logs
        //here we can check whether there are enough logs to process, such as
        //if(all.size() < 300) return;

        Set<MethodEntry> process = analyzeAndReturn(all);

        //if there is a repository to save cacheable values
        if (dataTarget != null) {
            dataTarget.removeAll();
            process.forEach(dataTarget::save);
        }

        //todo maybe clean the cache here?
        TracerAspect.cacheableMethods = process;
        TracerAspect.cacheableMethodKeys = process.stream().parallel().map(MethodEntry::getMethodInfoKey).collect(Collectors.toSet());

        String methods = "";
        for (MethodEntry me : process) methods = methods.concat(me.getMethodInfo().getSignature() + ",");

        //TODO maybe after the analysis end, new data would be already registered, which should not be deleted
        if (adaptiveConfig.modelling().equals(Modelling.FULLEXPLORATION)) {
            dataSource.removeAll();
            logger.info("Old monitoring data deleted.");
        }

        if (adaptiveConfig.analyzeOnce())
            TracerAspect.analyzerEnabled = false;

        logger.info("Start caching...");
    }


    public Set<MethodEntry> analyzeAndReturn(List<LogTrace> logList) {
        logger.info("Starting the analysis of cacheable methods from logs: " + logList.size() + " loaded.");

        FlowchartWorkFlow workflow = new FlowchartWorkFlow(cacheInfo, logList);
        Set<MethodEntry> process = workflow.filterCacheableMethods(adaptiveConfig.expiryInterval());
        logger.info(process.size() + " cacheable methods identified.");

        //TODO find by annotations @Ignore and remove the methods marked

        //if disable monitoring, should not schedule future analysis
        if (adaptiveConfig.disableMonitoringAfterAnalysis()) {
            TracerAspect.tracerEnabled = false;
            logger.info("Adaptive caching monitoring disabled since the model was built.");
        }

        return process;
    }
}
