package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.MethodInfo;

public class MethodEntry {

    private MethodInfo methodInfo;
    private MethodStats methodStats;
    private long lifetime;

    public MethodEntry(){

    }

    public MethodEntry(MethodInfo methodInfo, MethodStats methodStats, long lifetime) {
        this.methodInfo = methodInfo;
        this.methodStats = methodStats;
        this.lifetime = lifetime;
    }

    public MethodInfo getMethodInfo() {
        return methodInfo;
    }

    public Object getMethodInfoKey() {
        return methodInfo.getKey();
    }

    public MethodStats getMethodStats() {
        return methodStats;
    }

    @Override
    public String toString() {
        return "MethodEntry{" +
                "methodInfo=" + methodInfo +
                ", methodStats=" + methodStats +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MethodEntry)) return false;

        MethodEntry that = (MethodEntry) o;

        if (!methodInfo.equals(that.methodInfo)) return false;
        if (!methodStats.equals(that.methodStats)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = methodInfo.hashCode();
        result = 31 * result + methodStats.hashCode();
        return result;
    }

    public boolean expired() {
        return lifetime < System.currentTimeMillis();
    }
}
