package br.ufrgs.inf.prosoft.tigrisframework.metrics;

import br.ufrgs.inf.prosoft.tigrisframework.statistics.StatisticalTest;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class DataFiltering {

    public static boolean isGroup(String group, DescriptiveStatistics criteria, double value){

        boolean isNormal = StatisticalTest.isNormalDistribution(criteria.getValues(), 0.05);
        DescriptiveStatistics half = new DescriptiveStatistics();
        if(!isNormal && (group.equals("most") || group.equals("least"))) {
            for(double val : criteria.getValues())
                if(group.equals("most") && val >= criteria.getPercentile(75))
                    half.addValue(val);
                else if(group.equals("least") && val <= criteria.getPercentile(25))
                    half.addValue(val);
        }

        switch (group){
            case "normal":
                if (isNormal)
                    return (value > (criteria.getMean() - criteria.getStandardDeviation()) &&
                            value < (criteria.getMean() + criteria.getStandardDeviation()));
                else
                    return (value > criteria.getPercentile(25) &&
                            value < criteria.getPercentile(75));
            case "most":
                if (isNormal)
                    return value >= (criteria.getMean() + (2*criteria.getStandardDeviation()));
                else
                    return value >= half.getPercentile(50);
            case "least":
                if (isNormal)
                    return value <= (criteria.getMean() + (2*criteria.getStandardDeviation()));
                else
                    return value <= half.getPercentile(50);
            case "more":
                if (isNormal)
                    return value >= (criteria.getMean() + criteria.getStandardDeviation());
                else
                    return value >= criteria.getPercentile(75);
            case "less":
                if (isNormal)
                    return value <= (criteria.getMean() - criteria.getStandardDeviation());
                else
                    return value <= criteria.getPercentile(25);
        }

        throw new RuntimeException("Não foi possível classificar...");
    }

    public static String getGroup(DescriptiveStatistics criteria, double value){

        boolean isNormal = StatisticalTest.isNormalDistribution(criteria.getValues(), 0.05);
        DescriptiveStatistics upperHalf = new DescriptiveStatistics();
        DescriptiveStatistics lowerHalf = new DescriptiveStatistics();
        if(!isNormal) {
            for(double val : criteria.getValues())
                if(val >= criteria.getPercentile(75))
                    upperHalf.addValue(val);
                else if(val <= criteria.getPercentile(25))
                    lowerHalf.addValue(val);
        }

        if (isNormal){
            if(value > (criteria.getMean() - criteria.getStandardDeviation()) &&
                    value < (criteria.getMean() + criteria.getStandardDeviation()))
                return "normal";
            else if(value >= (criteria.getMean() + (2*criteria.getStandardDeviation())))
                return "most";
            else if(value <= (criteria.getMean() + (2*criteria.getStandardDeviation())))
                return "least";
            else if(value >= (criteria.getMean() + criteria.getStandardDeviation()))
                return "more";
            else if(value <= (criteria.getMean() - criteria.getStandardDeviation()))
                return "less";
        } else {
            if(value > criteria.getPercentile(25) &&
                    value < criteria.getPercentile(75))
                return "normal";
            else if(value >= upperHalf.getPercentile(50))
                return "most";
            else if(value <= lowerHalf.getPercentile(50))
                return "least";
            else if(value >= criteria.getPercentile(75))
                return "more";
            else if(value <= criteria.getPercentile(25))
                return "less";
        }

        throw new RuntimeException("Não foi possível classificar...");
    }

    public static String allMetricsToString(LightweightMetrics lightweightMetrics, StaticMetrics staticMetrics) {
        //frequency,maintainability,changeability,userBehavior,concurrency,errorprone,expensiveness,globalimpact,latency
        return lightweightMetrics.getFrequency() +
                "," + staticMetrics.getMetrics(lightweightMetrics.getName()).cyclomatic +
                "," + lightweightMetrics.getChangeability() +
                "," + lightweightMetrics.getUserBehavior() +
                "," + lightweightMetrics.getConcurrency() +
                "," + staticMetrics.getMetrics(lightweightMetrics.getName()).maxNesting +
                "," + lightweightMetrics.getExpensiveness() +
                "," + staticMetrics.getMetrics(lightweightMetrics.getName()).countOutput +
                "," + lightweightMetrics.getLatency();
    }
}
