package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.Analyzer;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model.MethodEntry;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCacheManager;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.TriggerType;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.vendors.guava.GuavaMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.providers.MongoRepository;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;

import java.lang.annotation.Annotation;

public class AnalyzerTest {

//    @Test
    public void test(){
        //TODO db according to properties file...
        MongoClient mongo = new MongoClient("localhost", 27017);
        MongoDatabase database = mongo.getDatabase("cachemonitoring");
        Repository repositoryTarget = new MongoRepository<MethodEntry>(database.getCollection("petclinicCacheable"), MethodEntry.class);
        Repository repositorySource = new MongoRepository<LogTrace>(database.getCollection("cloudstore"), LogTrace.class);

        //TODO db according to properties file...
        GuavaCacheManager cacheManager = new GuavaCacheManager();
        Cache cache = cacheManager.getCache("test");
        CacheMonitor cacheMonitor = new GuavaMonitor((GuavaCache) cache);

        AdaptiveCaching adaptiveCaching = new AdaptiveCaching() {
            @Override
            public boolean equals(Object obj) {
                return false;
            }

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public String toString() {
                return null;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public boolean enabled() {
                return true;
            }

            @Override
            public RepositoryType logRepository() {
                return RepositoryType.MONGODB;
            }

            @Override
            public CacheProviderType cacheProvider() {
                return CacheProviderType.GUAVA;
            }

            @Override
            public Modelling modelling() {
                return Modelling.ACCUMULATION;
            }

            @Override
            public long expiryInterval() {
                return 5;
            }

            @Override
            public long firstExpiry() {
                return 5;
            }

            @Override
            public long analysisInterval() {
                return 5;
            }

            @Override
            public long firstAnalysis() {
                return 2;
            }

            @Override
            public TriggerType triggerType() {
                return TriggerType.TIME;
            }

            @Override
            public long triggerTime() {
                return 5;
            }

            @Override
            public boolean analyzerEnabled() {
                return true;
            }

            @Override
            public boolean disableMonitoringAfterAnalysis() {
                return false;
            }

            @Override
            public boolean traceAsync() {
                return true;
            }

            @Override
            public boolean clearMonitoringDataOnStart() {
                return false;
            }

            @Override
            public boolean enableBlacklist() {
                return false;
            }

            @Override
            public boolean tracerEnabled() {
                return true;
            }

            @Override
            public boolean analyzeOnce() {
                return false;
            }
        };
        Analyzer analyzer = new Analyzer(repositorySource, null, cacheMonitor.getCacheInfo(), adaptiveCaching);

        //TODO trigger by time?
        analyzer.run();
    }
}
