package br.ufrgs.inf.prosoft.tigrisframework.annotations;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface Criteria {

    /**
     * Criteria in form of SET operations over the criteria.
     *
     * Operations allowed: union (U), intersection (I), difference (D), complement (C)
     * Verbs: frequent, expensive, changeable, errorprone, globalimpact
     * Additional: more, less
     *
     * Examples:
     * more frequent U more expensive C less changeable
     * less frequent C less expensive
     */
    String value() default "";
}
