Usage

Setting up RUBiS is a fairly involving task. It requires installing a web server, a database server and initializing the database, the latter being done using a Java-based user emulator. Furthermore, to make precise performance measurements, you need to make sure that the obtained deployment does not feature "noise", such as cron jobs firing up unexpectedly. If you want to go through this exercise by yourself, you may do so by following the RUBiS installation guide.

However, we recommend you to contact us, so we can provide you with ready-to-use Xen VM images, of about 16GB, based on Ubuntu 12.04.3 LTS. Even if you are using a different hypervisor or prefer using a different operating system, starting from these VM images may save you a lot of time.

For questions or comments, please contact Cristian Klein firstname.lastname@cs.umu.se.




Server Side

1. LAMP setting: LAMP (Linux + apache2 + MySQL + PHP5) settings

2. RUBiS database setup

$ cd /Your_RUBiS_Directory/database
$ mysql -u root –password=’Your password’
mysql> source rubis.sql;
mysql> source categories.sql;
mysql> source regions.sql;
mysql> GRANT ALL ON rubis.* TO ‘rubis’@’%’ IDENTIFIED BY ‘rubis’;
mysql> GRANT ALL ON rubis.* TO ‘rubis’@’localhost’ IDENTIFIED BY ‘rubis’;

3. Modify files: ‘generate_categories.awk ‘ and ‘generate_regions.awk’

Change ‘/bin/awk’ to ‘/usr/bin/awk’ in the first line respectively.

4. Execute files: ‘generate_categories.awk ‘ and ‘generate_regions.awk’

$ ./generate_categories.awk ebay_full_categories.txt
$ ./generate_regions.awk ebay_regions.txt
5. MySQL server setting

Comment the following line in /etc/mysql/my.cnf file.
# bind-address       = 127.0.0.1

/etc/init.d/mysql restart



Run servlets with: mvn clean package tomcat7:run




 Install Java.

$ apt-get install sun-java6-jdk

———————–
NOTE: If you are using Debian, and see the message like ‘there is no package named sun-java6-jdk’, then add a line similar to below line in /etc/apt/sources.list
deb http://ftp.pl.debian.org/debian/ squeeze non-free
which is: deb http://ftp.(your country).debian.org/debian (OS Name) non-free
Type $ apt-get update
and try again.
———————–

Add two lines to file ‘/etc/environments’

CLASSPATH=.:/usr/lib/jvm/java-6-sun/lib
JAVA_HOME=/usr/lib/jvm/java-6-sun

Add a following location to the first line of ‘/etc/jvm’ (If the file does not exist, then make it).

/usr/lib/jvm/java-6-sun

And type

$ update-java-alternatives -s java-6-sun

2. Build Client

In /Your_RUBiS_Directory/, type
$ make client

3. Modify your rubis.properties file in ‘/Your_RUBiS_Directory/Client/’. The following texts are from rubis.properties file. Find ‘###’ lines and modify them.

# HTTP server information
### httpd_hostname = sci23
httpd_hostname = 143.248.151.130
httpd_port = 80

# C-JDBC server information
cjdbc_hostname =

# Precise which version to use. Valid options are : PHP, Servlets, EJB
### httpd_use_version = EJB
httpd_use_version = PHP

ejb_server = sci20
ejb_html_path = /ejb_rubis_web
ejb_script_path = /ejb_rubis_web/servlet

servlets_server = sci21
servlets_html_path = /Servlet_HTML
servlets_script_path = /servlet

php_html_path = /PHP
php_script_path = /PHP

# Workload: precise which transition table to use
workload_remote_client_nodes =
workload_remote_client_command = /usr/local/java/jdk1.3.1/bin/java -classpath RUBiS edu.rice.rubis.client.ClientEmulator
### workload_number_of_clients_per_node = 240
workload_number_of_clients_per_node = 300

### workload_transition_table = /users/margueri/RUBiS/workload/transitions.txt
workload_transition_table = /root/RUBiS/workload/transitions.txt
workload_number_of_columns = 27
workload_number_of_rows = 29
workload_maximum_number_of_transitions = 1000
workload_number_of_items_per_page = 20
workload_use_tpcw_think_time = yes
workload_up_ramp_time_in_ms = 120000
workload_up_ramp_slowdown_factor = 2
### workload_session_run_time_in_ms = 900000
workload_session_run_time_in_ms = 300000
workload_down_ramp_time_in_ms = 60000
workload_down_ramp_slowdown_factor = 3
#Database information
### database_server = sci22
database_server = 143.248.151.130

# Users policy
database_number_of_users = 1000000

# Region & Category definition files
### database_regions_file = /users/margueri/RUBiS/database/ebay_regions.txt
### database_categories_file = /users/margueri/RUBiS/database/ebay_simple_categories.txt
database_regions_file = /root/RUBiS/database/ebay_regions.txt
database_categories_file = /root/RUBiS/database/ebay_simple_categories.txt
# Items policy
### database_number_of_old_items = 1000000
database_number_of_old_items = 10000
database_percentage_of_unique_items = 80
database_percentage_of_items_with_reserve_price = 40
database_percentage_of_buy_now_items = 10
database_max_quantity_for_multiple_items = 10
### database_item_description_length = 8192
database_item_description_length = 512

# Bids policy
database_max_bids_per_item = 20

# Comments policy
database_max_comments_per_user = 20
### database_comment_max_length = 2048
database_comment_max_length = 256
# Monitoring Information
monitoring_debug_level = 1
monitoring_program = /usr/bin/sar
monitoring_options = -n DEV -n SOCK -rubcw
monitoring_sampling_in_seconds = 1
monitoring_rsh = /usr/bin/ssh
monitoring_scp = /usr/bin/scp
### monitoring_gnuplot_terminal = jpeg
monitoring_gnuplot_terminal = png

3. Initiate DB

Type: ‘$ make initDB PARAM=all’
It takes quite a time! It should work out successfully saying “Done”.

4. Preparation for running the emulator

Before starting emulation, make sure that you can login to ssh automatically to server and client.
$ ssh-keygen -t rsa
And press enter until the end.
$ cat ~/.ssh/id_rsa.pub >> ~/.ssh/authorized_keys
$ scp ~/.ssh/id_rsa.pub <server host>:~/.ssh/
Connect to server via ssh, and
$ cat ~/.ssh/id_rsa.pub >> ~/.ssh/authorized_keys

– Also before emulation, make sure all .awk files in bench directory should be fixed from /bin/awk to /usr/bin/awk
$ cd /Your_RUBiS_Directory/bench
$ find . -type f -print0 | xargs -0 sed -i ‘s/\/bin\/awk/\/usr\/bin\/awk/g’

Finally before emulation, make sure sysstat, which include sar, is installed. But, parsing program depends on sar’s version.
8.0.3 version is safe, but 8.1.7 is not parsed. In order to tell what the version is, type: $ sar -V

5. Start emulation

In your RUBiS directory, type
$ make emulator

There will be no status messages while it is being executed.
You can see the result in /Your_RUBiS_Directory/bench/2012-9-3….(Time of the execution)/.

6. If you want to change workloads

Edit /Your_RUBiS_Directory/Client/rubis.properties
This line: workload_transition_table = /root/RUBiS/workload/transitions.txt
You can set any file name of /Your_RUBiS_Directory/workload




Access http://localhost:8080/rubis_servlets/

Run workloads:
cd Client
make client
make emulator
#Set up rubis.properties and workload/transitions.txt


RUBiS
=====

A java and PHP implementation of the _Rice University Bidding System_ (RUBiS).

RUBiS is a free, open source initiative.
This implementation is a fork of version 1.4.3 of [OW2 RUBiS](http://rubis.ow2.org).
As of 2012, the original 1.4.3 version can still be downloaded at the [OW2 site](http://forge.objectweb.org/project/showfiles.php?group_id=44)


## Overview

RUBiS is an auction site prototype modeled after [eBay](http://www.ebay.com/) site (one of the largest online marketplace) that is especially used to evaluate application design patterns and application servers performance scalability.

The auction site benchmark implements the core functionality of an auction site: selling, browsing and bidding.
Complementary services like instant messaging or newsgroups are not currently implemented.
There are three kinds of user sessions: visitor, buyer, and seller.
For a visitor session, users need not register but are only allowed to browse.
Buyer and seller sessions require registration.
In addition to the functionality provided during visitor sessions, during a buyer session users can bid on items and consult a summary of their current bids, rating and comments left by other users.
Seller sessions require a fee before a user is allowed to put up an item for sale.
An auction starts immediately and lasts typically for no more than a week.
The seller can specify a reserve (minimum) price for an item.


## Comparison with OW2 RUBiS

In the _OW2 RUBiS_, several versions of RUBiS are implemented by using three different technologies: PHP, Java servlets and Enterprise Java Bean (EJB).
The main purpose is to compare the trade-off between performance and complexity obtained with these technologies, as shown in the paper [(Checchet et al.,2002)][checchet-2002-performance].

In our implementation, unlike the OW2 one, we do not focus on the performance evaluation of different technologies and design patterns.
Instead, our aim is to provide a fully functional implementation that can be used to benchmark real computing systems and evaluate their performance.
Most of the changes will focus on stability and improvements to the original OW2 version.

For these reasons, currently we only provide an implementation based on Java servlets and on PHP.

## Compile and Install

### Precompilation Steps

Also, you need to setup the RUBiS database.
If you use MySQL, you can perform the following steps.

1. Log in to the DB server

2. Add the `rubis` user:

	$ mysql -uroot mysql

	mysql> CREATE USER 'rubis'@'%' IDENTIFIED BY 'rubis';

	mysql> GRANT ALL PRIVILEGES ON *.* TO 'rubis'@'%' IDENTIFIED BY 'rubis' WITH GRANT OPTION;

	mysql> CREATE USER 'rubis'@'localhost' IDENTIFIED BY 'rubis';

	mysql> GRANT ALL PRIVILEGES ON *.* TO 'rubis'@'localhost' IDENTIFIED BY 'rubis' WITH GRANT OPTION;

	mysql> exit;

Finally, you have to check possible firewall settings on both Web and DB server in order to enable the Web and DB server to accept remote connections.
For instance, if you use Apache Tomcat and MySQL, you typically need to instruct the Web server firewall to accept TCP connections on the 8080 port, and the DB server firewall to accept TCP connections on the 3306 port.

### Compilation Steps

In the following we refer to the variable `$RUBIS_HOME` as a variable containing the path pointing to this version of RUBiS.

#### PHP Incarnation

No compilation is required.
You only need to copy the `$RUBIS_HOME/php` directory to the document root of your Web Server and properly configure it.
For instance, if you use the Apache HTTPD 2 server under Linux, the document root is typically located in `/var/www`.
So, you only need to copy the `$RUBIS_HOME/php` directory to `/var/www/`.
For instance:

	$ mkdir -p /var/www/rubis
	$ cp -r $RUBIS_HOME/php /var/www/rubis/PHP

#### Java Servlets Incarnation

To compile the Java Servlets incarnation of RUBiS you need Java &ge; 1.5 and [Apache Ant](http://ant.apache.org).
To run RUBiS you need a Java Servlet container &ge; 2.5, like [Apache Tomcat](http://tomcat.apache.org), and a DBMS like [MySQL](http://www.mysql.com).

While the code should compile and run fine with every J2EE container and DBMS, we have currently tested it only with Apache Tomcat 6 and MySQL 5.6.\* (with MySQL Connector/J 5.0.\*).

1. Move to the `$RUBIS_HOME` directory.

	$ cd $RUBIS_HOME

2. Copy the template property file `setup/user.properties.template` to file `user.properties`

	$ cp setup/user.properties.template user.properties

3. Edit the file `user.properties` to set properties to a proper value (e.g., if you use Apache Tomcat this is the same of `$CATALINA_HOME`).

	$ vi user.properties

4. Move to the `servlets` directory.

	$ cd servlets

5. Edit the file `src/java/edu/rice/rubis/servlets/Config.java` to set the following properties
 * `J2eeContainerPath`: this is the path to the J2EE container (e.g., if you use Apache Tomcat this is the same of `$CATALINA_HOME`).
 * `DatabaseConnectionStrategy`: this is the type of strategy you want to use to connect to the database.
   You can choose among the following values:
   - `UNPOOLED_DRIVERMANAGER_DB_CONNECTION_STRATEGY`: don't use connection pooling and connect to the database by means the `java.sql.DriverManager` class.
   - `POOLED_DRIVERMANAGER_DB_CONNECTION_STRATEGY`: use connection pooling and connect to the database by means the `java.sql.DriverManager` class.
   - `DATASOURCE_DB_CONNECTION_STRATEGY`: setup and manage database connections by means of `javax.sql.DataSource` class (recommended).

6. Edit the database properties
   - If you chose `DATASOURCE_DB_CONNECTION_STRATEGY` as database connection strategy, you have to edit the context file to set properties to a proper value:

     $ vi web/META-INF/context.xml

   - Otherwise, if you chose either `UNPOOLED_DRIVERMANAGER_DB_CONNECTION_STRATEGY` or`POOLED_DRIVERMANAGER_DB_CONNECTION_STRATEGY` as database connection strategy, you have to create a property file in `src/conf/dbms.property` directory (optionally, replace `dbms` with the name of your DBMS).
     For instance, if you use MySQL you can edit the file `src/conf/mysql.properties` to set properties to a proper value (e.g., the host name where the DBMS runs).

	 $ vi src/conf/mysql.properties

     Then you have to edit the file `src/java/edu/rice/rubis/servlets/Config.java` and change the value of `DatabaseProperties` to point to the name of your `dbms.property` file.
     If you use MySQL, you can use the default value.

7. Copy the JAR file of the JDBC database driver in `$RUBIS_HOME/lib`.
   For instance, if you use MySQL you have to copy the Connector/J JAR file in that location (we assume that you have already download and unpacked the Connector/J binary package in `/tmp/mysql-connector-java-5.1.25`):

   $ mkdir -p $RUBIS\_HOME/lib

   $ cp /tmp/mysql-connector-java-5.1.25/mysql-connector-java-5.1.25-bin.jar lib/

8. Run Ant:

	$ ant clean all

9. Copy the WAR file to your container.
   For instance, if you use Apache Tomcat:

   $ cp dist/rubis\_servlets.war $CATALINA\_HOME/webapps/

10. Try to connect to the RUBiS web application by pointing your browser at the RUBiS home page.
    For instance:

   $ elinks localhot:8080/rubis\_servlets


## References

[checchet-2002-performance]: _Emmanuel Cecchet, Julie Marguerite and Willy Zwaenepoel_, __Performance and Scalability of EJB Applications__. In Proc. of the OOPSLA'02, Seattle, WA, USA, Nov. 4-8, 2002
