package br.ufrgs.inf.prosoft.adaptivecaching.analysis;

import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.FlowchartWorkFlow;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model.MethodEntry;
import br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.stats.CacheabilityMetrics;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCacheManager;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.TriggerType;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.TracerAspect;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheInfo;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.vendors.guava.GuavaMonitor;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.providers.MongoRepository;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;
import br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics.LightweightAnalyzer;
import br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics.LightweightMetricAspect;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Analyzer implements Runnable {

    public static Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private final AdaptiveCaching adaptiveConfig;
    private Repository dataSource;
    private Repository dataTarget;
    private CacheInfo cacheInfo;

    public Analyzer(Repository dataSource, Repository dataTarget, CacheInfo cacheInfo, AdaptiveCaching adaptiveConfig) {
        this.dataSource = dataSource;
        this.dataTarget = dataTarget;
        this.cacheInfo = cacheInfo;
        this.adaptiveConfig = adaptiveConfig;
    }

    public Analyzer(Repository dataSource, CacheInfo cacheInfo, AdaptiveCaching adaptiveConfig) {
        this.dataSource = dataSource;
        this.cacheInfo = cacheInfo;
        this.adaptiveConfig = adaptiveConfig;
    }

    @Override
    public void run() {

        if (!TracerAspect.analyzerEnabled) {
            logger.info("Analyzer disabled, not running...");
            return;
        }

        List all = dataSource.findAll();

        //TODO trigger by number of logs
        //here we can check whether there are enough logs to process, such as
        //if(all.size() < 300) return;

        Set<MethodEntry> process = analyzeAndReturn(all);

        //if there is a repository to save cacheable values
        if (dataTarget != null) {
            dataTarget.removeAll();
            process.forEach(dataTarget::save);
        }

        //todo maybe clean the cache here?
        TracerAspect.cacheableMethods = process;
        TracerAspect.cacheableMethodKeys = process.stream().parallel().map(MethodEntry::getMethodInfoKey).collect(Collectors.toSet());

        String methods = "";
        for (MethodEntry me : process) methods = methods.concat(me.getMethodInfo().getSignature() + ",");

        //TODO maybe after the analysis end, new data would be already registered, which should not be deleted
        if (adaptiveConfig.modelling().equals(Modelling.FULLEXPLORATION)) {
            dataSource.removeAll();
            logger.info("Old monitoring data deleted.");
        }

        if (adaptiveConfig.analyzeOnce())
            TracerAspect.analyzerEnabled = false;
    }


    public Set<MethodEntry> analyzeAndReturn(List<LogTrace> logList) {
        logger.info("Starting the analysis of cacheable methods from logs: " + logList.size() + " loaded.");

        FlowchartWorkFlow workflow = new FlowchartWorkFlow(cacheInfo, logList);
        Set<MethodEntry> process = workflow.filterCacheableMethods(adaptiveConfig.expiryInterval());
        logger.info(process.size() + " cacheable methods identified.");

        //TODO find by annotations @Ignore and remove the methods marked

        //if disable monitoring, should not schedule future analysis
        if (adaptiveConfig.disableMonitoringAfterAnalysis()) {
            TracerAspect.tracerEnabled = false;
            logger.info("Adaptive caching monitoring disabled since the model was built.");
        }

        return process;
    }
}
