package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache;

import java.util.Calendar;

public class CacheInfo {

    private Long numberOfObjects;

    private Long usedSpace;

    private Long totalSpace;

    private long currentTime;

    //TODO maybe it would be necessary a var to expired keys, which are different from evicted keys (redis has, memcached not)
    private Long evictedKeys;
    private Long keyspaceHits;
    private Long keyspaceMisses;

    //TODO rewrite it to each cache provider
    public CacheInfo() {
        this.currentTime = Calendar.getInstance().getTimeInMillis();
    }

    public Long getFreeSpace() {
        long freeSpace = totalSpace - usedSpace;
        return (freeSpace > 0) ? freeSpace : 1;
    }

    public Long getNumberOfObjects() {
        return numberOfObjects;
    }

    public void setNumberOfObjects(Long numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
    }

    //used space can be in bytes or in number of elements
    public Long getUsedSpace() {
        return usedSpace;
    }

    //used space can be in bytes or in number of elements
    public void setUsedSpace(Long usedSpace) {
        this.usedSpace = usedSpace;
    }

    //total space can be in bytes or in number of elements
    public Long getTotalSpace() {
        return totalSpace;
    }

    //total space can be in bytes or in number of elements
    public void setTotalSpace(Long totalSpace) {
        this.totalSpace = totalSpace;
    }

    public Long getEvictedKeys() {
        return evictedKeys;
    }

    public void setEvictedKeys(Long evictedKeys) {
        this.evictedKeys = evictedKeys;
    }

    public Long getKeyspaceHits() {
        return keyspaceHits;
    }

    public void setKeyspaceHits(Long keyspaceHits) {
        this.keyspaceHits = keyspaceHits;
    }

    public Long getKeyspaceMisses() {
        return keyspaceMisses;
    }

    public void setKeyspaceMisses(Long keyspaceMisses) {
        this.keyspaceMisses = keyspaceMisses;
    }

    public double averageObjectSize() {
        return getUsedSpace() / getNumberOfObjects();
    }

    public double hitRatio() {
        return getKeyspaceHits() / getKeyspaceTotalRequests();
    }

    public double missRatio() {
        return getKeyspaceMisses() / getKeyspaceTotalRequests();
    }

    public Long getKeyspaceTotalRequests() {
        return keyspaceHits + keyspaceMisses;
    }

    public long getCurrentTime() {
        return currentTime;
    }

    @Override
    public String toString() {
        return "CacheInfo{" +
                "numberOfObjects=" + numberOfObjects +
                ", usedSpace=" + usedSpace +
                ", totalSpace=" + totalSpace +
                ", currentTime=" + currentTime +
                ", evictedKeys=" + evictedKeys +
                ", keyspaceHits=" + keyspaceHits +
                ", keyspaceMisses=" + keyspaceMisses +
                '}';
    }
}
