package br.ufrgs.inf.prosoft.adaptivecaching.sampling.adaptation;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import java.lang.management.ManagementFactory;

public class ResourceUsage {
    private static String generateRAM()
    {
        final long RAM_TOTAL = Runtime.getRuntime().totalMemory();
        final long RAM_FREE = Runtime.getRuntime().freeMemory();
        final long RAM_USED = RAM_TOTAL - RAM_FREE;
        final long RAM_TOTAL_MB = RAM_TOTAL / 1024 / 1024;
        final long RAM_FREE_MB = RAM_FREE  / 1024 / 1024;
        final double RAM_USED_MB = (double) RAM_USED / 1024 / 1024;
        final double RAM_USED_PERCENTAGE = ((double) RAM_USED / RAM_TOTAL) * 100;
        return RAM_TOTAL_MB + "MB TOTAL / " + RAM_FREE_MB + "MB FREE / " + RAM_USED_MB + "MB USED (" + RAM_USED_PERCENTAGE + "%)";
    }

    public static double getProcessCpuLoad() throws Exception {

        MBeanServer mbs    = ManagementFactory.getPlatformMBeanServer();
        ObjectName name    = ObjectName.getInstance("java.lang:type=SystemCpuLoad");
        AttributeList list = mbs.getAttributes(name, new String[]{ "ProcessCpuLoad" });

        if (list.isEmpty())     return Double.NaN;

        Attribute att = (Attribute)list.get(0);
        Double value  = (Double)att.getValue();

        // usually takes a couple of seconds before we get real values
        if (value == -1.0)      return Double.NaN;
        // returns a percentage value with 1 decimal point precision
        return ((int)(value * 1000) / 10.0);
    }

//    import org.ehcache.sizeof.SizeOf;
//    private static SizeOf sizeOf = SizeOf.newInstance();
//    sizeOf.sizeOf(methodInfo.getReturnedValue());
}
