package br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics;

import br.ufrgs.inf.prosoft.adaptivecaching.sampling.statistics.StatisticalTest;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashSet;
import java.util.Set;

public class LightweightAnalyzer implements Runnable {

    static Logger logger = LoggerFactory.getLogger(LightweightAnalyzer.class);

    public static Set<String> allowedFineGrained = new HashSet<>();

    public static void analyze() {

        logger.info("Analyzing {} lightweight methods for relevance", LightweightMetricAspect.metrics.size());

        DescriptiveStatistics frequencies = new DescriptiveStatistics();
        DescriptiveStatistics changeabilities = new DescriptiveStatistics();
        DescriptiveStatistics errorprones = new DescriptiveStatistics();
        DescriptiveStatistics latencies = new DescriptiveStatistics();
        DescriptiveStatistics maintainabilities = new DescriptiveStatistics();
        DescriptiveStatistics userBehaviors = new DescriptiveStatistics();
        DescriptiveStatistics concurrencies = new DescriptiveStatistics();
        DescriptiveStatistics expensiveness = new DescriptiveStatistics();
        DescriptiveStatistics globalimpact = new DescriptiveStatistics();
        for (String method : LightweightMetricAspect.metrics.keySet()) {
            LightweightMetrics sc = LightweightMetricAspect.metrics.get(method);
            frequencies.addValue(sc.getFrequency());
            changeabilities.addValue(sc.getChangeability());
            errorprones.addValue(sc.getStaticErrorprone());
            latencies.addValue(sc.getLatency());
            maintainabilities.addValue(sc.getMaintainability());
            userBehaviors.addValue(sc.getUserBehavior());
            concurrencies.addValue(sc.getConcurrency());
            expensiveness.addValue(sc.getExpensiveness());
            globalimpact.addValue(sc.getGlobalImpact());

//            System.out.print(sc.getFrequency() + ",");
        }

        System.out.println("---------------------------");
        System.out.println("Metric: frequency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(frequencies.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: maintainability; Distribution: " +
                ((StatisticalTest.isNormalDistribution(maintainabilities.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: changeability; Distribution: " +
                ((StatisticalTest.isNormalDistribution(changeabilities.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: userBehavior; Distribution: " +
                ((StatisticalTest.isNormalDistribution(userBehaviors.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: concurrency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(concurrencies.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: errorprone; Distribution: " +
                ((StatisticalTest.isNormalDistribution(errorprones.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: expensiveness; Distribution: " +
                ((StatisticalTest.isNormalDistribution(expensiveness.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: globalimpact; Distribution: " +
                ((StatisticalTest.isNormalDistribution(globalimpact.getValues(), 0.05)) ? "normal" : "not_normal"));
        System.out.println("Metric: latency; Distribution: " +
                ((StatisticalTest.isNormalDistribution(latencies.getValues(), 0.05)) ? "normal" : "not_normal"));

        //cleaning selected methods
        allowedFineGrained = new HashSet<>();

        //TODO precess SET operations dynamically
//        LightweightMetricAspect.criteriaDSL

//        //Example: more frequent I more expensive
//        for (String method : LightweightMetricAspect.metrics.keySet()) {
//            LightweightMetrics sc = LightweightMetricAspect.metrics.get(method);
//
//            logger.info("Testing {} with frequency {} and expensiveness {}", sc
//                    , frequencies.getMean() + frequencies.getStandardDeviation()
//                    , expensiveness.getMean() + expensiveness.getStandardDeviation());
//            if (sc.getFrequency() > (frequencies.getMean() + frequencies.getStandardDeviation())
//                    && sc.getExpensiveness() > (expensiveness.getMean() + expensiveness.getStandardDeviation()))
//                allowedFineGrained.add(sc.getLongName());
//        }

        //Example: more frequent U more expensive
        for(String method : LightweightMetricAspect.metrics.keySet()) {
            LightweightMetrics sc = LightweightMetricAspect.metrics.get(method);
            if(sc.getFrequency() > (frequencies.getMean() + frequencies.getStandardDeviation())
                    || sc.getExpensiveness() > (expensiveness.getMean() + expensiveness.getStandardDeviation()))
                allowedFineGrained.add(sc.getLongName());
        }

        logger.info("Selected methods for fine-grained: {}", allowedFineGrained);

//
//        //Example: less frequent
//        for(String method : LightweightMetricAspect.metrics.keySet()) {
//            LightweightMetrics sc = LightweightMetricAspect.metrics.get(method);
//            if(sc.getFrequency() < (frequencies.getMean() - frequencies.getStandardDeviation()))
//                allowedFineGrained.add(sc.getLongName());
//        }
//
//        //Example: frequent
//        for(String method : LightweightMetricAspect.metrics.keySet()) {
//            LightweightMetrics sc = LightweightMetricAspect.metrics.get(method);
//            if(sc.getFrequency() >= (frequencies.getMean() - frequencies.getStandardDeviation())
//                    && sc.getFrequency() <= (frequencies.getMean() + frequencies.getStandardDeviation()))
//                allowedFineGrained.add(sc.getLongName());
//        }

    }

    @Override
    public void run() {
        logger.info("Lightweight calculating metrics and updating coarse-monitoring into {} methods...", allowedFineGrained);
        analyze();
    }
}
