package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.vendors.ehcache;

import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.ehcache.EhCacheCache;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheInfo;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.cache.CacheMonitor;
import net.sf.ehcache.Ehcache;

public class EhCacheMonitor implements CacheMonitor {

    private EhCacheCache cache;

    public EhCacheMonitor(EhCacheCache cache) {
        this.cache = cache;
    }

    @Override
    public CacheInfo getCacheInfo() {

        Ehcache ehcache = this.cache.getNativeCache();

        //CacheStatistics statistics = new CacheStatistics(this.cache.getNativeCache());

//        final StatisticsGateway statisticsGateway = cache.getNativeCache().getStatistics();

        CacheInfo cacheInfo = new CacheInfo();

        //TODO see how to deal with disk, we are not dealing with it
        //TODO there are a lot of ways to set maximum space in ehcache: maxentries, maxelements, maxbytes
        //TODO there are a lot of spaces to store data in ehcache: localheap, localdisk, remote, localheapoff
        cacheInfo.setTotalSpace(ehcache.getCacheConfiguration().getMaxEntriesLocalHeap());
        cacheInfo.setUsedSpace(ehcache.getStatistics().getSize());
        cacheInfo.setEvictedKeys(ehcache.getStatistics().cacheEvictedCount());
        cacheInfo.setKeyspaceHits(ehcache.getStatistics().cacheHitCount());
        cacheInfo.setKeyspaceMisses(ehcache.getStatistics().cacheMissCount());
        cacheInfo.setNumberOfObjects(ehcache.getStatistics().getSize());

        return cacheInfo;
    }
}
