package br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics;

import br.ufrgs.inf.prosoft.adaptivecaching.sampling.statistics.StatisticalTest;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class DataFiltering {

    public static boolean isGroup(String group, DescriptiveStatistics criteria, double value){

        boolean isNormal = StatisticalTest.isNormalDistribution(criteria.getValues(), 0.05);
        DescriptiveStatistics half = new DescriptiveStatistics();
        if(!isNormal && (group.equals("most") || group.equals("least"))) {
            for(double val : criteria.getValues())
                if(group.equals("most") && val >= criteria.getPercentile(75))
                    half.addValue(val);
                else if(group.equals("least") && val <= criteria.getPercentile(25))
                    half.addValue(val);
        }

        switch (group){
            case "normal":
                if (isNormal)
                    return (value >= (criteria.getMean() - criteria.getStandardDeviation()) &&
                            value <= (criteria.getMean() + criteria.getStandardDeviation()));
                else
                    return (value >= criteria.getPercentile(25) &&
                            value <= criteria.getPercentile(75));
            case "more":
                if (isNormal)
                    return value >= (criteria.getMean() + criteria.getStandardDeviation());
                else
                    return value >= criteria.getPercentile(75);
            case "less":
                if (isNormal)
                    return value <= (criteria.getMean() - criteria.getStandardDeviation());
                else
                    return value <= criteria.getPercentile(25);
            case "most":
                if (isNormal)
                    return value >= (criteria.getMean() + (2*criteria.getStandardDeviation()));
                else
                    return value >= half.getPercentile(50);
            case "least":
                if (isNormal)
                    return value <= (criteria.getMean() + (2*criteria.getStandardDeviation()));
                else
                    return value <= half.getPercentile(50);
        }

        throw new RuntimeException("Não foi possível classificar...");
    }


    //
//        //Example: less frequent
//        for(String method : LightweightMetricAspect.metrics.keySet()) {
//            LightweightMetrics sc = LightweightMetricAspect.metrics.get(method);
//            if(sc.getFrequency() < (frequencies.getMean() - frequencies.getStandardDeviation()))
//                allowedFineGrained.add(sc.getLongName());
//        }
//
//        //Example: frequent
//        for(String method : LightweightMetricAspect.metrics.keySet()) {
//            LightweightMetrics sc = LightweightMetricAspect.metrics.get(method);
//            if(sc.getFrequency() >= (frequencies.getMean() - frequencies.getStandardDeviation())
//                    && sc.getFrequency() <= (frequencies.getMean() + frequencies.getStandardDeviation()))
//                allowedFineGrained.add(sc.getLongName());
//        }


    //Example: more frequent U more expensive
//        if(DataFiltering.isGroup("more", frequencies, sc.getFrequency())
//                || DataFiltering.isGroup("more", expensiveness, sc.getFrequency()))
//            allowedFineGrained.add(sc.getLongName());
}
