package br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics;

import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.util.threads.NamedThreads;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.adaptivecaching.exceptions.ConfigurationException;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.TracerAspect;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.usersession.UserGetter;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.usersession.UserGetterFactory;
import br.ufrgs.inf.prosoft.adaptivecaching.sampling.annotations.Criteria;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import static java.lang.System.currentTimeMillis;

//@Aspect
public class LightweightMetricAspect {

//    public static boolean enabled = true;

//    @Pointcut(
//            //any execution except the own framework
//            "(execution(!void *(..)) && !within(br.ufrgs.inf.prosoft.adaptivecaching..*) " +
//            //avoid calls from repository while serializing objects, it is necessary if a hash could not be used
//            "&& !cflow(call(* br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage..*(..)))" +
//            //conditional to enable and disable at runtime
//            "&& if())"
//    )
//    public static boolean anyCall() {
//        return enabled;
//    }

    Logger logger = LoggerFactory.getLogger(LightweightMetricAspect.class);

//    private final ScheduledExecutorService analyzerExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreads(
//            "lightweight-analyzer",
//            "computing lightweight metrics and setting allowedmethods"
//    ));

//    public static Map<String, LightweightMetrics> metrics;
    private UserGetter userGetter;

    //traceable configuration
    private String[] allowed;
    private String[] notAllowed;

//    public static String criteriaDSL = "";

    public LightweightMetricAspect() {
//        metrics = new HashMap<>();
        userGetter = UserGetterFactory.getInstance();

//        Class<?> configClass = getAvailableConfigurationClass();

        //getting criteria DSL
//        Criteria criteria = configClass.getAnnotation(Criteria.class);
//        criteriaDSL = criteria.value();

        //getting allowed packages from @ComponentScan
//        ComponentScan componentScanConfig = configClass.getAnnotation(ComponentScan.class);
//        if (componentScanConfig == null) {
//            //if not specified, it assumes the same package where @AdaptiveCaching were declared
//            allowed = new String[]{configClass.getPackage().getName()};
//            //logger.error("ComponenScan for AdaptiveCaching not found, adaptive caching disabled.");
//            //enabled = false;
//            //return;
//        }
//        allowed = componentScanConfig.allowed();
//        notAllowed = componentScanConfig.denied();
        logger.info("Lightweight monitoring will trace methods into {} packages...", allowed);

//        if(enabled)
//            analyzerExecutor.scheduleWithFixedDelay(
//                new LightweightAnalyzer(),
//                60000, 450000, TimeUnit.MILLISECONDS);

//        TracerAspect.enabled = false;
    }

//    @Around("anyCall()")
    public Object aroundMethods(ProceedingJoinPoint joinPoint) throws Throwable {

//        if (!isAllowed(joinPoint))
//            return joinPoint.proceed();

        String signature = joinPoint.getSignature().toString();

//        LightweightMetrics metric = metrics.get(signature);
//        if (metric != null)
//            metric.incOccurrence();
//        else {
//            String name = joinPoint.getSignature().toString().split(" ")[1];
//            name = name.substring(0, name.indexOf("("));
//            metric = new LightweightMetrics(name, joinPoint.getSignature().toLongString());
//            metric.incOccurrence();
//            if(TracerAspect.analyzerEnabled)
//                metrics.put(signature, metric);
//        }

        //values are given in bytes, divide by 1000000 to get values in MB.
//        Runtime runtime = Runtime.getRuntime();
//        long startMemory = runtime.totalMemory() - runtime.freeMemory();
        long startTime = currentTimeMillis();
//        long startThread = java.lang.Thread.activeCount();

        Object result = joinPoint.proceed();

        long endTime = currentTimeMillis();
//        metric.addTime(startTime, endTime - startTime);
//        long endMemory = runtime.totalMemory() - runtime.freeMemory();
//        metric.addMemoryConsumption(endMemory - startMemory);
//        long endThread = java.lang.Thread.activeCount();
//        metric.addThreadNumber(endThread - startThread);
//        metric.addReturnSize(result);
//        metric.addUser(userGetter.getCurrentUser());

        return result;
    }

//    @AfterThrowing(pointcut = "anyCall()", throwing = "e")
//    public void myAfterThrowing(JoinPoint joinPoint, Throwable e) {
//        String signature = joinPoint.getSignature().toString();
//        LightweightMetrics metric = metrics.get(signature);
//        metric.incThrown();
//    }
}
