package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.providers;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;
import org.redisson.Redisson;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;

import java.util.List;

public class RedisRepository<T> implements Repository<T> {

    private final RedissonClient redisson;
    private final RList<T> traces;

    public RedisRepository(){
        redisson = Redisson.create();

        //Map<String, CacheConfig> config = new HashMap<String, CacheConfig>();
        // create "testMap" cache with ttl = 24 seconds and maxIdleTime = 12 seconds
        //config.put("testMap", new CacheConfig(24*60*1000, 12*60*1000));

        traces = redisson.getList("tracer");
    }

    @Override
    public void save(T t) {
        traces.add(t);
        //RBucket<T> bucket = redisson.getBucket("anyObject");
        // set an object
        //bucket.setAsync(t);
    }

    @Override
    public List<T> findAll() {
        return traces.readAll();
    }

    @Override
    public void removeAll() {
        traces.clearExpireAsync();
    }

    @Override
    public void saveAll(List<T> toSave) {
        traces.addAll(toSave);
    }
}
