package br.ufrgs.inf.prosoft.adaptivecaching.sampling.metrics;


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StaticMetrics {

    private Map<String, StaticMetric> metrics;

    public StaticMetrics(String filename) throws IOException {
        loadMetrics(filename);
    }

    public StaticMetric getMetrics(String method){
        return metrics.get(method);
    }

    public void loadMetrics(String filename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String line = null;
        metrics = new HashMap<>();

        while ((line = br.readLine()) != null) {
            if (line.contains("Kind")) continue;
            String str[] = line.split(",");
            metrics.put(str[1], new StaticMetric(Long.valueOf(str[2]), Long.valueOf(str[3]), Long.valueOf(str[4])));
        }
    }

    public Map<String, StaticMetric> getAllMetrics() {
        return metrics;
    }

    class StaticMetric {
        public long countOutput;
        public long cyclomatic;
        public long maxNesting;

        public StaticMetric(long countOutput, long cyclomatic, long maxNesting) {
            this.countOutput = countOutput;
            this.cyclomatic = cyclomatic;
            this.maxNesting = maxNesting;
        }

        @Override
        public String toString() {
            return "StaticMetric{" +
                    "countOutput=" + countOutput +
                    ", cyclomatic=" + cyclomatic +
                    ", maxNesting=" + maxNesting +
                    '}';
        }
    }
}
