package br.ufrgs.inf.prosoft.adaptivecaching.cache;

import java.util.Calendar;

/**
 * The type Cache info.
 */
public class CacheInfo {

    private Long numberOfObjects;

    private Long usedSpace;

    private Long totalSpace;

    private long currentTime;

    //TODO maybe it would be necessary a var to expired keys, which are different from evicted keys (redis has, memcached not)
    private Long evictedKeys;
    private Long keyspaceHits;
    private Long keyspaceMisses;

    /**
     * Instantiates a new Cache info.
     */
//TODO rewrite it to each cache provider
    public CacheInfo() {
        this.currentTime = Calendar.getInstance().getTimeInMillis();
    }

    /**
     * Gets free space.
     *
     * @return the free space
     */
    public Long getFreeSpace() {
        long freeSpace = totalSpace - usedSpace;
        return (freeSpace > 0) ? freeSpace : 1;
    }

    /**
     * Gets number of objects.
     *
     * @return the number of objects
     */
    public Long getNumberOfObjects() {
        return numberOfObjects;
    }

    /**
     * Sets number of objects.
     *
     * @param numberOfObjects the number of objects
     */
    public void setNumberOfObjects(Long numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
    }

    /**
     * Gets used space.
     *
     * @return the used space
     */
//used space can be in bytes or in number of elements
    public Long getUsedSpace() {
        return usedSpace;
    }

    /**
     * Sets used space.
     *
     * @param usedSpace the used space
     */
//used space can be in bytes or in number of elements
    public void setUsedSpace(Long usedSpace) {
        this.usedSpace = usedSpace;
    }

    /**
     * Gets total space.
     *
     * @return the total space
     */
//total space can be in bytes or in number of elements
    public Long getTotalSpace() {
        return totalSpace;
    }

    /**
     * Sets total space.
     *
     * @param totalSpace the total space
     */
//total space can be in bytes or in number of elements
    public void setTotalSpace(Long totalSpace) {
        this.totalSpace = totalSpace;
    }

    /**
     * Gets evicted keys.
     *
     * @return the evicted keys
     */
    public Long getEvictedKeys() {
        return evictedKeys;
    }

    /**
     * Sets evicted keys.
     *
     * @param evictedKeys the evicted keys
     */
    public void setEvictedKeys(Long evictedKeys) {
        this.evictedKeys = evictedKeys;
    }

    /**
     * Gets keyspace hits.
     *
     * @return the keyspace hits
     */
    public Long getKeyspaceHits() {
        return keyspaceHits;
    }

    /**
     * Sets keyspace hits.
     *
     * @param keyspaceHits the keyspace hits
     */
    public void setKeyspaceHits(Long keyspaceHits) {
        this.keyspaceHits = keyspaceHits;
    }

    /**
     * Gets keyspace misses.
     *
     * @return the keyspace misses
     */
    public Long getKeyspaceMisses() {
        return keyspaceMisses;
    }

    /**
     * Sets keyspace misses.
     *
     * @param keyspaceMisses the keyspace misses
     */
    public void setKeyspaceMisses(Long keyspaceMisses) {
        this.keyspaceMisses = keyspaceMisses;
    }

    /**
     * Average object size double.
     *
     * @return the double
     */
    public double averageObjectSize() {
        return getUsedSpace() / getNumberOfObjects();
    }

    /**
     * Hit ratio double.
     *
     * @return the double
     */
    public double hitRatio() {
        return getKeyspaceHits() / getKeyspaceTotalRequests();
    }

    /**
     * Miss ratio double.
     *
     * @return the double
     */
    public double missRatio() {
        return getKeyspaceMisses() / getKeyspaceTotalRequests();
    }

    /**
     * Gets keyspace total requests.
     *
     * @return the keyspace total requests
     */
    public Long getKeyspaceTotalRequests() {
        return keyspaceHits + keyspaceMisses;
    }

    /**
     * Gets current time.
     *
     * @return the current time
     */
    public long getCurrentTime() {
        return currentTime;
    }

    @Override
    public String toString() {
        return "CacheInfo{" +
                "numberOfObjects=" + numberOfObjects +
                ", usedSpace=" + usedSpace +
                ", totalSpace=" + totalSpace +
                ", currentTime=" + currentTime +
                ", evictedKeys=" + evictedKeys +
                ", keyspaceHits=" + keyspaceHits +
                ", keyspaceMisses=" + keyspaceMisses +
                '}';
    }
}
