package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.support;

import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.AbstractCacheManager;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;

import java.util.Collection;

/**
 * Simple model manager working against a given collection of caches.
 * Useful for testing or simple caching declarations.
 */
public class SimpleCacheManager extends AbstractCacheManager {

    private Collection<? extends Cache> caches;


    /**
     * Specify the collection of Cache instances to use for this CacheManager.
     *
     * @param caches the caches
     */
    public void setCaches(Collection<? extends Cache> caches) {
        this.caches = caches;
    }

    @Override
    protected Collection<? extends Cache> loadCaches() {
        return this.caches;
    }

}
