package br.ufrgs.inf.prosoft.shopizer;

import java.util.Random;

public class WorkloadUtils {

    /**
     * Returns a pseudo-random number between min and max, inclusive.
     * The difference between min and max can be at most
     * <code>Integer.MAX_VALUE - 1</code>.
     *
     * @param min Minimum value
     * @param max Maximum value.  Must be greater than min.
     * @return Integer between min and max, inclusive.
     * @see java.util.Random#nextInt(int)
     */
    public static int randInt(int min, int max) {

        // NOTE: This will (intentionally) not run as written so that folks
        // copy-pasting have to think about how to initialize their
        // Random instance.  Initialization of the Random instance is outside
        // the main scope of the question, but some decent options are to have
        // a field that is initialized once and then re-used as needed or to
        // use ThreadLocalRandom (if using at least Java 1.7).
        Random rand = new Random();

        // nextInt is normally exclusive of the top value,
        // so add 1 to make it inclusive
        int randomNum = rand.nextInt((max - min) + 1) + min;

        return randomNum;
    }

    public static double randDouble(double min, double max) {
        Random r = new Random();
        double randomValue = min + (max - min) * r.nextDouble();
        return randomValue;
    }

    /**
     * A Gaussian distribution with a mean 0 and standard deviation one means that the average of the distribution
     * is 0 and about 70% of the population lies in the range [-1, 1]. Ignore the numbers that are outside your
     * range -- they form the fringe 16% approx on either side.
     */
    private static double nextGaussian(double mean, double standard_deviation)
    {
        Random r = new Random();
        return mean + r.nextGaussian() * standard_deviation;
    }

    public static double randGaussian(double mean, double standard_deviation, double min, double max) {
        double x;
        do {
            x = nextGaussian(mean, standard_deviation);
        } while (x < min || x > max);
        return x;
    }

}
