package org.springframework.samples.petclinic;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigris.annotations.Criteria;
import br.ufrgs.inf.prosoft.tigris.annotations.TigrisConfiguration;

@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE, logRepository = RepositoryType.MEMORY,
    modelling = Modelling.FULLEXPLORATION, analyzerEnabled = true, enabled = true, disableMonitoringAfterAnalysis = false,
    clearMonitoringDataOnStart = true, traceAsync = false, tracerEnabled = true, analyzeOnce = true, expiryInterval = 60)
@TigrisConfiguration(
    samplingEnabled = true,
    samplingPercentage = 5,
    staticMetricFile = "/home/jhonnymertz/workspace/adaptive-caching-framework/understand/petclinic.csv")
@Criteria("more frequent OR more expensive")
//Jhonny: workaround below. a better solution involve filter by serialization methods in aspect to avoid it
@ComponentScan(allowed = "org.springframework.samples.petclinic", denied = "org.springframework.samples.petclinic.model")
public class Configuration {
}
