package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.cacher;

import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.cacher.key.Key;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.Cache;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.CacheManager;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.ValueWrapper;
import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.util.CacheManagerFactory;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveMethodCacher implements MethodCacher {

    Logger logger = LoggerFactory.getLogger(AdaptiveMethodCacher.class);

    //caching components
    private CacheManager cacheManager;
    private Cache cache;

    public AdaptiveMethodCacher(CacheProviderType cacheProviderType, long expiryInterval) {
        this.cacheManager = CacheManagerFactory.getCacheManager(cacheProviderType, expiryInterval);
        this.cache = cacheManager.getCache("adaptivecaching");
    }

    @Override
    public Object cache(Object key, ProceedingJoinPoint joinPoint) throws Throwable {

        //already calculated
        //final Key key = new Key(joinPoint);
        //final SimpleKey key = (SimpleKey) joinPointKeyGenerator.generate(joinPoint);
        ValueWrapper value = cache.get(key);

        if (value != null) {
            logger.debug(key + " with value: " + value.get() + " got from cachemanager");
            return value.get();
        }

        Object result;
        try {
            result = joinPoint.proceed();
        } catch (Exception ex) {
            throw ex;
        }

        if (result != null) {
            //todo maximize such decision
            //maybe getcache info a lot can lead to a performance problem
//            if(cacheMonitor.getCacheInfo().getFreeSpace() > 0) {
            cache.put(key, result);
            logger.debug(key + " with value: " + result + " set in cachemanager");
//            }
        }

        return result;
    }

    @Override
    public Object cache(ProceedingJoinPoint joinPoint) throws Throwable {
        final Key key = new Key(joinPoint);
        return cache(key, joinPoint);
    }

    @Override
    public void preflush(JoinPoint point) {

    }

    @Override
    public void postflush(JoinPoint point) {

    }

    public Cache getCache() {
        return cache;
    }

    /**
     * Clean cacheable methods expired.
     */
    private void clean() {
        cache.clear();
        logger.info("All cached values were removed.");
    }
}
