package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model.support;

import java.io.Serializable;

/**
 * Simple serializable class that serves as a {@code null} replacement
 * for model stores which otherwise do not support {@code null} values.
 */
public final class NullValue implements Serializable {

    /**
     * The Instance.
     */
    static final Object INSTANCE = new NullValue();

    private static final long serialVersionUID = 1L;


    private NullValue() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

}
