package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.cacher;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;

/**
 * The interface Method cacher.
 */
public interface MethodCacher {
    /**
     * Put in cache.
     *
     * @param key    the key
     * @param result the result
     * @throws Throwable the throwable
     */
    void putInCache(final Object key, Object result) throws Throwable;

    /**
     * Gets from cache.
     *
     * @param key the key
     * @return the from cache
     * @throws Throwable the throwable
     */
    Object getFromCache(final Object key) throws Throwable;

    /**
     * Preflush.
     *
     * @param joinPoint the join point
     */
    void preflush(final JoinPoint joinPoint);

    /**
     * Postflush.
     *
     * @param joinPoint the join point
     */
    void postflush(final JoinPoint joinPoint);
}
