package br.ufrgs.inf.prosoft.adaptivecaching.analysis.decision.flowchart.model;

import br.ufrgs.inf.prosoft.tigris.monitoring.metadata.MethodInfo;

/**
 * The type Method entry.
 */
public class MethodEntry {

    private MethodInfo methodInfo;
    private MethodStats methodStats;
    private long lifetime;

    /**
     * Instantiates a new Method entry.
     */
    public MethodEntry(){

    }

    /**
     * Instantiates a new Method entry.
     *
     * @param methodInfo  the method info
     * @param methodStats the method stats
     * @param lifetime    the lifetime
     */
    public MethodEntry(MethodInfo methodInfo, MethodStats methodStats, long lifetime) {
        this.methodInfo = methodInfo;
        this.methodStats = methodStats;
        this.lifetime = lifetime;
    }

    /**
     * Gets method info.
     *
     * @return the method info
     */
    public MethodInfo getMethodInfo() {
        return methodInfo;
    }

    /**
     * Gets method info key.
     *
     * @return the method info key
     */
    public Object getMethodInfoKey() {
        return methodInfo.getKey();
    }

    /**
     * Gets method stats.
     *
     * @return the method stats
     */
    public MethodStats getMethodStats() {
        return methodStats;
    }

    @Override
    public String toString() {
        return "MethodEntry{" +
                "methodInfo=" + methodInfo +
                ", methodStats=" + methodStats +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MethodEntry)) return false;

        MethodEntry that = (MethodEntry) o;

        if (!methodInfo.equals(that.methodInfo)) return false;
        if (!methodStats.equals(that.methodStats)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = methodInfo.hashCode();
        result = 31 * result + methodStats.hashCode();
        return result;
    }

    /**
     * Expired boolean.
     *
     * @return the boolean
     */
    public boolean expired() {
        return lifetime < System.currentTimeMillis();
    }
}
