package br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation;

import java.lang.annotation.*;

/**
 * The interface Cacheable.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
//TODO parser such annotation on flowchart caching decision
public @interface Cacheable {
    /**
     * Value boolean.
     *
     * @return the boolean
     */
    boolean value();

    /**
     * Statical boolean.
     *
     * @return the boolean
     */
    boolean statical() default false;

    /**
     * Less changing boolean.
     *
     * @return the boolean
     */
    boolean lessChanging() default false;

    /**
     * Frequent boolean.
     *
     * @return the boolean
     */
    boolean frequent() default false;

    /**
     * Shareable boolean.
     *
     * @return the boolean
     */
    boolean shareable() default false;

    /**
     * Expensive boolean.
     *
     * @return the boolean
     */
    boolean expensive() default false;

    /**
     * Large boolean.
     *
     * @return the boolean
     */
    boolean large() default false;
}
