package org.springframework.samples.petclinic;

import br.ufrgs.inf.prosoft.tigris.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.tigris.configuration.annotation.TigrisConfiguration;
import br.ufrgs.inf.prosoft.tigris.configuration.types.RepositoryType;
import br.ufrgs.inf.prosoft.tigris.sampling.GranularityType;
import br.ufrgs.inf.prosoft.tigris.sampling.SamplingConfiguration;

@TigrisConfiguration(
    logRepository = RepositoryType.MEMORY,
    staticMetricFile = "petclinic.csv",
    criteria = "more frequent OR more expensive")
@SamplingConfiguration(granularity = GranularityType.METHOD, samplingPercentage = 50)
//Jhonny: workaround below. a better solution involve filter by serialization methods in aspect to avoid it
@ComponentScan(allowed = "org.springframework.samples.petclinic.*", denied = "org.springframework.samples.petclinic.model.*")
public class Configuration {
}
