package br.ufrgs.inf.prosoft.tigris.sampling;

import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PerformanceBaselineDataSet {

    private Map<Granularity, SummaryStatistics> granularityBaseline = new HashMap<>();
    private long n;

    public void addItem(Granularity item, long executionTime) {
        SummaryStatistics statistics = new SummaryStatistics();
        if (granularityBaseline.containsKey(item)){
            statistics = granularityBaseline.get(item);
        }
        statistics.addValue(executionTime);
        granularityBaseline.put(item, statistics);
        n++;
    }

    public long getTotalItems(){
        return n;
    }

    public Set<Granularity> getGranularities(){
        return granularityBaseline.keySet();
    }
}
