package br.ufrgs.inf.prosoft.tigris.monitoring.metadata;

import org.apache.commons.lang3.builder.EqualsBuilder;

import java.util.Objects;

/**
 * The type Method info.
 */
public class MethodInfo {

    private String signature;

    private Object[] arguments;

    private Object returnedValue;

    private Key key;

//    private Integer hashedReturnedValue;
//    private Integer hashedArguments;

    /**
     * Instantiates a new Method info.
     */
    public MethodInfo() {
    }

    /**
     * Instantiates a new Method info.
     *
     * @param signature the signature
     * @param arguments the arguments
     */
    public MethodInfo(String signature, Object[] arguments) {
        this.signature = signature;
        this.arguments = arguments;

//        try {
//            //TODO hash or not???
//            this.hashedArguments = HashCodeBuilder.reflectionHashCode(arguments);
//        } catch (Exception e) {
//        }
    }

    /**
     * Instantiates a new Method info.
     *
     * @param signature     the signature
     * @param arguments     the arguments
     * @param returnedValue the returned value
     */
    public MethodInfo(String signature, Object[] arguments, Object returnedValue) {
        this(signature, arguments);
        this.returnedValue = returnedValue;

//        try {
//            //TODO hash or not???
//            this.hashedArguments = HashCodeBuilder.reflectionHashCode(arguments);
//            this.hashedReturnedValue = HashCodeBuilder.reflectionHashCode(returnedValue);
//        } catch (Exception e) {
//        }
    }

    /**
     * Instantiates a new Method info.
     *
     * @param s             the s
     * @param joinPointArgs the join point args
     * @param result        the result
     * @param key           the key
     */
    public MethodInfo(String s, Object[] joinPointArgs, Object result, Key key) {
        this(s, joinPointArgs, result);
        this.key = key;
    }

    /**
     * Gets signature.
     *
     * @return the signature
     */
    public String getSignature() {
        return this.signature;
    }

    /**
     * Get arguments object [ ].
     *
     * @return the object [ ]
     */
    public Object[] getArguments() {
        return this.arguments;
    }

    /**
     * Gets returned value.
     *
     * @return the returned value
     */
    public Object getReturnedValue() {
        return this.returnedValue;
    }

    /**
     * Gets key.
     *
     * @return the key
     */
    public Object getKey() {
        return key;
    }

    /**
     * Equals without returned value boolean.
     *
     * @param o the o
     * @return the boolean
     */
    public boolean equalsWithoutReturnedValue(MethodInfo o) {

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        if (!signature.equals(o.signature)) return false;
        if (!(Objects.deepEquals(arguments, o.arguments) || EqualsBuilder.reflectionEquals(arguments, o.arguments))) return false;

        return true;
        //return EqualsBuilder.reflectionEquals(this, o, "returnedValue", "key");
    }

    @Override
    public boolean equals(Object o) {
//        return EqualsBuilder.reflectionEquals(this, o, "key");

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MethodInfo that = (MethodInfo) o;

        if (!signature.equals(that.signature)) return false;
        if (!EqualsBuilder.reflectionEquals(arguments, that.arguments)) return false;
        return EqualsBuilder.reflectionEquals(returnedValue, that.returnedValue) || Objects.deepEquals(returnedValue, that.returnedValue);
    }

//    public boolean equalsHashed(Object o) {
//        if (this == o) return true;
//        if (o == null || getClass() != o.getClass()) return false;
//
//        MethodInfo that = (MethodInfo) o;
//
//        if (!signature.equals(that.signature)) return false;
//        if (!Objects.deepEquals(hashedArguments, that.hashedArguments)) return false;
//        return hashedReturnedValue != null ? Objects.deepEquals(hashedReturnedValue, that.hashedReturnedValue) : that.hashedReturnedValue == null;
//    }
//
//    public boolean equalsHashedWithoutReturnedValue(Object o) {
//        if (this == o) return true;
//        if (o == null || getClass() != o.getClass()) return false;
//
//        MethodInfo that = (MethodInfo) o;
//
//        if (!signature.equals(that.signature)) return false;
//        if (!Objects.deepEquals(hashedArguments, that.hashedArguments)) return false;
//        return true;
//    }

//    public Integer getHashedReturnedValue() {
//        return hashedReturnedValue;
//    }
//
//    public Integer getHashedArguments() {
//        return hashedArguments;
//    }
//
//    public void setArguments(Object[] arguments) {
//        this.arguments = arguments;
//    }
//
//    public void setReturnedValue(Object returnedValue) {
//        this.returnedValue = returnedValue;
//    }

    @Override
    public int hashCode() {
        //TODO equals is enough to distinghish, not able to get a unique hashcode
        return 1;
        //return HashCodeBuilder.reflectionHashCode(this, "key");
    }

    public String toString() {
        return "br.ufrgs.inf.prosoft.tigris.monitoring.application.metadata.MethodInfo(signature=" + this.signature + ", arguments=" + this.arguments + ", returnedValue=" + this.returnedValue + ")";
    }
}
