package org.springframework.samples.petclinic;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.AdaptiveCaching;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.ComponentScan;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;

//working config: mongodb, accumulation
@AdaptiveCaching(cacheProvider = CacheProviderType.EHCACHE, logRepository = RepositoryType.MONGODB,
    modelling = Modelling.ACCUMULATION, analyzerEnabled = true, enabled = true, disableMonitoringAfterAnalysis = true,
    clearMonitoringDataOnStart = true, traceAsync = false, tracerEnabled = true)

//Jhonny: workaround below. a better solution involve filter by serialization methods in aspect to avoid it
@ComponentScan(allowed = "org.springframework.samples.petclinic", denied = "org.springframework.samples.petclinic.model")
public class Configuration {
}
