package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.util.threads;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ThreadFactory;

/**
 * <p>This custom class is used instead of a default ThreadFactory in order
 * to name scheduled threads correctly on construction.
 *
 * @author Yegor Bugayenko (yegor@tpc2.com)
 * @version $Id$
 * @since 0.7.17
 */
@SuppressWarnings("PMD.DoNotUseThreads")
public class NamedThreads implements ThreadFactory {

    /**
     * Name of the thread.
     */
    private final transient String name;
    /**
     * Purpose of these threads.
     */
    private final transient String purpose;
    /**
     * Thread group to use.
     */
    private final transient ThreadGroup group;
    Logger logger = LoggerFactory.getLogger(NamedThreads.class);

    /**
     * Public ctor.
     *
     * @param suffix Suffix of thread names
     * @param desc   Description of purpose
     */
    public NamedThreads(final String suffix, final String desc) {
        this.name = String.format("%s", suffix);
        this.purpose = desc;
        this.group = new ThreadGroup("adaptivecaching");
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        final Thread thread = new Thread(this.group, runnable);
        thread.setName(this.name);
        thread.setDaemon(true);
        logger.info("adaptivecaching started new daemon thread " + this.name + " for " + this.purpose);
        return thread;
    }

}

