package br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation;

import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.CacheProviderType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.Modelling;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.RepositoryType;
import br.ufrgs.inf.prosoft.adaptivecaching.configuration.annotation.types.TriggerType;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface AdaptiveCaching {

    boolean enabled() default true;

    RepositoryType logRepository() default RepositoryType.MONGODB;

    CacheProviderType cacheProvider() default CacheProviderType.GUAVA;

    Modelling modelling() default Modelling.ACCUMULATION;

    long expiry() default 5; //in minutes

    TriggerType triggerType() default TriggerType.TIME; //if were not by time, load the class that implements the interface @Trigger

    long triggerTime() default 5; //in minutes

    boolean analyzerEnabled() default true;

    boolean disableMonitoringAfterAnalysis() default false;

    boolean traceAsync() default true;

    boolean clearMonitoringDataOnStart() default false;

    boolean tracerEnabled() default true;

    boolean analyzeOnce() default false;
}
