package br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.support;

import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.aspects.TracerAspect;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.application.metadata.LogTrace;
import br.ufrgs.inf.prosoft.adaptivecaching.monitoring.storage.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;

public class Tracer implements Runnable {

    Logger logger = LoggerFactory.getLogger(Tracer.class);

    private Repository repository;
    private LogTrace logTrace;

    public Tracer(Repository repository, LogTrace logTrace) {
        this.repository = repository;
        this.logTrace = logTrace;
    }

    @Override
    public void run() {
        long la = System.currentTimeMillis();
        try {
            repository.save(logTrace);
            logger.debug("New trace entry: " + logTrace + " serialization and save time: " + (System.currentTimeMillis() - la));
        } catch (Exception e) {
//            if (logTrace.getMethodInfo().getHashedArguments() != null && logTrace.getMethodInfo().getHashedReturnedValue() != null) {
//                //TODO few calls may not be serialization to the repository (mongo), then only the hash is saved
//                logTrace.getMethodInfo().setArguments(null);
//                logTrace.getMethodInfo().setReturnedValue(null);
//                repository.save(logTrace);
//                logger.debug("New trace entry: " + logTrace + " save time: " + (System.currentTimeMillis() - la));
//            } else {
            logger.debug("Couldn't trace " + logTrace.getMethodInfo().getSignature() + " due to: " + e.getMessage() + " process time: " + (System.currentTimeMillis() - la), e);
            logger.debug("Adding " + logTrace.getMethodInfo().getSignature() + " to blacklist");
            TracerAspect.methodBlackList.add(logTrace.getMethodInfo().getSignature());
//            }
        }
    }
}
