package br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.model;


import br.ufrgs.inf.prosoft.adaptivecaching.cachemanager.extensions.guava.GuavaCacheManager;

import java.util.Collection;

//Available implementations: AbstractCacheManager, AbstractTransactionSupportingCacheManager, CaffeineCacheManager,
//        CompositeCacheManager, ConcurrentMapCacheManager, EhCacheCacheManager, GuavaCacheManager, JCacheCacheManager,
//        NoOpCacheManager, SimpleCacheManager, TransactionAwareCacheManagerProxy

//For future use, do not use it yet
public class AdaptiveCacheManager implements CacheManager {

    private CacheManager cacheManager;

    public AdaptiveCacheManager() {
        this(new GuavaCacheManager());
    }

    public AdaptiveCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Cache getCache(String s) {
        return this.cacheManager.getCache(s);
    }

    @Override
    public Collection<String> getCacheNames() {
        return this.cacheManager.getCacheNames();
    }
}
