/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.Plugin;

public class DependencyResolver {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String JAVA_CLASS_PATH = "java.class.path";
    protected final Set<Plugin> deletions = new HashSet<Plugin>();
    protected final Set<Plugin> additions = new HashSet<Plugin>();
    protected final Map<String, String> libAdditions = new HashMap<String, String>();
    protected final Set<String> libDeletions = new HashSet<String>();
    protected final Map<Plugin, Boolean> allPlugins;

    public DependencyResolver(Map<Plugin, Boolean> allPlugins) {
        this.allPlugins = allPlugins;
        this.resolveFlags();
        this.resolveUpgrades();
        this.resolveDeleteByDependency();
        this.resolveInstallByDependency();
        this.resolveDeleteLibs();
        this.resolveInstallLibs();
    }

    public Set<Plugin> getDeletions() {
        return this.deletions;
    }

    public Set<Plugin> getAdditions() {
        return this.additions;
    }

    public Map<String, String> getLibAdditions() {
        return this.libAdditions;
    }

    public Set<String> getLibDeletions() {
        return this.libDeletions;
    }

    private Plugin getPluginByID(String id) {
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.getID().equals(id)) continue;
            return plugin;
        }
        throw new RuntimeException("Plugin not found by ID: " + id);
    }

    private Set<Plugin> getDependants(Plugin plugin) {
        HashSet<Plugin> res = new HashSet<Plugin>();
        for (Plugin pAll : this.allPlugins.keySet()) {
            for (String depID : pAll.getDepends()) {
                if (!depID.equals(plugin.getID())) continue;
                res.add(pAll);
            }
        }
        return res;
    }

    private void resolveFlags() {
        for (Map.Entry<Plugin, Boolean> entry : this.allPlugins.entrySet()) {
            if (entry.getKey().isInstalled()) {
                if (entry.getValue().booleanValue()) continue;
                this.deletions.add(entry.getKey());
                continue;
            }
            if (!entry.getValue().booleanValue()) continue;
            this.additions.add(entry.getKey());
        }
    }

    private void resolveUpgrades() {
        for (Map.Entry<Plugin, Boolean> entry : this.allPlugins.entrySet()) {
            Plugin plugin = entry.getKey();
            if (!entry.getValue().booleanValue() || !plugin.isInstalled() || plugin.getInstalledVersion().equals(plugin.getCandidateVersion())) continue;
            log.debug("Upgrade: " + plugin);
            this.deletions.add(plugin);
            this.additions.add(plugin);
        }
    }

    private void resolveDeleteByDependency() {
        boolean hasModifications = true;
        block0: while (hasModifications) {
            log.debug("Check uninstall dependencies");
            hasModifications = false;
            for (Plugin plugin : this.deletions) {
                if (!this.additions.contains(plugin)) {
                    for (Plugin dep : this.getDependants(plugin)) {
                        if (!this.deletions.contains(dep) && dep.isInstalled()) {
                            log.debug("Add to deletions: " + dep);
                            this.deletions.add(dep);
                            hasModifications = true;
                        }
                        if (!this.additions.contains(dep)) continue;
                        log.debug("Remove from additions: " + dep);
                        this.additions.remove(dep);
                        hasModifications = true;
                    }
                }
                if (!hasModifications) continue;
                continue block0;
            }
        }
    }

    private void resolveInstallByDependency() {
        boolean hasModifications = true;
        block0: while (hasModifications) {
            log.debug("Check install dependencies: " + this.additions);
            hasModifications = false;
            for (Plugin plugin : this.additions) {
                for (String pluginID : plugin.getDepends()) {
                    Plugin depend = this.getPluginByID(pluginID);
                    if (depend.isInstalled() && !this.deletions.contains(depend) || this.additions.contains(depend)) continue;
                    log.debug("Add to install: " + depend);
                    this.additions.add(depend);
                    hasModifications = true;
                }
                if (!hasModifications) continue;
                continue block0;
            }
        }
    }

    private void resolveInstallLibs() {
        for (Plugin plugin : this.additions) {
            Map<String, String> libs = plugin.getLibs(plugin.getCandidateVersion());
            for (String lib : libs.keySet()) {
                if (Plugin.getLibInstallPath(lib) != null) continue;
                this.libAdditions.put(lib, libs.get(lib));
            }
        }
    }

    private void resolveDeleteLibs() {
        for (Plugin plugin : this.deletions) {
            if (this.additions.contains(plugin)) continue;
            Map<String, String> libs = plugin.getLibs(plugin.getInstalledVersion());
            for (String lib : libs.keySet()) {
                if (Plugin.getLibInstallPath(lib) != null) {
                    this.libDeletions.add(lib);
                    continue;
                }
                log.warn("Did not find library to uninstall it: " + lib);
            }
        }
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!this.additions.contains(plugin) && (!plugin.isInstalled() || this.deletions.contains(plugin))) continue;
            String ver = this.additions.contains(plugin) ? plugin.getCandidateVersion() : plugin.getInstalledVersion();
            Map<String, String> libs = plugin.getLibs(ver);
            for (String lib : libs.keySet()) {
                if (!this.libDeletions.contains(lib)) continue;
                log.debug("Won't delete lib " + lib + " since it is used by " + plugin);
                this.libDeletions.remove(lib);
            }
        }
    }
}

