/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.PluginManagerDialog;

public class PluginManagerMenuItem
extends JMenuItem
implements ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static PluginManagerDialog dialog;
    private final PluginManager mgr;

    public PluginManagerMenuItem() {
        super("Plugins Manager", PluginManagerMenuItem.getPluginsIcon());
        this.addActionListener(this);
        this.mgr = new PluginManager();
        try {
            this.mgr.load();
        }
        catch (Throwable e) {
            log.warn("Failed to load plugin updates info", e);
        }
        if (this.mgr.hasAnyUpdates()) {
            this.setText("Plugins Manager (has upgrades)");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (dialog == null) {
            int timeout = Integer.parseInt(JMeterUtils.getPropDefault((String)"jpgc.repo.timeout", (String)"5000"));
            this.mgr.setTimeout(timeout);
            dialog = new PluginManagerDialog(this.mgr);
        }
        dialog.pack();
        dialog.setVisible(true);
    }

    public static ImageIcon getPluginsIcon() {
        return new ImageIcon(PluginManagerMenuItem.class.getResource("/org/jmeterplugins/logo.png"));
    }
}

