/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginCheckbox;

public class CheckBoxList<T extends JCheckBox>
extends JList<T> {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public CheckBoxList(final int xOffset) {
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CheckBoxList.this.locationToIndex(e.getPoint());
                if (index != -1) {
                    JCheckBox checkbox = (JCheckBox)CheckBoxList.this.getModel().getElementAt(index);
                    Icon i = UIManager.getIcon("CheckBox.icon");
                    if (e.getX() <= i.getIconWidth() + xOffset && checkbox.isEnabled()) {
                        checkbox.setSelected(!checkbox.isSelected());
                    }
                    CheckBoxList.this.repaint();
                }
            }
        });
        this.setSelectionMode(0);
    }

    protected class CellRenderer
    implements ListCellRenderer<JCheckBox> {
        protected CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            Plugin p;
            value.setBackground(isSelected ? CheckBoxList.this.getSelectionBackground() : CheckBoxList.this.getBackground());
            value.setForeground(isSelected ? CheckBoxList.this.getSelectionForeground() : CheckBoxList.this.getForeground());
            value.setEnabled(CheckBoxList.this.isEnabled() && value.isEnabled());
            value.setFont(CheckBoxList.this.getFont());
            if (value instanceof PluginCheckbox && (p = ((PluginCheckbox)value).getPlugin()).isUpgradable()) {
                value.setFont(CheckBoxList.this.getFont().deriveFont(3));
            }
            value.setFocusPainted(false);
            value.setBorderPainted(true);
            value.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return value;
        }
    }
}

