/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.GenericCallback;

public class Downloader {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String filename;
    private GenericCallback<String> callback;

    public Downloader(GenericCallback<String> statusChanged) {
        this.callback = statusChanged;
    }

    public String download(final String id, URI url) throws IOException {
        log.info("Downloading: " + url);
        this.callback.notify("Downloading " + id + "...");
        SystemDefaultHttpClient httpClient = new SystemDefaultHttpClient();
        HttpGet httpget = new HttpGet(url);
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget, (HttpContext)context);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException(response.getStatusLine().toString());
        }
        HttpEntity entity = response.getEntity();
        File tempFile = File.createTempFile(id, ".jar");
        final long size = entity.getContentLength();
        InputStream inputStream = entity.getContent();
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        this.copyLarge(inputStream, outputStream, new GenericCallback<Long>(){

            @Override
            public void notify(Long progress) {
                Downloader.this.callback.notify(String.format("Downloading %s: %d%%", id, 100L * progress / size));
            }
        });
        ((OutputStream)outputStream).close();
        this.callback.notify("Downloaded " + id + "...");
        Header cd = response.getLastHeader("Content-Disposition");
        if (cd != null) {
            this.filename = cd.getValue().split(";")[1].split("=")[1];
        } else {
            HttpUriRequest currentReq = (HttpUriRequest)context.getAttribute("http.request");
            HttpHost currentHost = (HttpHost)context.getAttribute("http.target_host");
            String currentUrl = currentReq.getURI().isAbsolute() ? currentReq.getURI().toString() : currentHost.toURI() + currentReq.getURI();
            this.filename = FilenameUtils.getName((String)currentUrl);
        }
        return tempFile.getPath();
    }

    public String getFilename() {
        return this.filename;
    }

    private long copyLarge(InputStream input, OutputStream output, GenericCallback<Long> progressCallback) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            progressCallback.notify(count);
            count += (long)n;
        }
        return count;
    }
}

