/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.repository.ChangesMaker;
import org.jmeterplugins.repository.DependencyResolver;
import org.jmeterplugins.repository.Downloader;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;

public class PluginManager {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private int timeout = 1000;
    protected AbstractHttpClient httpClient = new DefaultHttpClient();
    private static final String address = JMeterUtils.getPropDefault((String)"jpgc.repo.address", (String)System.getProperty("jpgc.repo.address", "https://jmeter-plugins.org"));
    protected Map<Plugin, Boolean> allPlugins = new HashMap<Plugin, Boolean>();
    private static PluginManager staticManager = new PluginManager();
    private boolean doRestart = true;

    public PluginManager() {
        String proxyHost = System.getProperty("https.proxyHost", "");
        if (!proxyHost.isEmpty()) {
            int proxyPort = Integer.parseInt(System.getProperty("https.proxyPort", "-1"));
            log.info("Using proxy " + proxyHost + ":" + proxyPort);
            HttpParams params = this.httpClient.getParams();
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            params.setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser", JMeterUtils.getProperty((String)"http.proxyUser"));
            if (proxyUser != null) {
                log.info("Using authenticated proxy with username: " + proxyUser);
                String proxyPass = System.getProperty("http.proxyPass", JMeterUtils.getProperty((String)"http.proxyPass"));
                String localHost = this.getLocalHost();
                AuthScope authscope = new AuthScope(proxyHost, proxyPort);
                String proxyDomain = JMeterUtils.getPropDefault((String)"http.proxyDomain", (String)"");
                NTCredentials credentials = new NTCredentials(proxyUser, proxyPass, localHost, proxyDomain);
                this.httpClient.getCredentialsProvider().setCredentials(authscope, (Credentials)credentials);
            }
        }
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Throwable e) {
            log.error("Failed to get local host name, defaulting to 'localhost'", e);
            return "localhost";
        }
    }

    public void load() throws Throwable {
        File libext;
        String jarPath;
        if (this.allPlugins.size() > 0) {
            return;
        }
        JSON json = this.getJSON("/repo/?installID=" + this.getInstallID());
        if (!(json instanceof JSONArray)) {
            throw new RuntimeException("Result is not array");
        }
        for (Object elm : (JSONArray)json) {
            if (elm instanceof JSONObject) {
                Plugin plugin = Plugin.fromJSON((JSONObject)elm);
                if (plugin.getName().isEmpty()) {
                    log.debug("Skip empty name: " + plugin);
                    continue;
                }
                if (!plugin.isVirtual()) {
                    plugin.detectInstalled(this.getInstalledPlugins());
                }
                this.allPlugins.put(plugin, plugin.isInstalled());
                continue;
            }
            log.warn("Invalid array element: " + elm);
        }
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.isVirtual()) continue;
            plugin.detectInstalled(this.getInstalledPlugins());
        }
        log.info("Plugins Status: " + this.getAllPluginsStatusString());
        if (JMeterUtils.getPropDefault((String)"jpgc.repo.sendstats", (String)"true").equals("true")) {
            try {
                this.reportStats();
            }
            catch (Exception e) {
                log.debug("Failed to report usage stats", (Throwable)e);
            }
        }
        if ((jarPath = Plugin.getJARPath(JMeterEngine.class.getCanonicalName())) != null && !this.isWritable(libext = new File(URLDecoder.decode(jarPath, "UTF-8")).getParentFile())) {
            this.allPlugins.clear();
            String msg = "Have no write access for JMeter directories, not possible to use Plugins Manager: ";
            throw new AccessDeniedException(msg + libext);
        }
    }

    private boolean isWritable(File path) {
        File sample = new File(path.getParent(), "empty.txt");
        try {
            sample.createNewFile();
            sample.delete();
            return true;
        }
        catch (IOException e) {
            log.debug("Write check failed for " + path, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSON getJSON(String path) throws IOException {
        String uri = address + path;
        log.debug("Requesting " + uri);
        HttpGet get = new HttpGet(uri);
        HttpParams requestParams = get.getParams();
        requestParams.setIntParameter("http.socket.timeout", this.timeout);
        requestParams.setIntParameter("http.connection.timeout", this.timeout);
        HttpResponse result = this.httpClient.execute((HttpUriRequest)get);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HttpEntity entity = result.getEntity();
        try {
            entity.writeTo((OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            if (bytes == null) {
                bytes = "null".getBytes();
            }
            String response = new String(bytes);
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode >= 300) {
                log.warn("Response with code " + result + ": " + response);
                throw new IOException("Repository responded with wrong status code: " + statusCode);
            }
            log.debug("Response with code " + result + ": " + response);
            JSON jSON = JSONSerializer.toJSON((Object)response, new JsonConfig());
            return jSON;
        }
        finally {
            get.abort();
            entity.getContent().close();
        }
    }

    public void startModifications(Set<Plugin> delPlugins, Set<Plugin> installPlugins, Map<String, String> installLibs, Set<String> libDeletions) throws IOException {
        ChangesMaker maker = new ChangesMaker(this.allPlugins);
        File moveFile = maker.getMovementsFile(delPlugins, installPlugins, installLibs, libDeletions);
        File installFile = maker.getInstallFile(installPlugins);
        File restartFile = this.doRestart ? maker.getRestartFile() : null;
        ProcessBuilder builder = maker.getProcessBuilder(moveFile, installFile, restartFile);
        log.info("JAR Modifications log will be saved into: " + builder.redirectOutput().file().getPath());
        builder.start();
    }

    public void applyChanges(GenericCallback<String> statusChanged) {
        DependencyResolver resolver = new DependencyResolver(this.allPlugins);
        Set<Plugin> additions = resolver.getAdditions();
        HashMap<String, String> libInstalls = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : resolver.getLibAdditions().entrySet()) {
            Downloader dwn = new Downloader(statusChanged);
            try {
                String tmpFile = dwn.download(entry.getKey(), new URI(entry.getValue()));
                libInstalls.put(tmpFile, dwn.getFilename());
            }
            catch (Exception e) {
                String msg = "Failed to download " + entry.getKey();
                log.error(msg, (Throwable)e);
                statusChanged.notify(msg);
                throw new RuntimeException("Failed to download library " + entry.getKey(), e);
            }
        }
        for (Plugin plugin : additions) {
            try {
                plugin.download(statusChanged);
            }
            catch (IOException e) {
                String msg = "Failed to download " + plugin;
                log.error(msg, (Throwable)e);
                statusChanged.notify(msg);
                throw new RuntimeException("Failed to download plugin " + plugin, e);
            }
        }
        statusChanged.notify("Restarting JMeter...");
        HashSet<String> libDeletions = new HashSet<String>();
        for (String lib : resolver.getLibDeletions()) {
            libDeletions.add(Plugin.getLibInstallPath(lib));
        }
        this.modifierHook(resolver.getDeletions(), additions, libInstalls, libDeletions);
    }

    private void modifierHook(final Set<Plugin> deletions, final Set<Plugin> additions, final Map<String, String> libInstalls, final Set<String> libDeletions) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    PluginManager.this.startModifications(deletions, additions, libInstalls, libDeletions);
                }
                catch (Exception e) {
                    log.warn("Failed to run plugin cleaner job", (Throwable)e);
                }
            }
        });
    }

    private void reportStats() throws IOException {
        String uri = address + "/repo/";
        HttpPost post = new HttpPost(uri);
        StringEntity body = new StringEntity("stats=" + URLEncoder.encode(this.getUsageStats(), "UTF-8"));
        post.setEntity((HttpEntity)body);
        HttpParams requestParams = post.getParams();
        requestParams.setIntParameter("http.socket.timeout", 3000);
        requestParams.setIntParameter("http.connection.timeout", 1000);
        log.debug("Requesting " + uri);
        this.httpClient.execute((HttpUriRequest)post);
        post.abort();
    }

    protected String getUsageStats() {
        ArrayList<String> data = new ArrayList<String>();
        data.add(this.getInstallID());
        data.add(JMeterUtils.getJMeterVersion());
        for (Plugin p : this.getInstalledPlugins()) {
            data.add(p.getID() + "=" + p.getInstalledVersion());
        }
        log.debug("Usage stats: " + data);
        return Arrays.toString(data.toArray(new String[0]));
    }

    public String getChangesAsText() {
        DependencyResolver resolver = new DependencyResolver(this.allPlugins);
        String text = "";
        for (Plugin plugin : resolver.getDeletions()) {
            text = text + "Uninstall plugin: " + plugin + " " + plugin.getInstalledVersion() + "\n";
        }
        for (String string : resolver.getLibDeletions()) {
            text = text + "Uninstall library: " + string + "\n";
        }
        for (String string : resolver.getLibAdditions().keySet()) {
            text = text + "Install library: " + string + "\n";
        }
        for (Plugin plugin : resolver.getAdditions()) {
            text = text + "Install plugin: " + plugin + " " + plugin.getCandidateVersion() + "\n";
        }
        return text;
    }

    public Set<Plugin> getInstalledPlugins() {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.isInstalled()) continue;
            result.add(plugin);
        }
        return result;
    }

    public Set<Plugin> getAvailablePlugins() {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (plugin.isInstalled()) continue;
            result.add(plugin);
        }
        return result;
    }

    public Set<Plugin> getUpgradablePlugins() {
        TreeSet<Plugin> result = new TreeSet<Plugin>(new PluginComparator());
        for (Plugin plugin : this.allPlugins.keySet()) {
            if (!plugin.isUpgradable()) continue;
            result.add(plugin);
        }
        return result;
    }

    public void toggleInstalled(Plugin plugin, boolean cbState) {
        if (!cbState && !plugin.canUninstall()) {
            log.warn("Cannot uninstall plugin: " + plugin);
            cbState = true;
        }
        this.allPlugins.put(plugin, cbState);
    }

    public boolean hasAnyUpdates() {
        for (Plugin p : this.allPlugins.keySet()) {
            if (!p.isUpgradable()) continue;
            return true;
        }
        return false;
    }

    public Plugin getPluginByID(String key) {
        for (Plugin p : this.allPlugins.keySet()) {
            if (!p.getID().equals(key)) continue;
            return p;
        }
        throw new IllegalArgumentException("Plugin not found in repo: " + key);
    }

    public void setDoRestart(boolean doRestart) {
        this.doRestart = doRestart;
    }

    public String getInstallID() {
        String str = "";
        str = str + this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile();
        try {
            str = str + "\t" + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.warn("Cannot get local host name", (Throwable)e);
        }
        try {
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(ifs)) {
                str = str + "\t" + Arrays.toString(netint.getHardwareAddress());
            }
        }
        catch (SocketException e) {
            log.warn("Failed to get network addresses", (Throwable)e);
        }
        return DigestUtils.md5Hex((String)str);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public static PluginManager getStaticManager() {
        try {
            staticManager.load();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to get plugin repositories", e);
        }
        return staticManager;
    }

    public static String getPluginStatus(String id) {
        PluginManager manager = PluginManager.getStaticManager();
        for (Plugin plugin : manager.allPlugins.keySet()) {
            if (!plugin.id.equals(id)) continue;
            return plugin.getInstalledVersion();
        }
        return null;
    }

    public static String getAllPluginsStatus() {
        PluginManager manager = PluginManager.getStaticManager();
        return manager.getAllPluginsStatusString();
    }

    private String getAllPluginsStatusString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Plugin plugin : this.getInstalledPlugins()) {
            res.add(plugin.getID() + "=" + plugin.getInstalledVersion());
        }
        return Arrays.toString(res.toArray());
    }

    private class PluginComparator
    implements Comparator<Plugin> {
        private PluginComparator() {
        }

        @Override
        public int compare(Plugin o1, Plugin o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

